# 機能設計書：インデントガイド（Indent Guides）

## 1. 機能概要

### 1.1 機能の目的
インデントガイド機能は、コードのインデントレベルを視覚的な縦線で表示する機能である。コードの構造とネスト深度を一目で把握できるようにし、特に長いコードブロックの可読性を向上させることを目的とする。

### 1.2 機能の範囲
- インデントレベルに応じた縦線の表示
- 現在のカーソル位置に対応するガイドのハイライト
- ブラケットペアに基づくカラフルガイド
- 空白行のガイド継続表示

### 1.3 関連画面
- エディタメインビュー（コード行の左側）

## 2. 機能要件

### 2.1 ユーザーストーリー
- 開発者として、コードのネスト構造を視覚的に把握したい
- 開発者として、現在編集中のスコープを明確にしたい
- 開発者として、ブラケットペアごとに異なる色でガイドを表示したい

### 2.2 入力仕様
| 項目 | 説明 |
|------|------|
| ドキュメント | 現在開いているテキストモデル（ITextModel） |
| インデント設定 | tabSize、indentSize、insertSpaces |
| カーソル位置 | 現在のカーソル行番号 |

### 2.3 出力仕様
| 項目 | 説明 |
|------|------|
| IndentGuide[] | ガイド線の位置と属性のリスト |
| アクティブガイド | 現在のスコープに対応するガイド情報 |

### 2.4 処理フロー

```mermaid
sequenceDiagram
    participant Editor
    participant GuidesTextModelPart
    participant TextModel
    participant ViewParts

    Editor->>GuidesTextModelPart: getLinesIndentGuides()
    GuidesTextModelPart->>TextModel: getLineContent()
    GuidesTextModelPart->>GuidesTextModelPart: computeIndentLevel()
    GuidesTextModelPart-->>Editor: number[] (インデントレベル)

    Editor->>GuidesTextModelPart: getActiveIndentGuide()
    GuidesTextModelPart->>GuidesTextModelPart: スコープ計算
    GuidesTextModelPart-->>Editor: IActiveIndentGuideInfo

    Editor->>ViewParts: ガイド線描画
```

### 2.5 ビジネスルール
1. インデントガイドは`editor.guides.indentation`設定で制御
2. 空白行のガイドは前後の行のインデントから推定
3. offSide言語（Python等）は特別なルールを適用
4. ブラケットガイドは括弧の対応関係に基づく

## 3. 画面設計

### 3.1 画面レイアウト
インデントガイドはコードの左側に縦線として表示される。

### 3.2 画面要素
| 要素 | 説明 | 操作 |
|------|------|------|
| インデントガイド線 | 各インデントレベルの縦線 | 表示のみ |
| アクティブガイド | 現在のスコープを示すハイライト | 自動更新 |
| ブラケットガイド | 括弧ペアに対応した色付きガイド | 表示のみ |

## 4. データ設計

### 4.1 入力データ構造
```typescript
interface IndentGuideParams {
    startLineNumber: number;
    endLineNumber: number;
    options: TextModelResolvedOptions;
}

interface BracketGuideOptions {
    includeInactive: boolean;
    horizontalGuides: HorizontalGuidesState;
    highlightActive: boolean;
}
```

### 4.2 出力データ構造
```typescript
interface IndentGuide {
    visibleColumn: number;       // ガイドの列位置
    column: number;              // 元の列位置
    className: string;           // CSSクラス名
    horizontalLine: IndentGuideHorizontalLine | null;
    forWrappedLinesBeforeOrAfterContentText?: boolean;
    forWrappedLinesAfterContentText?: boolean;
}

interface IActiveIndentGuideInfo {
    startLineNumber: number;     // スコープ開始行
    endLineNumber: number;       // スコープ終了行
    indent: number;              // インデントレベル
}
```

## 5. コードリーディングガイド

### 5.1 推奨読解順序

1. **データ構造の理解**
   - `src/vs/editor/common/textModelGuides.ts` - IndentGuide、IActiveIndentGuideInfo等の型定義

2. **モデル層**
   - `src/vs/editor/common/model/guidesTextModelPart.ts` - ガイド計算ロジック（**18-602行目**）
     - `GuidesTextModelPart`クラスがガイド計算を担当
     - **34-39行目**: `_computeIndentLevel()`でインデントレベル計算
     - **41-272行目**: `getActiveIndentGuide()`でアクティブガイド計算
     - **274-459行目**: `getLinesBracketGuides()`でブラケットガイド計算
     - **471-560行目**: `getLinesIndentGuides()`で行ごとのガイド取得

3. **ビュー層**
   - `src/vs/editor/browser/viewParts/indentGuides/indentGuides.ts` - 描画処理

### 5.2 プログラム呼び出し階層図

```
guidesTextModelPart.ts
  └── GuidesTextModelPart
        ├── _computeIndentLevel()
        │     └── computeIndentLevel() from utils.ts
        ├── getActiveIndentGuide()
        │     ├── _resolveIndents() (上方向検索)
        │     └── _resolveIndents() (下方向検索)
        ├── getLinesBracketGuides()
        │     └── bracketPairs.getBracketPairsInRangeWithMinIndentation()
        └── getLinesIndentGuides()
              └── _getIndentLevelForWhitespaceLine()

indentGuides.ts (ビュー)
  └── IndentGuidesOverlay
        └── prepareRender() → render()
```

### 5.3 データフロー図

```
[TextModel - 行コンテンツ]
        ↓
[computeIndentLevel() - インデント計算]
        ↓
[getLinesIndentGuides() - ガイドレベル配列]
        ↓
[getActiveIndentGuide() - アクティブスコープ]
        ↓
[IndentGuidesOverlay - 描画]
```

### 5.4 読解のコツ
- `GuidesTextModelPart`は`TextModelPart`を継承
- `offSide`言語（Python等）は`foldingRules.offSide`で判定
- 空白行のインデントは上下の行から推定（`_getIndentLevelForWhitespaceLine`）
- ブラケットガイドは`bracketPairs`サブシステムを使用
- `BracketPairGuidesClassNames`で色分けクラス名を生成

### 5.5 関連ファイル一覧

| パス | 種別 | 役割 |
|------|------|------|
| `src/vs/editor/common/model/guidesTextModelPart.ts` | モデル | ガイド計算ロジック |
| `src/vs/editor/common/textModelGuides.ts` | 型定義 | IndentGuide等の型 |
| `src/vs/editor/common/model/utils.ts` | ユーティリティ | computeIndentLevel |
| `src/vs/editor/browser/viewParts/indentGuides/indentGuides.ts` | ビュー | ガイド描画 |
| `src/vs/editor/common/languages/languageConfigurationRegistry.ts` | 設定 | 言語設定（offSide等） |

## 6. 非機能要件

### 6.1 パフォーマンス
- 可視範囲のみを処理
- 最大50000行の検索制限（無限ループ防止）
- キャッシュによる再計算の最小化

### 6.2 エラーハンドリング
- 不正な行番号はBugIndicatingErrorをスロー
- 範囲外の行はエラーとして処理

## 7. 設計上の考慮事項

### 7.1 拡張性
- 言語設定（foldingRules.offSide）で言語別動作をカスタマイズ
- ブラケットペアカラーリングとの統合

### 7.2 依存関係
- `TextModel`のgetLineContent()に依存
- `ILanguageConfigurationService`で言語設定を取得
- `bracketPairs`サブシステムとの連携
