# 機能設計書：ミニマップ（Minimap）

## 1. 機能概要

### 1.1 機能の目的
ミニマップ機能は、エディタの右側にドキュメント全体の縮小表示を提供する機能である。開発者がファイル全体の構造を俯瞰し、素早く目的の位置にナビゲートできるようにすることを目的とする。

### 1.2 機能の範囲
- ドキュメント全体の縮小表示
- 現在のビューポートを示すスライダー
- クリック/ドラッグによるナビゲーション
- デコレーション（エラー、警告、変更箇所等）の表示
- セクションヘッダーの表示

### 1.3 関連画面
- エディタメインビュー（右側マージン）

## 2. 機能要件

### 2.1 ユーザーストーリー
- 開発者として、ファイル全体の構造を一目で把握したい
- 開発者として、ミニマップをクリックして素早くジャンプしたい
- 開発者として、エラーや変更箇所をミニマップで確認したい

### 2.2 入力仕様
| 項目 | 説明 |
|------|------|
| ビューモデル | 現在のビューモデル |
| 設定 | enabled、renderMinimap、size、showSlider、autohide |
| デコレーション | エラー、警告、変更箇所等 |

### 2.3 出力仕様
| 項目 | 説明 |
|------|------|
| Canvas | ミニマップのCanvas描画 |
| スライダー | ビューポート表示用のスライダーUI |

### 2.4 処理フロー

```mermaid
sequenceDiagram
    participant Editor
    participant Minimap
    participant MinimapOptions
    participant MinimapLayout
    participant Canvas

    Editor->>Minimap: onConfigurationChanged
    Minimap->>MinimapOptions: 設定取得
    MinimapOptions-->>Minimap: オプション
    Minimap->>MinimapLayout: レイアウト計算
    MinimapLayout-->>Minimap: レイアウト情報
    Minimap->>Canvas: render()

    Note over Minimap,Canvas: クリック時
    Minimap->>MinimapLayout: getDesiredScrollTop()
    Minimap->>Editor: setScrollTop()
```

### 2.5 ビジネスルール
1. `editor.minimap.enabled`がfalseの場合は表示しない
2. ファイルが大きすぎる場合はサンプリングモードに切り替え
3. スライダーはマウスオーバー時のみ表示（設定可能）
4. ドラッグ中に一定距離離れるとリセット

## 3. 画面設計

### 3.1 画面レイアウト
ミニマップはエディタの右側に配置される。

### 3.2 画面要素
| 要素 | 説明 | 操作 |
|------|------|------|
| ミニマップ本体 | コードの縮小表示 | クリックでジャンプ |
| スライダー | 現在のビューポート | ドラッグでスクロール |
| デコレーション | エラー/警告マーカー | 表示のみ |
| セクションヘッダー | クラス/関数名 | 表示のみ |

## 4. データ設計

### 4.1 入力データ構造
```typescript
interface MinimapOptions {
    renderMinimap: RenderMinimap;
    size: 'proportional' | 'fill' | 'fit';
    showSlider: 'always' | 'mouseover';
    autohide: 'none' | 'mouseover' | 'scroll';
    minimapWidth: number;
    minimapHeight: number;
}

enum RenderMinimap {
    None = 0,
    Text = 1,
    Blocks = 2
}
```

### 4.2 出力データ構造
```typescript
class MinimapLayout {
    scrollTop: number;
    scrollHeight: number;
    sliderNeeded: boolean;
    sliderTop: number;
    sliderHeight: number;
    startLineNumber: number;
    endLineNumber: number;
}
```

## 5. コードリーディングガイド

### 5.1 推奨読解順序

1. **設定の理解**
   - `src/vs/editor/common/config/editorOptions.ts` - RenderMinimap等の設定定義

2. **ビュー層**
   - `src/vs/editor/browser/viewParts/minimap/minimap.ts` - ミニマップ本体の実装
     - `MinimapOptions`クラス（**50-212行目**）: 設定の管理
     - `MinimapLayout`クラス（**214-413行目**）: レイアウト計算
     - `MinimapSamplingState`クラス（**616-800行目**）: サンプリング状態管理
     - `Minimap`クラス: ミニマップ本体

3. **文字レンダリング**
   - `src/vs/editor/browser/viewParts/minimap/minimapCharRenderer.ts` - 文字描画
   - `src/vs/editor/browser/viewParts/minimap/minimapCharRendererFactory.ts` - レンダラ生成

### 5.2 プログラム呼び出し階層図

```
minimap.ts
  └── Minimap
        ├── MinimapOptions（設定管理）
        │     └── equals() - 変更検出
        ├── MinimapLayout（レイアウト計算）
        │     ├── create() - レイアウト生成
        │     ├── getDesiredScrollTopFromDelta()
        │     └── intersectWithViewport()
        ├── MinimapSamplingState（サンプリング）
        │     └── compute() - サンプリング計算
        ├── RenderData（レンダリングデータ）
        │     └── linesEquals() - 変更検出
        └── render()
              └── Canvas描画
```

### 5.3 データフロー図

```
[EditorOption.minimap設定]
        ↓
[MinimapOptions - 設定解析]
        ↓
[MinimapLayout.create() - レイアウト計算]
        ↓
[MinimapSamplingState - サンプリング]
        ↓
[RenderData - レンダリングデータ生成]
        ↓
[Canvas - ミニマップ描画]
```

### 5.4 読解のコツ
- `Minimap`は`ViewPart`を継承
- ダブルバッファリングで描画のちらつきを防止（`MinimapBuffers`）
- 大きなファイルはサンプリングモードで処理
- `POINTER_DRAG_RESET_DISTANCE = 140`でドラッグリセット距離を定義
- `MinimapCharRenderer`でピクセル単位の文字描画

### 5.5 関連ファイル一覧

| パス | 種別 | 役割 |
|------|------|------|
| `src/vs/editor/browser/viewParts/minimap/minimap.ts` | ビュー | ミニマップ本体 |
| `src/vs/editor/browser/viewParts/minimap/minimap.css` | スタイル | ミニマップCSS |
| `src/vs/editor/browser/viewParts/minimap/minimapCharRenderer.ts` | レンダラ | 文字描画 |
| `src/vs/editor/browser/viewParts/minimap/minimapCharRendererFactory.ts` | ファクトリ | レンダラ生成 |
| `src/vs/editor/browser/viewParts/minimap/minimapCharSheet.ts` | 定数 | 文字シート定義 |
| `src/vs/editor/common/viewModel/minimapTokensColorTracker.ts` | ユーティリティ | トークン色追跡 |

## 6. 非機能要件

### 6.1 パフォーマンス
- ダブルバッファリングで描画を最適化
- サンプリングモードで大きなファイルに対応
- 変更検出で不要な再描画を防止
- Canvas APIを使用した高速描画

### 6.2 エラーハンドリング
- Canvas取得失敗時はフォールバック
- メモリ不足時は描画をスキップ

## 7. 設計上の考慮事項

### 7.1 拡張性
- デコレーションAPIでカスタムマーカーを追加可能
- セクションヘッダーのカスタマイズが可能

### 7.2 依存関係
- `ViewContext`からビューモデルにアクセス
- `MinimapTokensColorTracker`でトークン色を追跡
- `GlobalPointerMoveMonitor`でドラッグ処理
