# 機能設計書 2-シンタックスハイライト

## 概要

本ドキュメントは、VS Codeエディタにおけるシンタックスハイライト機能の設計仕様を記載する。プログラミング言語の構文に基づいたコードの色分け表示を実現する。

### 本機能の処理概要

シンタックスハイライト機能は、ソースコードのテキストを言語の構文規則に基づいて解析し、トークン（キーワード、変数、文字列、コメントなど）ごとに適切な色やスタイルを適用して表示する機能である。

**業務上の目的・背景**：ソースコードの可読性を大幅に向上させることが本機能の主要な目的である。色分けによりコードの構造を視覚的に把握しやすくなり、開発者はシンタックスエラーの早期発見、コードの理解促進、レビュー効率の向上といった恩恵を受けることができる。また、異なるプログラミング言語を扱う際も一貫した視覚的体験を提供する。

**機能の利用シーン**：ソースコードを開いた瞬間から自動的に適用される。新規ファイル作成時、既存ファイル編集時、コードスニペット挿入時など、エディタ上でソースコードが表示されるあらゆる場面で機能する。

**主要な処理内容**：
1. 言語識別 - ファイル拡張子やファイル内容から対象プログラミング言語を特定する
2. トークナイゼーション - ソースコードをトークン（字句）単位に分割する
3. トークン分類 - 各トークンを標準トークンタイプ（コメント、文字列、正規表現等）に分類する
4. メタデータ生成 - 各トークンに色、フォントスタイル（太字、斜体等）のメタデータを付与する
5. レンダリング - メタデータに基づいてCSSクラスまたはインラインスタイルを生成し、表示に適用する

**関連システム・外部連携**：vscode-textmateライブラリを使用してTextMate文法に基づくトークナイゼーションを行う。また、セマンティックトークンプロバイダにより言語サーバーからの高度なトークン情報を統合する。

**権限による制御**：特になし。すべてのユーザーが同等の機能を利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | テキストエディタ | 主画面 | プログラミング言語の構文に基づいた色分け |

## 機能種別

表示処理 / トークナイゼーション / スタイル適用

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| lineContent | string | Yes | ハイライト対象の行テキスト | 空文字列も許容 |
| languageId | string | Yes | 言語識別子 | 登録済み言語IDであること |
| colorMap | Color[] | No | カラーマップ | テーマから取得 |

### 入力データソース

- TextModel（エディタのテキストバッファ）
- 言語設定（ファイル拡張子、モード設定）
- テーマ設定（カラーマップ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| tokens | Uint32Array | トークン配列（endOffset, metadata のペア） |
| className | string | CSSクラス名（mtk1, mtki等） |
| inlineStyle | string | インラインCSSスタイル |

### 出力先

- ビューレイヤー（DOM要素へのクラス/スタイル適用）

## 処理フロー

### 処理シーケンス

```
1. 言語識別
   └─ ファイル拡張子またはLanguage Modeから言語を特定
2. トークナイゼーションサポートの取得
   └─ TokenizationRegistryから言語対応のトークナイザを取得
3. 行ごとのトークナイゼーション
   └─ 各行のテキストをトークンに分割
4. トークンメタデータの生成
   └─ 32ビット整数にトークン情報をエンコード
5. LineTokensオブジェクトの生成
   └─ Uint32Arrayとテキストを組み合わせてLineTokensを作成
6. CSSクラス/スタイルの生成
   └─ TokenMetadataからクラス名またはインラインスタイルを生成
7. DOMへの適用
   └─ ビューレンダラーがスタイルを適用
```

### フローチャート

```mermaid
flowchart TD
    A[行テキスト入力] --> B[言語ID取得]
    B --> C{トークナイザ登録済み?}
    C -->|Yes| D[トークナイザ取得]
    C -->|No| E[デフォルトトークン生成]
    D --> F[トークナイゼーション実行]
    F --> G[メタデータエンコード]
    G --> H[LineTokens生成]
    E --> H
    H --> I[CSSクラス生成]
    I --> J[DOM適用]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 言語フォールバック | 未登録言語はプレーンテキストとして処理 | 言語トークナイザ未登録時 |
| BR-002 | 遅延トークナイゼーション | 可視範囲外の行は遅延してトークナイズ | パフォーマンス最適化 |
| BR-003 | セマンティック上書き | セマンティックトークンはTextMateトークンを上書き可能 | 言語サーバー連携時 |
| BR-004 | カラーマップ依存 | 色はカラーマップのインデックスで管理 | テーマ変更時に再計算 |

### 計算ロジック

**トークンメタデータの32ビットエンコード形式**：
```
ビット配置: bbbb bbbb ffff ffff fFFF FBTT LLLL LLLL
- L (0-7): LanguageId - 言語識別子（8ビット）
- T (8-9): StandardTokenType - トークンタイプ（2ビット）
- B (10): BalancedBrackets - バランス括弧フラグ（1ビット）
- F (11-14): FontStyle - フォントスタイル（4ビット）
- f (15-23): Foreground - 前景色ID（9ビット）
- b (24-31): Background - 背景色ID（8ビット）
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。すべてのトークン情報はメモリ上で管理される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TOKEN_LENGTH_MISMATCH | 警告 | トークン長とテキスト長が不一致 | エラーログ出力、デフォルトトークン適用 |
| TOKENIZER_NOT_FOUND | 情報 | 言語トークナイザ未登録 | プレーンテキストとして表示 |

### リトライ仕様

特になし

## トランザクション仕様

特になし（読み取り専用処理）

## パフォーマンス要件

- 初回トークナイゼーション: 行あたり1ms以内
- 増分トークナイゼーション: 変更行のみ再処理
- 大規模ファイル（10万行）: 初期表示3秒以内

## セキュリティ考慮事項

- 悪意のある文法定義によるDoS攻撃の防止（タイムアウト設定）
- ユーザー入力テキストのサニタイズ（XSS対策）

## 備考

VS Codeはvscode-textmateライブラリを使用してTextMate文法形式（.tmLanguage, .tmGrammar）に対応している。これにより多くの既存言語定義を再利用可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、トークンのメタデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | encodedTokenAttributes.ts | `src/vs/editor/common/encodedTokenAttributes.ts` | トークンメタデータの32ビットエンコード形式 |
| 1-2 | lineTokens.ts | `src/vs/editor/common/tokens/lineTokens.ts` | 行トークンの管理クラス |

**読解のコツ**:
- MetadataConstsの定数でビットマスクの構造を理解する
- FontStyle, ColorId, StandardTokenTypeの列挙型がトークンの属性を定義する

#### Step 2: エントリーポイントを理解する

トークナイゼーションサポートの登録・取得メカニズムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tokenizationRegistry.ts | `src/vs/editor/common/tokenizationRegistry.ts` | トークナイゼーションサポートの登録と取得 |

**主要処理フロー**:
1. **33-43行目**: `register()` - 言語IDに対してトークナイゼーションサポートを登録
2. **45-47行目**: `get()` - 言語IDからトークナイゼーションサポートを取得
3. **63-79行目**: `getOrCreate()` - 遅延ロードを含むトークナイゼーションサポート取得
4. **95-101行目**: `setColorMap()` - カラーマップの設定

#### Step 3: トークンクラスを理解する

LineTokensクラスの構造と操作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lineTokens.ts | `src/vs/editor/common/tokens/lineTokens.ts` | LineTokensクラスの実装 |

**主要処理フロー**:
- **32-41行目**: `createEmpty()` - 空のLineTokensを生成
- **103-112行目**: コンストラクタ - Uint32Arrayとテキストからトークンを構築
- **178-181行目**: `getClassName()` - トークンからCSSクラス名を生成
- **183-186行目**: `getInlineStyle()` - トークンからインラインスタイルを生成
- **202-204行目**: `findTokenIndexAtOffset()` - オフセットからトークンを検索

#### Step 4: メタデータ操作を理解する

TokenMetadataクラスでのビット操作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | encodedTokenAttributes.ts | `src/vs/editor/common/encodedTokenAttributes.ts` | TokenMetadataクラス |

**主要処理フロー**:
- **101-103行目**: `getLanguageId()` - メタデータから言語IDを抽出
- **105-107行目**: `getTokenType()` - メタデータからトークンタイプを抽出
- **117-119行目**: `getForeground()` - メタデータから前景色IDを抽出
- **125-144行目**: `getClassNameFromMetadata()` - メタデータからCSSクラス名を生成

### プログラム呼び出し階層図

```
TextModel.tokenization.getLineTokens()
    │
    ├─ TokenizationRegistry.get()
    │      └─ トークナイゼーションサポート取得
    │
    ├─ ITokenizationSupport.tokenizeEncoded()
    │      └─ 行テキストのトークナイゼーション
    │
    └─ LineTokens構築
           │
           ├─ TokenMetadata.getClassNameFromMetadata()
           │      └─ CSSクラス名生成
           │
           └─ TokenMetadata.getInlineStyleFromMetadata()
                  └─ インラインスタイル生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

行テキスト ──▶ トークナイザ ──▶ Uint32Array（トークン配列）
                   │
言語ID ──────▶ TokenizationRegistry ──▶ ITokenizationSupport
                   │
カラーマップ ──▶ TokenMetadata ──▶ CSSクラス/インラインスタイル
                                     │
                                     ▼
                               DOM要素へのスタイル適用
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| encodedTokenAttributes.ts | `src/vs/editor/common/encodedTokenAttributes.ts` | ソース | トークンメタデータのエンコード/デコード |
| tokenizationRegistry.ts | `src/vs/editor/common/tokenizationRegistry.ts` | ソース | トークナイゼーションサポートの登録・管理 |
| lineTokens.ts | `src/vs/editor/common/tokens/lineTokens.ts` | ソース | 行トークンの管理 |
| contiguousTokensStore.ts | `src/vs/editor/common/tokens/contiguousTokensStore.ts` | ソース | 連続トークンのストア |
| sparseTokensStore.ts | `src/vs/editor/common/tokens/sparseTokensStore.ts` | ソース | セマンティックトークンのストア |
| tokenizationTextModelPart.ts | `src/vs/editor/common/tokenizationTextModelPart.ts` | ソース | TextModelのトークナイゼーション部分 |
| languages.ts | `src/vs/editor/common/languages.ts` | ソース | 言語機能定義 |
