# 機能設計書 3-コード補完（IntelliSense）

## 概要

本ドキュメントは、VS Codeエディタにおけるコード補完（IntelliSense）機能の設計仕様を記載する。入力中のコードに対する補完候補の提示を行う。

### 本機能の処理概要

コード補完（IntelliSense）機能は、開発者がコードを入力している際に、適切な補完候補を自動的に提示し、選択することでコード入力を効率化する機能である。

**業務上の目的・背景**：ソフトウェア開発において、API名やメソッド名、変数名などを正確に入力することは時間を要し、タイプミスの原因ともなる。IntelliSenseは、コンテキストに応じた補完候補を提示することで、入力速度の向上、タイプミスの防止、APIの発見促進を実現する。言語サーバーと連携することで、型情報に基づいた高精度な補完を提供する。

**機能の利用シーン**：コード入力中に以下の場面で使用される。
- ドット（.）入力後のメンバー候補表示
- 変数名やメソッド名の途中入力時の候補フィルタリング
- インポート文入力時のモジュール名候補表示
- Ctrl+Spaceによる手動トリガー

**主要な処理内容**：
1. トリガー検知 - トリガー文字入力またはショートカット実行を検知
2. 補完プロバイダへの問い合わせ - 登録済みのCompletionItemProviderに候補を要求
3. 候補のマージとソート - 複数プロバイダからの候補を統合し優先度順にソート
4. ファジーマッチングフィルタリング - 入力テキストで候補をフィルタリング
5. 補完ウィジェット表示 - 候補リストをウィジェットで表示
6. 候補選択と挿入 - ユーザー選択に基づき補完テキストを挿入

**関連システム・外部連携**：Language Server Protocol（LSP）経由で言語サーバーからの補完候補を取得する。拡張機能が独自のCompletionItemProviderを登録可能。

**権限による制御**：特になし。ただし読み取り専用モードでは補完挿入が無効。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | テキストエディタ | 主画面 | 入力中のコードに対する補完候補の提示 |

## 機能種別

入力支援 / 補完処理 / ウィジェット表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| position | IPosition | Yes | カーソル位置 | 有効な行番号・列番号 |
| triggerKind | CompletionTriggerKind | Yes | トリガー種別（Invoke/TriggerCharacter/TriggerForIncompleteCompletions） | 列挙値 |
| triggerCharacter | string | No | トリガー文字（.など） | 1文字 |
| context | CompletionContext | Yes | 補完コンテキスト | - |

### 入力データソース

- キーボード入力（文字入力、ショートカット）
- 言語設定（トリガー文字定義）
- CompletionItemProvider（拡張機能、言語サーバー）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CompletionItem[] | 配列 | 補完候補のリスト |
| insertText | string | 挿入するテキスト |
| label | string | 表示ラベル |
| kind | CompletionItemKind | 候補の種類（Method, Property, Variable等） |
| detail | string | 詳細説明 |
| documentation | MarkdownString | ドキュメント |

### 出力先

- SuggestWidgetウィジェット（候補リスト表示）
- エディタ（選択時の補完テキスト挿入）

## 処理フロー

### 処理シーケンス

```
1. トリガー検知
   └─ トリガー文字入力またはCtrl+Space押下を検知
2. 補完モデル状態更新
   └─ SuggestModelの状態をTriggeredに変更
3. プロバイダへの問い合わせ
   └─ 登録済みCompletionItemProviderにprovideCompletionItemsを呼び出し
4. 候補の収集とマージ
   └─ 複数プロバイダの結果を統合
5. フィルタリングとソート
   └─ FuzzyScoreによる候補フィルタリング、優先度ソート
6. ウィジェット表示
   └─ SuggestWidgetで候補リストを表示
7. ユーザー選択処理
   └─ Enterキーまたはクリックで候補を選択
8. テキスト挿入
   └─ 選択された補完テキストをエディタに挿入
```

### フローチャート

```mermaid
flowchart TD
    A[トリガー検知] --> B{トリガー種別}
    B -->|Invoke| C[Ctrl+Space]
    B -->|TriggerCharacter| D[トリガー文字入力]
    C --> E[SuggestModel.trigger]
    D --> E
    E --> F[provideSuggestionItems]
    F --> G[CompletionItemProvider.provideCompletionItems]
    G --> H[CompletionItem収集]
    H --> I[CompletionModel作成]
    I --> J[FuzzyScoreフィルタリング]
    J --> K[SuggestWidget表示]
    K --> L{ユーザー選択}
    L -->|選択| M[insertSuggestion]
    L -->|キャンセル| N[ウィジェット非表示]
    M --> O[テキスト挿入完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | スニペット優先度 | スニペット候補の表示位置をTop/Inline/Bottomから選択可能 | スニペット含む場合 |
| BR-002 | 非推奨候補表示 | Deprecatedタグ付き候補の表示/非表示を設定可能 | showDeprecatedオプション |
| BR-003 | 選択モード | never/always/whenTriggerCharacter/whenQuickSuggestionから選択 | 自動補完時 |
| BR-004 | Insert/Replace | 補完時に既存テキストをInsert（追加）かReplace（置換）か選択 | 候補にinsert/replaceRange両方ある場合 |

### 計算ロジック

**FuzzyScore計算**：
- 入力テキストと候補ラベルのファジーマッチスコアを計算
- 連続一致、先頭一致、単語境界一致でボーナススコア
- スコア0以下は非表示

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| PROVIDER_ERROR | 警告 | プロバイダからのエラー応答 | 該当プロバイダをスキップ、他候補を表示 |
| CANCELLATION | 情報 | ユーザーによるキャンセル | 正常終了扱い |
| TIMEOUT | 警告 | プロバイダ応答タイムアウト | 取得済み候補のみ表示 |

### リトライ仕様

特になし（次回トリガー時に再実行）

## トランザクション仕様

補完テキスト挿入はUndoスタックに積まれ、取り消し可能。

## パフォーマンス要件

- 補完候補表示: 100ms以内
- フィルタリング更新: 16ms以内（60FPS）
- 候補数上限: 1000件程度

## セキュリティ考慮事項

- 拡張機能からの補完候補はサンドボックス内で処理
- 悪意のある補完テキストによるコードインジェクション防止

## 備考

IntelliSenseはMicrosoft社の商標であり、VS Codeのコード補完機能全般を指す。言語サーバーとの連携により、型推論に基づく高精度な補完を実現。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、補完アイテムの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | suggest.ts | `src/vs/editor/contrib/suggest/browser/suggest.ts` | CompletionItemクラス、Context定義 |
| 1-2 | languages.ts | `src/vs/editor/common/languages.ts` | CompletionItemインターフェース、CompletionItemKind列挙型 |

**読解のコツ**:
- CompletionItemはプロバイダから取得したlanguages.CompletionItemをラップ
- editStart, editInsertEnd, editReplaceEndで挿入/置換範囲を管理

#### Step 2: エントリーポイントを理解する

補完機能の起動とコントローラを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | suggestController.ts | `src/vs/editor/contrib/suggest/browser/suggestController.ts` | SuggestControllerクラス |

**主要処理フロー**:
1. **114-120行目**: SuggestController定義、ID登録
2. **138-146行目**: コンストラクタでSuggestModel、SuggestWidget初期化
3. **166行目**: onDidSelectでinsertSuggestion呼び出し
4. **233-276行目**: model.onDidSuggestで候補表示処理

#### Step 3: モデル層を理解する

補完モデルとプロバイダ呼び出しを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | suggest.ts | `src/vs/editor/contrib/suggest/browser/suggest.ts` | provideSuggestionItems関数 |
| 3-2 | suggestModel.ts | `src/vs/editor/contrib/suggest/browser/suggestModel.ts` | SuggestModelクラス |
| 3-3 | completionModel.ts | `src/vs/editor/contrib/suggest/browser/completionModel.ts` | CompletionModelクラス |

**主要処理フロー**:
- **214-268行目（suggest.ts）**: provideSuggestionItems - プロバイダ呼び出しと結果収集
- **47-88行目（suggest.ts）**: CompletionItemコンストラクタ - 範囲正規化、検証

#### Step 4: ウィジェット層を理解する

補完ウィジェットの表示処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | suggestWidget.ts | `src/vs/editor/contrib/suggest/browser/suggestWidget.ts` | SuggestWidgetクラス |
| 4-2 | suggestWidgetRenderer.ts | `src/vs/editor/contrib/suggest/browser/suggestWidgetRenderer.ts` | アイテムレンダラー |

### プログラム呼び出し階層図

```
SuggestController
    │
    ├─ SuggestModel
    │      ├─ trigger() - 補完開始
    │      ├─ provideSuggestionItems() - プロバイダ問い合わせ
    │      │      └─ CompletionItemProvider.provideCompletionItems()
    │      └─ CompletionModel作成
    │
    ├─ SuggestWidget
    │      ├─ showTriggered() - トリガー表示
    │      ├─ showSuggestions() - 候補表示
    │      └─ onDidSelect - 選択イベント
    │
    └─ _insertSuggestion()
           └─ EditOperation.replace() - テキスト挿入
```

### データフロー図

```
[入力]               [処理]                    [出力]

トリガー文字 ──▶ SuggestModel.trigger() ──▶ トリガーイベント
                        │
                        ▼
CompletionItemProvider ──▶ provideSuggestionItems() ──▶ CompletionItem[]
                        │
                        ▼
CompletionItem[] ──▶ CompletionModel ──▶ フィルタ済み候補
                        │
                        ▼
候補リスト ──▶ SuggestWidget ──▶ 画面表示
                        │
                        ▼
ユーザー選択 ──▶ insertSuggestion() ──▶ テキスト挿入
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| suggest.ts | `src/vs/editor/contrib/suggest/browser/suggest.ts` | ソース | 補完アイテム、プロバイダ呼び出し |
| suggestController.ts | `src/vs/editor/contrib/suggest/browser/suggestController.ts` | ソース | 補完コントローラ |
| suggestModel.ts | `src/vs/editor/contrib/suggest/browser/suggestModel.ts` | ソース | 補完モデル、状態管理 |
| completionModel.ts | `src/vs/editor/contrib/suggest/browser/completionModel.ts` | ソース | フィルタリング、ソート |
| suggestWidget.ts | `src/vs/editor/contrib/suggest/browser/suggestWidget.ts` | ソース | 補完ウィジェットUI |
| suggestWidgetRenderer.ts | `src/vs/editor/contrib/suggest/browser/suggestWidgetRenderer.ts` | ソース | アイテムレンダリング |
| suggestWidgetDetails.ts | `src/vs/editor/contrib/suggest/browser/suggestWidgetDetails.ts` | ソース | 詳細パネル |
| suggestMemory.ts | `src/vs/editor/contrib/suggest/browser/suggestMemory.ts` | ソース | 選択履歴記憶 |
| suggestCommitCharacters.ts | `src/vs/editor/contrib/suggest/browser/suggestCommitCharacters.ts` | ソース | コミット文字処理 |
| wordDistance.ts | `src/vs/editor/contrib/suggest/browser/wordDistance.ts` | ソース | 単語距離計算 |
