# 機能設計書 31-コマンドパレット

## 概要

本ドキュメントは、Visual Studio Codeのコマンドパレット機能の設計内容を記述する。コマンドパレットは、エディタで利用可能なすべてのコマンドを検索・実行するための統合インターフェースを提供する中核的なユーザーインタラクション機能である。

### 本機能の処理概要

コマンドパレット機能は、VS Code内で実行可能なすべてのコマンドをクイックアクセス形式で検索・実行できる機能である。ユーザーはキーボードショートカット（Ctrl+Shift+P または F1）でコマンドパレットを開き、コマンド名やキーワードを入力することで目的のコマンドを素早く見つけて実行できる。

**業務上の目的・背景**：開発者は多数のコマンドやアクションを日常的に実行する必要があるが、すべてのメニュー階層やキーボードショートカットを記憶することは困難である。コマンドパレットは、コマンド名の一部を入力するだけで目的の機能にアクセスできるため、開発効率を大幅に向上させる。また、拡張機能が提供するコマンドも統一的なインターフェースで利用可能となる。

**機能の利用シーン**：
- 特定のコマンドを実行したいが、メニュー位置やショートカットが分からない場合
- 拡張機能が提供する機能を素早く呼び出す場合
- 設定やキーバインドのカスタマイズ画面に移動する場合
- Git操作やファイル操作などの頻繁に使用するアクションを実行する場合

**主要な処理内容**：
1. クイックアクセスUIの表示とフィルタリングによるコマンド候補の絞り込み
2. エディタコンテキストに基づいた利用可能コマンドの動的取得
3. 拡張機能から登録されたコマンドの収集と表示
4. コマンド実行履歴の管理と優先表示
5. AI関連情報サービスと連携した自然言語検索（実験的機能）
6. キーバインド設定画面への遷移機能

**関連システム・外部連携**：
- MenuService: コマンドパレット用メニュー（MenuId.CommandPalette）からコマンドを取得
- ExtensionService: 拡張機能の登録完了を待機してコマンドを収集
- AIRelatedInformationService: 自然言語によるコマンド検索機能
- ChatAgentService: AIチャットとの連携機能

**権限による制御**：コンテキストキー（ContextKey）に基づいて、現在のエディタ状態で実行可能なコマンドのみが表示される。例えば、アクティブなエディタがテキストエディタでない場合、テキスト編集関連のコマンドは非表示となる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | コマンドパレット | 主画面 | コマンドの検索・実行（Ctrl+Shift+P） |

## 機能種別

検索・実行機能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| filter | string | No | コマンド検索のフィルタ文字列 | なし |
| preserveInput | boolean | No | 前回の入力値を保持するか | 設定値による |

### 入力データソース

- ユーザーのキーボード入力（クイックアクセス検索ボックス）
- workbench.commandPalette設定からの構成値
- コマンド実行履歴（StorageService経由）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| commandPicks | ICommandQuickPick[] | 表示するコマンド候補一覧 |
| selectedCommand | string | ユーザーが選択したコマンドID |

### 出力先

- クイックアクセスUI（クイックピック形式）
- 選択されたコマンドの実行（CommandService経由）

## 処理フロー

### 処理シーケンス

```
1. ユーザーがCtrl+Shift+P または F1を押下
   └─ ShowAllCommandsActionが呼び出される
2. QuickInputServiceにCommandsQuickAccessProviderを指定して表示
   └─ プレフィックス ">" でコマンドパレットモードを指定
3. 拡張機能の登録完了を待機（最大800ms）
   └─ extensionService.whenInstalledExtensionsRegistered()
4. コマンド一覧の取得
   └─ getCodeEditorCommandPicks(): エディタ固有コマンド
   └─ getGlobalCommandPicks(): グローバルコマンド
5. ユーザー入力に基づくフィルタリング
   └─ AI関連情報サービスによる追加候補取得（有効時）
6. コマンド選択時の実行
   └─ CommandService.executeCommand()
7. 履歴の更新
   └─ CommandsHistory.push()
```

### フローチャート

```mermaid
flowchart TD
    A[ユーザーがCtrl+Shift+P押下] --> B[QuickAccessUI表示]
    B --> C{拡張機能登録待機}
    C -->|完了/タイムアウト| D[コマンド一覧取得]
    D --> E[MenuServiceからグローバルコマンド取得]
    D --> F[エディタコマンド取得]
    E --> G[コマンド候補リスト作成]
    F --> G
    G --> H{ユーザー入力}
    H -->|フィルタ文字列| I[候補絞り込み]
    I --> J{AI検索有効?}
    J -->|Yes| K[AI関連情報サービスで追加候補取得]
    J -->|No| L[フィルタ結果表示]
    K --> L
    L --> M{コマンド選択}
    M -->|選択| N[コマンド実行]
    N --> O[履歴更新]
    O --> P[終了]
    M -->|キャンセル| P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-31-01 | コマンド表示条件 | コンテキストキーの条件を満たすコマンドのみ表示 | 常時 |
| BR-31-02 | 履歴優先表示 | 最近使用したコマンドを上位に表示 | 履歴が存在する場合 |
| BR-31-03 | 拡張機能待機 | 拡張機能登録完了を最大800ms待機 | コマンドパレット初回表示時 |
| BR-31-04 | AI検索デバウンス | AI検索は200ms のデバウンス後に実行 | AI検索有効時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 履歴保存 | StorageService | INSERT/UPDATE | コマンド実行履歴の永続化 |
| 履歴取得 | StorageService | SELECT | コマンド実行履歴の読み込み |

### テーブル別操作詳細

#### StorageService (commandsHistory)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | history | 実行したコマンドIDのリスト | JSON形式で保存 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | タイムアウト | 拡張機能登録が800ms以内に完了しない | 登録済みのコマンドのみで続行 |
| - | AI検索エラー | AI関連情報サービスが利用不可 | 通常のフィルタ検索にフォールバック |

### リトライ仕様

なし（タイムアウト時は現在利用可能なコマンドで続行）

## トランザクション仕様

なし（状態管理はメモリ内で完結）

## パフォーマンス要件

- コマンドパレット表示: 100ms以内
- フィルタリング応答: 50ms以内
- AI検索応答: 200msのデバウンス後に非同期で取得

## セキュリティ考慮事項

- コマンドの実行可否はコンテキストキーで制御
- 拡張機能が登録するコマンドは拡張機能の権限に準拠
- 履歴データはローカルストレージに保存（同期対象外）

## 備考

- プレフィックス ">" でコマンドパレットモードを識別
- "@" プレフィックスでシンボル検索、":" で行番号ジャンプなど、他のクイックアクセス機能と連携
- 設定 `workbench.commandPalette.preserveInput` で前回入力の保持を制御可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コマンドパレットで扱うデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | quickInput.ts | `src/vs/platform/quickinput/common/quickInput.ts` | IQuickPickItem、IQuickInputServiceのインターフェース定義 |
| 1-2 | commandsQuickAccess.ts | `src/vs/platform/quickinput/browser/commandsQuickAccess.ts` | ICommandQuickPick、CommandsHistoryの型定義 |

**読解のコツ**: VS Codeのクイックアクセスは複数のプロバイダー（コマンド、ファイル、シンボル等）を持つ共通基盤。プレフィックスでプロバイダーを切り替える仕組みを理解する。

#### Step 2: エントリーポイントを理解する

コマンドパレットの起動から表示までの流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | commandsQuickAccess.ts | `src/vs/workbench/contrib/quickaccess/browser/commandsQuickAccess.ts` | ShowAllCommandsActionクラスとCommandsQuickAccessProviderクラス |

**主要処理フロー**:
1. **273-294行目**: ShowAllCommandsAction - Ctrl+Shift+Pのアクション定義
2. **291-293行目**: QuickInputService.quickAccess.show()でコマンドパレット表示
3. **44-94行目**: CommandsQuickAccessProviderのコンストラクタ - 各種サービスの注入と初期化

#### Step 3: コマンド収集ロジックを理解する

コマンド一覧の取得処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | commandsQuickAccess.ts | `src/vs/workbench/contrib/quickaccess/browser/commandsQuickAccess.ts` | getCommandPicks、getGlobalCommandPicksメソッド |

**主要処理フロー**:
- **119-142行目**: getCommandPicks - エディタコマンドとグローバルコマンドを統合
- **226-268行目**: getGlobalCommandPicks - MenuServiceからCommandPaletteメニューのコマンドを取得

#### Step 4: AI検索機能を理解する

AI関連情報サービスを使った追加検索機能を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | commandsQuickAccess.ts | `src/vs/workbench/contrib/quickaccess/browser/commandsQuickAccess.ts` | hasAdditionalCommandPicks、getAdditionalCommandPicksメソッド |

**主要処理フロー**:
- **144-155行目**: hasAdditionalCommandPicks - AI検索の有効判定
- **157-198行目**: getAdditionalCommandPicks - AI関連情報サービスへの問い合わせと結果統合

#### Step 5: 登録と初期化を理解する

コマンドパレットの登録処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | quickAccess.contribution.ts | `src/vs/workbench/contrib/quickaccess/browser/quickAccess.contribution.ts` | クイックアクセスプロバイダーの登録 |

**主要処理フロー**:
- **42-48行目**: CommandsQuickAccessProviderの登録（プレフィックス ">"、プレースホルダーメッセージ設定）
- **55-62行目**: メニューバーへの登録
- **115-117行目**: アクションの登録

### プログラム呼び出し階層図

```
ShowAllCommandsAction.run()
    │
    ├─ IQuickInputService.quickAccess.show(">")
    │      │
    │      └─ CommandsQuickAccessProvider.provide()
    │             │
    │             ├─ extensionRegistrationRace (拡張機能待機)
    │             │
    │             ├─ getCommandPicks()
    │             │      ├─ getCodeEditorCommandPicks()
    │             │      └─ getGlobalCommandPicks()
    │             │             └─ IMenuService.getMenuActions(MenuId.CommandPalette)
    │             │
    │             └─ getAdditionalCommandPicks() [AI検索有効時]
    │                    └─ IAiRelatedInformationService.getRelatedInformation()
    │
    └─ [ユーザー選択時]
           └─ ICommandService.executeCommand()
                  └─ CommandsHistory.push()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ユーザー入力         ───▶  CommandsQuickAccessProvider  ───▶  QuickPickUI
(Ctrl+Shift+P)                    │
                                  ├─ MenuService
フィルタ文字列       ───▶         ├─ ExtensionService
                                  ├─ AIRelatedInfoService
                                  │
コマンド選択         ───▶         └─ CommandService      ───▶  コマンド実行
                                         │
                                         └─ CommandsHistory ───▶ StorageService
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| commandsQuickAccess.ts | `src/vs/workbench/contrib/quickaccess/browser/commandsQuickAccess.ts` | ソース | コマンドパレットのメインプロバイダー |
| quickAccess.contribution.ts | `src/vs/workbench/contrib/quickaccess/browser/quickAccess.contribution.ts` | ソース | クイックアクセス機能の登録 |
| viewQuickAccess.ts | `src/vs/workbench/contrib/quickaccess/browser/viewQuickAccess.ts` | ソース | ビュークイックアクセス（関連機能） |
| commandsQuickAccess.ts | `src/vs/platform/quickinput/browser/commandsQuickAccess.ts` | ソース | コマンドクイックアクセスの基底クラス |
| quickInput.ts | `src/vs/platform/quickinput/common/quickInput.ts` | ソース | クイック入力サービスのインターフェース |
| quickAccess.ts | `src/vs/platform/quickinput/common/quickAccess.ts` | ソース | クイックアクセスのインターフェース |
| quickInputService.ts | `src/vs/platform/quickinput/browser/quickInputService.ts` | ソース | クイック入力サービスの実装 |
