# 機能設計書 32-設定エディタ

## 概要

本ドキュメントは、Visual Studio Codeの設定エディタ機能の設計内容を記述する。設定エディタは、ユーザー設定・ワークスペース設定・フォルダ設定をGUIまたはJSON形式で編集するための中核的な構成管理機能である。

### 本機能の処理概要

設定エディタ機能は、VS Codeの動作を制御する各種設定項目をユーザーフレンドリーなUI形式で編集できる機能である。設定項目は階層的なカテゴリに分類され、検索機能によって目的の設定を素早く見つけることができる。

**業務上の目的・背景**：VS Codeは数千の設定項目を持ち、開発者ごとの好みやプロジェクト要件に応じたカスタマイズが必要である。設定エディタは、settings.jsonを直接編集する代わりに、視覚的なインターフェースで設定の意味や選択肢を理解しながら変更を行えるようにする。これにより、設定ミスを減らし、設定作業の効率を向上させる。

**機能の利用シーン**：
- エディタのフォントサイズやテーマを変更する場合
- ワークスペース固有の設定（フォーマッタ、リンター設定等）を行う場合
- 拡張機能の設定を確認・変更する場合
- 特定の設定項目を検索して値を確認・変更する場合
- 設定の同期状態を確認する場合

**主要な処理内容**：
1. 設定スキーマの解析と設定項目ツリーの構築
2. 目次（TOC）とフィルタ機能による設定項目のナビゲーション
3. 各設定項目に適したUIコントロール（テキスト、数値、ブール、列挙、配列等）の動的レンダリング
4. ユーザー設定・ワークスペース設定・フォルダ設定のスコープ切り替え
5. 設定変更の即時反映とバリデーション
6. AI支援による設定検索（実験的機能）

**関連システム・外部連携**：
- ConfigurationService: 設定の読み込み・書き込みを管理
- ConfigurationRegistry: 設定スキーマの登録・取得
- UserDataSyncService: 設定の同期状態管理
- ExtensionService: 拡張機能が提供する設定の収集

**権限による制御**：
- アプリケーションスコープ設定は特定の条件下でのみ編集可能
- ワークスペーストラスト設定により、信頼されていないワークスペースでは一部設定が制限
- ポリシー設定は管理者により強制され、ユーザーによる変更は不可

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | 設定エディタ | 主画面 | GUI形式でのカテゴリ別設定項目の編集 |
| 19 | プロファイルエディタ | 参照画面 | プロファイル別の設定管理 |

## 機能種別

CRUD操作 / 設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| query | string | No | 設定検索クエリ | なし |
| target | ConfigurationTarget | No | 設定スコープ（ユーザー/ワークスペース/フォルダ） | 有効なスコープ値 |
| focusSearch | boolean | No | 検索ボックスにフォーカスするか | なし |
| revealSetting | object | No | 特定の設定を表示・編集状態にする | key: string, edit?: boolean |

### 入力データソース

- ConfigurationService: 現在の設定値
- ConfigurationRegistry: 設定スキーマ（型、デフォルト値、説明等）
- ExtensionManifest: 拡張機能が定義する設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| settingsTree | SettingsTreeModel | 設定項目のツリー構造 |
| tocTree | TOCTreeModel | 目次ツリー構造 |
| searchResults | SearchResultModel | 検索結果モデル |

### 出力先

- 設定ファイル（settings.json）への書き込み
- UI表示（設定エディタペイン）
- 設定変更イベントの発行

## 処理フロー

### 処理シーケンス

```
1. ユーザーが設定エディタを開く
   └─ Ctrl+, または メニューから「設定」を選択
2. SettingsEditor2の初期化
   └─ 設定スキーマの読み込みとモデル構築
3. 目次ツリー（TOC）の構築
   └─ カテゴリ階層に基づくナビゲーション構造
4. 設定項目ツリーの構築
   └─ SettingsTreeModelによる設定項目のフラット化と階層化
5. ユーザーインタラクション
   └─ 検索、カテゴリ選択、設定値変更
6. 設定変更の保存
   └─ ConfigurationServiceへの書き込みとバリデーション
7. 変更の反映
   └─ 即時反映または再起動要求の表示
```

### フローチャート

```mermaid
flowchart TD
    A[設定エディタを開く] --> B[設定スキーマ読み込み]
    B --> C[SettingsTreeModel構築]
    C --> D[TOCTreeModel構築]
    D --> E[UI表示]
    E --> F{ユーザー操作}
    F -->|検索| G[フィルタリング処理]
    F -->|カテゴリ選択| H[該当セクションへスクロール]
    F -->|設定変更| I[値のバリデーション]
    G --> J[検索結果表示]
    H --> E
    I --> K{バリデーション結果}
    K -->|成功| L[ConfigurationServiceへ保存]
    K -->|失敗| M[エラー表示]
    L --> N[変更イベント発行]
    N --> E
    M --> E
    J --> E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-32-01 | スコープ優先順位 | フォルダ > ワークスペース > ユーザー > デフォルト | 設定値の解決時 |
| BR-32-02 | 即時反映 | 多くの設定は変更後即座に反映される | 再起動不要の設定 |
| BR-32-03 | ポリシー設定制限 | ポリシーで強制された設定は変更不可 | ポリシー設定時 |
| BR-32-04 | ワークスペーストラスト | 信頼されていないワークスペースでは一部設定が制限 | 未信頼ワークスペース |
| BR-32-05 | 検索デバウンス | 検索は200msのデバウンス後に実行 | 検索入力時 |

### 計算ロジック

設定値の解決順序:
1. フォルダ設定（存在する場合）
2. ワークスペース設定（存在する場合）
3. ユーザー設定（存在する場合）
4. デフォルト値

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定読み込み | settings.json | SELECT | 各スコープの設定ファイル読み込み |
| 設定保存 | settings.json | INSERT/UPDATE | 設定値の永続化 |
| 設定削除 | settings.json | DELETE | 設定をデフォルトに戻す |

### テーブル別操作詳細

#### settings.json

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | 任意の設定キー | ユーザーが入力した値 | JSONスキーマに基づくバリデーション |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | 設定値がスキーマに適合しない | エラーメッセージを表示し、変更を拒否 |
| - | ファイル書き込みエラー | 設定ファイルへの書き込み失敗 | 通知を表示し、リトライを促す |
| - | スキーマエラー | 設定スキーマの解析失敗 | 該当設定を非表示にし、ログ出力 |

### リトライ仕様

ファイル書き込みエラー時はユーザーに再試行を促す

## トランザクション仕様

なし（ファイルベースの設定管理）

## パフォーマンス要件

- 設定エディタ初期表示: 500ms以内
- 検索応答: デバウンス200ms後に開始、結果表示500ms以内
- 設定保存: 100ms以内

## セキュリティ考慮事項

- 機密情報（APIキー等）を含む設定は適切にマスクされる
- ワークスペーストラスト機能により、悪意のある設定からの保護
- ポリシー設定による企業管理者の制御

## 備考

- 設定エディタはSettingsEditor2クラスで実装
- JSON形式での直接編集も引き続きサポート
- AI支援検索は実験的機能として提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定エディタで扱うデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | settingsTreeModels.ts | `src/vs/workbench/contrib/preferences/browser/settingsTreeModels.ts` | SettingsTreeModel、SettingsTreeElement、SearchResultModelの定義 |
| 1-2 | preferences.ts | `src/vs/workbench/contrib/preferences/common/preferences.ts` | ISettingsEditorModel、ISettingsGroupなどのインターフェース |

**読解のコツ**: 設定項目は階層構造（グループ > サブグループ > 設定）で管理され、SettingsTreeModelがこの階層をフラット化してUI表示用に変換する。

#### Step 2: エントリーポイントを理解する

設定エディタの起動から表示までの流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | preferences.contribution.ts | `src/vs/workbench/contrib/preferences/browser/preferences.contribution.ts` | 設定エディタの登録とアクション定義 |
| 2-2 | settingsEditor2.ts | `src/vs/workbench/contrib/preferences/browser/settingsEditor2.ts` | SettingsEditor2クラスのcreateEditor、setInputメソッド |

**主要処理フロー**:
1. **71-80行目** (preferences.contribution.ts): SettingsEditor2の登録
2. **108-200行目** (settingsEditor2.ts): SettingsEditor2クラス定義、各種UIコンポーネントの宣言

#### Step 3: 設定ツリーの構築を理解する

設定項目のツリー構築処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | settingsTree.ts | `src/vs/workbench/contrib/preferences/browser/settingsTree.ts` | SettingsTree、SettingTreeRenderersクラス |
| 3-2 | tocTree.ts | `src/vs/workbench/contrib/preferences/browser/tocTree.ts` | TOCTree、TOCTreeModelクラス |

**主要処理フロー**:
- settingsTree.ts: 各設定項目に適したレンダラー（テキスト、数値、ブール等）の選択と描画
- tocTree.ts: 目次ツリーの構築とカテゴリナビゲーション

#### Step 4: 検索機能を理解する

設定検索の実装を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | preferencesSearch.ts | `src/vs/workbench/contrib/preferences/browser/preferencesSearch.ts` | IPreferencesSearchService、検索プロバイダーの実装 |
| 4-2 | settingsTreeModels.ts | `src/vs/workbench/contrib/preferences/browser/settingsTreeModels.ts` | parseQuery関数、SearchResultModelクラス |

**主要処理フロー**:
- 検索クエリのパース（@タグ、フィルタ条件等）
- 複数の検索プロバイダー（文字列マッチ、TF-IDF、AI等）による検索

#### Step 5: 設定の保存を理解する

設定値の変更と永続化の処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | settingsEditor2.ts | `src/vs/workbench/contrib/preferences/browser/settingsEditor2.ts` | 設定変更イベントのハンドリング |

**主要処理フロー**:
- 設定変更のデバウンス処理（SETTING_UPDATE_FAST_DEBOUNCE、SETTING_UPDATE_SLOW_DEBOUNCE）
- ConfigurationServiceへの書き込み

### プログラム呼び出し階層図

```
OpenSettingsAction.run()
    │
    ├─ IPreferencesService.openSettings()
    │      │
    │      └─ SettingsEditor2.setInput()
    │             │
    │             ├─ Settings2EditorModel構築
    │             │      └─ ConfigurationRegistry.getConfigurationProperties()
    │             │
    │             ├─ SettingsTreeModel構築
    │             │      └─ resolveSettingsTree()
    │             │
    │             └─ TOCTreeModel構築
    │                    └─ createTOCIterator()
    │
    └─ [設定変更時]
           ├─ バリデーション
           └─ IConfigurationService.updateValue()
                  └─ settings.json への書き込み
```

### データフロー図

```
[入力]                        [処理]                              [出力]

ConfigurationRegistry  ───▶  SettingsEditor2               ───▶  設定エディタUI
(設定スキーマ)                      │
                                   ├─ Settings2EditorModel
settings.json          ───▶        ├─ SettingsTreeModel     ───▶  設定項目ツリー表示
(現在の設定値)                      ├─ TOCTreeModel          ───▶  目次ツリー表示
                                   │
ユーザー入力           ───▶        └─ ConfigurationService  ───▶  settings.json
(検索、設定変更)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| settingsEditor2.ts | `src/vs/workbench/contrib/preferences/browser/settingsEditor2.ts` | ソース | 設定エディタのメインクラス |
| preferences.contribution.ts | `src/vs/workbench/contrib/preferences/browser/preferences.contribution.ts` | ソース | 設定エディタの登録とアクション |
| settingsTreeModels.ts | `src/vs/workbench/contrib/preferences/browser/settingsTreeModels.ts` | ソース | 設定ツリーのデータモデル |
| settingsTree.ts | `src/vs/workbench/contrib/preferences/browser/settingsTree.ts` | ソース | 設定ツリーのUIレンダリング |
| tocTree.ts | `src/vs/workbench/contrib/preferences/browser/tocTree.ts` | ソース | 目次ツリーの実装 |
| preferencesSearch.ts | `src/vs/workbench/contrib/preferences/browser/preferencesSearch.ts` | ソース | 設定検索機能 |
| settingsWidgets.ts | `src/vs/workbench/contrib/preferences/browser/settingsWidgets.ts` | ソース | 設定編集用ウィジェット |
| preferencesWidgets.ts | `src/vs/workbench/contrib/preferences/browser/preferencesWidgets.ts` | ソース | 設定ターゲット選択ウィジェット |
| settingsLayout.ts | `src/vs/workbench/contrib/preferences/browser/settingsLayout.ts` | ソース | 設定カテゴリのレイアウト定義 |
| preferences.ts | `src/vs/workbench/contrib/preferences/common/preferences.ts` | ソース | 設定関連のインターフェース定義 |
