# 機能設計書 34-テーマ

## 概要

本ドキュメントは、Visual Studio Codeのテーマ機能の設計内容を記述する。テーマ機能は、カラーテーマ、ファイルアイコンテーマ、製品アイコンテーマの切り替えと管理を行うための外観カスタマイズ機能である。

### 本機能の処理概要

テーマ機能は、VS Codeのユーザーインターフェースの外観をカスタマイズするための機能を提供する。ユーザーは、エディタやワークベンチの配色（カラーテーマ）、ファイルエクスプローラーに表示されるアイコン（ファイルアイコンテーマ）、UI全体で使用されるアイコン（製品アイコンテーマ）を個別に選択・変更できる。

**業務上の目的・背景**：開発者は長時間エディタを使用するため、視覚的な快適性が作業効率と眼精疲労の軽減に重要である。また、ダークモード/ライトモードの切り替えや、システムの外観設定に連動した自動切り替えにより、様々な環境での作業を支援する。

**機能の利用シーン**：
- 好みのカラースキームに変更する場合
- システムのダーク/ライトモードに合わせて自動切り替えする場合
- ハイコントラストモードで視認性を向上させる場合
- プロジェクトごとに異なるテーマを使用する場合
- マーケットプレイスから新しいテーマをインストールする場合

**主要な処理内容**：
1. インストール済みテーマの一覧表示とクイックピックによる選択
2. テーマのプレビュー（選択前に一時適用）
3. カラーテーマ、ファイルアイコンテーマ、製品アイコンテーマの個別管理
4. システムカラーモード検出と自動切り替え
5. マーケットプレイスからのテーマ検索とインストール
6. テーマ設定の永続化

**関連システム・外部連携**：
- WorkbenchThemeService: テーマの管理と適用
- ExtensionGalleryService: マーケットプレイスからのテーマ取得
- ConfigurationService: テーマ設定の永続化
- ExtensionManagementService: テーマ拡張機能のインストール

**権限による制御**：特になし（すべてのユーザーがテーマを自由に変更可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | テーマ選択クイックピック | 主画面 | カラーテーマ/アイコンテーマの選択 |

## 機能種別

設定管理 / UI カスタマイズ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| themeId | string | Yes | テーマの識別子 | 有効なテーマID |
| settingsTarget | ThemeSettingTarget | No | 設定の保存先（auto/preview） | なし |

### 入力データソース

- 拡張機能のpackage.json: テーマ定義
- settings.json: ユーザーのテーマ設定
- ExtensionGalleryService: マーケットプレイスのテーマ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| currentColorTheme | IWorkbenchColorTheme | 現在のカラーテーマ |
| currentFileIconTheme | IWorkbenchFileIconTheme | 現在のファイルアイコンテーマ |
| currentProductIconTheme | IWorkbenchProductIconTheme | 現在の製品アイコンテーマ |

### 出力先

- UIスタイルの即時反映
- settings.json（テーマ設定の永続化）

## 処理フロー

### 処理シーケンス

```
1. ユーザーがテーマ選択コマンドを実行
   └─ Ctrl+K Ctrl+T または コマンドパレットから選択
2. InstalledThemesPicker表示
   └─ インストール済みテーマの一覧取得
3. テーマのプレビュー
   └─ 選択候補にカーソルを合わせると一時適用
4. テーマの選択
   └─ Enterで確定、Escでキャンセル
5. テーマの適用
   └─ WorkbenchThemeServiceでテーマを設定
6. 設定の永続化
   └─ ConfigurationServiceでsettings.jsonに保存
```

### フローチャート

```mermaid
flowchart TD
    A[テーマ選択コマンド実行] --> B[InstalledThemesPicker表示]
    B --> C[インストール済みテーマ取得]
    C --> D[クイックピック表示]
    D --> E{ユーザー操作}
    E -->|カーソル移動| F[プレビュー適用]
    F --> D
    E -->|Enter| G[テーマ確定]
    E -->|マーケットプレイス| H[MarketplaceThemesPicker]
    E -->|Escape| I[元のテーマに戻す]
    G --> J[WorkbenchThemeService.setTheme]
    H --> K[テーマ検索・インストール]
    K --> G
    J --> L[ConfigurationService保存]
    L --> M[UI反映]
    I --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-34-01 | システムモード検出 | OSのダーク/ライトモード設定を検出して自動切り替え | detectColorScheme設定が有効時 |
| BR-34-02 | プレビュー動作 | クイックピックでカーソルを合わせると200ms後にプレビュー | テーマ選択中 |
| BR-34-03 | キャンセル時復元 | Escapeキーでキャンセル時は元のテーマに戻す | テーマ選択中 |
| BR-34-04 | デフォルトテーマ | ファイルアイコンなし、製品アイコンはデフォルトが選択可能 | 常時 |

### 計算ロジック

システムカラーモードの検出:
1. window.matchMedia('(prefers-color-scheme: dark)')で検出
2. detectColorScheme設定が有効な場合、対応するテーマを自動適用

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テーマ読み込み | settings.json | SELECT | 現在のテーマ設定の読み込み |
| テーマ保存 | settings.json | UPDATE | テーマ設定の永続化 |

### テーブル別操作詳細

#### settings.json

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | workbench.colorTheme | テーマID | カラーテーマ |
| UPDATE | workbench.iconTheme | テーマID | ファイルアイコンテーマ |
| UPDATE | workbench.productIconTheme | テーマID | 製品アイコンテーマ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | テーマ読み込みエラー | テーマファイルの解析失敗 | デフォルトテーマにフォールバック |
| - | インストールエラー | マーケットプレイスからのインストール失敗 | エラー通知を表示 |

### リトライ仕様

マーケットプレイスからのインストール失敗時はユーザーに通知

## トランザクション仕様

なし

## パフォーマンス要件

- テーマ切り替え: 200ms以内
- プレビュー適用: 200ms以内
- マーケットプレイス検索: 1000ms以内

## セキュリティ考慮事項

- テーマはJSONで定義され、任意のコード実行は不可
- マーケットプレイスからのインストールは拡張機能として管理

## 備考

- SelectColorThemeCommandId = 'workbench.action.selectTheme'
- SelectFileIconThemeCommandId = 'workbench.action.selectIconTheme'
- SelectProductIconThemeCommandId = 'workbench.action.selectProductIconTheme'
- ライト/ダークテーマの切り替えコマンドも提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テーマ機能で扱うデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | workbenchThemeService.ts | `src/vs/workbench/services/themes/common/workbenchThemeService.ts` | IWorkbenchThemeService、IWorkbenchColorTheme等のインターフェース |

**読解のコツ**: テーマは3種類（カラー、ファイルアイコン、製品アイコン）あり、それぞれ別のインターフェースで管理される。

#### Step 2: エントリーポイントを理解する

テーマ選択コマンドの実装を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | themes.contribution.ts | `src/vs/workbench/contrib/themes/browser/themes.contribution.ts` | SelectColorThemeコマンド、InstalledThemesPickerクラス |

**主要処理フロー**:
1. **400-483行目**: SelectColorThemeコマンドの実装
2. **291-398行目**: InstalledThemesPickerクラス - テーマ選択UIの実装
3. **316-332行目**: selectTheme関数 - プレビューと確定の処理
4. **54-278行目**: MarketplaceThemesPickerクラス - マーケットプレイスからのテーマ取得

#### Step 3: テーマの適用を理解する

テーマサービスによる適用処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | workbenchThemeService.ts | `src/vs/workbench/services/themes/common/workbenchThemeService.ts` | setColorTheme、setFileIconTheme、setProductIconThemeメソッド |

**主要処理フロー**:
- テーマの読み込みと解析
- CSSスタイルの生成と適用
- 設定の永続化

#### Step 4: マーケットプレイス連携を理解する

マーケットプレイスからのテーマ取得・インストールを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | themes.contribution.ts | `src/vs/workbench/contrib/themes/browser/themes.contribution.ts` | MarketplaceThemesPickerクラス |

**主要処理フロー**:
- **54-85行目**: コンストラクタとプロパティ
- **106-158行目**: doSearch - マーケットプレイス検索
- **160-239行目**: openQuickPick - 検索結果の表示とインストール
- **241-265行目**: installExtension - 拡張機能としてインストール

### プログラム呼び出し階層図

```
SelectColorThemeAction.run()
    │
    ├─ IWorkbenchThemeService.getColorThemes()
    │
    ├─ InstalledThemesPicker.openQuickPick()
    │      │
    │      ├─ selectTheme(preview)
    │      │      └─ IWorkbenchThemeService.setColorTheme(theme, 'preview')
    │      │
    │      └─ selectTheme(apply)
    │             └─ IWorkbenchThemeService.setColorTheme(theme, 'auto')
    │
    └─ [マーケットプレイス選択時]
           │
           └─ MarketplaceThemesPicker.openQuickPick()
                  │
                  ├─ IExtensionGalleryService.query()
                  │
                  └─ IExtensionManagementService.installFromGallery()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

拡張機能                ───▶  WorkbenchThemeService         ───▶  UIスタイル適用
(テーマ定義)                         │
                                    ├─ ColorThemeData
settings.json          ───▶         ├─ FileIconThemeData    ───▶  settings.json
(テーマ設定)                        ├─ ProductIconThemeData
                                    │
マーケットプレイス      ───▶         └─ ExtensionManagement  ───▶  拡張機能インストール
(テーマ検索)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| themes.contribution.ts | `src/vs/workbench/contrib/themes/browser/themes.contribution.ts` | ソース | テーマ選択コマンドとUI |
| workbenchThemeService.ts | `src/vs/workbench/services/themes/common/workbenchThemeService.ts` | ソース | テーマサービスのインターフェース |
| colorThemeData.ts | `src/vs/workbench/services/themes/common/colorThemeData.ts` | ソース | カラーテーマのデータモデル |
| fileIconThemeData.ts | `src/vs/workbench/services/themes/browser/fileIconThemeData.ts` | ソース | ファイルアイコンテーマのデータモデル |
| productIconThemeData.ts | `src/vs/workbench/services/themes/browser/productIconThemeData.ts` | ソース | 製品アイコンテーマのデータモデル |
| colorRegistry.ts | `src/vs/platform/theme/common/colorRegistry.ts` | ソース | カラー定義のレジストリ |
