# 機能設計書 35-ノートブック

## 概要

本ドキュメントは、Visual Studio Codeのノートブック機能の設計内容を記述する。ノートブック機能は、Jupyter Notebookをはじめとする対話的なドキュメント形式をサポートし、コードセルとマークダウンセルを組み合わせた実行可能なドキュメントの編集・実行を提供する。

### 本機能の処理概要

ノートブック機能は、コードと説明テキストを交互に配置できる対話的なドキュメント形式を提供する。各セルは独立して実行可能であり、実行結果（テキスト、画像、グラフ等）はセルの直下に表示される。データサイエンス、機械学習、教育用ドキュメントなどの分野で広く使用される。

**業務上の目的・背景**：データサイエンティストや研究者は、コードの実行結果を確認しながらドキュメントを作成する必要がある。ノートブック形式は、コードと説明、実行結果を一つのドキュメントにまとめることで、再現性のある分析ワークフローを実現する。

**機能の利用シーン**：
- Jupyter Notebookファイル（.ipynb）の編集と実行
- Pythonによるデータ分析・機械学習の実験
- 教育用の対話的なコード説明ドキュメントの作成
- コードと結果を含むレポートの作成
- 複数のカーネルを使用した多言語プログラミング

**主要な処理内容**：
1. ノートブックファイルの読み込みとパース
2. セル（コード/マークダウン）の表示とレンダリング
3. カーネルの選択と接続
4. セルの実行と結果表示（テキスト、リッチ出力）
5. セルの追加・削除・移動・コピー
6. ノートブックファイルの保存

**関連システム・外部連携**：
- NotebookService: ノートブックの管理
- NotebookKernelService: カーネルの管理と実行
- NotebookRendererService: 出力のレンダリング
- ExtensionService: ノートブックプロバイダーの拡張機能

**権限による制御**：ワークスペーストラスト設定により、信頼されていないワークスペースではコードの自動実行が制限される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | ノートブックエディタ | 主画面 | セルの編集・実行 |

## 機能種別

エディタ / 実行環境

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| notebookUri | URI | Yes | ノートブックファイルのURI | 有効なファイルURI |
| viewType | string | No | ノートブックのビュータイプ | 登録済みのビュータイプ |

### 入力データソース

- ノートブックファイル（.ipynb等）
- カーネルプロバイダー（拡張機能）
- NotebookRendererExtensions（出力レンダラー）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| notebookTextModel | NotebookTextModel | ノートブックのデータモデル |
| cellOutputs | ICellOutput[] | セル実行結果 |

### 出力先

- ノートブックエディタUI
- ノートブックファイル（保存時）

## 処理フロー

### 処理シーケンス

```
1. ユーザーがノートブックファイルを開く
   └─ NotebookEditorInputの作成
2. NotebookEditorの初期化
   └─ NotebookEditorWidgetの作成
3. ノートブックモデルの読み込み
   └─ NotebookTextModelの構築
4. カーネルの選択
   └─ NotebookKernelServiceでカーネルを取得
5. セルのレンダリング
   └─ コードセル/マークダウンセルの表示
6. セル実行
   └─ カーネルにコードを送信、結果を受信
7. 出力のレンダリング
   └─ NotebookRendererServiceで出力を表示
8. 保存
   └─ NotebookTextModelをファイルに書き込み
```

### フローチャート

```mermaid
flowchart TD
    A[ノートブックを開く] --> B[NotebookEditorWidget作成]
    B --> C[NotebookTextModel読み込み]
    C --> D[セル一覧表示]
    D --> E{カーネル選択}
    E -->|選択| F[カーネル接続]
    E -->|未選択| G[カーネル選択UI]
    G --> F
    F --> H{ユーザー操作}
    H -->|セル編集| I[セル内容更新]
    H -->|セル実行| J[カーネルにコード送信]
    H -->|セル追加/削除| K[セル構造変更]
    I --> D
    J --> L[実行結果受信]
    L --> M[出力レンダリング]
    M --> D
    K --> D
    H -->|保存| N[ファイル書き込み]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-35-01 | セル実行順序 | セルは任意の順序で実行可能だが、変数のスコープはカーネルに依存 | コードセル実行時 |
| BR-35-02 | カーネル自動選択 | ファイルの言語に基づいて適切なカーネルを自動選択 | ノートブック初回オープン時 |
| BR-35-03 | 出力のMIMEタイプ | 複数のMIMEタイプがある場合、優先順位に基づいて表示 | 出力レンダリング時 |
| BR-35-04 | 信頼性制御 | 未信頼のノートブックではリッチ出力を制限 | ワークスペーストラスト無効時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 読み込み | ノートブックファイル | SELECT | ファイルからノートブック構造を読み込み |
| 保存 | ノートブックファイル | UPDATE | 編集内容をファイルに書き込み |

### テーブル別操作詳細

なし（ファイルベース）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | カーネル接続エラー | カーネルへの接続失敗 | エラー通知を表示、再接続を促す |
| - | 実行タイムアウト | セル実行がタイムアウト | ユーザーに通知、カーネル再起動オプション |
| - | ファイル読み込みエラー | 不正なノートブック形式 | エラー通知を表示 |
| - | ファイルサイズ超過 | 大きすぎるノートブックファイル | 警告を表示、部分読み込みオプション |

### リトライ仕様

カーネル接続エラー時は自動リトライ（設定可能）

## トランザクション仕様

なし

## パフォーマンス要件

- ノートブック表示: ファイルサイズに依存、基本的に1秒以内
- セル実行: カーネルの処理速度に依存
- 保存: 500ms以内

## セキュリティ考慮事項

- ワークスペーストラストによるコード実行制御
- 出力内のHTMLはサニタイズされる
- 外部カーネルへの接続はセキュリティ設定に基づく

## 備考

- NotebookEditor.ID = NOTEBOOK_EDITOR_ID
- Jupyter Notebookフォーマット（.ipynb）を標準サポート
- 拡張機能によるカスタムノートブックタイプのサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ノートブック機能で扱うデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notebookCommon.ts | `src/vs/workbench/contrib/notebook/common/notebookCommon.ts` | CellKind、NOTEBOOK_EDITOR_ID、INotebookCellなどの型定義 |
| 1-2 | notebookTextModel.ts | `src/vs/workbench/contrib/notebook/common/model/notebookTextModel.ts` | NotebookTextModelクラス |

**読解のコツ**: ノートブックはセルの配列で構成され、各セルはCellKind（コード/マークダウン）、内容、出力を持つ。

#### Step 2: エントリーポイントを理解する

ノートブックエディタの起動から表示までの流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notebookEditor.ts | `src/vs/workbench/contrib/notebook/browser/notebookEditor.ts` | NotebookEditorクラス |
| 2-2 | notebookEditorWidget.ts | `src/vs/workbench/contrib/notebook/browser/notebookEditorWidget.ts` | NotebookEditorWidgetクラス |

**主要処理フロー**:
1. **55-56行目** (notebookEditor.ts): NotebookEditor.ID = NOTEBOOK_EDITOR_ID
2. **82-106行目**: コンストラクタ - 各種サービスの注入
3. **197-200行目**: setInput - ノートブックの読み込み開始

#### Step 3: セル操作を理解する

セルの追加・削除・移動などの操作を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | coreActions.ts | `src/vs/workbench/contrib/notebook/browser/controller/coreActions.ts` | セル操作のアクション |

**主要処理フロー**:
- SELECT_KERNEL_ID: カーネル選択アクション
- セルの実行、追加、削除、移動などのアクション

#### Step 4: カーネル管理を理解する

カーネルの選択と実行の処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | notebookKernelService.ts | `src/vs/workbench/contrib/notebook/common/notebookKernelService.ts` | INotebookKernelService |

**主要処理フロー**:
- カーネルの登録と取得
- セル実行リクエストの送信

#### Step 5: 出力レンダリングを理解する

セル出力の表示処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | notebookRendererService.ts | `src/vs/workbench/contrib/notebook/common/notebookRendererService.ts` | INotebookRendererService |

**主要処理フロー**:
- MIMEタイプに基づくレンダラーの選択
- リッチ出力（HTML、画像、グラフ等）のレンダリング

### プログラム呼び出し階層図

```
NotebookEditor.setInput()
    │
    ├─ NotebookEditorWidget.setModel()
    │      │
    │      ├─ NotebookTextModel読み込み
    │      │      └─ INotebookService.resolveNotebook()
    │      │
    │      └─ セル一覧のレンダリング
    │             └─ CellRenderer
    │
    └─ [セル実行時]
           │
           ├─ INotebookKernelService.selectKernel()
           │
           └─ カーネル.executeNotebookCell()
                  │
                  └─ INotebookRendererService.renderOutput()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

ノートブックファイル    ───▶  NotebookEditor                ───▶  ノートブックUI
(.ipynb)                           │
                                   ├─ NotebookEditorWidget
                                   ├─ NotebookTextModel
カーネル               ───▶        ├─ NotebookKernelService  ───▶  実行結果
(Jupyter等)                        │
                                   └─ NotebookRendererService ───▶ リッチ出力表示
ユーザー入力           ───▶
(セル編集、実行)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notebookEditor.ts | `src/vs/workbench/contrib/notebook/browser/notebookEditor.ts` | ソース | ノートブックエディタペイン |
| notebookEditorWidget.ts | `src/vs/workbench/contrib/notebook/browser/notebookEditorWidget.ts` | ソース | ノートブックウィジェット |
| notebookTextModel.ts | `src/vs/workbench/contrib/notebook/common/model/notebookTextModel.ts` | ソース | ノートブックデータモデル |
| notebookCommon.ts | `src/vs/workbench/contrib/notebook/common/notebookCommon.ts` | ソース | 共通型定義 |
| notebookKernelService.ts | `src/vs/workbench/contrib/notebook/common/notebookKernelService.ts` | ソース | カーネル管理サービス |
| notebookRendererService.ts | `src/vs/workbench/contrib/notebook/common/notebookRendererService.ts` | ソース | 出力レンダリングサービス |
| notebookEditorInput.ts | `src/vs/workbench/contrib/notebook/common/notebookEditorInput.ts` | ソース | エディタ入力クラス |
| coreActions.ts | `src/vs/workbench/contrib/notebook/browser/controller/coreActions.ts` | ソース | セル操作アクション |
