# 機能設計書 36-チャット

## 概要

本ドキュメントは、Visual Studio CodeのAI統合チャット機能の設計内容を記述する。チャット機能は、AI（Copilot等）との対話を通じてコード生成、質問応答、コード説明などの支援を受けるための中核的なAI支援機能である。

### 本機能の処理概要

チャット機能は、VS Code内でAIアシスタント（GitHub Copilot等）と対話するためのインターフェースを提供する。ユーザーは自然言語で質問やリクエストを入力し、AIからコード提案、説明、デバッグ支援などの応答を受け取ることができる。

**業務上の目的・背景**：開発作業において、コードの書き方、バグの原因調査、APIの使用方法など、様々な疑問が生じる。AI統合チャットは、これらの疑問に対して即座に回答を得ることで、開発効率を大幅に向上させる。また、コード生成やリファクタリングの提案により、反復的な作業を削減できる。

**機能の利用シーン**：
- コードの書き方や設計パターンについて質問する場合
- エラーの原因調査とデバッグ支援を受ける場合
- 新しいコードを生成させる場合
- 既存コードの説明やドキュメント生成を依頼する場合
- テストコードの生成を依頼する場合

**主要な処理内容**：
1. ユーザー入力の受け付けとチャットセッション管理
2. コンテキスト情報（選択中のコード、ファイル等）の収集
3. AIプロバイダー（言語モデル）へのリクエスト送信
4. ストリーミング応答の表示とマークダウンレンダリング
5. コードブロックの表示とクリップボード/エディタへの挿入
6. チャット履歴の保存と復元
7. 複数のAIエージェント（参加者）のサポート

**関連システム・外部連携**：
- ChatService: チャットセッションとメッセージの管理
- ChatAgentService: AIエージェント（参加者）の管理
- LanguageModelsService: 言語モデルプロバイダーの管理
- ChatVariablesService: コンテキスト変数の解決
- ChatEditingService: コード編集の統合

**権限による制御**：
- AIサービスの利用には認証（GitHub等）が必要
- エンタープライズポリシーによるAI機能の制限

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | チャットビュー | 主画面 | AIとの対話インターフェース |
| 37 | チャットエディタ | 参照画面 | エディタペインでのチャット |

## 機能種別

AI支援 / 対話インターフェース

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| message | string | Yes | ユーザーの入力メッセージ | 空文字不可 |
| attachments | IChatAttachment[] | No | 添付ファイルやコンテキスト | なし |
| agent | string | No | 対象のAIエージェントID | 登録済みエージェント |
| mode | ChatModeKind | No | チャットモード（Ask/Edit等） | 有効なモード |

### 入力データソース

- ユーザーのテキスト入力
- 選択中のコードや開いているファイル
- @メンションによるコンテキスト参照
- 添付ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| response | IChatResponseModel | AIからの応答 |
| codeBlocks | ICodeBlock[] | 応答内のコードブロック |

### 出力先

- チャットUI（サイドバーまたはエディタ）
- エディタ（コードブロック挿入時）
- クリップボード（コピー時）

## 処理フロー

### 処理シーケンス

```
1. ユーザーがチャットウィジェットにメッセージを入力
   └─ ChatWidget.acceptInput()
2. コンテキスト情報の収集
   └─ ChatVariablesService.resolveVariables()
3. リクエストの構築
   └─ ChatService.sendRequest()
4. AIプロバイダーへの送信
   └─ LanguageModelsService経由で言語モデルにリクエスト
5. ストリーミング応答の受信
   └─ onDidReceiveProgress イベントで逐次表示
6. 応答のレンダリング
   └─ マークダウン、コードブロック、参照の表示
7. ツール実行（必要に応じて）
   └─ LanguageModelToolsService.invokeTool()
8. 応答の完了
   └─ 履歴への保存
```

### フローチャート

```mermaid
flowchart TD
    A[メッセージ入力] --> B[コンテキスト収集]
    B --> C[リクエスト構築]
    C --> D[ChatService.sendRequest]
    D --> E[言語モデルへ送信]
    E --> F[ストリーミング応答開始]
    F --> G{応答内容}
    G -->|テキスト| H[マークダウンレンダリング]
    G -->|コードブロック| I[コードブロック表示]
    G -->|ツール呼び出し| J[ツール実行]
    H --> K{応答継続?}
    I --> K
    J --> K
    K -->|Yes| G
    K -->|No| L[応答完了]
    L --> M[履歴保存]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-36-01 | 認証必須 | AIサービス利用には認証が必要 | 常時 |
| BR-36-02 | エンタイトルメント | 利用資格に基づく機能制限 | 商用利用時 |
| BR-36-03 | コンテキスト制限 | コンテキストサイズに上限あり | リクエスト構築時 |
| BR-36-04 | ストリーミング表示 | 応答は逐次表示される | 応答受信時 |
| BR-36-05 | ツール自動承認 | 設定により一部ツールは自動実行可能 | ツール呼び出し時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 履歴保存 | ChatSessionStorage | INSERT | チャット履歴の永続化 |
| 履歴読込 | ChatSessionStorage | SELECT | チャット履歴の復元 |

### テーブル別操作詳細

なし（メモリ/ローカルストレージベース）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | 未認証またはトークン期限切れ | サインインを促す |
| - | レート制限 | APIリクエスト制限超過 | 待機を促すメッセージ表示 |
| - | ネットワークエラー | API接続失敗 | リトライまたはエラー通知 |
| - | コンテキスト超過 | コンテキストサイズ超過 | 入力の削減を促す |

### リトライ仕様

ネットワークエラー時は自動リトライ（指数バックオフ）

## トランザクション仕様

なし

## パフォーマンス要件

- 初回トークン表示: 1秒以内
- ストリーミング応答: リアルタイム表示
- チャット履歴読込: 500ms以内

## セキュリティ考慮事項

- AI送信データは暗号化通信
- 機密コードの送信は設定で制御可能
- 企業ポリシーによるAI機能制限のサポート
- ツール実行は承認フロー経由

## 備考

- ChatAgentLocation: Panel（サイドバー）、Editor（エディタ）、Notebook（ノートブック内）
- @メンション（@workspace、@vscode、@terminal等）でコンテキストを指定可能
- スラッシュコマンド（/explain、/fix、/tests等）で操作を指定可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

チャット機能で扱うデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | chatService.ts | `src/vs/workbench/contrib/chat/common/chatService/chatService.ts` | IChatService、IChatModel、IChatRequestModelなどのインターフェース |
| 1-2 | constants.ts | `src/vs/workbench/contrib/chat/common/constants.ts` | ChatAgentLocation、ChatModeKindなどの定数 |

**読解のコツ**: チャットはセッション（IChatModel）で管理され、各セッションはリクエスト/レスポンスのペアを持つ。

#### Step 2: エントリーポイントを理解する

チャット機能の登録と初期化を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | chat.contribution.ts | `src/vs/workbench/contrib/chat/browser/chat.contribution.ts` | サービス登録、設定定義、アクション登録 |

**主要処理フロー**:
1. **148-200行目**: 設定スキーマの定義（chat.fontSize、chat.fontFamily等）
2. **34-65行目**: 各種サービスのインポートと登録

#### Step 3: ウィジェットを理解する

チャットUIの実装を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | chatWidget.ts | `src/vs/workbench/contrib/chat/browser/widget/chatWidget.ts` | ChatWidgetクラス |

**主要処理フロー**:
- 入力ボックス、メッセージリスト、コードブロックの管理
- acceptInput(): メッセージ送信処理

#### Step 4: サービス層を理解する

チャットのバックエンド処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | chatServiceImpl.ts | `src/vs/workbench/contrib/chat/common/chatService/chatServiceImpl.ts` | ChatServiceクラス |
| 4-2 | languageModels.ts | `src/vs/workbench/contrib/chat/common/languageModels.ts` | ILanguageModelsService |

**主要処理フロー**:
- sendRequest(): リクエスト送信とストリーミング応答の処理
- 言語モデルプロバイダーの管理

#### Step 5: エージェント（参加者）を理解する

AIエージェントの管理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | chatAgents.ts | `src/vs/workbench/contrib/chat/common/participants/chatAgents.ts` | IChatAgentService |

**主要処理フロー**:
- エージェントの登録と取得
- @メンションによるエージェント指定

### プログラム呼び出し階層図

```
ChatWidget.acceptInput()
    │
    ├─ IChatVariablesService.resolveVariables()
    │      └─ @メンションの解決
    │
    ├─ IChatService.sendRequest()
    │      │
    │      ├─ IChatAgentService.getAgent()
    │      │
    │      └─ ILanguageModelsService.sendChatRequest()
    │             │
    │             └─ ストリーミング応答
    │                    │
    │                    ├─ テキストチャンク
    │                    ├─ コードブロック
    │                    └─ ツール呼び出し
    │                           └─ ILanguageModelToolsService.invokeTool()
    │
    └─ IChatWidgetHistoryService.saveHistory()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

ユーザー入力            ───▶  ChatWidget                    ───▶  チャットUI
(メッセージ)                        │
                                   ├─ ChatService
コンテキスト            ───▶        ├─ ChatVariablesService
(@workspace等)                     ├─ ChatAgentService
                                   │
言語モデル              ◀───        └─ LanguageModelsService  ───▶  ストリーミング応答
(Copilot等)

ツールサービス          ◀───────────────────────────────────▶  ツール実行結果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| chat.contribution.ts | `src/vs/workbench/contrib/chat/browser/chat.contribution.ts` | ソース | 機能登録と設定 |
| chatWidget.ts | `src/vs/workbench/contrib/chat/browser/widget/chatWidget.ts` | ソース | チャットUIウィジェット |
| chatServiceImpl.ts | `src/vs/workbench/contrib/chat/common/chatService/chatServiceImpl.ts` | ソース | チャットサービス実装 |
| chatService.ts | `src/vs/workbench/contrib/chat/common/chatService/chatService.ts` | ソース | チャットサービスインターフェース |
| languageModels.ts | `src/vs/workbench/contrib/chat/common/languageModels.ts` | ソース | 言語モデルサービス |
| chatAgents.ts | `src/vs/workbench/contrib/chat/common/participants/chatAgents.ts` | ソース | エージェントサービス |
| chatVariables.ts | `src/vs/workbench/contrib/chat/common/attachments/chatVariables.ts` | ソース | 変数解決サービス |
| constants.ts | `src/vs/workbench/contrib/chat/common/constants.ts` | ソース | 定数定義 |
| chatEditingServiceImpl.ts | `src/vs/workbench/contrib/chat/browser/chatEditing/chatEditingServiceImpl.ts` | ソース | コード編集統合 |
