# 機能設計書 37-インラインチャット

## 概要

本ドキュメントは、Visual Studio Codeのインラインチャット機能の設計内容を記述する。インラインチャット機能は、エディタ内で直接AIとの対話を行い、コードの編集・生成・リファクタリングを行うためのエディタ統合型AI支援機能である。

### 本機能の処理概要

インラインチャット機能は、サイドパネルのチャットとは異なり、エディタ内の特定の位置に小さなチャットUIを表示し、その場でAIと対話してコード変更を行う機能である。選択中のコードに対する操作（説明、修正、リファクタリング）や、カーソル位置への新規コード生成が可能である。

**業務上の目的・背景**：コード編集中に、コンテキストを切り替えることなくAI支援を受けられることで、開発のフローを維持しながら効率的にコードを改善できる。特に、選択中のコードに対する即座の操作が可能であり、パネルチャットより迅速なインタラクションを実現する。

**機能の利用シーン**：
- 選択中のコードの説明を求める場合
- バグのあるコードを修正する場合
- コードをリファクタリングする場合
- カーソル位置に新しいコードを生成する場合
- テストコードを生成する場合

**主要な処理内容**：
1. エディタ内でのインラインチャットウィジェット表示
2. 選択中のコードまたはカーソル位置のコンテキスト取得
3. AIへのリクエスト送信とストリーミング応答の表示
4. 提案されたコード変更のプレビュー表示
5. 変更の適用（Accept）またはキャンセル
6. 変更履歴の管理（Undo対応）

**関連システム・外部連携**：
- InlineChatController: インラインチャットの制御
- InlineChatSessionService: セッション管理
- ChatService: AIとの対話処理
- EditorService: エディタへのコード反映

**権限による制御**：パネルチャットと同様、AIサービスの利用には認証が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | エディタ | 主画面 | インラインチャットウィジェットの表示・操作 |

## 機能種別

AI支援 / エディタ統合

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| message | string | Yes | ユーザーの入力メッセージ | 空文字不可 |
| selection | IRange | No | 選択中のコード範囲 | 有効な範囲 |

### 入力データソース

- ユーザーのテキスト入力
- エディタの選択範囲またはカーソル位置
- 現在のファイルコンテキスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| proposedEdit | ITextEdit | 提案されたコード変更 |
| response | string | AIからのテキスト応答 |

### 出力先

- インラインチャットウィジェット（応答テキスト）
- エディタ（コード変更のプレビュー/適用）

## 処理フロー

### 処理シーケンス

```
1. ユーザーがインラインチャットを起動
   └─ Ctrl+I または コンテキストメニューから選択
2. InlineChatControllerの起動
   └─ インラインチャットウィジェットの表示
3. ユーザー入力の受け付け
   └─ メッセージ入力またはスラッシュコマンド選択
4. コンテキスト情報の収集
   └─ 選択範囲、周辺コード、ファイル情報
5. AIへのリクエスト送信
   └─ ChatService経由でリクエスト
6. ストリーミング応答の表示
   └─ テキスト応答とコード変更の分離
7. コード変更のプレビュー
   └─ エディタ内でdiff表示
8. ユーザーの操作
   └─ Accept（適用）、Discard（破棄）、継続編集
```

### フローチャート

```mermaid
flowchart TD
    A[Ctrl+Iで起動] --> B[InlineChatWidget表示]
    B --> C[メッセージ入力]
    C --> D[コンテキスト収集]
    D --> E[AIリクエスト送信]
    E --> F[ストリーミング応答]
    F --> G{応答内容}
    G -->|テキスト| H[テキスト表示]
    G -->|コード変更| I[diff プレビュー]
    H --> J{ユーザー操作}
    I --> J
    J -->|Accept| K[変更適用]
    J -->|Discard| L[変更破棄]
    J -->|継続| C
    K --> M[セッション終了]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-37-01 | 編集モード | 選択範囲がある場合は編集モード、なければ生成モード | セッション開始時 |
| BR-37-02 | Undo対応 | 適用された変更はUndo操作で元に戻せる | 変更適用後 |
| BR-37-03 | セッション排他 | 1つのエディタに対して同時に1つのセッションのみ | 常時 |
| BR-37-04 | V1モード | レガシーモード（CTX_INLINE_CHAT_V1_ENABLED）のサポート | 設定による |

### 計算ロジック

特になし

## データベース操作仕様

なし（メモリ内操作）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | 未認証またはトークン期限切れ | サインインを促す |
| - | AIエラー | AIサービスからのエラー応答 | エラーメッセージを表示 |
| - | 競合エラー | 編集中にファイルが変更された | 競合解決を促す |

### リトライ仕様

AIエラー時はユーザーに再試行を促す

## トランザクション仕様

なし（エディタのUndo/Redoスタックで管理）

## パフォーマンス要件

- ウィジェット表示: 100ms以内
- 初回トークン表示: 1秒以内
- 変更プレビュー更新: リアルタイム

## セキュリティ考慮事項

- パネルチャットと同様の認証・認可制御
- エディタ内容がAIに送信されることの透明性

## 備考

- InlineChatController.ID = 'editor.contrib.inlineChat'
- スラッシュコマンド（/doc、/explain、/fix等）のサポート
- ガターアイコンからの起動もサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

インラインチャット機能で扱うデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | inlineChat.ts | `src/vs/workbench/contrib/inlineChat/common/inlineChat.ts` | コンテキストキー、メニューID、インターフェース定義 |

**読解のコツ**: CTX_INLINE_CHAT_*のコンテキストキーでインラインチャットの状態を管理する。

#### Step 2: エントリーポイントを理解する

インラインチャットの登録と初期化を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | inlineChat.contribution.ts | `src/vs/workbench/contrib/inlineChat/browser/inlineChat.contribution.ts` | エディタコントリビューションの登録 |

**主要処理フロー**:
1. **27行目**: InlineChatControllerのエディタコントリビューション登録
2. **29-31行目**: アクション登録（KeepSessionAction、UndoAndCloseSessionAction）
3. **34行目**: InlineChatSessionServiceImplのシングルトン登録

#### Step 3: コントローラーを理解する

インラインチャットの制御ロジックを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | inlineChatController.ts | `src/vs/workbench/contrib/inlineChat/browser/inlineChatController.ts` | InlineChatControllerクラス |

**主要処理フロー**:
- セッションの開始と終了
- ウィジェットの表示制御
- AIリクエストの送信と応答処理

#### Step 4: アクションを理解する

インラインチャットのアクションを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | inlineChatActions.ts | `src/vs/workbench/contrib/inlineChat/browser/inlineChatActions.ts` | StartSessionAction、KeepSessionAction等 |

**主要処理フロー**:
- StartSessionAction: インラインチャットの起動
- KeepSessionAction: 変更の適用
- UndoAndCloseSessionAction: 変更の破棄

### プログラム呼び出し階層図

```
StartSessionAction.run()
    │
    └─ InlineChatController.run()
           │
           ├─ InlineChatWidget表示
           │
           ├─ IInlineChatSessionService.createSession()
           │
           └─ [メッセージ送信時]
                  │
                  ├─ IChatService.sendRequest()
                  │
                  └─ [応答受信時]
                         │
                         ├─ テキスト応答表示
                         │
                         └─ コード変更プレビュー
                                │
                                ├─ KeepSessionAction → 変更適用
                                │
                                └─ UndoAndCloseSessionAction → 変更破棄
```

### データフロー図

```
[入力]                        [処理]                              [出力]

ユーザー入力            ───▶  InlineChatController          ───▶  インラインウィジェット
(Ctrl+I、メッセージ)              │
                                  ├─ InlineChatWidget
エディタ選択範囲        ───▶       ├─ InlineChatSessionService
                                  │
                                  └─ ChatService             ───▶  コード変更プレビュー
                                         │
                                         └─ LanguageModelsService  ───▶  エディタ反映
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| inlineChat.contribution.ts | `src/vs/workbench/contrib/inlineChat/browser/inlineChat.contribution.ts` | ソース | 機能登録 |
| inlineChatController.ts | `src/vs/workbench/contrib/inlineChat/browser/inlineChatController.ts` | ソース | メインコントローラー |
| inlineChatActions.ts | `src/vs/workbench/contrib/inlineChat/browser/inlineChatActions.ts` | ソース | アクション定義 |
| inlineChatSessionService.ts | `src/vs/workbench/contrib/inlineChat/browser/inlineChatSessionService.ts` | ソース | セッション管理インターフェース |
| inlineChatSessionServiceImpl.ts | `src/vs/workbench/contrib/inlineChat/browser/inlineChatSessionServiceImpl.ts` | ソース | セッション管理実装 |
| inlineChat.ts | `src/vs/workbench/contrib/inlineChat/common/inlineChat.ts` | ソース | 共通定義 |
| inlineChatNotebook.ts | `src/vs/workbench/contrib/inlineChat/browser/inlineChatNotebook.ts` | ソース | ノートブック統合 |
