# 機能設計書 38-マージエディタ

## 概要

本ドキュメントは、Visual Studio Codeのマージエディタ機能の設計内容を記述する。マージエディタは、Gitなどのバージョン管理システムで発生する3-wayマージの競合を視覚的に解決するための専用エディタである。

### 本機能の処理概要

マージエディタ機能は、3つのバージョン（Base、Input 1、Input 2）と結果（Result）を表示し、競合箇所を視覚的に比較・解決するための専用エディタを提供する。ユーザーは各競合について、どちらの変更を採用するか、または両方を組み合わせるかを選択できる。

**業務上の目的・背景**：チーム開発において、複数の開発者が同じファイルを編集した場合にマージ競合が発生する。従来のテキストベースのマージマーカー（<<<<、====、>>>>）は理解しにくく、誤った解決をしやすい。マージエディタは、視覚的な比較と直感的な操作で競合解決を支援する。

**機能の利用シーン**：
- Gitのマージ操作で競合が発生した場合
- Gitのリベース操作で競合が発生した場合
- プルリクエストをマージする際に競合がある場合
- チェリーピック操作で競合が発生した場合

**主要な処理内容**：
1. 3-wayマージの入力ファイル（Base、Input 1、Input 2）の読み込み
2. 差分アルゴリズムによる競合箇所の検出
3. 4ペイン表示（Base、Input 1、Input 2、Result）
4. 各競合に対するアクション（Accept Input 1、Accept Input 2、Accept Combination）
5. 結果ファイルの編集とプレビュー
6. マージ完了の確定と保存

**関連システム・外部連携**：
- SCM（Source Control Management）: 競合ファイルの検出と状態管理
- DiffService: 差分計算
- EditorService: エディタの管理

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | マージエディタ | 主画面 | 3-wayマージの競合解決 |

## 機能種別

エディタ / 差分比較

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| base | URI | Yes | ベースファイル（共通の祖先） | 有効なファイルURI |
| input1 | URI | Yes | 入力1（現在のブランチ） | 有効なファイルURI |
| input2 | URI | Yes | 入力2（マージ元のブランチ） | 有効なファイルURI |
| result | URI | Yes | 結果ファイル | 有効なファイルURI |

### 入力データソース

- Gitの競合ファイル（マージマーカー付き）
- SCMサービスからの競合情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| resolvedContent | string | 競合解決後のファイル内容 |
| conflictCount | number | 未解決の競合数 |

### 出力先

- 結果ファイル（マージ結果）
- SCMサービス（競合解決状態の更新）

## 処理フロー

### 処理シーケンス

```
1. 競合ファイルの検出
   └─ SCMサービスからマージ競合を検出
2. マージエディタの起動
   └─ MergeEditorInputの作成
3. 3-wayマージモデルの構築
   └─ Base、Input 1、Input 2、Resultの読み込み
4. 競合箇所の検出
   └─ 差分アルゴリズムによる分析
5. UIの表示
   └─ 4ペインレイアウトまたは列レイアウト
6. ユーザーによる競合解決
   └─ 各競合に対するアクション選択
7. マージ完了
   └─ Accept Mergeでファイル保存
```

### フローチャート

```mermaid
flowchart TD
    A[競合ファイル検出] --> B[MergeEditor起動]
    B --> C[3-wayマージモデル構築]
    C --> D[競合箇所検出]
    D --> E[4ペイン表示]
    E --> F{競合あり?}
    F -->|Yes| G[競合選択]
    G --> H{アクション}
    H -->|Accept Input1| I[Input1を採用]
    H -->|Accept Input2| J[Input2を採用]
    H -->|Accept Combination| K[両方を組み合わせ]
    H -->|Manual Edit| L[手動編集]
    I --> M[Result更新]
    J --> M
    K --> M
    L --> M
    M --> F
    F -->|No| N[Accept Merge]
    N --> O[ファイル保存]
    O --> P[競合解決完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-38-01 | 競合未解決警告 | 未解決の競合がある状態での保存時に警告 | 保存操作時 |
| BR-38-02 | 自動マージ | 競合しない変更は自動的にマージ | マージエディタ起動時 |
| BR-38-03 | 差分アルゴリズム | advanced（デフォルト）またはlegacyを選択可能 | 設定による |
| BR-38-04 | 削除マーカー表示 | 削除された行を視覚的に表示 | 設定による |

### 計算ロジック

差分アルゴリズムの選択:
- advanced: より高精度な差分計算（デフォルト）
- legacy: 従来の差分計算

## データベース操作仕様

なし（ファイルベース）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル読み込みエラー | 入力ファイルが存在しない | エラー通知を表示 |
| - | 競合未解決エラー | 未解決の競合がある状態で保存 | 警告ダイアログを表示 |

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

- マージエディタ表示: 1秒以内（ファイルサイズによる）
- 競合解決アクション: 100ms以内

## セキュリティ考慮事項

特になし

## 備考

- MergeEditor.ID = 'workbench.editor.mergeEditor'
- レイアウト: Mixed（デフォルト）またはColumn
- Base表示の切り替え可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

マージエディタで扱うデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mergeEditorInput.ts | `src/vs/workbench/contrib/mergeEditor/browser/mergeEditorInput.ts` | MergeEditorInputクラス |

**読解のコツ**: マージエディタは4つのリソース（Base、Input 1、Input 2、Result）を管理する。

#### Step 2: エントリーポイントを理解する

マージエディタの登録と初期化を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mergeEditor.contribution.ts | `src/vs/workbench/contrib/mergeEditor/browser/mergeEditor.contribution.ts` | エディタペインとアクションの登録 |

**主要処理フロー**:
1. **29-38行目**: MergeEditorのエディタペイン登録
2. **40-43行目**: MergeEditorSerializerの登録
3. **45-62行目**: 設定スキーマ（diffAlgorithm、showDeletionMarkers）の登録
4. **64-92行目**: 各種アクションの登録

#### Step 3: エディタ本体を理解する

マージエディタの実装を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mergeEditor.ts | `src/vs/workbench/contrib/mergeEditor/browser/view/mergeEditor.ts` | MergeEditorクラス |

**主要処理フロー**:
- 4ペインレイアウトの構築
- 競合箇所のハイライト表示
- アクションボタンの配置

#### Step 4: コマンドを理解する

マージエディタのコマンドを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | commands.ts | `src/vs/workbench/contrib/mergeEditor/browser/commands/commands.ts` | AcceptMerge、GoToNextUnhandledConflict等 |

**主要処理フロー**:
- AcceptMerge: マージの確定
- GoToNextUnhandledConflict: 次の未解決競合へ移動
- AcceptAllInput1/AcceptAllInput2: すべての競合を一括解決

### プログラム呼び出し階層図

```
OpenMergeEditorAction.run()
    │
    └─ IEditorService.openEditor(MergeEditorInput)
           │
           ├─ MergeEditorInput.resolve()
           │      └─ 4ファイルの読み込み
           │
           └─ MergeEditor.setInput()
                  │
                  ├─ 差分計算
                  │
                  ├─ 競合検出
                  │
                  └─ UIレンダリング
                         │
                         └─ [競合解決時]
                                │
                                ├─ AcceptAllInput1/2
                                ├─ ToggleActiveConflictInput1/2
                                └─ AcceptMerge
                                       └─ ファイル保存
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Base (共通祖先)         ───▶  MergeEditor                   ───▶  4ペイン表示
Input 1 (現在)          ───▶         │
Input 2 (マージ元)      ───▶         ├─ 差分アルゴリズム
                                     ├─ 競合検出
                                     │
ユーザー操作            ───▶         └─ 競合解決アクション    ───▶  Result ファイル
(Accept、Edit)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mergeEditor.contribution.ts | `src/vs/workbench/contrib/mergeEditor/browser/mergeEditor.contribution.ts` | ソース | 機能登録 |
| mergeEditor.ts | `src/vs/workbench/contrib/mergeEditor/browser/view/mergeEditor.ts` | ソース | エディタ本体 |
| mergeEditorInput.ts | `src/vs/workbench/contrib/mergeEditor/browser/mergeEditorInput.ts` | ソース | エディタ入力 |
| mergeEditorSerializer.ts | `src/vs/workbench/contrib/mergeEditor/browser/mergeEditorSerializer.ts` | ソース | シリアライザー |
| commands.ts | `src/vs/workbench/contrib/mergeEditor/browser/commands/commands.ts` | ソース | コマンド定義 |
| devCommands.ts | `src/vs/workbench/contrib/mergeEditor/browser/commands/devCommands.ts` | ソース | 開発用コマンド |
| mergeEditorAccessibilityHelp.ts | `src/vs/workbench/contrib/mergeEditor/browser/mergeEditorAccessibilityHelp.ts` | ソース | アクセシビリティ |
