# 機能設計書 39-差分エディタ

## 概要

本ドキュメントは、Visual Studio Codeの差分エディタ（マルチ差分エディタ）機能の設計内容を記述する。差分エディタは、複数のファイル間の差分を一覧表示し、変更内容を効率的にレビューするための専用エディタである。

### 本機能の処理概要

差分エディタ機能は、2つのファイルまたは複数ファイル間の差分を視覚的に表示する機能を提供する。特にマルチ差分エディタは、SCM（ソース管理）の変更一覧やプルリクエストの変更ファイルを一つのビューで効率的にレビューできる。

**業務上の目的・背景**：コードレビューやコミット前の変更確認において、複数のファイルの変更を一つ一つ開くのは非効率である。マルチ差分エディタは、すべての変更を一覧表示し、連続してナビゲートすることで、レビュー作業を効率化する。

**機能の利用シーン**：
- Gitのコミット前に変更内容を確認する場合
- プルリクエストの変更内容をレビューする場合
- 特定のコミット間の変更を比較する場合
- ワーキングツリーの変更を確認する場合

**主要な処理内容**：
1. 差分ソース（SCMグループ、コミット範囲等）からの差分リスト取得
2. 各ファイルペアの差分計算
3. マルチ差分ビューでの一覧表示
4. 変更箇所間のナビゲーション
5. 変更の展開/折りたたみ

**関連システム・外部連携**：
- MultiDiffSourceResolverService: 差分ソースの解決
- SCMService: ソース管理の変更情報取得
- DiffService: 差分計算

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | 差分エディタ | 主画面 | ファイル間の差分表示 |

## 機能種別

エディタ / 差分比較

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| multiDiffSource | URI | Yes | 差分ソースのURI | 有効なURI |

### 入力データソース

- SCMサービス（ステージされた変更、変更、未追跡ファイル）
- Gitコミット範囲
- プルリクエストの変更ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| diffEntries | IMultiDiffEntry[] | 差分エントリの一覧 |
| currentDiff | IDiffEntry | 現在フォーカス中の差分 |

### 出力先

- マルチ差分エディタUI

## 処理フロー

### 処理シーケンス

```
1. 差分ソースの指定
   └─ SCMグループ、コミット範囲等
2. MultiDiffEditorの起動
   └─ MultiDiffEditorInputの作成
3. 差分ソースの解決
   └─ MultiDiffSourceResolverServiceで差分リスト取得
4. 差分計算
   └─ 各ファイルペアの差分を計算
5. UI表示
   └─ 差分一覧とプレビューの表示
6. ナビゲーション
   └─ 次/前の変更へ移動
```

### フローチャート

```mermaid
flowchart TD
    A[差分ソース指定] --> B[MultiDiffEditor起動]
    B --> C[MultiDiffSourceResolver]
    C --> D[差分リスト取得]
    D --> E[各ファイルの差分計算]
    E --> F[マルチ差分ビュー表示]
    F --> G{ユーザー操作}
    G -->|次の変更| H[GoToNextChange]
    G -->|前の変更| I[GoToPreviousChange]
    G -->|ファイル選択| J[GoToFile]
    G -->|展開| K[Expand]
    G -->|折りたたみ| L[Collapse]
    H --> F
    I --> F
    J --> F
    K --> F
    L --> F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-39-01 | 差分計算遅延 | 表示領域外の差分は遅延計算 | パフォーマンス最適化 |
| BR-39-02 | 変更ハイライト | 追加（緑）、削除（赤）で色分け | 常時 |
| BR-39-03 | インライン/サイドバイサイド | 表示モードの切り替え可能 | 設定による |

### 計算ロジック

特になし

## データベース操作仕様

なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ソース解決エラー | 差分ソースの取得失敗 | エラー通知を表示 |
| - | 差分計算エラー | ファイルの差分計算失敗 | 該当ファイルをスキップ |

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

- マルチ差分ビュー表示: ファイル数に依存、基本的に1秒以内
- 変更間ナビゲーション: 100ms以内

## セキュリティ考慮事項

特になし

## 備考

- MultiDiffEditor.ID = 'multiDiffEditor'
- SCMグループ（Staged Changes、Changes等）からの直接起動をサポート
- 展開/折りたたみで詳細表示を制御

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

差分エディタで扱うデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | multiDiffEditorInput.ts | `src/vs/workbench/contrib/multiDiffEditor/browser/multiDiffEditorInput.ts` | MultiDiffEditorInput、IMultiDiffSourceResolverService |

**読解のコツ**: マルチ差分エディタは差分ソースからファイルペアのリストを取得し、一覧表示する。

#### Step 2: エントリーポイントを理解する

差分エディタの登録と初期化を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | multiDiffEditor.contribution.ts | `src/vs/workbench/contrib/multiDiffEditor/browser/multiDiffEditor.contribution.ts` | エディタペインとアクションの登録 |

**主要処理フロー**:
1. **20-25行目**: アクション登録（GoToFile、GoToNextChange等）
2. **27行目**: MultiDiffSourceResolverServiceのシングルトン登録
3. **30行目**: MultiDiffEditorResolverContributionの登録
4. **32-36行目**: エディタペインの登録
5. **38-39行目**: MultiDiffEditorSerializerの登録

#### Step 3: エディタ本体を理解する

マルチ差分エディタの実装を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | multiDiffEditor.ts | `src/vs/workbench/contrib/multiDiffEditor/browser/multiDiffEditor.ts` | MultiDiffEditorクラス |

**主要処理フロー**:
- 差分エントリのリスト表示
- スクロールとナビゲーション

#### Step 4: アクションを理解する

差分エディタのアクションを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | actions.ts | `src/vs/workbench/contrib/multiDiffEditor/browser/actions.ts` | GoToFileAction、GoToNextChangeAction等 |

**主要処理フロー**:
- GoToFileAction: 選択したファイルを開く
- GoToNextChangeAction/GoToPreviousChangeAction: 変更間ナビゲーション
- CollapseAllAction/ExpandAllAction: 展開/折りたたみ

### プログラム呼び出し階層図

```
OpenScmGroupAction.run()
    │
    └─ IEditorService.openEditor(MultiDiffEditorInput)
           │
           ├─ MultiDiffEditorInput.resolve()
           │      └─ IMultiDiffSourceResolverService.resolve()
           │             └─ 差分リスト取得
           │
           └─ MultiDiffEditor.setInput()
                  │
                  ├─ 差分計算
                  │
                  └─ UIレンダリング
                         │
                         └─ [ナビゲーション時]
                                │
                                ├─ GoToNextChangeAction
                                ├─ GoToPreviousChangeAction
                                └─ GoToFileAction
```

### データフロー図

```
[入力]                        [処理]                              [出力]

差分ソース              ───▶  MultiDiffEditor               ───▶  差分一覧表示
(SCMグループ等)                    │
                                  ├─ MultiDiffSourceResolver
                                  │
                                  └─ DiffService              ───▶  差分詳細表示
ユーザー操作            ───▶
(ナビゲーション)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| multiDiffEditor.contribution.ts | `src/vs/workbench/contrib/multiDiffEditor/browser/multiDiffEditor.contribution.ts` | ソース | 機能登録 |
| multiDiffEditor.ts | `src/vs/workbench/contrib/multiDiffEditor/browser/multiDiffEditor.ts` | ソース | エディタ本体 |
| multiDiffEditorInput.ts | `src/vs/workbench/contrib/multiDiffEditor/browser/multiDiffEditorInput.ts` | ソース | エディタ入力 |
| multiDiffSourceResolverService.ts | `src/vs/workbench/contrib/multiDiffEditor/browser/multiDiffSourceResolverService.ts` | ソース | ソース解決サービス |
| actions.ts | `src/vs/workbench/contrib/multiDiffEditor/browser/actions.ts` | ソース | アクション定義 |
| scmMultiDiffSourceResolver.ts | `src/vs/workbench/contrib/multiDiffEditor/browser/scmMultiDiffSourceResolver.ts` | ソース | SCM統合 |
