# 機能設計書 4-括弧マッチング

## 概要

本ドキュメントは、VS Codeエディタにおける括弧マッチング機能の設計仕様を記載する。対応する括弧のハイライト表示を実現する。

### 本機能の処理概要

括弧マッチング機能は、カーソル位置の括弧に対応する開き括弧または閉じ括弧を検出し、視覚的にハイライト表示する機能である。

**業務上の目的・背景**：プログラミングにおいて括弧（丸括弧、波括弧、角括弧など）の対応関係を正確に把握することは、コードの構造理解とバグ防止に不可欠である。対応する括弧をハイライト表示することで、ネストの深いコードでも括弧の対応関係を即座に確認でき、括弧の不一致によるシンタックスエラーを早期に発見できる。

**機能の利用シーン**：コード編集中、カーソルを括弧の位置に置いた際に自動的に対応する括弧がハイライトされる。また、「Go to Bracket」コマンドで対応する括弧にジャンプしたり、「Select to Bracket」で括弧内のテキストを選択したりすることができる。

**主要な処理内容**：
1. カーソル位置の監視 - カーソル位置変更イベントを検知
2. 括弧位置の検出 - カーソル位置またはその近傍の括弧を検出
3. 対応括弧の検索 - TextModelのbracketPairs機能を使用して対応する括弧を検索
4. デコレーション適用 - 対応する括弧ペアにハイライトデコレーションを適用
5. オーバービュールーラー表示 - ミニマップ横のルーラーにもマーカーを表示

**関連システム・外部連携**：言語設定の括弧定義と連携。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | テキストエディタ | 主画面 | 対応する括弧のハイライト表示 |

## 機能種別

表示処理 / デコレーション / ナビゲーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| position | Position | Yes | カーソル位置 | 有効な行番号・列番号 |
| matchBrackets | 'never' / 'near' / 'always' | No | マッチングモード | 設定値 |
| selectBrackets | boolean | No | 括弧自体を選択に含めるか | true/false |

### 入力データソース

- カーソル位置変更イベント
- エディタ設定（matchBracketsオプション）
- 言語設定（括弧定義）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| brackets | [Range, Range] | 対応する括弧ペアの範囲 |
| decorations | IModelDeltaDecoration[] | ハイライトデコレーション |

### 出力先

- エディタ画面（デコレーションによるハイライト表示）
- オーバービュールーラー（マーカー表示）

## 処理フロー

### 処理シーケンス

```
1. カーソル位置変更検知
   └─ onDidChangeCursorPositionイベントをリッスン
2. マッチングモード確認
   └─ matchBracketsオプションがneverの場合はスキップ
3. スケジューラによる遅延実行
   └─ 50msの遅延でupdateBracketsを実行（連続入力時の最適化）
4. 括弧マッチング実行
   └─ model.bracketPairs.matchBracket()を呼び出し
5. デコレーション更新
   └─ 対応する括弧ペアにハイライトデコレーションを適用
```

### フローチャート

```mermaid
flowchart TD
    A[カーソル位置変更] --> B{matchBrackets設定}
    B -->|never| C[処理スキップ]
    B -->|near/always| D[50ms遅延スケジュール]
    D --> E[updateBrackets実行]
    E --> F{括弧位置にカーソル?}
    F -->|Yes| G[matchBracket呼び出し]
    F -->|No| H[デコレーションクリア]
    G --> I{対応括弧あり?}
    I -->|Yes| J[ハイライトデコレーション適用]
    I -->|No| H
    J --> K[オーバービュールーラーマーカー表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | near/alwaysモード | nearは括弧の直後にカーソルがある場合のみ、alwaysは常にマッチング | matchBrackets設定 |
| BR-002 | 遅延実行 | 連続入力時のパフォーマンス最適化のため50ms遅延 | カーソル移動時 |
| BR-003 | 括弧ジャンプ | Go to Bracketコマンドで対応する括弧にジャンプ | ユーザーコマンド実行時 |
| BR-004 | 括弧選択 | Select to Bracketで括弧内テキストを選択 | ユーザーコマンド実行時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NO_MODEL | 情報 | エディタにモデルがない場合 | 処理をスキップ |
| NO_MATCH | 情報 | 対応する括弧が見つからない場合 | デコレーションをクリア |

### リトライ仕様

特になし

## トランザクション仕様

特になし（表示処理のみ）

## パフォーマンス要件

- マッチング処理: 10ms以内
- デコレーション更新: 遅延実行（50ms）

## セキュリティ考慮事項

特になし

## 備考

括弧マッチング機能は言語設定の括弧定義（brackets）に依存する。カスタム言語でも適切な括弧定義を設定することで機能する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、括弧データの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bracketMatching.ts | `src/vs/editor/contrib/bracketMatching/browser/bracketMatching.ts` | BracketsDataクラス、Brackets型定義 |

**読解のコツ**:
- Brackets型は[Range, Range]のタプルで、開き括弧と閉じ括弧の範囲を表す

#### Step 2: エントリーポイントを理解する

コントローラとアクションを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bracketMatching.ts | `src/vs/editor/contrib/bracketMatching/browser/bracketMatching.ts` | BracketMatchingController、各Actionクラス |

**主要処理フロー**:
1. **29-46行目**: JumpToBracketAction - 括弧ジャンプアクション
2. **48-79行目**: SelectToBracketAction - 括弧選択アクション
3. **81-99行目**: RemoveBracketsAction - 括弧削除アクション
4. **115-180行目**: BracketMatchingControllerコンストラクタ - イベント登録
5. **182-200行目**: jumpToBracket() - ジャンプ処理

#### Step 3: マッチング処理を理解する

括弧マッチングのロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | textModelBracketPairs.ts | `src/vs/editor/common/textModelBracketPairs.ts` | IBracketPairsTextModelPart |

**主要処理フロー**:
- **192行目**: model.bracketPairs.matchBracket() - 括弧マッチング呼び出し

### プログラム呼び出し階層図

```
BracketMatchingController
    │
    ├─ onDidChangeCursorPosition
    │      └─ _updateBracketsSoon.schedule()
    │             └─ _updateBrackets()
    │                    └─ model.bracketPairs.matchBracket()
    │
    ├─ jumpToBracket()
    │      └─ model.bracketPairs.matchBracket()
    │             └─ editor.setPosition()
    │
    └─ selectToBracket()
           └─ model.bracketPairs.matchBracket()
                  └─ editor.setSelection()
```

### データフロー図

```
[入力]               [処理]                    [出力]

カーソル位置 ──▶ BracketMatchingController ──▶ BracketsData
                        │
                        ▼
括弧定義 ──▶ model.bracketPairs.matchBracket() ──▶ [Range, Range]
                        │
                        ▼
ハイライト色 ──▶ ModelDecorationOptions ──▶ デコレーション表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bracketMatching.ts | `src/vs/editor/contrib/bracketMatching/browser/bracketMatching.ts` | ソース | 括弧マッチングコントローラ |
| bracketMatching.css | `src/vs/editor/contrib/bracketMatching/browser/bracketMatching.css` | スタイル | ハイライトスタイル定義 |
| textModelBracketPairs.ts | `src/vs/editor/common/textModelBracketPairs.ts` | ソース | 括弧ペア検索インターフェース |
| editorColorRegistry.ts | `src/vs/editor/common/core/editorColorRegistry.ts` | ソース | 括弧マッチ色定義 |
