# 機能設計書 40-タスク

## 概要

本ドキュメントは、Visual Studio Codeのタスク機能の設計内容を記述する。タスク機能は、ビルド、テスト、リント、デプロイなどの自動化されたタスクを定義・実行するためのワークフロー自動化機能である。

### 本機能の処理概要

タスク機能は、プロジェクトに関連する繰り返し作業（ビルド、テスト、lint等）を自動化するための仕組みを提供する。タスクはtasks.jsonファイルで定義され、ターミナルまたはバックグラウンドで実行される。実行結果は問題マッチャーを通じて「問題」パネルに表示される。

**業務上の目的・背景**：開発作業において、コードの変更後にビルド、テスト、リントなどの作業を繰り返し行う必要がある。タスク機能は、これらの作業をワンクリックまたはキーボードショートカットで実行可能にし、開発効率を向上させる。また、問題マッチャーにより、実行結果からエラーや警告を自動的に検出・表示する。

**機能の利用シーン**：
- TypeScript/JavaScriptプロジェクトのビルド
- テストの実行
- ESLint/Prettierなどのコード品質チェック
- Dockerコンテナのビルドとデプロイ
- カスタムスクリプトの実行

**主要な処理内容**：
1. tasks.jsonからのタスク定義の読み込み
2. タスクプロバイダー（拡張機能）からのタスク収集
3. タスクの実行（ターミナルまたはプロセス）
4. 問題マッチャーによるエラー/警告の検出
5. 実行中タスクのステータスバー表示
6. タスクの自動実行（ワークスペース信頼設定に基づく）

**関連システム・外部連携**：
- TaskService: タスクの管理と実行
- TerminalService: ターミナルでのタスク実行
- ProblemMatcherRegistry: 問題マッチャーの登録と管理
- TaskDefinitionRegistry: タスク定義タイプの登録

**権限による制御**：ワークスペーストラスト設定により、信頼されていないワークスペースではタスクの自動実行が制限される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | タスクターミナル | 主画面 | タスク実行結果の表示 |
| 43 | タスク設定ファイル | 参照画面 | tasks.jsonの編集 |

## 機能種別

ワークフロー自動化 / ビルドシステム

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| task | Task | Yes | 実行するタスク定義 | 有効なタスク |
| runOptions | IRunOptions | No | 実行オプション | なし |

### 入力データソース

- tasks.json: ワークスペースのタスク定義
- タスクプロバイダー（拡張機能からの動的タスク）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| taskExecution | ITaskExecution | タスク実行インスタンス |
| problems | IMarker[] | 検出されたエラー/警告 |

### 出力先

- ターミナル（タスク出力）
- 問題パネル（マッチしたエラー/警告）
- ステータスバー（実行中タスク数）

## 処理フロー

### 処理シーケンス

```
1. タスクの選択
   └─ コマンドパレット、メニュー、クイックアクセスから選択
2. タスク定義の解決
   └─ TaskServiceでタスク定義を取得
3. 実行環境の準備
   └─ ターミナルの作成または再利用
4. タスクの実行
   └─ コマンドの実行開始
5. 出力の処理
   └─ 問題マッチャーによる解析
6. 問題の報告
   └─ 問題パネルへのエラー/警告追加
7. タスクの完了
   └─ 終了コードの確認、ステータス更新
```

### フローチャート

```mermaid
flowchart TD
    A[タスク選択] --> B[TaskService.run]
    B --> C[タスク定義解決]
    C --> D{実行タイプ}
    D -->|shell/process| E[ターミナル作成]
    D -->|background| F[バックグラウンド実行]
    E --> G[コマンド実行]
    F --> G
    G --> H[出力監視]
    H --> I{問題マッチャー}
    I -->|マッチ| J[問題パネルに追加]
    I -->|非マッチ| K[出力表示のみ]
    J --> L{タスク完了?}
    K --> L
    L -->|No| H
    L -->|Yes| M[ステータス更新]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-40-01 | ビルドタスク | Ctrl+Shift+Bでビルドタスクを実行 | ビルドグループのタスク |
| BR-40-02 | テストタスク | テストグループのタスクとしてマーク可能 | テストグループ設定時 |
| BR-40-03 | 自動タスク | ワークスペースオープン時に自動実行可能 | runOn設定と信頼設定 |
| BR-40-04 | 問題マッチャー | 出力からエラー/警告を正規表現でパース | マッチャー設定時 |
| BR-40-05 | ターミナル再利用 | 設定により同名タスクでターミナルを再利用 | presentation設定 |

### 計算ロジック

特になし

## データベース操作仕様

なし（ファイルベース）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | タスク実行エラー | コマンドの実行失敗 | 終了コードとエラー出力を表示 |
| - | タスク定義エラー | tasks.jsonの構文エラー | エラー通知を表示 |
| - | ワークスペーストラストエラー | 信頼されていないワークスペースでの自動実行 | 警告を表示、手動実行を促す |

### リトライ仕様

タスクの再実行はユーザーの手動操作による

## トランザクション仕様

なし

## パフォーマンス要件

- タスク一覧表示: 500ms以内
- タスク起動: 500ms以内
- 問題マッチング: リアルタイム処理

## セキュリティ考慮事項

- ワークスペーストラストにより、悪意のあるタスクからの保護
- シェルコマンドの実行はユーザーの明示的な操作が必要
- 環境変数の参照は制限可能

## 備考

- TASKS_CATEGORY: タスクカテゴリの識別子
- TaskGroup.Build、TaskGroup.Test: ビルト・イングループ
- 問題マッチャーは$gcc、$tsc等のプリセットと、カスタム定義をサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

タスク機能で扱うデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tasks.ts | `src/vs/workbench/contrib/tasks/common/tasks.ts` | Task、TaskGroup、TaskEventKindなどの型定義 |
| 1-2 | taskService.ts | `src/vs/workbench/contrib/tasks/common/taskService.ts` | ITaskServiceインターフェース |

**読解のコツ**: タスクはTask型で表現され、type、command、group、problemMatchersなどのプロパティを持つ。

#### Step 2: エントリーポイントを理解する

タスク機能の登録と初期化を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | task.contribution.ts | `src/vs/workbench/contrib/tasks/browser/task.contribution.ts` | 機能登録、メニュー登録、ステータスバー |

**主要処理フロー**:
1. **48-49行目**: RunAutomaticTasksの登録（自動タスク実行）
2. **51-59行目**: ManageAutomaticTaskRunningのメニュー登録
3. **61-161行目**: TaskStatusBarContributions - ステータスバー表示
4. **165-200行目**: メニュー項目（Run Task、Run Build Task等）の登録

#### Step 3: タスクサービスを理解する

タスクの管理と実行を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | abstractTaskService.ts | `src/vs/workbench/contrib/tasks/browser/abstractTaskService.ts` | AbstractTaskService、ConfigureTaskAction |

**主要処理フロー**:
- タスクの取得と実行
- tasks.jsonの読み込み
- 問題マッチャーの適用

#### Step 4: 問題マッチャーを理解する

問題マッチャーの実装を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | problemMatcher.ts | `src/vs/workbench/contrib/tasks/common/problemMatcher.ts` | ProblemMatcherRegistry |

**主要処理フロー**:
- 問題マッチャーの登録と取得
- 正規表現によるエラー/警告のパース

#### Step 5: クイックアクセスを理解する

タスクのクイックアクセスを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | tasksQuickAccess.ts | `src/vs/workbench/contrib/tasks/browser/tasksQuickAccess.ts` | TasksQuickAccessProvider |

**主要処理フロー**:
- タスク一覧のクイックピック表示
- タスクの検索とフィルタリング

### プログラム呼び出し階層図

```
RunTaskAction.run()
    │
    └─ ITaskService.tasks()
           │
           └─ タスク一覧取得
                  │
                  ├─ tasks.json読み込み
                  │
                  └─ タスクプロバイダー
                         │
                         └─ IQuickInputService.pick()
                                │
                                └─ [タスク選択時]
                                       │
                                       └─ ITaskService.run(task)
                                              │
                                              ├─ ターミナル作成
                                              │
                                              ├─ コマンド実行
                                              │
                                              └─ 問題マッチャー適用
                                                     │
                                                     └─ IMarkerService.changeAll()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

tasks.json              ───▶  TaskService                   ───▶  タスク一覧
(タスク定義)                        │
                                   ├─ AbstractTaskService
タスクプロバイダー      ───▶        │
(拡張機能)                         └─ TerminalService        ───▶  ターミナル出力
                                          │
コマンド実行結果        ───▶               └─ ProblemMatcher  ───▶  問題パネル
                                                 │
                                                 └─ MarkerService
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| task.contribution.ts | `src/vs/workbench/contrib/tasks/browser/task.contribution.ts` | ソース | 機能登録 |
| abstractTaskService.ts | `src/vs/workbench/contrib/tasks/browser/abstractTaskService.ts` | ソース | タスクサービス |
| tasks.ts | `src/vs/workbench/contrib/tasks/common/tasks.ts` | ソース | タスク型定義 |
| taskService.ts | `src/vs/workbench/contrib/tasks/common/taskService.ts` | ソース | サービスインターフェース |
| problemMatcher.ts | `src/vs/workbench/contrib/tasks/common/problemMatcher.ts` | ソース | 問題マッチャー |
| taskDefinitionRegistry.ts | `src/vs/workbench/contrib/tasks/common/taskDefinitionRegistry.ts` | ソース | タスク定義レジストリ |
| tasksQuickAccess.ts | `src/vs/workbench/contrib/tasks/browser/tasksQuickAccess.ts` | ソース | クイックアクセス |
| runAutomaticTasks.ts | `src/vs/workbench/contrib/tasks/browser/runAutomaticTasks.ts` | ソース | 自動タスク実行 |
| jsonSchema_v1.ts | `src/vs/workbench/contrib/tasks/common/jsonSchema_v1.ts` | ソース | タスクJSONスキーマv1 |
| jsonSchema_v2.ts | `src/vs/workbench/contrib/tasks/common/jsonSchema_v2.ts` | ソース | タスクJSONスキーマv2 |
