# 機能設計書 45-リモート接続

## 概要

本ドキュメントは、VS Codeのリモート接続機能に関する機能設計書である。SSH、WSL、コンテナ等を経由したリモートサーバーへの接続とポートフォワーディング機能を定義する。

### 本機能の処理概要

リモート接続機能は、VS Codeをローカルで実行しながらリモートマシン上のファイルシステムや開発環境にアクセスできるようにする機能である。ポートフォワーディングによりリモートで実行されるサービスへのアクセスも提供する。

**業務上の目的・背景**：クラウドやリモートサーバーでの開発が一般化する中、ローカル環境と同等の開発体験をリモートで実現する。これにより開発環境の統一化、リソースの有効活用、チーム間での環境共有が可能になる。

**機能の利用シーン**：
- SSH経由でのリモートサーバー開発
- WSL（Windows Subsystem for Linux）での開発
- Dev Containersを使用したコンテナ内開発
- GitHub Codespacesでのクラウド開発
- ポートフォワーディングによるリモートサービスへのアクセス

**主要な処理内容**：
1. リモートサーバーへの接続・切断管理
2. リモートエクスプローラービューの提供
3. ポートフォワーディング（自動/手動）
4. トンネル管理（作成・削除・復元）
5. 接続ステータスの表示・監視
6. 接続ヘルス監視とリコネクト

**関連システム・外部連携**：
- Remote - SSH拡張機能（SSH接続）
- Remote - WSL拡張機能（WSL接続）
- Dev Containers拡張機能（コンテナ接続）
- GitHub Codespaces拡張機能（クラウド開発）
- トンネルサービス（ポートフォワーディング）

**権限による制御**：リモート接続には適切な認証情報（SSH鍵、パスワード等）が必要。ポートフォワーディングはプライバシー設定で制御可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | リモートエクスプローラー | 主画面 | リモート接続の管理 |
| - | ポートビュー | 参照画面 | ポートフォワーディングの管理 |
| - | ステータスバー | 参照画面 | 接続状態の表示 |

## 機能種別

接続管理 / ポートフォワーディング / UI連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| remoteAuthority | string | Yes | リモート接続先の識別子 | - |
| tunnelPort | number | Yes | フォワードするポート番号 | 0-65535 |
| localPort | number | No | ローカル側のポート番号 | 0-65535 |
| privacy | TunnelPrivacyId | No | トンネルのプライバシー設定 | - |

### 設定項目

| 設定キー | 型 | デフォルト | 説明 |
|---------|-----|---------|------|
| remote.autoForwardPorts | boolean | true | 自動ポートフォワーディング |
| remote.autoForwardPortsSource | string | 'process' | 検出ソース（process/output/hybrid） |
| remote.autoForwardPortsFallback | number | 0 | フォールバック動作 |

### 入力データソース

- ユーザーのリモート接続操作
- 拡張機能からのポートフォワーディング要求
- 自動検出されたポート（プロセス/出力から）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| RemoteTunnel | interface | 作成されたトンネル情報 |
| localPort | number | ローカル側ポート |
| remotePort | number | リモート側ポート |
| localAddress | string | ローカルアドレス |

### 出力先

- ポートビュー（UI表示）
- ステータスバー（接続状態）
- アクティビティバッジ（フォワードポート数）

## 処理フロー

### 処理シーケンス

```
1. リモート接続確立
   └─ remoteAuthority に基づいてRemote Agentに接続

2. ポートビューの初期化
   └─ ForwardedPortsView でUI登録
   └─ 既存トンネルの復元（PortRestore）

3. 自動ポートフォワーディング設定
   └─ AutomaticPortForwarding でソース設定
   └─ プロセス/出力の監視開始

4. ポート検出
   └─ ProcAutomaticPortForwarding（プロセス監視）
   └─ OutputAutomaticPortForwarding（ターミナル出力監視）

5. トンネル作成
   └─ ITunnelService.openTunnel() でトンネル作成
   └─ TunnelModel に追加

6. 状態管理
   └─ ステータスバー更新
   └─ アクティビティバッジ更新
```

### フローチャート

```mermaid
flowchart TD
    A[リモート接続開始] --> B{リモート環境?}
    B -->|Yes| C[Remote Agent接続]
    B -->|No| D[ローカルモード]
    C --> E[ポートビュー初期化]
    D --> E
    E --> F[既存トンネル復元]
    F --> G{自動フォワード有効?}
    G -->|Yes| H[ポート監視開始]
    G -->|No| I[手動モード]
    H --> J{ポート検出?}
    J -->|Yes| K[トンネル作成]
    J -->|No| L[監視継続]
    K --> M[UI更新]
    I --> N{ユーザー操作?}
    N -->|Forward| K
    N -->|Close| O[トンネル削除]
    O --> M
    L --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-45-01 | 自動検出ソース | process/output/hybridから検出ソースを選択 | 設定による |
| BR-45-02 | トンネル復元 | 前回セッションのトンネルを自動復元 | 環境トンネル設定後 |
| BR-45-03 | 50msデバウンス | ポート変更イベントを50msでデバウンス | イベント発火時 |
| BR-45-04 | ステータスバー表示 | ポート使用時のみステータスバーに表示 | リモート環境または使用中 |

### 計算ロジック

**フォワードポート数の計算**：
```typescript
// entry より
const count = this.remoteExplorerService.tunnelModel.forwarded.size
            + this.remoteExplorerService.tunnelModel.detected.size;
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| トンネル状態保存 | IStorageService | INSERT/UPDATE | トンネル設定の永続化 |
| 設定読込 | IConfigurationService | SELECT | 自動フォワード設定等 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CONNECTION_LOST | システムエラー | リモート接続が切断された | リコネクト試行、通知表示 |
| PORT_IN_USE | 業務エラー | ローカルポートが使用中 | 代替ポートの提案 |
| TUNNEL_FAILED | システムエラー | トンネル作成に失敗 | エラー通知、再試行オプション |

### リトライ仕様

接続切断時は自動リコネクトを試行。ReconnectionWaitEventで再接続待機を管理。

## トランザクション仕様

トランザクション制御は行わない。各トンネル操作は独立して実行される。

## パフォーマンス要件

- ポート変更イベントの50msデバウンス
- 遅延ビュー登録（ForwardedPortsViewEnabled）
- 環境トンネル設定後の復元処理

## セキュリティ考慮事項

- トンネルのプライバシー設定（private/public）
- SSH鍵等の認証情報は拡張機能側で管理
- ポートフォワーディングはローカルホストバインドがデフォルト

## 備考

- リモート機能の主要実装は各Remote拡張機能で提供
- ワークベンチはポートフォワーディングUIと共通機能を提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | remoteExplorer.ts | `src/vs/workbench/contrib/remote/browser/remoteExplorer.ts` | VIEWLET_ID、ForwardedPortsView（43行目〜） |
| 1-2 | remote.ts | `src/vs/workbench/contrib/remote/browser/remote.ts` | HelpModel、リモートヘルプビュー |

**主要処理フロー**:
1. **41行目**: `VIEWLET_ID = 'workbench.view.remote'` でビューレットID定義
2. **43-172行目**: `ForwardedPortsView` でポートビューの管理
3. **110-127行目**: `enableBadgeAndStatusBar()` でバッジ・ステータスバー連携

#### Step 2: トンネル管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tunnelView.ts | `src/vs/workbench/contrib/remote/browser/tunnelView.ts` | TunnelPanel、TunnelViewModel |
| 2-2 | tunnelModel.ts | `src/vs/workbench/services/remote/common/tunnelModel.ts` | Tunnel、TunnelModel |

#### Step 3: 自動ポートフォワーディングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | remoteExplorer.ts | `src/vs/workbench/contrib/remote/browser/remoteExplorer.ts` | AutomaticPortForwarding（195行目〜） |
| 3-2 | urlFinder.ts | `src/vs/workbench/contrib/remote/browser/urlFinder.ts` | 出力からのURL検出 |

### プログラム呼び出し階層図

```
ForwardedPortsView (remoteExplorer.ts)
    │
    ├─ TunnelViewModel (tunnelView.ts)
    │      └─ ITunnelService
    │
    ├─ IRemoteExplorerService
    │      └─ TunnelModel
    │             ├─ forwarded: Map
    │             └─ detected: Map
    │
    └─ AutomaticPortForwarding
           ├─ ProcAutomaticPortForwarding [プロセス監視]
           └─ OutputAutomaticPortForwarding [出力監視]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| remoteExplorer.ts | `src/vs/workbench/contrib/remote/browser/remoteExplorer.ts` | ソース | ポートビュー・自動転送 |
| remote.ts | `src/vs/workbench/contrib/remote/browser/remote.ts` | ソース | リモートヘルプ |
| tunnelView.ts | `src/vs/workbench/contrib/remote/browser/tunnelView.ts` | ソース | トンネルUI |
| tunnelFactory.ts | `src/vs/workbench/contrib/remote/browser/tunnelFactory.ts` | ソース | トンネル生成 |
| remoteIndicator.ts | `src/vs/workbench/contrib/remote/browser/remoteIndicator.ts` | ソース | 接続インジケータ |
| urlFinder.ts | `src/vs/workbench/contrib/remote/browser/urlFinder.ts` | ソース | URL検出 |
| remoteExplorerService.ts | `src/vs/workbench/services/remote/common/remoteExplorerService.ts` | ソース | サービス定義 |
| tunnelModel.ts | `src/vs/workbench/services/remote/common/tunnelModel.ts` | ソース | トンネルモデル |
