# 機能設計書 47-設定管理

## 概要

本ドキュメントは、VS Codeの設定管理機能に関する機能設計書である。設定の読み込み・保存・更新を行うプラットフォームサービスを定義する。

### 本機能の処理概要

設定管理機能は、VS Codeの各種設定を階層的に管理するプラットフォームサービスである。デフォルト、ユーザー、ワークスペース等の複数レベルで設定を管理し、オーバーライドを含む柔軟な設定解決を提供する。

**業務上の目的・背景**：開発者ごと、プロジェクトごとの設定カスタマイズを可能にし、生産性と開発体験を向上させる。また、拡張機能が独自の設定を定義できる拡張性を提供する。

**機能の利用シーン**：
- ユーザー設定（settings.json）の読み書き
- ワークスペース設定の管理
- フォルダ固有設定の管理
- 言語固有設定のオーバーライド
- 設定エディタでのGUI編集

**主要な処理内容**：
1. 設定値の取得（getValue）
2. 設定値の更新（updateValue）
3. 設定の詳細情報取得（inspect）
4. 設定変更イベントの発火
5. 設定データのリロード
6. 複数設定ソースのマージ

**関連システム・外部連携**：
- 設定エディタ（GUI）
- 拡張機能（設定定義の登録）
- ストレージサービス（設定ファイルの保存）
- ワークベンチ全体（設定の参照）

**権限による制御**：ConfigurationTargetによりユーザー設定、ワークスペース設定等のスコープを制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ワークベンチ | 補助機能 | フォント情報等のワークベンチ状態の永続化 |
| 14 | 設定エディタ | 補助機能 | 設定の読み込み・保存 |
| 17 | ウェルカムエディタ | 遷移先機能 | 設定のカスタマイズへのリンク |
| 19 | プロファイルエディタ | 主機能 | ユーザープロファイルの設定管理 |

## 機能種別

プラットフォームサービス / 設定管理

## 入力仕様

### 入力パラメータ（主要メソッド）

#### getValue

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| section | string | No | 設定キー（ドット区切り） | - |
| overrides | IConfigurationOverrides | No | オーバーライド条件 | - |

#### updateValue

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| key | string | Yes | 設定キー | - |
| value | unknown | Yes | 設定値 | - |
| target | ConfigurationTarget | No | 保存先ターゲット | - |
| overrides | IConfigurationOverrides | No | オーバーライド条件 | - |

### IConfigurationOverrides

| フィールド | 型 | 説明 |
|-----------|-----|------|
| overrideIdentifier | string | 言語識別子（[typescript]等） |
| resource | URI | リソースURI（フォルダ固有設定用） |

### ConfigurationTarget列挙

| 値 | 説明 |
|-----|------|
| APPLICATION | アプリケーション全体（マシン固有） |
| USER | ユーザー設定 |
| USER_LOCAL | ローカルユーザー設定 |
| USER_REMOTE | リモートユーザー設定 |
| WORKSPACE | ワークスペース設定 |
| WORKSPACE_FOLDER | ワークスペースフォルダ設定 |
| DEFAULT | デフォルト設定 |
| MEMORY | メモリ内設定（永続化なし） |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| T | generic | 設定値 |
| IConfigurationValue<T> | interface | 設定の詳細情報 |
| IConfigurationChangeEvent | interface | 変更イベント |

### 出力先

- 呼び出し元（getValue戻り値）
- イベントリスナー（onDidChangeConfiguration）
- 設定ファイル（settings.json等）

## 処理フロー

### 処理シーケンス

```
1. 設定値取得（getValue）
   └─ section からドット区切りでキーを解決
   └─ オーバーライド適用（言語、リソース）
   └─ 階層的にマージして値を返却

2. 設定値更新（updateValue）
   └─ target に応じた設定ファイルを特定
   └─ 値を更新してファイルに保存
   └─ onDidChangeConfiguration イベント発火

3. 設定詳細取得（inspect）
   └─ 各ターゲットの値を個別に取得
   └─ IConfigurationValue として返却
```

### フローチャート

```mermaid
flowchart TD
    A[getValue呼び出し] --> B{セクション指定?}
    B -->|Yes| C[キー解決]
    B -->|No| D[全設定取得]
    C --> E{オーバーライド?}
    E -->|Yes| F[オーバーライド適用]
    E -->|No| G[階層マージ]
    F --> G
    D --> G
    G --> H[値返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-47-01 | 階層的マージ | DEFAULT < USER < WORKSPACE < WORKSPACE_FOLDER の順でマージ | 値取得時 |
| BR-47-02 | undefined削除 | undefinedを設定すると該当ターゲットから削除 | updateValue時 |
| BR-47-03 | デフォルト値削除 | デフォルト値と同じ値を設定すると削除扱い | updateValue時 |
| BR-47-04 | 言語オーバーライド | [language]形式でセクションを指定すると言語固有設定を取得 | getValue時 |

### 値解決の優先順位

```
Policy > Memory > WorkspaceFolder > Workspace > UserRemote > UserLocal > User > Application > Default
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| 設定読込 | settings.json | SELECT | 設定ファイルの読み込み |
| 設定保存 | settings.json | UPDATE | 設定ファイルへの書き込み |

### 設定ファイル一覧

| スコープ | パス | 説明 |
|---------|------|------|
| User | ~/.config/Code/User/settings.json | ユーザー設定 |
| Workspace | .vscode/settings.json | ワークスペース設定 |
| Folder | {folder}/.vscode/settings.json | フォルダ設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| INVALID_KEY | 業務エラー | 無効な設定キー | エラーメッセージ表示 |
| FILE_DIRTY | 業務エラー | 設定ファイルが変更中 | handleDirtyFileオプションで制御 |
| PERMISSION_DENIED | 権限エラー | 書き込み権限なし | エラー通知 |

## トランザクション仕様

設定の更新はファイル単位で行われる。複数設定の同時更新にトランザクション保証はない。

## パフォーマンス要件

- 設定値のキャッシュ
- 遅延評価による未使用設定の非読込
- 設定変更イベントのバッチ処理

## セキュリティ考慮事項

- 設定ファイルはローカルに保存
- 機密情報は設定に保存すべきでない（シークレットサービスを使用）
- ワークスペース信頼により、ワークスペース設定の一部は制限可能

## 備考

- 設定スキーマはconfigurationRegistryで管理
- 拡張機能は`contributes.configuration`で設定を定義

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | configuration.ts | `src/vs/platform/configuration/common/configuration.ts` | IConfigurationService（152-207行目）が中心 |

**主要処理フロー**:
1. **14行目**: `IConfigurationService = createDecorator<IConfigurationService>('configurationService')` でサービスID定義
2. **40-49行目**: `ConfigurationTarget` 列挙型
3. **83-107行目**: `IConfigurationValue<T>` 設定値の詳細情報
4. **152-207行目**: `IConfigurationService` インターフェース

#### Step 2: 型定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | configuration.ts | `src/vs/platform/configuration/common/configuration.ts` | 24-38行目のオーバーライド型 |
| 2-2 | configuration.ts | `src/vs/platform/configuration/common/configuration.ts` | 209-230行目のデータモデル |

**主要な型**:
- **24-27行目**: `IConfigurationOverrides` - オーバーライド条件
- **68-75行目**: `IConfigurationChangeEvent` - 変更イベント
- **209-230行目**: `IConfigurationData` - 設定データ全体

### プログラム呼び出し階層図

```
IConfigurationService
    │
    ├─ getValue() ──▶ 設定値取得
    │      └─ オーバーライド解決
    │
    ├─ updateValue() ──▶ 設定値更新
    │      └─ ファイル書き込み
    │      └─ イベント発火
    │
    ├─ inspect() ──▶ 詳細情報取得
    │      └─ 各ターゲットの値を返却
    │
    └─ onDidChangeConfiguration ──▶ 変更通知
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| configuration.ts | `src/vs/platform/configuration/common/configuration.ts` | ソース | インターフェース定義 |
| configurationModels.ts | `src/vs/platform/configuration/common/configurationModels.ts` | ソース | モデル実装 |
| configurationRegistry.ts | `src/vs/platform/configuration/common/configurationRegistry.ts` | ソース | 設定スキーマ登録 |
