# 機能設計書 5-コードフォールディング

## 概要

本ドキュメントは、VS Codeエディタにおけるコードフォールディング機能の設計仕様を記載する。コードブロックの折りたたみ/展開による表示管理を実現する。

### 本機能の処理概要

コードフォールディング機能は、関数、クラス、条件分岐などのコードブロックを折りたたんで非表示にしたり、展開して表示したりする機能である。

**業務上の目的・背景**：大規模なソースファイルでは、全体の構造を把握することが困難になる。コードフォールディングにより、関心のある部分に集中し、関係のない部分を一時的に非表示にすることで、コードの可読性と編集効率を向上させる。特に長いクラスやネストの深いコードで効果を発揮する。

**機能の利用シーン**：
- ファイル全体の構造を俯瞰する際、詳細部分を折りたたむ
- 特定のメソッドに集中する際、他のメソッドを折りたたむ
- import文やコメントブロックを折りたたんでコード本体を見やすくする

**主要な処理内容**：
1. フォールディング範囲の検出 - インデントベースまたは言語プロバイダベースで折りたたみ範囲を検出
2. フォールディングモデルの構築 - 検出した範囲からFoldingModelを構築
3. 非表示範囲の管理 - HiddenRangeModelで折りたたまれた行を管理
4. デコレーション表示 - 折りたたみマーカー（+/-）をガターに表示
5. ユーザー操作処理 - クリックやキーボードショートカットによる折りたたみ/展開

**関連システム・外部連携**：FoldingRangeProviderを通じて言語サーバーから折りたたみ範囲を取得可能。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | テキストエディタ | 主画面 | コードブロックの折りたたみ/展開による表示管理 |

## 機能種別

表示処理 / ナビゲーション / デコレーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| foldingStrategy | 'auto' / 'indentation' | No | 折りたたみ戦略 | 設定値 |
| foldingHighlight | boolean | No | 折りたたみハイライト表示 | true/false |
| showFoldingControls | 'always' / 'mouseover' | No | コントロール表示タイミング | 設定値 |
| foldingImportsByDefault | boolean | No | import文をデフォルトで折りたたむか | true/false |

### 入力データソース

- TextModel（テキスト内容）
- FoldingRangeProvider（言語プロバイダ）
- IndentRangeProvider（インデントベース）
- エディタ設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| foldingRegions | FoldingRegions | 折りたたみ範囲のコレクション |
| hiddenRanges | ILineRange[] | 非表示行の範囲 |
| decorations | IModelDeltaDecoration[] | 折りたたみマーカーデコレーション |

### 出力先

- エディタ画面（折りたたみマーカー、非表示行）

## 処理フロー

### 処理シーケンス

```
1. フォールディング有効化確認
   └─ foldingオプションがtrueであることを確認
2. 範囲プロバイダの選択
   └─ foldingStrategy設定に基づきプロバイダを選択
3. フォールディング範囲の計算
   └─ プロバイダからFoldingRegionsを取得
4. FoldingModelの構築
   └─ 範囲情報からFoldingModelを作成
5. HiddenRangeModelの更新
   └─ 折りたたまれた範囲を非表示に設定
6. デコレーションの適用
   └─ ガターに折りたたみマーカーを表示
```

### フローチャート

```mermaid
flowchart TD
    A[モデル変更検知] --> B{folding有効?}
    B -->|No| C[処理スキップ]
    B -->|Yes| D{foldingStrategy}
    D -->|indentation| E[IndentRangeProvider]
    D -->|auto| F[FoldingRangeProvider優先]
    E --> G[範囲計算]
    F --> G
    G --> H[FoldingModel構築]
    H --> I[デコレーション適用]
    I --> J{ユーザー操作}
    J -->|折りたたみ| K[HiddenRangeModel更新]
    J -->|展開| L[HiddenRangeModel更新]
    K --> I
    L --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 戦略選択 | autoは言語プロバイダ優先、なければインデントベース | foldingStrategy設定 |
| BR-002 | デバウンス | フォールディング計算は200ms以上のデバウンス | パフォーマンス最適化 |
| BR-003 | import折りたたみ | foldingImportsByDefaultでimport文を自動折りたたみ | オプション有効時 |
| BR-004 | 範囲制限 | 大規模ファイルでは折りたたみ範囲数に制限 | パフォーマンス最適化 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| PROVIDER_ERROR | 警告 | FoldingRangeProviderエラー | インデントベースにフォールバック |
| LIMIT_EXCEEDED | 情報 | 折りたたみ範囲が上限超過 | 制限内の範囲のみ表示 |

### リトライ仕様

特になし

## トランザクション仕様

折りたたみ状態はビューステートとして保存・復元可能。

## パフォーマンス要件

- 範囲計算: 200ms以上のデバウンス
- デコレーション更新: 即座

## セキュリティ考慮事項

特になし

## 備考

コードフォールディングは言語定義のフォールディング範囲マーカー（#region/#endregionなど）にも対応。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、折りたたみ範囲のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | foldingRanges.ts | `src/vs/editor/contrib/folding/browser/foldingRanges.ts` | FoldingRegion, FoldingRegions, FoldRange |

**読解のコツ**:
- FoldingRegionは個々の折りたたみ範囲を表す
- FoldingRegionsは効率的な範囲検索のためのコレクション

#### Step 2: エントリーポイントを理解する

コントローラの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | folding.ts | `src/vs/editor/contrib/folding/browser/folding.ts` | FoldingController |

**主要処理フロー**:
1. **68-74行目**: FoldingController定義、ID登録
2. **88-109行目**: プロパティ定義（FoldingModel, HiddenRangeModel等）
3. **116-150行目**: コンストラクタでオプション初期化

#### Step 3: モデル層を理解する

FoldingModelとHiddenRangeModelを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | foldingModel.ts | `src/vs/editor/contrib/folding/browser/foldingModel.ts` | FoldingModel |
| 3-2 | hiddenRangeModel.ts | `src/vs/editor/contrib/folding/browser/hiddenRangeModel.ts` | HiddenRangeModel |

#### Step 4: プロバイダ層を理解する

範囲プロバイダの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | indentRangeProvider.ts | `src/vs/editor/contrib/folding/browser/indentRangeProvider.ts` | インデントベースプロバイダ |
| 4-2 | syntaxRangeProvider.ts | `src/vs/editor/contrib/folding/browser/syntaxRangeProvider.ts` | 言語プロバイダラッパー |

### プログラム呼び出し階層図

```
FoldingController
    │
    ├─ RangeProvider
    │      ├─ IndentRangeProvider.compute()
    │      └─ SyntaxRangeProvider.compute()
    │             └─ FoldingRangeProvider.provideFoldingRanges()
    │
    ├─ FoldingModel
    │      ├─ update() - 範囲更新
    │      └─ toggleCollapseState() - 折りたたみ切替
    │
    └─ HiddenRangeModel
           └─ setHiddenAreas() - 非表示範囲設定
```

### データフロー図

```
[入力]               [処理]                    [出力]

テキストモデル ──▶ RangeProvider.compute() ──▶ FoldingRegions
                        │
                        ▼
FoldingRegions ──▶ FoldingModel ──▶ 折りたたみ状態
                        │
                        ▼
折りたたみ状態 ──▶ HiddenRangeModel ──▶ 非表示行
                        │
                        ▼
非表示行 ──▶ FoldingDecorationProvider ──▶ デコレーション表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| folding.ts | `src/vs/editor/contrib/folding/browser/folding.ts` | ソース | フォールディングコントローラ |
| foldingRanges.ts | `src/vs/editor/contrib/folding/browser/foldingRanges.ts` | ソース | 範囲データ構造 |
| foldingModel.ts | `src/vs/editor/contrib/folding/browser/foldingModel.ts` | ソース | フォールディングモデル |
| hiddenRangeModel.ts | `src/vs/editor/contrib/folding/browser/hiddenRangeModel.ts` | ソース | 非表示範囲モデル |
| indentRangeProvider.ts | `src/vs/editor/contrib/folding/browser/indentRangeProvider.ts` | ソース | インデントベースプロバイダ |
| syntaxRangeProvider.ts | `src/vs/editor/contrib/folding/browser/syntaxRangeProvider.ts` | ソース | 言語プロバイダラッパー |
| foldingDecorations.ts | `src/vs/editor/contrib/folding/browser/foldingDecorations.ts` | ソース | デコレーションプロバイダ |
