# 機能設計書 55-クイック入力

## 概要

本ドキュメントは、VS Codeのクイック入力（Quick Input）機能に関する設計書である。QuickPick（選択リスト）、InputBox（入力ボックス）、QuickTree（ツリー選択）などのUIコンポーネントを提供し、ユーザーが素早くコマンド実行やファイル選択を行えるようにする。

### 本機能の処理概要

**業務上の目的・背景**：
VS Codeの生産性向上のため、キーボード中心の高速な操作インターフェースを提供する。コマンドパレット（Ctrl+Shift+P）やクイックオープン（Ctrl+P）など、VS Codeの中核的な操作がこの機能に基づいている。マウスを使わずにファイル検索、コマンド実行、シンボル検索などを行える。

**機能の利用シーン**：
- コマンドパレットでのコマンド検索・実行（Ctrl+Shift+P）
- ファイルのクイックオープン（Ctrl+P）
- ワークスペース内シンボル検索（Ctrl+T）
- 拡張機能からのユーザー入力取得
- マルチステップウィザードの実装

**主要な処理内容**：
1. QuickPick - アイテムリストからの選択
2. InputBox - テキスト入力
3. QuickTree - ツリー構造からの選択
4. QuickWidget - カスタムHTML要素の表示
5. QuickAccessプロバイダーによる拡張
6. ファジーマッチングによるフィルタリング
7. キーボードナビゲーション

**関連システム・外部連携**：
- コンテキストキーサービス（IContextKeyService）: 表示条件の制御
- キーバインディングサービス: ショートカットキーの表示

**権限による制御**：
特になし（拡張機能からも利用可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | コマンドパレット | 主機能 | コマンドの検索・実行（Ctrl+Shift+P） |
| 48 | クイックオープン | 主機能 | ファイルの素早い検索・オープン（Ctrl+P） |

## 機能種別

UI表示 / ユーザー入力 / 検索・選択

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| items | IQuickPickItem[] | Yes(pick) | 選択候補アイテム | 配列 |
| options | IPickOptions | No | 選択オプション | - |
| value | string | No | 初期入力値 | - |
| placeholder | string | No | プレースホルダーテキスト | - |
| canPickMany | boolean | No | 複数選択可否 | - |

### 入力データソース

- プログラムコードからの直接呼び出し
- QuickAccessプロバイダーからの動的アイテム提供
- 拡張機能API経由

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| selectedItems | T[] | 選択されたアイテム（複数選択時） |
| selectedItem | T | 選択されたアイテム（単一選択時） |
| inputValue | string | 入力されたテキスト |

### 出力先

- Promiseとして呼び出し元に返却
- イベント（onDidAccept、onDidChangeValue等）

## 処理フロー

### 処理シーケンス

```
1. QuickInput作成（createQuickPick/createInputBox）
   └─ UIコントローラーを初期化
2. アイテム/オプション設定
   └─ items、placeholder、buttons等を設定
3. show()呼び出し
   └─ QuickInputを画面に表示
4. ユーザー入力処理
   └─ キー入力、マウス操作を処理
5. フィルタリング
   └─ ファジーマッチングでアイテムを絞り込み
6. 選択/入力完了
   └─ onDidAcceptイベント発火
7. 結果返却
   └─ 選択アイテムまたは入力値を返却
```

### フローチャート

```mermaid
flowchart TD
    A[createQuickPick] --> B[items/options設定]
    B --> C[show]
    C --> D[入力待機]
    D --> E{ユーザー操作}
    E -->|テキスト入力| F[ファジーマッチング]
    F --> G[アイテムフィルタ]
    G --> D
    E -->|アイテム選択| H[onDidAccept発火]
    E -->|Escape| I[hide]
    E -->|ボタンクリック| J[onDidTriggerButton発火]
    H --> K{canPickMany?}
    K -->|Yes| L[selectedItems返却]
    K -->|No| M[selectedItem返却]
    I --> N[undefined返却]
    J --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-55-01 | ファジーマッチング | ラベル、説明、詳細に対してファジー検索 | matchOnLabel/Description/Detail有効時 |
| BR-55-02 | アイテムアクティベーション | 初期表示時の選択アイテム制御 | itemActivation設定時 |
| BR-55-03 | バックグラウンド選択 | 右矢印キーでピッカーを閉じずに選択 | canAcceptInBackground有効時 |
| BR-55-04 | 入力検証 | validateInput関数で入力値を検証 | InputBox使用時 |
| BR-55-05 | クイックナビゲート | 修飾キー付きで素早く選択 | quickNavigate設定時 |

### 計算ロジック

```typescript
// アイテムアクティベーション
enum ItemActivation {
  NONE,    // アイテムをアクティブにしない
  FIRST,   // 最初のアイテムをアクティブに
  SECOND,  // 2番目のアイテムをアクティブに
  LAST     // 最後のアイテムをアクティブに
}

// フォーカス操作
enum QuickPickFocus {
  First = 1,      // 最初のアイテム
  Second,         // 2番目のアイテム
  Last,           // 最後のアイテム
  Next,           // 次のアイテム
  Previous,       // 前のアイテム
  NextPage,       // 次のページ
  PreviousPage,   // 前のページ
  NextSeparator,  // 次のセパレーター
  PreviousSeparator // 前のセパレーター
}
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| VALIDATION_ERROR | 検証エラー | InputBoxで検証失敗 | エラーメッセージ表示 |

### リトライ仕様

該当なし（ユーザーが再入力）

## トランザクション仕様

該当なし

## パフォーマンス要件

- ファジーマッチングは即座に実行
- 大量アイテム時の仮想スクロール対応
- 入力に対する即時フィードバック

## セキュリティ考慮事項

- パスワード入力はマスク表示（password: true）
- 拡張機能からの入力は信頼性を検証

## 備考

- 拡張機能APIではvscode.window.showQuickPick等として公開
- QuickAccessプロバイダーで独自のプレフィックス（'>'、'@'等）を登録可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

QuickInputのインターフェースと型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | quickInput.ts | `src/vs/platform/quickinput/common/quickInput.ts` | IQuickInputService、IQuickPick、IInputBox定義 |

**読解のコツ**:
- IQuickPickItem、IQuickPickSeparatorでアイテムとセパレーターを区別
- QuickInputTypeでPick/InputBox/Widget/Treeを識別

**主要処理フロー**:
1. **19-27行目**: IQuickItemHighlights - マッチハイライト
2. **33-100行目**: IQuickPickItem - 選択アイテムの型定義
3. **102-113行目**: IQuickPickSeparator - セパレーターの型定義
4. **274-279行目**: QuickInputType enum
5. **284-377行目**: IQuickInput - 基本インターフェース
6. **479-706行目**: IQuickPick - QuickPick固有のインターフェース
7. **711-768行目**: IInputBox - InputBox固有のインターフェース
8. **918-1029行目**: IQuickInputService - サービスインターフェース

#### Step 2: QuickPickの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | quickInput.ts | `src/vs/platform/quickinput/common/quickInput.ts` | IPickOptions、IQuickPickDidAcceptEvent |

**主要処理フロー**:
- **126-204行目**: IPickOptions - pick()メソッドのオプション
- **392-409行目**: IQuickPickDidAcceptEvent - 選択完了イベント
- **415-432行目**: ItemActivation enum - アイテムアクティベーション
- **437-474行目**: QuickPickFocus enum - フォーカス操作

#### Step 3: ボタンと操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | quickInput.ts | `src/vs/platform/quickinput/common/quickInput.ts` | IQuickInputButton、イベント型 |

**主要処理フロー**:
- **770-836行目**: IQuickInputButton - ボタン定義
- **842-876行目**: IQuickPickItemButtonEvent - アイテムボタンイベント

#### Step 4: QuickTreeを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | quickInput.ts | `src/vs/platform/quickinput/common/quickInput.ts` | IQuickTree、IQuickTreeItem |

**主要処理フロー**:
- **1036-1176行目**: IQuickTree - ツリー選択インターフェース
- **1181-1205行目**: IQuickTreeItem - ツリーアイテムの型定義

### プログラム呼び出し階層図

```
IQuickInputService (サービスエントリポイント)
    │
    ├─ pick() - 簡易選択API
    │      │
    │      ├─ items (IQuickPickItem[])
    │      ├─ options (IPickOptions)
    │      └─ Promise<T | T[] | undefined>
    │
    ├─ input() - 簡易入力API
    │      │
    │      ├─ options (IInputOptions)
    │      └─ Promise<string | undefined>
    │
    ├─ createQuickPick() - QuickPick作成
    │      │
    │      └─ IQuickPick<T>
    │             ├─ items
    │             ├─ activeItems
    │             ├─ selectedItems
    │             ├─ onDidAccept
    │             ├─ onDidChangeValue
    │             └─ show() / hide()
    │
    ├─ createInputBox() - InputBox作成
    │      │
    │      └─ IInputBox
    │             ├─ value
    │             ├─ validationMessage
    │             ├─ onDidAccept
    │             └─ show() / hide()
    │
    ├─ createQuickTree() - QuickTree作成
    │      │
    │      └─ IQuickTree<T>
    │             ├─ setItemTree()
    │             ├─ checkedLeafItems
    │             └─ expand() / collapse()
    │
    └─ quickAccess - QuickAccessController
           ├─ show()
           └─ プロバイダー管理
```

### データフロー図

```
[入力]               [処理]                    [出力]

createQuickPick()
    │
    ↓
┌───────────────┐
│IQuickPick作成 │
│ - items設定   │
│ - options設定 │
└───────────────┘
    │
    ↓
┌───────────────┐
│  show()       │
└───────────────┘
    │
    ↓
┌───────────────┐
│ユーザー入力   │
│ (テキスト)    │
└───────────────┘
    │
    ↓
┌───────────────┐
│ファジーマッチ │
│ - label       │
│ - description │
│ - detail      │
└───────────────┘
    │
    ↓
┌───────────────┐
│フィルタ適用   │
│ アイテム絞込  │
└───────────────┘
    │
    ↓
┌───────────────┐
│ユーザー選択   │
│ (Enter/Click) │
└───────────────┘
    │
    ↓
┌───────────────┐
│onDidAccept    │
│イベント発火   │
└───────────────┘
    │
    ↓
[selectedItems]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| quickInput.ts | `src/vs/platform/quickinput/common/quickInput.ts` | ソース | インターフェース定義 |
| quickAccess.ts | `src/vs/platform/quickinput/common/quickAccess.ts` | ソース | QuickAccessプロバイダー定義 |
| quickInputService.ts | `src/vs/platform/quickinput/browser/quickInputService.ts` | ソース | サービス実装 |
| quickInputController.ts | `src/vs/platform/quickinput/browser/quickInputController.ts` | ソース | UIコントローラー |
| quickInputList.ts | `src/vs/platform/quickinput/browser/quickInputList.ts` | ソース | リスト表示 |
| quickInputBox.ts | `src/vs/platform/quickinput/browser/quickInputBox.ts` | ソース | 入力ボックス |
| quickInput.ts | `src/vs/platform/quickinput/browser/quickInput.ts` | ソース | ブラウザ実装 |
| quickInputUtils.ts | `src/vs/platform/quickinput/browser/quickInputUtils.ts` | ソース | ユーティリティ |
