# 機能設計書 58-プロセス

## 概要

本ドキュメントは、VS Codeのプロセス管理機能に関する設計書である。VS Code自身のプロセスおよび子プロセスの情報取得、システム情報の収集、パフォーマンス情報の取得などを提供する。

### 本機能の処理概要

**業務上の目的・背景**：
VS Codeは複数のプロセス（メインプロセス、レンダラープロセス、拡張機能ホストプロセス等）で構成されており、それらのリソース使用状況を把握することが重要である。問題診断、パフォーマンス分析、リソース管理のためにプロセス情報へのアクセスが必要となる。

**機能の利用シーン**：
- プロセスエクスプローラーでのリソース使用状況確認
- Issue Reporter でのシステム情報収集
- パフォーマンス問題の診断
- 開発者ツールでのデバッグ

**主要な処理内容**：
1. プロセス情報の解決（resolveProcesses）
2. システムステータスの取得（getSystemStatus）
3. システム情報の取得（getSystemInfo）
4. パフォーマンス情報の取得（getPerformanceInfo）
5. プロセス名とPIDのマッピング

**関連システム・外部連携**：
- 診断サービス（IDiagnosticsService）: システム情報の詳細取得
- Node.js process API: プロセス情報取得

**権限による制御**：
特になし（診断機能として提供）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 52 | プロセスエクスプローラー | 主機能 | VSCodeプロセスのリソース使用状況表示 |

## 機能種別

システム情報取得 / 診断 / モニタリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | パラメータなし（状態取得） | - |

### 入力データソース

- OS API（プロセス情報）
- VS Code内部状態
- リモート接続情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| pidToNames | [number, string][] | PIDとプロセス名のマッピング |
| processes | ProcessItem[] | プロセスツリー情報 |
| systemInfo | SystemInfo | システム情報 |
| performanceInfo | PerformanceInfo | パフォーマンス情報 |

### 出力先

- プロセスエクスプローラーUI
- Issue Reporter
- 開発者コンソール

## 処理フロー

### 処理シーケンス

```
1. プロセス情報要求
   └─ resolveProcesses呼び出し
2. ローカルプロセス取得
   └─ メイン、レンダラー、拡張機能ホストの情報取得
3. リモートプロセス取得（該当時）
   └─ リモート接続先のプロセス情報取得
4. プロセスツリー構築
   └─ 親子関係を含むツリー構造を構築
5. 結果返却
   └─ IResolvedProcessInformationとして返却
```

### フローチャート

```mermaid
flowchart TD
    A[resolveProcesses] --> B[ローカルプロセス取得]
    B --> C{リモート接続あり?}
    C -->|Yes| D[リモートプロセス取得]
    C -->|No| E[プロセスツリー構築]
    D --> E
    E --> F[PIDマッピング構築]
    F --> G[結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-58-01 | プロセスグループ化 | name属性でプロセスをグループ化 | 常時 |
| BR-58-02 | リモートエラー | リモート取得失敗時はIRemoteDiagnosticErrorを返す | リモート接続時 |
| BR-58-03 | ルートプロセス | rootProcessがプロセスツリーのルート | 常時 |

### 計算ロジック

```typescript
// プロセス情報の型定義
interface IResolvedProcessInformation {
  readonly pidToNames: [number, string][];
  readonly processes: {
    readonly name: string;
    readonly rootProcess: ProcessItem | IRemoteDiagnosticError;
  }[];
}
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | リモート診断エラー | リモートプロセス取得失敗 | IRemoteDiagnosticErrorを返却 |

### リトライ仕様

該当なし（都度取得）

## トランザクション仕様

該当なし

## パフォーマンス要件

- プロセス情報取得は非同期で実行
- 大量のプロセスがある場合も適切に処理

## セキュリティ考慮事項

- プロセス情報には機密情報が含まれる可能性があるため、取り扱いに注意
- Issue Reporter経由で送信される情報は匿名化される

## 備考

- プロセスエクスプローラーは「ヘルプ > プロセスエクスプローラーを開く」から起動
- リモート開発時はリモートプロセスも含めて表示

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プロセス関連の型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | process.ts | `src/vs/platform/process/common/process.ts` | IProcessService、IResolvedProcessInformation |

**読解のコツ**:
- ProcessItemは外部モジュール（base/common/processes.ts）から提供
- IRemoteDiagnosticErrorはリモート取得失敗時のエラー型

**主要処理フロー**:
1. **12-19行目**: WindowStyles、WindowData - ウィンドウスタイル情報
2. **21-25行目**: IssueSource enum - 問題ソースの種別
3. **32行目**: IProcessService decorator登録
4. **34-40行目**: IResolvedProcessInformation - プロセス情報の型
5. **42-51行目**: IProcessService - サービスインターフェース

### プログラム呼び出し階層図

```
IProcessService
    │
    ├─ resolveProcesses()
    │      │
    │      └─ IResolvedProcessInformation
    │             ├─ pidToNames: [number, string][]
    │             └─ processes[]
    │                    ├─ name
    │                    └─ rootProcess: ProcessItem | IRemoteDiagnosticError
    │
    ├─ getSystemStatus()
    │      └─ string (フォーマット済みステータス)
    │
    ├─ getSystemInfo()
    │      └─ SystemInfo
    │
    └─ getPerformanceInfo()
           └─ PerformanceInfo
```

### データフロー図

```
[入力]               [処理]                    [出力]

resolveProcesses()
    │
    ↓
┌───────────────┐
│ローカル       │
│プロセス取得   │
└───────────────┘
    │
    ↓
┌───────────────┐
│リモート       │
│プロセス取得   │──→ (エラー時) IRemoteDiagnosticError
└───────────────┘
    │
    ↓
┌───────────────┐
│プロセスツリー │
│  構築        │
└───────────────┘
    │
    ↓
┌───────────────┐
│PIDマッピング  │
│  構築        │
└───────────────┘
    │
    ↓
[IResolvedProcessInformation]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process.ts | `src/vs/platform/process/common/process.ts` | ソース | 共通型定義・インターフェース |
| processMainService.ts | `src/vs/platform/process/electron-main/processMainService.ts` | ソース | メインプロセス実装 |
| processes.ts | `src/vs/base/common/processes.ts` | ソース | ProcessItem等の基本型 |
| diagnostics.ts | `src/vs/platform/diagnostics/common/diagnostics.ts` | ソース | SystemInfo、PerformanceInfo型 |
