# 機能設計書 6-検索・置換

## 概要

本ドキュメントは、VS Codeエディタにおける検索・置換機能の設計仕様を記載する。テキスト検索と一括置換機能を実現する。

### 本機能の処理概要

検索・置換機能は、エディタ内のテキストを検索し、必要に応じて別のテキストに置換する機能である。正規表現、大文字小文字区別、単語単位検索などの高度な検索オプションをサポートする。

**業務上の目的・背景**：ソフトウェア開発において、変数名やメソッド名の変更、特定パターンの検索、コードの一括修正は頻繁に発生する作業である。検索・置換機能により、これらの作業を効率的かつ正確に実行でき、手動での修正漏れや誤修正を防止する。

**機能の利用シーン**：
- 変数名やメソッド名を一括でリネームする
- 特定のコードパターンを検索して確認する
- 正規表現でパターンマッチングを行う
- 選択範囲内のみで検索・置換を行う

**主要な処理内容**：
1. 検索ウィジェット表示 - Ctrl+Fで検索ウィジェットを表示
2. 検索文字列の設定 - ユーザー入力またはカーソル位置の単語から取得
3. マッチング処理 - TextModelに対して検索を実行
4. ハイライト表示 - マッチ箇所をデコレーションでハイライト
5. ナビゲーション - 次/前のマッチへ移動
6. 置換処理 - 単一置換または一括置換を実行

**関連システム・外部連携**：グローバルクリップボードからの検索文字列取得（macOS）。

**権限による制御**：読み取り専用モードでは置換操作が無効。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | テキストエディタ | 主画面 | テキスト検索、一括置換機能 |

## 機能種別

検索処理 / 置換処理 / ウィジェット表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| searchString | string | Yes | 検索文字列 | 最大524288文字 |
| replaceString | string | No | 置換文字列 | - |
| isRegex | boolean | No | 正規表現検索 | true/false |
| matchWholeWord | boolean | No | 単語単位検索 | true/false |
| isCaseSensitive | boolean | No | 大文字小文字区別 | true/false |
| preserveCase | boolean | No | 大文字小文字を保持して置換 | true/false |
| findInSelection | boolean | No | 選択範囲内検索 | true/false |

### 入力データソース

- キーボード入力（検索/置換文字列）
- 選択テキスト（検索文字列のシード）
- グローバルクリップボード（macOS）
- ストレージ（検索履歴）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| matches | FindMatch[] | マッチ結果のリスト |
| currentMatch | number | 現在のマッチインデックス |
| decorations | IModelDeltaDecoration[] | ハイライトデコレーション |

### 出力先

- FindWidget（検索/置換ウィジェット）
- エディタ画面（ハイライトデコレーション）
- オーバービュールーラー（マッチ位置マーカー）

## 処理フロー

### 処理シーケンス

```
1. 検索ウィジェット表示
   └─ Ctrl+F または Ctrl+H で検索/置換ウィジェットを表示
2. 検索文字列の設定
   └─ ユーザー入力またはカーソル位置の単語を検索文字列に設定
3. 検索オプションの設定
   └─ 正規表現、大文字小文字区別などのオプションを設定
4. 検索実行
   └─ FindModelBoundToEditorModelが検索を実行
5. マッチハイライト
   └─ FindDecorationsでマッチ箇所をハイライト
6. ナビゲーション
   └─ 次/前のマッチへカーソル移動
7. 置換実行（オプション）
   └─ 単一置換または一括置換を実行
```

### フローチャート

```mermaid
flowchart TD
    A[Ctrl+F押下] --> B[FindWidget表示]
    B --> C[検索文字列入力]
    C --> D[検索オプション設定]
    D --> E[FindModel.search実行]
    E --> F{マッチあり?}
    F -->|Yes| G[FindDecorations適用]
    F -->|No| H[「結果なし」表示]
    G --> I{ユーザー操作}
    I -->|次へ| J[次のマッチへ移動]
    I -->|前へ| K[前のマッチへ移動]
    I -->|置換| L{読み取り専用?}
    I -->|全置換| M{読み取り専用?}
    L -->|No| N[単一置換実行]
    L -->|Yes| O[操作拒否]
    M -->|No| P[一括置換実行]
    M -->|Yes| O
    J --> I
    K --> I
    N --> E
    P --> E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 検索文字列最大長 | 検索文字列は最大524288文字 | 検索実行時 |
| BR-002 | 履歴保存 | 検索/置換履歴を500ms遅延で保存 | 文字列変更時 |
| BR-003 | 大文字小文字保持 | preserveCaseで置換時の大文字小文字を保持 | 置換時 |
| BR-004 | 選択範囲検索 | findInSelectionで選択範囲内のみ検索 | オプション有効時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。検索履歴はストレージサービスに保存。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| INVALID_REGEX | エラー | 無効な正規表現パターン | エラーメッセージを表示 |
| READONLY | 警告 | 読み取り専用ファイルへの置換試行 | 操作を拒否 |
| TOO_LONG | 警告 | 検索文字列が上限超過 | 切り詰めまたは拒否 |

### リトライ仕様

特になし

## トランザクション仕様

置換操作はUndoスタックに積まれ、取り消し可能。一括置換も単一のUndo操作として扱われる。

## パフォーマンス要件

- 検索実行: 大規模ファイルでも1秒以内
- ハイライト更新: 即座

## セキュリティ考慮事項

- 正規表現によるReDoS攻撃の防止（タイムアウト設定）

## 備考

VS Codeの検索・置換機能はFindWidgetで実装され、エディタ内検索とワークスペース全体検索の両方をサポート。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、検索状態のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | findState.ts | `src/vs/editor/contrib/find/browser/findState.ts` | FindReplaceState |

**読解のコツ**:
- FindReplaceStateは検索/置換の全状態を管理
- 各オプション（isRegex, matchWholeWord等）の変更イベントを発行

#### Step 2: エントリーポイントを理解する

コントローラの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | findController.ts | `src/vs/editor/contrib/find/browser/findController.ts` | CommonFindController, FindController |

**主要処理フロー**:
1. **38行目**: SEARCH_STRING_MAX_LENGTH - 検索文字列最大長
2. **40-63行目**: getSelectionSearchString() - 選択テキストから検索文字列取得
3. **92-113行目**: CommonFindController定義

#### Step 3: モデル層を理解する

検索モデルの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | findModel.ts | `src/vs/editor/contrib/find/browser/findModel.ts` | FindModelBoundToEditorModel |
| 3-2 | findDecorations.ts | `src/vs/editor/contrib/find/browser/findDecorations.ts` | FindDecorations |

#### Step 4: ウィジェット層を理解する

UIウィジェットの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | findWidget.ts | `src/vs/editor/contrib/find/browser/findWidget.ts` | FindWidget |

### プログラム呼び出し階層図

```
CommonFindController / FindController
    │
    ├─ FindReplaceState
    │      └─ 検索/置換状態管理
    │
    ├─ FindModelBoundToEditorModel
    │      ├─ research() - 検索実行
    │      ├─ replace() - 単一置換
    │      └─ replaceAll() - 一括置換
    │
    ├─ FindDecorations
    │      └─ ハイライトデコレーション管理
    │
    └─ FindWidget
           └─ 検索/置換UI
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索文字列 ──▶ FindReplaceState ──▶ 状態変更イベント
                        │
                        ▼
TextModel ──▶ FindModelBoundToEditorModel ──▶ FindMatch[]
                        │
                        ▼
FindMatch[] ──▶ FindDecorations ──▶ ハイライト表示
                        │
                        ▼
ユーザー操作 ──▶ replace/replaceAll ──▶ テキスト置換
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| findController.ts | `src/vs/editor/contrib/find/browser/findController.ts` | ソース | 検索コントローラ |
| findState.ts | `src/vs/editor/contrib/find/browser/findState.ts` | ソース | 検索状態管理 |
| findModel.ts | `src/vs/editor/contrib/find/browser/findModel.ts` | ソース | 検索モデル |
| findDecorations.ts | `src/vs/editor/contrib/find/browser/findDecorations.ts` | ソース | デコレーション管理 |
| findWidget.ts | `src/vs/editor/contrib/find/browser/findWidget.ts` | ソース | 検索ウィジェットUI |
| replacePattern.ts | `src/vs/editor/contrib/find/browser/replacePattern.ts` | ソース | 置換パターン処理 |
| replaceAllCommand.ts | `src/vs/editor/contrib/find/browser/replaceAllCommand.ts` | ソース | 一括置換コマンド |
