# 機能設計書 61-MCP

## 概要

本ドキュメントは、Visual Studio CodeにおけるMCP（Model Context Protocol）対応機能の設計仕様を記載する。MCPは、AIエージェントとの連携を可能にするプロトコルであり、外部MCPサーバーの管理・実行機能を提供する。

### 本機能の処理概要

MCP機能は、AIエージェント（Copilotなど）が外部ツールやデータソースと通信するための標準化されたプロトコル実装を提供する。

**業務上の目的・背景**：AI支援機能の拡張性を高めるため、外部MCPサーバーとの連携が必要となった。MCPサーバーを通じて、ファイルシステムアクセス、データベース接続、API呼び出しなど、様々な外部リソースへのアクセスをAIエージェントに提供できる。これにより、ユーザーはAIエージェントの機能を大幅に拡張できる。

**機能の利用シーン**：開発者がAIチャット機能（GitHub Copilot Chat等）を使用する際に、追加のMCPサーバーを設定することで、プロジェクト固有のツールやデータソースにAIがアクセスできるようになる。例えば、社内APIへのアクセス、カスタムデータベースクエリ、専門的な計算ツールの実行などが可能になる。

**主要な処理内容**：
1. MCPサーバー設定の読み込みと管理（mcp.jsonからの設定スキャン）
2. MCPギャラリーからのサーバー検索・インストール
3. MCPサーバーの起動・停止・状態監視
4. MCPサーバーとの通信（stdio/HTTP/SSEトランスポート）
5. MCPサーバーの認証管理（OAuth対応）
6. 変数置換による動的設定

**関連システム・外部連携**：MCPギャラリー（レジストリサービス）、npm/pip/docker等のパッケージレジストリ、OAuth認証プロバイダー

**権限による制御**：MCPサーバーの実行は信頼設定に基づく。ワークスペース信頼機能との連携により、信頼されたワークスペースでのみMCPサーバーが実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 43 | チャットビュー | 主画面 | MCPサーバーのツール呼び出しを通じたAI機能拡張 |

## 機能種別

データ連携 / プロセス管理 / 設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | MCPサーバー名 | 一意識別子 |
| type | enum | Yes | サーバータイプ（stdio/http） | 'stdio' または 'http' |
| command | string | type=studioの場合Yes | 実行コマンド | 存在するコマンド |
| args | string[] | No | コマンド引数 | - |
| env | Record<string,string> | No | 環境変数 | - |
| url | string | type=httpの場合Yes | リモートサーバーURL | 有効なURL |
| headers | Record<string,string> | No | HTTPヘッダー | - |
| version | string | No | サーバーバージョン | セマンティックバージョン |
| gallery | boolean\|string | No | ギャラリー情報 | - |

### 入力データソース

- ユーザー設定ファイル（`~/.vscode/mcp.json`）
- ワークスペース設定ファイル（`.vscode/mcp.json`）
- ワークスペースファイル（`.code-workspace`の`settings.mcp`セクション）
- MCPギャラリーAPI

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ILocalMcpServer | object | インストール済みMCPサーバー情報 |
| McpConnectionState | enum | サーバー接続状態（Starting/Running/Stopped/Error） |
| MCP.JSONRPCMessage | object | MCPプロトコルメッセージ |

### 出力先

- メモリ内サーバー状態管理
- MCPレジストリ（サーバー定義の登録）
- ログ出力チャネル

## 処理フロー

### 処理シーケンス

```
1. 設定ファイルのスキャン
   └─ mcp.jsonファイルを読み込み、サーバー定義を抽出

2. MCPサーバー定義の登録
   └─ IMcpRegistryにサーバー定義を登録

3. サーバー起動要求
   └─ 信頼チェック後、変数置換を実行

4. トランスポート確立
   └─ stdio/HTTP/SSEに応じた接続を確立

5. プロトコル通信
   └─ JSON-RPCメッセージの送受信

6. 状態監視
   └─ 接続状態の変化を監視・通知
```

### フローチャート

```mermaid
flowchart TD
    A[設定ファイル読み込み] --> B{サーバー定義存在?}
    B -->|Yes| C[サーバー定義登録]
    B -->|No| D[終了]
    C --> E{起動要求?}
    E -->|Yes| F{信頼チェック}
    F -->|信頼済み| G[変数置換]
    F -->|未信頼| H[信頼確認ダイアログ]
    H -->|許可| G
    H -->|拒否| D
    G --> I{トランスポートタイプ}
    I -->|stdio| J[プロセス起動]
    I -->|http| K[HTTP接続]
    J --> L[JSON-RPC通信開始]
    K --> L
    L --> M[状態監視]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-61-01 | 信頼要件 | MCPサーバーは信頼されたワークスペースでのみ実行可能 | サーバー起動時 |
| BR-61-02 | 許可リスト | chat.mcp.access設定で許可されたサーバーのみ実行可能 | サーバー起動時 |
| BR-61-03 | バージョン管理 | ギャラリーインストール時はバージョンを記録 | インストール時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルベースの設定管理）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| MCP_NOT_FOUND | 設定エラー | 指定されたMCPサーバーが見つからない | 設定ファイルを確認 |
| MCP_START_FAILED | 起動エラー | サーバープロセスの起動に失敗 | コマンドパスと権限を確認 |
| MCP_AUTH_REQUIRED | 認証エラー | OAuth認証が必要 | ユーザーに認証を要求 |
| MCP_CONNECTION_LOST | 接続エラー | サーバーとの接続が切断 | 自動再接続を試行 |

### リトライ仕様

接続エラー発生時、指数バックオフで最大3回まで再接続を試行

## トランザクション仕様

該当なし

## パフォーマンス要件

- MCPサーバー起動: 5秒以内
- メッセージ応答: 30秒タイムアウト
- 同時接続MCPサーバー数: 制限なし（リソースによる）

## セキュリティ考慮事項

- MCPサーバーの実行はワークスペース信頼に依存
- シークレット情報（APIキー等）はSecretStorageに保存
- OAuth認証トークンは安全に管理
- 環境変数による機密情報の注入に対応

## 備考

MCPはAnthropic社が策定したModel Context Protocolに準拠している。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

MCPサーバー設定とプロトコルの型定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mcpPlatformTypes.ts | `src/vs/platform/mcp/common/mcpPlatformTypes.ts` | サーバー設定の型定義（IMcpServerConfiguration、McpServerType等） |
| 1-2 | mcpManagement.ts | `src/vs/platform/mcp/common/mcpManagement.ts` | MCPサーバー管理のインターフェース定義 |

**読解のコツ**: `McpServerType`は`LOCAL`（stdio）と`REMOTE`（http）の2種類。`ILocalMcpServer`がインストール済みサーバーを表す。

#### Step 2: エントリーポイントを理解する

MCPサービスの登録と初期化フロー。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mcpManagementService.ts | `src/vs/platform/mcp/common/mcpManagementService.ts` | MCPサーバー管理サービスの実装 |

**主要処理フロー**:
1. **49-70行目**: AbstractCommonMcpManagementServiceの基底クラス定義
2. **305-420行目**: AbstractMcpResourceManagementServiceでファイル監視とサーバー管理
3. **454-470行目**: install()メソッドでサーバーをリソースに追加

#### Step 3: ギャラリーサービスを理解する

MCPギャラリーとの連携処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mcpGalleryService.ts | `src/vs/platform/mcp/common/mcpGalleryService.ts` | ギャラリーAPIとの通信、サーバー検索 |

**主要処理フロー**:
- **696-1057行目**: McpGalleryServiceクラス全体
- **718-749行目**: query()メソッドでサーバー検索
- **971-997行目**: getMcpServer()で個別サーバー取得

#### Step 4: 拡張機能ホストとの連携を理解する

メインスレッドと拡張機能ホスト間のMCP通信。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | mainThreadMcp.ts | `src/vs/workbench/api/browser/mainThreadMcp.ts` | メインスレッド側のMCP処理 |

**主要処理フロー**:
- **34-117行目**: MainThreadMcpクラスのコンストラクタとデリゲート登録
- **83-99行目**: サーバー起動処理（start）
- **217-329行目**: 認証トークン取得処理

### プログラム呼び出し階層図

```
McpManagementService
    │
    ├─ McpUserResourceManagementService
    │      ├─ McpResourceScannerService (設定ファイルスキャン)
    │      └─ McpGalleryService (ギャラリー連携)
    │
    └─ IMcpRegistry
           └─ MainThreadMcp
                  └─ ExtHostMcp (拡張機能ホスト側)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

mcp.json ─────────────▶ McpResourceScannerService ─▶ ILocalMcpServer[]
                              │
MCPギャラリーAPI ────────▶ McpGalleryService ─────────▶ IGalleryMcpServer[]
                              │
ユーザー操作 ────────────▶ McpManagementService ────▶ サーバー起動/停止
                              │
                        MainThreadMcp ──────────────▶ MCP JSON-RPC通信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mcpPlatformTypes.ts | `src/vs/platform/mcp/common/mcpPlatformTypes.ts` | ソース | 型定義 |
| mcpManagement.ts | `src/vs/platform/mcp/common/mcpManagement.ts` | ソース | インターフェース定義 |
| mcpManagementService.ts | `src/vs/platform/mcp/common/mcpManagementService.ts` | ソース | サーバー管理サービス |
| mcpGalleryService.ts | `src/vs/platform/mcp/common/mcpGalleryService.ts` | ソース | ギャラリー連携 |
| mcpResourceScannerService.ts | `src/vs/platform/mcp/common/mcpResourceScannerService.ts` | ソース | 設定スキャン |
| mainThreadMcp.ts | `src/vs/workbench/api/browser/mainThreadMcp.ts` | ソース | メインスレッドMCP処理 |
| allowedMcpServersService.ts | `src/vs/platform/mcp/common/allowedMcpServersService.ts` | ソース | 許可リスト管理 |
