# 機能設計書 62-拡張機能ホスト

## 概要

本ドキュメントは、Visual Studio Codeにおける拡張機能ホスト（Extension Host）の設計仕様を記載する。拡張機能ホストは、拡張機能を別プロセスで実行し、VS Code本体との通信を管理する中核コンポーネントである。

### 本機能の処理概要

拡張機能ホストは、拡張機能コードを安全に隔離されたプロセスで実行し、メインプロセス（renderer）との間でRPCを通じた双方向通信を行う。

**業務上の目的・背景**：拡張機能を別プロセスで実行することで、拡張機能のクラッシュやパフォーマンス問題がエディタ本体に影響を与えることを防ぐ。また、拡張機能APIの一貫したインターフェースを提供し、拡張機能開発者が安全にVS Codeの機能を拡張できるようにする。

**機能の利用シーン**：VS Code起動時に拡張機能ホストが起動し、インストール済み拡張機能のロードと初期化を行う。ユーザーがエディタを操作する際、拡張機能ホストを通じて拡張機能が提供する機能（コード補完、シンタックスハイライト、コマンド等）が呼び出される。

**主要な処理内容**：
1. 拡張機能ホストプロセスの起動と管理
2. 拡張機能のロード・初期化・アクティベーション
3. メインプロセスとのRPC通信
4. 拡張機能APIの実装と提供
5. 拡張機能間の依存関係解決
6. リモート開発対応（SSH、WSL、コンテナ）

**関連システム・外部連携**：メインプロセス（renderer）、リモート開発サーバー、Node.jsランタイム、Web Worker（ブラウザ版）

**権限による制御**：拡張機能ホストはサンドボックス化されておらず、Node.js APIへのフルアクセスが可能。ワークスペース信頼機能により、一部の危険な操作は制限される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 33 | 拡張機能ビュー | 参照 | 拡張機能のアクティベーション状態表示 |

## 機能種別

プロセス管理 / API提供 / 通信基盤

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| extensions | IExtensionDescription[] | Yes | ロードする拡張機能リスト | manifest検証済み |
| activationEvents | Map<string,string[]> | Yes | アクティベーションイベントマッピング | - |
| environment | IEnvironment | Yes | 実行環境情報 | - |
| workspace | IWorkspaceData | No | ワークスペース情報 | - |
| remoteAuthority | string | No | リモート接続先 | URI形式 |

### 入力データソース

- 拡張機能manifest（package.json）
- ユーザー設定
- ワークスペース設定
- リモートサーバー接続情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ExtensionHostProcessId | number | ホストプロセスID |
| ActivatedExtension | object | アクティベート済み拡張機能情報 |
| ExtensionAPI | vscode namespace | 拡張機能API |

### 出力先

- メインプロセス（RPC経由）
- 拡張機能（API経由）
- ログ出力チャネル

## 処理フロー

### 処理シーケンス

```
1. 拡張機能ホストプロセス起動
   └─ Node.jsまたはWeb Workerとして起動

2. 初期化データ受信
   └─ 拡張機能リスト、設定、ワークスペース情報を受信

3. 拡張機能レジストリ構築
   └─ 拡張機能メタデータをパースしてレジストリに登録

4. RPC通信確立
   └─ メインスレッドとのProxy/Stubペアを初期化

5. APIインスタンス生成
   └─ 各拡張機能用にvscode名前空間を生成

6. 即座にアクティベーションが必要な拡張機能を起動
   └─ '*'アクティベーションイベントの拡張機能

7. オンデマンドアクティベーション
   └─ 各種イベントに応じて拡張機能をアクティベート
```

### フローチャート

```mermaid
flowchart TD
    A[プロセス起動] --> B[初期化データ受信]
    B --> C[レジストリ構築]
    C --> D[RPC通信確立]
    D --> E[即座アクティベーション]
    E --> F{イベント待機}
    F -->|activationEvent| G[依存関係解決]
    G --> H[拡張機能ロード]
    H --> I[activate関数呼び出し]
    I --> J[API返却]
    J --> F
    F -->|deactivate| K[拡張機能停止]
    K --> L{全停止?}
    L -->|Yes| M[プロセス終了]
    L -->|No| F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-62-01 | 依存関係順序 | 拡張機能は依存先が先にアクティベートされる | アクティベーション時 |
| BR-62-02 | APIバージョン | engines.vscodeで指定されたAPIバージョンを尊重 | ロード時 |
| BR-62-03 | 提案API | enabledApiProposalsで許可されたAPIのみ利用可能 | API呼び出し時 |

### 計算ロジック

**アクティベーション時間計測**：各拡張機能のactivate()関数の実行時間を計測し、パフォーマンス分析に使用。

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EXT_NOT_FOUND | ロードエラー | 拡張機能ファイルが見つからない | 拡張機能の再インストール |
| EXT_ACTIVATION_FAILED | アクティベーションエラー | activate()が例外をスロー | エラーログ出力、拡張機能を無効化 |
| EXT_DEPENDENCY_MISSING | 依存関係エラー | 依存拡張機能がインストールされていない | 依存拡張機能のインストール |
| EXT_HOST_CRASH | プロセスエラー | 拡張機能ホストがクラッシュ | 自動再起動 |

### リトライ仕様

拡張機能ホストがクラッシュした場合、自動的に再起動を試行。短時間に複数回クラッシュした場合は再起動を停止。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 拡張機能ホスト起動: 3秒以内
- 個々の拡張機能アクティベーション: 1秒以内（推奨）
- RPC往復時間: 10ms以内

## セキュリティ考慮事項

- 拡張機能は別プロセスで実行され、メインプロセスへの直接アクセス不可
- 提案API（Proposed API）は明示的な許可が必要
- ワークスペース信頼機能との連携
- リモート開発時は拡張機能ホストがリモートサーバーで実行

## 備考

拡張機能ホストは、Desktop版ではNode.jsプロセス、Web版ではWeb Workerとして動作する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

拡張機能とプロトコルの型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | extensions.ts | `src/vs/platform/extensions/common/extensions.ts` | IExtensionDescription（拡張機能メタデータ） |
| 1-2 | extHost.protocol.ts | `src/vs/workbench/api/common/extHost.protocol.ts` | MainThread/ExtHostのプロトコル定義 |

**読解のコツ**: `IExtensionDescription`はpackage.jsonをパースした結果。`MainContext`/`ExtHostContext`でRPCチャネルを定義。

#### Step 2: エントリーポイントを理解する

拡張機能ホストの起動と初期化フロー。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extHostExtensionService.ts | `src/vs/workbench/api/common/extHostExtensionService.ts` | 拡張機能サービスのメイン実装 |

**主要処理フロー**:
1. **83-200行目**: AbstractExtHostExtensionServiceの初期化
2. **128-142行目**: コンストラクタでの依存関係注入
3. **159-167行目**: レジストリの構築
4. **185-200行目**: アクティベーターの初期化

#### Step 3: アクティベーション処理を理解する

拡張機能のロードとアクティベーション。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extHostExtensionActivator.ts | `src/vs/workbench/api/common/extHostExtensionActivator.ts` | ExtensionsActivatorクラス |

**主要処理フロー**:
- `ExtensionsActivator`クラスがアクティベーションを管理
- `actualActivateExtension`メソッドで実際のactivate()を呼び出し
- `ActivatedExtension`で結果を保持

#### Step 4: API実装を理解する

vscode名前空間の実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | extHost.api.impl.ts | `src/vs/workbench/api/common/extHost.api.impl.ts` | vscode APIの実装 |

**主要処理フロー**:
- 各名前空間（window, workspace, languages等）の実装
- Proxy/Stubパターンによるメインスレッドとの通信

### プログラム呼び出し階層図

```
ExtensionHostMain
    │
    ├─ AbstractExtHostExtensionService
    │      ├─ ExtensionDescriptionRegistry (メタデータ管理)
    │      ├─ ExtensionsActivator (アクティベーション制御)
    │      └─ ExtHostStorage (永続化)
    │
    └─ ExtHost API実装
           ├─ ExtHostCommands
           ├─ ExtHostLanguageFeatures
           ├─ ExtHostWorkspace
           ├─ ExtHostDocuments
           └─ ... (各種ExtHost*)
```

### データフロー図

```
[メインプロセス]                    [拡張機能ホスト]

ExtensionService ──RPC──▶ ExtHostExtensionService
       │                           │
       ▼                           ▼
MainThreadXxx ◀───RPC───▶ ExtHostXxx
       │                           │
       ▼                           ▼
    UIコンポーネント             拡張機能コード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extHostExtensionService.ts | `src/vs/workbench/api/common/extHostExtensionService.ts` | ソース | 拡張機能サービス実装 |
| extHostExtensionActivator.ts | `src/vs/workbench/api/common/extHostExtensionActivator.ts` | ソース | アクティベーション管理 |
| extHost.protocol.ts | `src/vs/workbench/api/common/extHost.protocol.ts` | ソース | RPCプロトコル定義 |
| extHost.api.impl.ts | `src/vs/workbench/api/common/extHost.api.impl.ts` | ソース | vscode API実装 |
| extHostTypes.ts | `src/vs/workbench/api/common/extHostTypes.ts` | ソース | 型定義 |
| extHostCommands.ts | `src/vs/workbench/api/common/extHostCommands.ts` | ソース | コマンドAPI |
| extHostLanguageFeatures.ts | `src/vs/workbench/api/common/extHostLanguageFeatures.ts` | ソース | 言語機能API |
| extHostWorkspace.ts | `src/vs/workbench/api/common/extHostWorkspace.ts` | ソース | ワークスペースAPI |
