# 機能設計書 63-拡張機能管理

## 概要

本ドキュメントは、Visual Studio Codeにおける拡張機能管理機能の設計仕様を記載する。拡張機能管理は、マーケットプレイスからの拡張機能のインストール、更新、アンインストール、有効/無効化を行う機能を提供する。

### 本機能の処理概要

拡張機能管理は、Visual Studio Code Marketplaceとの連携を通じて、拡張機能のライフサイクル全体を管理する。

**業務上の目的・背景**：VS Codeのエコシステムの中核として、数万の拡張機能を安全かつ効率的にユーザーに提供する必要がある。拡張機能の検索、インストール、更新、セキュリティ検証を一元管理することで、ユーザー体験の向上とセキュリティの確保を両立する。

**機能の利用シーン**：ユーザーが新しい言語サポートやツールを追加したい場合、拡張機能ビューから検索・インストールを行う。また、インストール済みの拡張機能の更新確認や、不要になった拡張機能のアンインストールを行う。

**主要な処理内容**：
1. マーケットプレイスへのクエリと拡張機能検索
2. 拡張機能のダウンロードとインストール
3. 拡張機能の署名検証
4. 拡張機能の更新管理
5. 拡張機能の有効/無効化
6. 拡張機能の許可リスト管理

**関連システム・外部連携**：Visual Studio Code Marketplace、署名検証サービス、プロファイル同期サービス

**権限による制御**：企業ポリシーによる拡張機能の許可/禁止、署名検証の強制、特定の拡張機能のブロック

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 33 | 拡張機能ビュー | 主画面 | 拡張機能の検索、インストール、管理 |

## 機能種別

データ連携 / 設定管理 / セキュリティ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| extensionId | string | Yes | 拡張機能識別子 | publisher.name形式 |
| version | string | No | バージョン | セマンティックバージョン |
| preRelease | boolean | No | プレリリース版を含むか | - |
| targetPlatform | TargetPlatform | No | ターゲットプラットフォーム | 有効なプラットフォーム |
| installOptions | InstallOptions | No | インストールオプション | - |

### 入力データソース

- Visual Studio Code Marketplace API
- ローカルVSIXファイル
- 設定同期データ
- ユーザー設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ILocalExtension | object | インストール済み拡張機能情報 |
| IGalleryExtension | object | マーケットプレイス拡張機能情報 |
| InstallExtensionResult | object | インストール結果 |

### 出力先

- 拡張機能ディレクトリ（`~/.vscode/extensions`）
- 拡張機能プロファイル
- ログ出力チャネル

## 処理フロー

### 処理シーケンス

```
1. 拡張機能検索/特定
   └─ マーケットプレイスAPIにクエリを送信

2. 互換性チェック
   └─ エンジンバージョン、プラットフォームの確認

3. 許可チェック
   └─ 許可リスト、悪意ある拡張機能リストの確認

4. ダウンロード
   └─ VSIXパッケージをダウンロード

5. 署名検証
   └─ パッケージの署名を検証

6. 展開・インストール
   └─ パッケージを展開し、メタデータを保存

7. 有効化
   └─ 拡張機能ホストに通知
```

### フローチャート

```mermaid
flowchart TD
    A[インストール要求] --> B{互換性チェック}
    B -->|不適合| C[エラー通知]
    B -->|適合| D{許可チェック}
    D -->|禁止| C
    D -->|許可| E[ダウンロード]
    E --> F{署名検証}
    F -->|失敗| G{署名必須?}
    G -->|Yes| C
    G -->|No| H[警告表示]
    F -->|成功| I[展開]
    H --> I
    I --> J[メタデータ保存]
    J --> K[拡張機能ホスト通知]
    K --> L[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-63-01 | 許可リスト | extensions.allowed設定で指定された拡張機能のみインストール可能 | ポリシー設定時 |
| BR-63-02 | 悪意ある拡張機能 | マーケットプレイスが報告した悪意ある拡張機能はインストール不可 | 常時 |
| BR-63-03 | 署名検証 | 公開リポジトリの拡張機能は署名検証が推奨 | インストール時 |
| BR-63-04 | 自動更新 | extensions.autoUpdate設定に従って自動更新 | 設定に応じて |

### 計算ロジック

**拡張機能サイズ計算**：インストール済み拡張機能のディスク使用量を再帰的に計算。

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルシステムベース）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NotFound | 検索エラー | 拡張機能がマーケットプレイスに存在しない | 拡張機能IDを確認 |
| Incompatible | 互換性エラー | エンジンバージョン不適合 | VS Codeを更新 |
| Malicious | セキュリティエラー | 悪意ある拡張機能として報告済み | インストール不可 |
| SignatureVerificationFailed | 署名エラー | 署名検証失敗 | 設定で検証を無効化（非推奨） |
| Download | ダウンロードエラー | ネットワークエラー | リトライまたはプロキシ設定確認 |

### リトライ仕様

ダウンロードエラー時、指数バックオフで最大3回リトライ。

## トランザクション仕様

該当なし

## パフォーマンス要件

- マーケットプレイス検索: 3秒以内
- 拡張機能インストール: ダウンロードサイズに依存
- 署名検証: 2秒以内

## セキュリティ考慮事項

- パッケージ署名検証によるタンパリング検出
- 悪意ある拡張機能リストの自動更新
- 企業ポリシーによる拡張機能制限
- HTTPSによるダウンロード通信の保護

## 備考

プラットフォーム固有の拡張機能（ネイティブモジュールを含む）は、ターゲットプラットフォームに応じたパッケージが提供される。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

拡張機能の型定義とマーケットプレイスの型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | extensionManagement.ts | `src/vs/platform/extensionManagement/common/extensionManagement.ts` | IGalleryExtension、ILocalExtension等の型定義 |
| 1-2 | extensions.ts | `src/vs/platform/extensions/common/extensions.ts` | IExtensionIdentifier、TargetPlatform |

**読解のコツ**: `IGalleryExtension`がマーケットプレイスの拡張機能、`ILocalExtension`がインストール済みの拡張機能を表す。

#### Step 2: エントリーポイントを理解する

拡張機能管理サービスのインターフェース。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extensionManagement.ts | `src/vs/platform/extensionManagement/common/extensionManagement.ts` | IExtensionManagementService、IExtensionGalleryService |

**主要処理フロー**:
1. **399-423行目**: IExtensionGalleryServiceのインターフェース定義
2. **601-636行目**: IExtensionManagementServiceのインターフェース定義
3. **563-591行目**: InstallOptions、UninstallOptionsの型定義

#### Step 3: ギャラリーサービスを理解する

マーケットプレイスとの通信処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extensionGalleryService.ts | `src/vs/platform/extensionManagement/common/extensionGalleryService.ts` | ExtensionGalleryService実装 |

**主要処理フロー**:
- `query()`メソッドで拡張機能検索
- `getExtensions()`で特定の拡張機能取得
- `download()`でパッケージダウンロード

#### Step 4: 署名検証を理解する

パッケージ署名の検証処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | extensionSignatureVerificationService.ts | `src/vs/platform/extensionManagement/node/extensionSignatureVerificationService.ts` | 署名検証サービス |

**主要処理フロー**:
- ExtensionSignatureVerificationCode列挙型で検証結果を表現
- shouldRequireRepositorySignatureFor()で署名必須判定

### プログラム呼び出し階層図

```
IExtensionManagementService
    │
    ├─ IExtensionGalleryService (マーケットプレイス通信)
    │      ├─ query() - 検索
    │      ├─ getExtensions() - 取得
    │      └─ download() - ダウンロード
    │
    ├─ IExtensionsScannerService (ローカルスキャン)
    │      └─ scanExtensions() - インストール済み拡張機能取得
    │
    └─ 署名検証サービス
           └─ verify() - 署名検証
```

### データフロー図

```
[入力]                         [処理]                          [出力]

マーケットプレイス ─────▶ ExtensionGalleryService ──▶ IGalleryExtension
                              │
ダウンロードURL ─────────▶ download() ─────────────▶ VSIXファイル
                              │
VSIXファイル ─────────────▶ 署名検証 ────────────────▶ 検証結果
                              │
                        展開・インストール ─────────▶ ILocalExtension
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extensionManagement.ts | `src/vs/platform/extensionManagement/common/extensionManagement.ts` | ソース | 型定義とインターフェース |
| extensionGalleryService.ts | `src/vs/platform/extensionManagement/common/extensionGalleryService.ts` | ソース | ギャラリーサービス |
| extensionManagementService.ts | `src/vs/platform/extensionManagement/node/extensionManagementService.ts` | ソース | 管理サービス実装（Node.js） |
| extensionSignatureVerificationService.ts | `src/vs/platform/extensionManagement/node/extensionSignatureVerificationService.ts` | ソース | 署名検証 |
| allowedExtensionsService.ts | `src/vs/platform/extensionManagement/common/allowedExtensionsService.ts` | ソース | 許可リスト管理 |
