# 機能設計書 64-言語機能

## 概要

本ドキュメントは、Visual Studio Codeにおける言語機能（Language Features）APIの設計仕様を記載する。言語機能APIは、コード補完、定義へ移動、シンボル検索などの言語インテリジェンス機能を拡張機能から提供するためのフレームワークである。

### 本機能の処理概要

言語機能APIは、Language Server Protocolを参考に設計された拡張機能APIであり、言語固有の編集支援機能を統一的なインターフェースで提供する。

**業務上の目的・背景**：様々なプログラミング言語に対して、一貫したコード編集体験を提供するため、言語機能を標準化されたAPIとして定義する。拡張機能開発者はこのAPIを実装することで、任意の言語に対してIntelliSense機能を提供できる。

**機能の利用シーン**：ユーザーがコードを編集する際、コード補完の候補表示、関数定義へのジャンプ、シンボルのリネーム、エラー診断の表示など、様々な言語支援機能が呼び出される。

**主要な処理内容**：
1. コード補完（CompletionItemProvider）
2. 定義へ移動（DefinitionProvider）
3. ホバー情報（HoverProvider）
4. シグネチャヘルプ（SignatureHelpProvider）
5. ドキュメントシンボル（DocumentSymbolProvider）
6. コードアクション（CodeActionProvider）
7. 診断情報（DiagnosticCollection）
8. セマンティックトークン（SemanticTokensProvider）

**関連システム・外部連携**：Language Server Protocol（LSP）サーバー、拡張機能ホスト、エディタコア

**権限による制御**：特になし（拡張機能の一般的なAPI）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | エディタエリア | 主画面 | コード補完、ホバー、定義へ移動等の表示 |

## 機能種別

API提供 / 言語支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | TextDocument | Yes | 対象ドキュメント | 開いているドキュメント |
| position | Position | Yes | カーソル位置 | 有効な位置 |
| token | CancellationToken | Yes | キャンセルトークン | - |
| context | 各種Context | No | 呼び出しコンテキスト | - |

### 入力データソース

- エディタのドキュメント状態
- カーソル位置
- ユーザー入力（トリガー文字等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CompletionItem[] | array | 補完候補リスト |
| Location | object | 定義位置 |
| Hover | object | ホバー情報 |
| DocumentSymbol[] | array | ドキュメント内シンボル |
| Diagnostic[] | array | 診断情報 |

### 出力先

- エディタUI（補完リスト、ホバー、診断マーカー等）
- アウトラインビュー
- 問題パネル

## 処理フロー

### 処理シーケンス

```
1. ユーザーアクションまたはトリガー
   └─ 補完トリガー文字入力、ホバー、Ctrl+Click等

2. プロバイダー検索
   └─ ドキュメントの言語に対応するプロバイダーを検索

3. プロバイダー呼び出し
   └─ 登録されたプロバイダーのメソッドを呼び出し

4. 結果変換
   └─ 拡張機能APIの型からエディタ内部型に変換

5. UI表示
   └─ 結果をエディタUIに反映
```

### フローチャート

```mermaid
flowchart TD
    A[ユーザーアクション] --> B{プロバイダー登録済み?}
    B -->|No| C[デフォルト動作]
    B -->|Yes| D[プロバイダー取得]
    D --> E[RPC呼び出し]
    E --> F[拡張機能ホストで実行]
    F --> G[結果変換]
    G --> H[UI表示]
    H --> I{追加解決必要?}
    I -->|Yes| J[resolve呼び出し]
    J --> H
    I -->|No| K[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-64-01 | ドキュメントセレクター | 登録時に指定した言語/スキーム/パターンに一致するドキュメントのみ対象 | プロバイダー呼び出し時 |
| BR-64-02 | 複数プロバイダー | 同一機能に複数のプロバイダーが登録可能、結果はマージ | 常時 |
| BR-64-03 | キャンセル対応 | CancellationTokenでキャンセル可能 | 常時 |

### 計算ロジック

**補完スコアリング**：ユーザー入力との関連性に基づいて補完候補をスコアリング・ソート。

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ProviderError | 実行エラー | プロバイダーが例外をスロー | エラーログ出力、他のプロバイダーを続行 |
| Timeout | タイムアウト | プロバイダーが時間内に応答しない | タイムアウト処理 |
| Cancelled | キャンセル | ユーザーがキャンセル | 処理中断 |

### リトライ仕様

リトライなし。エラー発生時は他の登録プロバイダーの結果を使用。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 補完候補取得: 200ms以内（初回）
- 定義へ移動: 100ms以内
- ホバー情報: 200ms以内

## セキュリティ考慮事項

- プロバイダーは拡張機能ホストで実行され、メインプロセスへの直接アクセスなし
- ドキュメント内容へのアクセスは読み取り専用

## 備考

言語機能APIはLanguage Server Protocol（LSP）の概念を参考に設計されているが、LSPサーバーを直接必要としない。拡張機能は直接プロバイダーを実装するか、LSPクライアントライブラリを使用してLSPサーバーに委譲できる。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

言語機能の型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | extHostTypes.ts | `src/vs/workbench/api/common/extHostTypes.ts` | CompletionItem、Location、Hover等の型定義 |
| 1-2 | languages.ts | `src/vs/editor/common/languages.ts` | エディタ内部の言語機能型 |

**読解のコツ**: `extHostTypes.ts`が拡張機能API側の型、`languages.ts`がエディタ内部の型。変換処理で両者を橋渡し。

#### Step 2: エントリーポイントを理解する

言語機能の登録と呼び出し。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extHostLanguageFeatures.ts | `src/vs/workbench/api/common/extHostLanguageFeatures.ts` | ExtHostLanguageFeaturesクラス |

**主要処理フロー**:
1. **45-105行目**: DocumentSymbolAdapterの実装例
2. **107-193行目**: CodeLensAdapterの実装例
3. 各Adapterがプロバイダーをラップしてメインスレッドと通信

#### Step 3: 型変換を理解する

拡張機能API型とエディタ内部型の変換。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extHostTypeConverters.ts | `src/vs/workbench/api/common/extHostTypeConverters.ts` | 型変換ユーティリティ |

**主要処理フロー**:
- `Range.from/to`で範囲の変換
- `Position.from/to`で位置の変換
- `CompletionItem.from/to`で補完アイテムの変換

#### Step 4: メインスレッド側を理解する

エディタ本体での言語機能呼び出し。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | mainThreadLanguageFeatures.ts | `src/vs/workbench/api/browser/mainThreadLanguageFeatures.ts` | MainThreadLanguageFeatures |

### プログラム呼び出し階層図

```
エディタUI
    │
    ├─ CompletionController (補完UI)
    │      └─ LanguageFeaturesService
    │             └─ MainThreadLanguageFeatures
    │                    └─ ExtHostLanguageFeatures
    │                           └─ CompletionItemProvider (拡張機能)
    │
    ├─ DefinitionController (定義へ移動)
    │      └─ ... 同様の構造
    │
    └─ ... 他の言語機能
```

### データフロー図

```
[拡張機能]                     [拡張機能ホスト]               [メインスレッド]

Provider実装 ──register──▶ ExtHostLanguageFeatures ◀──RPC──▶ MainThreadLanguageFeatures
                                    │                              │
                                    ▼                              ▼
                              Adapter変換                   languages.xxxProvider
                                    │                              │
                                    ▼                              ▼
                              結果生成  ──────────RPC────────▶  UI表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extHostLanguageFeatures.ts | `src/vs/workbench/api/common/extHostLanguageFeatures.ts` | ソース | 言語機能ホスト側実装 |
| extHostTypes.ts | `src/vs/workbench/api/common/extHostTypes.ts` | ソース | API型定義 |
| extHostTypeConverters.ts | `src/vs/workbench/api/common/extHostTypeConverters.ts` | ソース | 型変換 |
| mainThreadLanguageFeatures.ts | `src/vs/workbench/api/browser/mainThreadLanguageFeatures.ts` | ソース | メインスレッド側実装 |
| languages.ts | `src/vs/editor/common/languages.ts` | ソース | エディタ内部型 |
