# 機能設計書 65-デバッグ

## 概要

本ドキュメントは、Visual Studio Codeにおけるデバッグ機能APIの設計仕様を記載する。デバッグAPIは、Debug Adapter Protocol（DAP）を通じて様々な言語・ランタイムのデバッガーと連携するためのフレームワークを提供する。

### 本機能の処理概要

デバッグAPIは、拡張機能がデバッグアダプター（Debug Adapter）を登録し、VS Codeのデバッグ機能と統合するためのインターフェースを提供する。

**業務上の目的・背景**：開発者が様々な言語やランタイムでデバッグを行えるように、標準化されたDebug Adapter Protocolを採用。拡張機能開発者はDAP準拠のデバッグアダプターを実装することで、VS Codeのデバッグ機能に統合できる。

**機能の利用シーン**：開発者がブレークポイントを設定し、デバッグセッションを開始する際に、設定されたデバッグアダプターが起動され、ターゲットプログラムのデバッグが可能になる。ステップ実行、変数の監視、コールスタックの表示など、統一されたデバッグ体験を提供する。

**主要な処理内容**：
1. デバッグ設定プロバイダーの登録（DebugConfigurationProvider）
2. デバッグアダプター記述子ファクトリの登録（DebugAdapterDescriptorFactory）
3. デバッグセッションの開始・停止
4. ブレークポイントの管理
5. デバッグコンソールとの通信
6. デバッグビジュアライザーの提供

**関連システム・外部連携**：Debug Adapter Protocol、デバッグアダプタープロセス、ターゲットプログラム

**権限による制御**：デバッグアダプターの実行はワークスペース信頼に依存

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | エディタエリア | 参照 | ブレークポイントの設定、インラインデバッグ情報表示 |
| 34 | デバッグビュー | 主画面 | デバッグセッション制御、変数監視 |

## 機能種別

API提供 / プロセス管理 / デバッグ支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| debugType | string | Yes | デバッグタイプ | 登録済みタイプ |
| configuration | DebugConfiguration | Yes | デバッグ設定 | 必須項目の存在確認 |
| folder | WorkspaceFolder | No | ワークスペースフォルダ | - |
| session | DebugSession | No | 親セッション | - |

### 入力データソース

- launch.json（デバッグ設定）
- package.json（debuggers contribution）
- ユーザー入力（クイックピック等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| DebugSession | object | デバッグセッション |
| Breakpoint[] | array | ブレークポイント状態 |
| DebugProtocolMessage | object | DAPメッセージ |

### 出力先

- デバッグビュー（変数、コールスタック、ウォッチ）
- デバッグコンソール
- エディタ（インライン値表示）

## 処理フロー

### 処理シーケンス

```
1. デバッグ開始要求
   └─ ユーザーがF5押下またはデバッグ開始コマンド

2. 設定解決
   └─ DebugConfigurationProviderで設定を解決・補完

3. アダプター起動
   └─ DebugAdapterDescriptorFactoryでアダプター取得・起動

4. DAPセッション確立
   └─ initialize/launch/attachリクエスト

5. デバッグ実行
   └─ ブレークポイント、ステップ実行、変数取得

6. セッション終了
   └─ terminate/disconnectでセッション終了
```

### フローチャート

```mermaid
flowchart TD
    A[デバッグ開始要求] --> B{設定存在?}
    B -->|No| C[設定プロバイダー呼び出し]
    B -->|Yes| D[設定解決]
    C --> D
    D --> E[アダプター記述子取得]
    E --> F{アダプタータイプ}
    F -->|Executable| G[プロセス起動]
    F -->|Server| H[ソケット接続]
    F -->|Inline| I[インライン実行]
    G --> J[DAPセッション確立]
    H --> J
    I --> J
    J --> K[デバッグ実行]
    K --> L{イベント}
    L -->|stopped| M[ブレーク処理]
    L -->|terminated| N[セッション終了]
    M --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-65-01 | 設定タイプ | debuggers.typeで登録されたタイプのみ使用可能 | デバッグ開始時 |
| BR-65-02 | 設定解決順序 | resolveDebugConfiguration -> resolveDebugConfigurationWithSubstitutedVariables | 設定解決時 |
| BR-65-03 | ブレークポイント種別 | ソース、関数、データ、例外ブレークポイントをサポート | ブレークポイント設定時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| AdapterNotFound | 起動エラー | デバッグアダプターが見つからない | 拡張機能のインストール確認 |
| ConfigurationError | 設定エラー | launch.jsonの設定エラー | 設定内容の確認 |
| AdapterCrash | 実行エラー | デバッグアダプターがクラッシュ | エラーログ確認 |
| TargetError | 実行エラー | ターゲットプログラムのエラー | デバッグコンソール確認 |

### リトライ仕様

アダプタークラッシュ時、ユーザーに再起動オプションを提示。自動リトライなし。

## トランザクション仕様

該当なし

## パフォーマンス要件

- デバッグセッション開始: 5秒以内
- ステップ実行応答: 1秒以内
- 変数取得: 2秒以内

## セキュリティ考慮事項

- デバッグアダプターは別プロセスで実行
- ターゲットプログラムへのアクセスはDAPを通じて制御
- ワークスペース信頼機能との連携

## 備考

VS CodeのデバッグはDebug Adapter Protocol（DAP）を採用している。DAPはMicrosoft主導で策定されたプロトコルで、言語サーバーのLSPと同様の位置づけ。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

デバッグの型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | IDebugSession、IBreakpoint等の型定義 |
| 1-2 | extHostTypes.ts | `src/vs/workbench/api/common/extHostTypes.ts` | Breakpoint、DebugAdapterExecutable等 |

**読解のコツ**: `IDebugSession`がデバッグセッションを表し、DAPアダプターとの通信を管理。`Breakpoint`は拡張機能APIの型。

#### Step 2: エントリーポイントを理解する

デバッグサービスの実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extHostDebugService.ts | `src/vs/workbench/api/common/extHostDebugService.ts` | ExtHostDebugServiceBaseクラス |

**主要処理フロー**:
1. **36-62行目**: IExtHostDebugServiceインターフェース定義
2. **64-168行目**: ExtHostDebugServiceBaseのコンストラクタと初期化
3. **56-61行目**: プロバイダー登録メソッド（registerDebugConfigurationProvider等）

#### Step 3: デバッグアダプター通信を理解する

DAPメッセージの送受信。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | abstractDebugAdapter.ts | `src/vs/workbench/contrib/debug/common/abstractDebugAdapter.ts` | AbstractDebugAdapterクラス |

**主要処理フロー**:
- `sendRequest()`でDAPリクエスト送信
- `onMessage()`でDAPレスポンス/イベント受信
- 各種DAPメッセージの処理

### プログラム呼び出し階層図

```
vscode.debug API
    │
    └─ ExtHostDebugService
           │
           ├─ DebugConfigurationProvider (設定解決)
           │
           ├─ DebugAdapterDescriptorFactory (アダプター生成)
           │      ├─ DebugAdapterExecutable
           │      ├─ DebugAdapterServer
           │      └─ DebugAdapterInlineImplementation
           │
           └─ DebugAdapterTrackerFactory (通信監視)
                  │
                  └─ AbstractDebugAdapter
                         │
                         └─ DAP通信
```

### データフロー図

```
[VS Code]                   [デバッグアダプター]            [ターゲット]

startDebugging() ──▶ resolveConfig ──▶ getAdapter
                                            │
                            DAP initialize ──▶ initialize
                            DAP launch/attach ──▶ launch/attach ──▶ プロセス起動
                                            │
                     ◀── DAP stopped ◀────── ブレーク
                            │
                    変数取得 ──▶ DAP variables ──▶ 変数読取
                            │
                     ◀── DAP terminated ◀───── プロセス終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extHostDebugService.ts | `src/vs/workbench/api/common/extHostDebugService.ts` | ソース | デバッグサービス実装 |
| extHostTypes.ts | `src/vs/workbench/api/common/extHostTypes.ts` | ソース | API型定義 |
| debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | ソース | 内部型定義 |
| abstractDebugAdapter.ts | `src/vs/workbench/contrib/debug/common/abstractDebugAdapter.ts` | ソース | アダプター基底クラス |
| debugUtils.ts | `src/vs/workbench/contrib/debug/common/debugUtils.ts` | ソース | ユーティリティ |
