# 機能設計書 66-Webview

## 概要

本ドキュメントは、Visual Studio CodeにおけるWebview APIの設計仕様を記載する。Webview APIは、拡張機能がカスタムHTMLコンテンツをエディタ内に表示するための仕組みを提供する。

### 本機能の処理概要

Webview APIは、拡張機能が任意のHTML/CSS/JavaScriptコンテンツをVS Code内のパネルまたはエディタに表示するためのセキュアなサンドボックス環境を提供する。

**業務上の目的・背景**：標準的なVS CodeのUIコンポーネントでは表現できないリッチなユーザーインターフェースを拡張機能から提供可能にする。マークダウンプレビュー、カスタムエディタ、ダッシュボード、フォームUIなど、様々なユースケースに対応する。

**機能の利用シーン**：拡張機能がカスタムビューを提供する場合（例：マークダウンプレビュー、Git差分ビュー、Jupyter Notebook、設定UI等）にWebviewが使用される。ユーザーはWebview内でインタラクティブなコンテンツを操作できる。

**主要な処理内容**：
1. WebviewPanelの作成と管理
2. HTMLコンテンツの設定
3. 拡張機能とWebview間のメッセージ通信
4. リソースURIの変換（asWebviewUri）
5. セキュリティポリシー（CSP）の適用
6. Webviewビューの登録（サイドバー等）

**関連システム・外部連携**：Electron iframe/webview、ブラウザセキュリティ、Content Security Policy

**権限による制御**：Webviewはサンドボックス化されており、localResourceRootsで指定されたリソースのみアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | エディタエリア | 主画面 | WebviewPanelの表示 |
| 2 | サイドバー | 参照 | WebviewViewの表示 |
| 36 | カスタムエディタビュー | 主画面 | カスタムエディタとしてのWebview |

## 機能種別

API提供 / UI拡張 / セキュリティ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| viewType | string | Yes | Webviewタイプ識別子 | 一意の識別子 |
| title | string | Yes | パネルタイトル | 文字列 |
| viewColumn | ViewColumn | Yes | 表示位置 | 有効なViewColumn |
| options | WebviewOptions | No | オプション設定 | - |
| html | string | Yes | HTMLコンテンツ | 有効なHTML |

### 入力データソース

- 拡張機能からのHTML/CSS/JS
- 拡張機能バンドルのリソースファイル
- メッセージAPI経由のデータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| WebviewPanel | object | Webviewパネルインスタンス |
| WebviewView | object | Webviewビューインスタンス |
| URI | object | Webview用リソースURI |

### 出力先

- エディタエリア（WebviewPanel）
- サイドバー/パネル（WebviewView）
- カスタムエディタ（CustomDocument）

## 処理フロー

### 処理シーケンス

```
1. Webview作成
   └─ createWebviewPanel()またはWebviewViewProvider登録

2. オプション設定
   └─ enableScripts、localResourceRoots等の設定

3. コンテンツ設定
   └─ webview.html にHTMLを設定

4. リソースURI変換
   └─ asWebviewUri()でローカルリソースをWebview用URIに変換

5. メッセージ通信
   └─ postMessage/onDidReceiveMessageで双方向通信

6. ライフサイクル管理
   └─ visible/active状態の監視、dispose処理
```

### フローチャート

```mermaid
flowchart TD
    A[Webview作成要求] --> B[WebviewPanel生成]
    B --> C[オプション適用]
    C --> D[HTMLコンテンツ設定]
    D --> E{スクリプト有効?}
    E -->|Yes| F[CSP設定]
    E -->|No| G[静的表示]
    F --> H[リソースURI変換]
    G --> I[レンダリング]
    H --> I
    I --> J{メッセージ?}
    J -->|postMessage| K[拡張機能へ送信]
    K --> J
    J -->|dispose| L[クリーンアップ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-66-01 | CSP適用 | WebviewはContent Security Policyの適用が推奨 | スクリプト有効時 |
| BR-66-02 | リソース制限 | localResourceRootsで指定したパス外のリソースはアクセス不可 | リソース読み込み時 |
| BR-66-03 | 状態保持 | retainContextWhenHiddenでバックグラウンド時の状態保持可能 | パフォーマンスとのトレードオフ |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CSPViolation | セキュリティエラー | CSPポリシー違反 | CSP設定の見直し |
| ResourceNotFound | リソースエラー | 指定リソースが見つからない | パスの確認、localResourceRootsの確認 |
| DisposedWebview | 状態エラー | dispose済みWebviewへのアクセス | ライフサイクル管理の見直し |

### リトライ仕様

リトライなし

## トランザクション仕様

該当なし

## パフォーマンス要件

- Webview初期表示: 1秒以内
- メッセージ往復: 50ms以内
- retainContextWhenHidden使用時はメモリ消費に注意

## セキュリティ考慮事項

- WebviewはiframeでサンドボックスされてNode.jsへのアクセス不可
- CSPによるスクリプト/スタイルの制御
- localResourceRootsによるファイルアクセス制限
- asWebviewUri()によるセキュアなリソースアクセス
- 古いvscode-resource: URIは非推奨

## 備考

Webviewは高機能だがリソース消費が大きいため、シンプルなUIにはTreeView等の軽量な代替を検討すること。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Webviewの型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | extHostWebview.ts | `src/vs/workbench/api/common/extHostWebview.ts` | ExtHostWebviewクラス |

**読解のコツ**: `ExtHostWebview`がWebviewインスタンスを表し、HTML設定やメッセージ通信を管理。

#### Step 2: エントリーポイントを理解する

Webviewの作成と管理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extHostWebview.ts | `src/vs/workbench/api/common/extHostWebview.ts` | ExtHostWebviewクラス実装 |

**主要処理フロー**:
1. **25-61行目**: ExtHostWebviewのコンストラクタと初期化
2. **78-82行目**: asWebviewUri()でリソースURI変換
3. **103-114行目**: htmlプロパティでコンテンツ設定
4. **131-137行目**: postMessage()でメッセージ送信

#### Step 3: パネル管理を理解する

WebviewPanelの管理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extHostWebviewPanels.ts | `src/vs/workbench/api/common/extHostWebviewPanels.ts` | ExtHostWebviewPanelsクラス |

**主要処理フロー**:
- `createWebviewPanel()`でパネル作成
- `reveal()`でパネル表示
- ライフサイクルイベント（onDidDispose等）

#### Step 4: ビュー管理を理解する

WebviewViewの管理（サイドバー等）。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | extHostWebviewView.ts | `src/vs/workbench/api/common/extHostWebviewView.ts` | ExtHostWebviewViews |

### プログラム呼び出し階層図

```
vscode.window.createWebviewPanel()
    │
    └─ ExtHostWebviewPanels
           │
           ├─ ExtHostWebview (コンテンツ管理)
           │      ├─ html設定
           │      ├─ asWebviewUri()
           │      └─ postMessage()
           │
           └─ MainThreadWebviewPanels (メインスレッド)
                  │
                  └─ WebviewPanel (UI表示)
```

### データフロー図

```
[拡張機能]                  [拡張機能ホスト]              [メインスレッド]

HTML設定 ──────────▶ ExtHostWebview ────RPC────▶ MainThreadWebviews
                          │                           │
postMessage() ─────▶ シリアライズ ───RPC────▶ Webview iframe
                          │                           │
               ◀─ onDidReceiveMessage ◀──RPC── iframe postMessage
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extHostWebview.ts | `src/vs/workbench/api/common/extHostWebview.ts` | ソース | Webview実装 |
| extHostWebviewPanels.ts | `src/vs/workbench/api/common/extHostWebviewPanels.ts` | ソース | パネル管理 |
| extHostWebviewView.ts | `src/vs/workbench/api/common/extHostWebviewView.ts` | ソース | ビュー管理 |
| extHostWebviewMessaging.ts | `src/vs/workbench/api/common/extHostWebviewMessaging.ts` | ソース | メッセージ通信 |
| webview.ts | `src/vs/workbench/contrib/webview/common/webview.ts` | ソース | 共通定義 |
