# 機能設計書 67-JavaScript/TypeScript

## 概要

本ドキュメントは、Visual Studio CodeにおけるJavaScript/TypeScript言語サポート拡張機能の設計仕様を記載する。本機能は組み込み拡張機能として、TypeScript Language Server（tsserver）との連携を通じて高度なIntelliSense機能を提供する。

### 本機能の処理概要

JavaScript/TypeScript言語サポートは、TypeScript Language Serverをバックエンドとして使用し、型情報に基づいたコード補完、診断、リファクタリング等の機能を提供する。

**業務上の目的・背景**：JavaScript/TypeScriptはVS Codeの主要なターゲット言語であり、最高品質の言語サポートを提供する必要がある。TypeScriptチームが提供するtsserverを利用することで、型システムに基づいた正確なIntelliSense機能を実現する。

**機能の利用シーン**：開発者がJavaScript/TypeScriptファイルを編集する際、コード補完、エラー診断、定義へ移動、リネーム、コードアクション（自動インポート等）、セマンティックハイライトなどの機能が利用される。

**主要な処理内容**：
1. TypeScript Language Server（tsserver）の起動と管理
2. コード補完（IntelliSense）
3. 診断情報（エラー、警告）の表示
4. 定義/型定義/実装へ移動
5. リファクタリング（リネーム、抽出等）
6. コードアクション（自動インポート、クイックフィックス）
7. セマンティックトークン
8. CodeLens（参照数、実装数表示）

**関連システム・外部連携**：TypeScript Language Server（tsserver）、Node.js、npm

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | エディタエリア | 主画面 | コード補完、診断、ホバー等の表示 |
| 30 | 問題パネル | 参照 | TypeScript/JavaScript診断エラーの表示 |

## 機能種別

言語サポート / IntelliSense / 診断

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | TextDocument | Yes | 対象ドキュメント | .js/.ts/.jsx/.tsx等 |
| position | Position | Yes | カーソル位置 | 有効な位置 |
| tsconfig | string | No | TypeScript設定ファイルパス | 有効なパス |

### 入力データソース

- ソースファイル（.js, .ts, .jsx, .tsx, .mjs, .mts等）
- tsconfig.json / jsconfig.json
- node_modules（型定義）
- ユーザー設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CompletionItem[] | array | 補完候補 |
| Diagnostic[] | array | 診断情報 |
| Location | object | 定義位置 |
| SemanticTokens | object | セマンティックトークン |

### 出力先

- エディタUI（補完リスト、ホバー、診断マーカー）
- 問題パネル
- アウトラインビュー

## 処理フロー

### 処理シーケンス

```
1. 拡張機能アクティベーション
   └─ JS/TSファイルオープン時にアクティベート

2. tsserver起動
   └─ TypeScript Language Serverプロセスを起動

3. プロジェクト初期化
   └─ tsconfig.json/jsconfig.jsonの読み込み

4. ファイル同期
   └─ オープンファイルの内容をtsserverに同期

5. 言語機能要求
   └─ 補完、診断、定義等の要求をtsserverに送信

6. 結果変換
   └─ tsserver応答をVS Code APIに変換
```

### フローチャート

```mermaid
flowchart TD
    A[JS/TSファイルオープン] --> B[拡張機能アクティベート]
    B --> C[tsserver起動]
    C --> D[プロジェクト設定読み込み]
    D --> E[ファイル同期]
    E --> F{ユーザー操作}
    F -->|補完要求| G[completions API]
    F -->|診断要求| H[diagnostics API]
    F -->|定義要求| I[definition API]
    G --> J[結果変換]
    H --> J
    I --> J
    J --> K[UI表示]
    K --> F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-67-01 | バージョン選択 | ワークスペースまたはユーザー設定でTypeScriptバージョンを選択可能 | 常時 |
| BR-67-02 | プラグイン | tsserver pluginsを拡張機能から追加可能 | プラグイン登録時 |
| BR-67-03 | セマンティックモード | TypeScript 3.7+でセマンティックトークン対応 | バージョン条件 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TsServerCrash | プロセスエラー | tsserverがクラッシュ | 自動再起動 |
| ProjectLoadError | 設定エラー | tsconfig.jsonのパースエラー | 設定ファイルの修正 |
| OutOfMemory | リソースエラー | 大規模プロジェクトでメモリ不足 | tsserver.maxTsServerMemory設定 |

### リトライ仕様

tsserverクラッシュ時、自動再起動を試行

## トランザクション仕様

該当なし

## パフォーマンス要件

- 補完候補取得: 300ms以内
- 診断更新: 500ms以内
- 大規模プロジェクトでのメモリ上限: typescript.tsserver.maxTsServerMemoryで設定可能

## セキュリティ考慮事項

- tsserverは別プロセスで実行
- ワークスペースのTypeScriptバージョン使用時はユーザー確認が必要

## 備考

TypeScript言語サポートは、TSGOモード（typescript.experimental.useTsgo）でネイティブTS実装に切り替え可能（実験的機能）。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

拡張機能の構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | extension.ts | `extensions/typescript-language-features/src/extension.ts` | 拡張機能エントリーポイント |
| 1-2 | configuration.ts | `extensions/typescript-language-features/src/configuration/configuration.ts` | 設定管理 |

**読解のコツ**: `activate()`関数が拡張機能のエントリーポイント。PluginManager、VersionProviderなどのコンポーネントを初期化。

#### Step 2: エントリーポイントを理解する

TypeScriptサービスクライアント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | typeScriptServiceClientHost.ts | `extensions/typescript-language-features/src/typeScriptServiceClientHost.ts` | サービスクライアントホスト |
| 2-2 | typescriptService.ts | `extensions/typescript-language-features/src/typescriptService.ts` | サービスインターフェース |

**主要処理フロー**:
1. TypeScriptServiceClientHostがtsserverとの接続を管理
2. ITypeScriptServiceClientがAPI呼び出しのインターフェース

#### Step 3: tsserver通信を理解する

tsserverプロセスとの通信。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | server.ts | `extensions/typescript-language-features/src/tsServer/server.ts` | サーバープロセス管理 |
| 3-2 | bufferSyncSupport.ts | `extensions/typescript-language-features/src/tsServer/bufferSyncSupport.ts` | ファイル同期 |

**主要処理フロー**:
- リクエストキューでtsserverへの要求を管理
- BufferSyncSupportでエディタ内容をtsserverに同期

#### Step 4: 言語機能を理解する

各種言語機能の実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | completions.ts | `extensions/typescript-language-features/src/languageFeatures/completions.ts` | 補完機能 |
| 4-2 | definitions.ts | `extensions/typescript-language-features/src/languageFeatures/definitions.ts` | 定義へ移動 |

### プログラム呼び出し階層図

```
extension.ts (activate)
    │
    ├─ TypeScriptServiceClientHost
    │      │
    │      ├─ TypeScriptServiceClient
    │      │      ├─ ServerProcess (tsserver)
    │      │      ├─ BufferSyncSupport
    │      │      └─ RequestQueue
    │      │
    │      └─ LanguageProvider
    │             ├─ CompletionItemProvider
    │             ├─ DefinitionProvider
    │             ├─ HoverProvider
    │             └─ ...
    │
    └─ PluginManager
```

### データフロー図

```
[エディタ]              [拡張機能]                    [tsserver]

ファイル編集 ──▶ BufferSyncSupport ─────▶ updateOpen
                       │
補完要求 ─────▶ CompletionItemProvider ──▶ completions
                       │                       │
                       ◀───────── 結果変換 ◀────
                       │
診断更新 ─────▶ DiagnosticsManager ◀────── diagnostics
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extension.ts | `extensions/typescript-language-features/src/extension.ts` | ソース | エントリーポイント |
| typeScriptServiceClientHost.ts | `extensions/typescript-language-features/src/typeScriptServiceClientHost.ts` | ソース | サービスホスト |
| server.ts | `extensions/typescript-language-features/src/tsServer/server.ts` | ソース | サーバー管理 |
| completions.ts | `extensions/typescript-language-features/src/languageFeatures/completions.ts` | ソース | 補完機能 |
| definitions.ts | `extensions/typescript-language-features/src/languageFeatures/definitions.ts` | ソース | 定義移動 |
| bufferSyncSupport.ts | `extensions/typescript-language-features/src/tsServer/bufferSyncSupport.ts` | ソース | ファイル同期 |
