# 機能設計書 68-JSON

## 概要

本ドキュメントは、Visual Studio CodeにおけるJSON言語サポート拡張機能の設計仕様を記載する。本機能は組み込み拡張機能として、JSON Language Serverとの連携を通じてJSONファイル編集の支援機能を提供する。

### 本機能の処理概要

JSON言語サポートは、Language Server Protocol（LSP）準拠のJSON Language Serverをバックエンドとして使用し、JSONスキーマに基づいた検証、補完、ホバー情報等の機能を提供する。

**業務上の目的・背景**：VS Codeの設定ファイル（settings.json、launch.json等）やpackage.json、tsconfig.json等、多くの重要な設定ファイルがJSON形式である。これらのファイル編集を支援するため、JSONスキーマに基づいた高度な編集支援機能を提供する。

**機能の利用シーン**：開発者がJSONファイルを編集する際、スキーマに基づいたプロパティ補完、値の検証、ホバーによるドキュメント表示、フォーマット等の機能が利用される。特に、VS Code設定ファイルの編集時に、利用可能な設定項目の補完が提供される。

**主要な処理内容**：
1. JSON Language Serverの起動と管理
2. JSONスキーマの関連付けと読み込み
3. スキーマに基づいたコード補完
4. JSON構文とスキーマ検証
5. ホバーによるドキュメント表示
6. 折りたたみ範囲の提供
7. ドキュメントカラー表示

**関連システム・外部連携**：JSON Language Server、JSON Schema Store、カスタムスキーマプロバイダー

**権限による制御**：スキーマダウンロードは信頼されたドメインからのみ許可

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | エディタエリア | 主画面 | コード補完、診断、ホバー等の表示 |
| 30 | 問題パネル | 参照 | JSON検証エラーの表示 |

## 機能種別

言語サポート / IntelliSense / 検証

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | TextDocument | Yes | 対象ドキュメント | .json/.jsonc等 |
| position | Position | Yes | カーソル位置 | 有効な位置 |
| schemaUri | string | No | JSONスキーマURI | 有効なURI |

### 入力データソース

- ソースファイル（.json, .jsonc, .code-snippets等）
- JSONスキーマファイル
- スキーマ関連付け設定（json.schemas）
- JSON Schema Store

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CompletionItem[] | array | 補完候補 |
| Diagnostic[] | array | 検証エラー |
| Hover | object | ホバー情報 |
| ColorInformation[] | array | カラー情報 |

### 出力先

- エディタUI（補完リスト、ホバー、診断マーカー）
- 問題パネル
- カラーデコレーション

## 処理フロー

### 処理シーケンス

```
1. 拡張機能アクティベーション
   └─ JSONファイルオープン時にアクティベート

2. Language Server起動
   └─ JSON Language Serverプロセスを起動

3. スキーマ関連付け
   └─ ファイルパターンに基づいてスキーマを関連付け

4. スキーマ読み込み
   └─ 関連付けられたスキーマをダウンロード/読み込み

5. 言語機能要求
   └─ 補完、検証、ホバー等の要求をサーバーに送信

6. 結果表示
   └─ サーバー応答をUIに反映
```

### フローチャート

```mermaid
flowchart TD
    A[JSONファイルオープン] --> B[拡張機能アクティベート]
    B --> C[Language Server起動]
    C --> D{スキーマ関連付け?}
    D -->|Yes| E[スキーマ読み込み]
    D -->|No| F[汎用JSON処理]
    E --> G{スキーマ取得成功?}
    G -->|Yes| H[スキーマベース機能]
    G -->|No| I[スキーマエラー表示]
    F --> J[構文ベース機能]
    H --> K[補完/検証/ホバー]
    J --> K
    I --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-68-01 | スキーマ関連付け | json.schemasまたは$schemaプロパティでスキーマを指定 | ファイルオープン時 |
| BR-68-02 | 信頼ドメイン | json.schemaDownload.trustedDomainsで許可されたドメインからのみスキーマダウンロード | スキーマ取得時 |
| BR-68-03 | 結果制限 | json.maxItemsComputedで大規模JSONの処理制限 | 補完/検証時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| SchemaLoadError | スキーマエラー | スキーマの読み込み失敗 | スキーマURIの確認、信頼ドメイン設定確認 |
| ValidationError | 検証エラー | スキーマ違反 | JSONの修正 |
| SyntaxError | 構文エラー | JSON構文エラー | 構文の修正 |

### リトライ仕様

スキーマ読み込み失敗時、ユーザーにリトライオプションを提示

## トランザクション仕様

該当なし

## パフォーマンス要件

- 補完候補取得: 200ms以内
- 検証更新: 300ms以内
- json.maxItemsComputedで大規模ファイルの処理制限

## セキュリティ考慮事項

- スキーマダウンロードは信頼されたドメインからのみ
- ワークスペース信頼機能との連携
- HTTPSによるスキーマ取得

## 備考

JSONスキーマのキャッシュはNode.js版でサポートされ、再起動時の高速化に寄与する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

拡張機能の構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | jsonClient.ts | `extensions/json-language-features/client/src/jsonClient.ts` | クライアント実装 |

**読解のコツ**: `Settings`型でJSON言語機能の設定構造を理解。`SettingIds`で設定キーを確認。

#### Step 2: エントリーポイントを理解する

Language Clientの初期化。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | jsonClientMain.ts | `extensions/json-language-features/client/src/node/jsonClientMain.ts` | Node.js版エントリーポイント |

**主要処理フロー**:
1. LanguageClientの初期化
2. スキーマリクエストハンドラの登録
3. カスタムリクエスト/通知の設定

#### Step 3: スキーマ管理を理解する

JSONスキーマの関連付けと読み込み。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | jsonClient.ts | `extensions/json-language-features/client/src/jsonClient.ts` | スキーマ関連付け処理 |

**主要処理フロー**:
- `SchemaAssociationNotification`でスキーマ関連付けを通知
- `VSCodeContentRequest`でスキーマコンテンツを取得
- `schemaCache`でスキーマをキャッシュ

#### Step 4: 言語機能を理解する

各種言語機能のミドルウェア。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | jsonClient.ts | `extensions/json-language-features/client/src/jsonClient.ts` | middlewareセクション |

### プログラム呼び出し階層図

```
jsonClientMain.ts (activate)
    │
    └─ startClient()
           │
           ├─ LanguageClient (LSP通信)
           │      └─ JSON Language Server
           │
           ├─ SchemaAssociation (スキーマ関連付け)
           │
           └─ LanguageStatus (ステータス表示)
                  └─ スキーマ情報表示
```

### データフロー図

```
[エディタ]              [クライアント]               [Language Server]

ファイルオープン ──▶ SchemaAssociation ────▶ スキーマ関連付け
                          │
                    VSCodeContentRequest ◀── スキーマ要求
                          │
                    スキーマ取得 ────────────▶ スキーマ解析
                          │
補完要求 ─────────▶ completion ──────────▶ スキーマベース補完
                          │
                    ◀──────────────── 候補リスト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| jsonClient.ts | `extensions/json-language-features/client/src/jsonClient.ts` | ソース | メインクライアント |
| jsonClientMain.ts | `extensions/json-language-features/client/src/node/jsonClientMain.ts` | ソース | Node.jsエントリー |
| languageStatus.ts | `extensions/json-language-features/client/src/languageStatus.ts` | ソース | ステータス表示 |
| languageParticipants.ts | `extensions/json-language-features/client/src/languageParticipants.ts` | ソース | 言語参加者 |
| schemaCache.ts | `extensions/json-language-features/client/src/node/schemaCache.ts` | ソース | スキーマキャッシュ |
