# 機能設計書 69-HTML

## 概要

本ドキュメントは、Visual Studio CodeにおけるHTML言語サポート拡張機能の設計仕様を記載する。本機能は組み込み拡張機能として、HTML Language Serverとの連携を通じてHTML編集の支援機能を提供する。

### 本機能の処理概要

HTML言語サポートは、Language Server Protocol（LSP）準拠のHTML Language Serverをバックエンドとして使用し、タグ補完、属性補完、自動クローズ、フォーマット等の機能を提供する。

**業務上の目的・背景**：Webアプリケーション開発においてHTMLは基礎的な技術であり、効率的なHTML編集支援が開発生産性に直結する。タグや属性の補完、閉じタグの自動挿入、埋め込みCSS/JavaScriptの言語サポートなど、包括的なHTML編集支援を提供する。

**機能の利用シーン**：開発者がHTML/HTM/XHTML等のファイルを編集する際、タグ補完、属性補完、閉じタグ自動挿入、リンク編集、フォーマット等の機能が利用される。また、PHPやRazor等のHTMLを含むテンプレート言語でもHTML部分の支援が提供される。

**主要な処理内容**：
1. HTML Language Serverの起動と管理
2. タグと属性のコード補完
3. 閉じタグの自動挿入（Auto Close Tag）
4. タグ名の連動編集（Linked Editing）
5. 埋め込みCSS/JavaScriptの言語サポート
6. HTMLフォーマット
7. セマンティックトークン
8. カスタムデータ拡張

**関連システム・外部連携**：HTML Language Server、CSS Language Server、JavaScript/TypeScript支援

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | エディタエリア | 主画面 | コード補完、フォーマット等の表示 |

## 機能種別

言語サポート / IntelliSense / フォーマット

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | TextDocument | Yes | 対象ドキュメント | .html/.htm/.xhtml等 |
| position | Position | Yes | カーソル位置 | 有効な位置 |
| triggerCharacter | string | No | トリガー文字（<, /等） | - |

### 入力データソース

- ソースファイル（.html, .htm, .xhtml等）
- カスタムデータファイル
- ユーザー設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CompletionItem[] | array | 補完候補（タグ、属性） |
| TextEdit | object | 自動挿入テキスト |
| SemanticTokens | object | セマンティックトークン |

### 出力先

- エディタUI（補完リスト、自動挿入）
- フォーマット結果

## 処理フロー

### 処理シーケンス

```
1. 拡張機能アクティベーション
   └─ HTMLファイルオープン時にアクティベート

2. Language Server起動
   └─ HTML Language Serverプロセスを起動

3. カスタムデータ読み込み
   └─ html.customDataで指定されたデータを読み込み

4. 言語機能要求
   └─ 補完、フォーマット、自動挿入等の要求をサーバーに送信

5. 埋め込み言語処理
   └─ <style>/<script>内の言語サービス委譲

6. 結果表示
   └─ サーバー応答をUIに反映
```

### フローチャート

```mermaid
flowchart TD
    A[HTMLファイルオープン] --> B[拡張機能アクティベート]
    B --> C[Language Server起動]
    C --> D[カスタムデータ読み込み]
    D --> E{ユーザー操作}
    E -->|タグ入力| F[タグ補完]
    E -->|属性入力| G[属性補完]
    E -->|>入力| H{自動クローズ有効?}
    E -->|フォーマット| I[HTMLフォーマット]
    H -->|Yes| J[閉じタグ挿入]
    H -->|No| K[何もしない]
    F --> L[UI表示]
    G --> L
    I --> L
    J --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-69-01 | 自動クローズ | html.autoClosingTagsでタグ自動クローズの有効/無効を制御 | タグ入力時 |
| BR-69-02 | 連動編集 | editor.linkedEditingで開始/終了タグの連動編集を制御 | タグ編集時 |
| BR-69-03 | フォーマット | html.format.enableでフォーマット機能の有効/無効を制御 | フォーマット要求時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ServerCrash | プロセスエラー | Language Serverクラッシュ | 自動再起動 |
| CustomDataError | データエラー | カスタムデータのパースエラー | データファイルの修正 |

### リトライ仕様

Language Serverクラッシュ時、自動再起動を試行

## トランザクション仕様

該当なし

## パフォーマンス要件

- 補完候補取得: 150ms以内
- 自動クローズ: 即時
- フォーマット: ドキュメントサイズに依存

## セキュリティ考慮事項

- 特になし

## 備考

HTML言語サポートは、他の言語（PHP、Razor、Vue等）の拡張機能からLanguage Participantとして利用される。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

拡張機能の構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | htmlClient.ts | `extensions/html-language-features/client/src/htmlClient.ts` | クライアント実装 |

**読解のコツ**: `SettingIds`で設定キーを確認。`AutoInsertRequest`で自動挿入の仕組みを理解。

#### Step 2: エントリーポイントを理解する

Language Clientの初期化。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | htmlClientMain.ts | `extensions/html-language-features/client/src/node/htmlClientMain.ts` | Node.js版エントリーポイント |

**主要処理フロー**:
1. `startClient()`でLanguage Client初期化
2. `LanguageParticipants`で対応言語を管理
3. カスタムデータの読み込み

#### Step 3: 自動挿入を理解する

閉じタグの自動挿入処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | autoInsertion.ts | `extensions/html-language-features/client/src/autoInsertion.ts` | 自動挿入実装 |

**主要処理フロー**:
- `AutoInsertRequest`でサーバーに自動挿入クエリ
- 閉じタグ（autoClose）と引用符（autoQuote）の自動挿入

#### Step 4: カスタムデータを理解する

HTML要素/属性の拡張。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | customData.ts | `extensions/html-language-features/client/src/customData.ts` | カスタムデータ管理 |

### プログラム呼び出し階層図

```
htmlClientMain.ts (activate)
    │
    └─ startClient()
           │
           ├─ LanguageClient (LSP通信)
           │      └─ HTML Language Server
           │
           ├─ LanguageParticipants (対応言語管理)
           │
           ├─ CustomDataSource (カスタムデータ)
           │
           └─ AutoInsertion (自動挿入)
```

### データフロー図

```
[エディタ]              [クライアント]               [Language Server]

タグ入力 ─────────▶ completion ──────────▶ タグ/属性補完
                          │
>入力 ───────────▶ AutoInsertRequest ────▶ 閉じタグ計算
                          │
                    ◀──────────────── 挿入テキスト
                          │
フォーマット要求 ──▶ formatting ─────────▶ HTMLフォーマット
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| htmlClient.ts | `extensions/html-language-features/client/src/htmlClient.ts` | ソース | メインクライアント |
| htmlClientMain.ts | `extensions/html-language-features/client/src/node/htmlClientMain.ts` | ソース | Node.jsエントリー |
| autoInsertion.ts | `extensions/html-language-features/client/src/autoInsertion.ts` | ソース | 自動挿入 |
| customData.ts | `extensions/html-language-features/client/src/customData.ts` | ソース | カスタムデータ |
| languageParticipants.ts | `extensions/html-language-features/client/src/languageParticipants.ts` | ソース | 言語参加者 |
