# 機能設計書 70-CSS

## 概要

本ドキュメントは、Visual Studio CodeにおけるCSS言語サポート拡張機能の設計仕様を記載する。本機能は組み込み拡張機能として、CSS Language Serverとの連携を通じてCSS/SCSS/Less編集の支援機能を提供する。

### 本機能の処理概要

CSS言語サポートは、Language Server Protocol（LSP）準拠のCSS Language Serverをバックエンドとして使用し、プロパティ補完、値補完、カラープレビュー、検証等の機能を提供する。

**業務上の目的・背景**：CSSはWebアプリケーションのスタイリングに不可欠であり、プロパティや値の補完、カラーピッカー、セレクタ検証等の機能により効率的なスタイルシート開発を支援する。また、SCSS/Lessなどのプリプロセッサも同様にサポートする。

**機能の利用シーン**：開発者がCSS/SCSS/Lessファイルを編集する際、プロパティ補完、値補完、カラーピッカー、フォールディング、定義へ移動（セレクタ）等の機能が利用される。

**主要な処理内容**：
1. CSS Language Serverの起動と管理
2. プロパティと値のコード補完
3. カラープレビューとカラーピッカー
4. CSSセレクタ検証
5. フォーマット機能
6. 折りたたみリージョン
7. カスタムデータ拡張

**関連システム・外部連携**：CSS Language Server、SCSS/Lessパーサー

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | エディタエリア | 主画面 | コード補完、カラープレビュー、フォーマット等 |

## 機能種別

言語サポート / IntelliSense / フォーマット

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | TextDocument | Yes | 対象ドキュメント | .css/.scss/.less等 |
| position | Position | Yes | カーソル位置 | 有効な位置 |

### 入力データソース

- ソースファイル（.css, .scss, .less等）
- カスタムデータファイル
- ユーザー設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CompletionItem[] | array | 補完候補（プロパティ、値） |
| ColorInformation[] | array | カラー情報 |
| FoldingRange[] | array | 折りたたみ範囲 |
| Diagnostic[] | array | 検証エラー |

### 出力先

- エディタUI（補完リスト、カラーデコレーション）
- フォーマット結果

## 処理フロー

### 処理シーケンス

```
1. 拡張機能アクティベーション
   └─ CSS/SCSS/Lessファイルオープン時にアクティベート

2. Language Server起動
   └─ CSS Language Serverプロセスを起動

3. カスタムデータ読み込み
   └─ css.customDataで指定されたデータを読み込み

4. 言語機能要求
   └─ 補完、フォーマット、カラー等の要求をサーバーに送信

5. 結果表示
   └─ サーバー応答をUIに反映
```

### フローチャート

```mermaid
flowchart TD
    A[CSSファイルオープン] --> B[拡張機能アクティベート]
    B --> C[Language Server起動]
    C --> D[カスタムデータ読み込み]
    D --> E{ユーザー操作}
    E -->|プロパティ入力| F[プロパティ補完]
    E -->|値入力| G[値補完]
    E -->|カラー値| H[カラープレビュー]
    E -->|フォーマット| I[CSSフォーマット]
    F --> J[UI表示]
    G --> J
    H --> K[カラーデコレーション]
    I --> J
    K --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-70-01 | フォーマット | css/scss/less.format.enableでフォーマット機能の有効/無効を制御 | フォーマット要求時 |
| BR-70-02 | 検証 | css/scss/less.validate.enableで検証機能の有効/無効を制御 | ファイル保存/編集時 |
| BR-70-03 | カスタムデータ | css.customDataで追加のプロパティ/値を定義可能 | 補完時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ServerCrash | プロセスエラー | Language Serverクラッシュ | 自動再起動 |
| ValidationError | 検証エラー | CSS構文エラー | スタイルの修正 |
| CustomDataError | データエラー | カスタムデータのパースエラー | データファイルの修正 |

### リトライ仕様

Language Serverクラッシュ時、自動再起動を試行

## トランザクション仕様

該当なし

## パフォーマンス要件

- 補完候補取得: 150ms以内
- カラープレビュー: 即時
- フォーマット: ドキュメントサイズに依存

## セキュリティ考慮事項

- 特になし

## 備考

CSS/SCSS/Lessは同じLanguage Serverで処理され、言語固有の設定（フォーマットオプション等）は各言語で個別に設定可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

拡張機能の構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cssClient.ts | `extensions/css-language-features/client/src/cssClient.ts` | クライアント実装 |

**読解のコツ**: `CSSFormatSettings`でフォーマットオプションを理解。`documentSelector`で対応言語を確認。

#### Step 2: エントリーポイントを理解する

Language Clientの初期化。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cssClientMain.ts | `extensions/css-language-features/client/src/node/cssClientMain.ts` | Node.js版エントリーポイント |

**主要処理フロー**:
1. `startClient()`でLanguage Client初期化
2. カスタムデータの読み込み
3. フォーマッタの条件付き登録

#### Step 3: フォーマット設定を理解する

言語別のフォーマット設定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cssClient.ts | `extensions/css-language-features/client/src/cssClient.ts` | フォーマット設定処理 |

**主要処理フロー**:
- `formatterRegistrations`で言語別フォーマッタ管理
- `CSSFormatSettings`でフォーマットオプション
- 設定変更時の動的再登録

#### Step 4: カスタムデータを理解する

CSS要素の拡張。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | customData.ts | `extensions/css-language-features/client/src/customData.ts` | カスタムデータ管理 |

### プログラム呼び出し階層図

```
cssClientMain.ts (activate)
    │
    └─ startClient()
           │
           ├─ LanguageClient (LSP通信)
           │      └─ CSS Language Server
           │
           ├─ CustomDataSource (カスタムデータ)
           │
           ├─ FormatterRegistration (フォーマッタ管理)
           │      ├─ css
           │      ├─ scss
           │      └─ less
           │
           └─ RegionCompletionProvider (リージョン補完)
```

### データフロー図

```
[エディタ]              [クライアント]               [Language Server]

プロパティ入力 ────▶ completion ──────────▶ プロパティ/値補完
                          │
カラー値 ──────────▶ documentColor ────────▶ カラー情報抽出
                          │
                    ◀──────────────── ColorInformation[]
                          │
フォーマット要求 ──▶ formatting ─────────▶ CSSフォーマット
                          │
                    ◀──────────────── TextEdit[]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cssClient.ts | `extensions/css-language-features/client/src/cssClient.ts` | ソース | メインクライアント |
| cssClientMain.ts | `extensions/css-language-features/client/src/node/cssClientMain.ts` | ソース | Node.jsエントリー |
| customData.ts | `extensions/css-language-features/client/src/customData.ts` | ソース | カスタムデータ |
| requests.ts | `extensions/css-language-features/client/src/requests.ts` | ソース | リクエスト定義 |
| dropOrPasteResource.ts | `extensions/css-language-features/client/src/dropOrPaste/dropOrPasteResource.ts` | ソース | ドロップ&ペースト |
