# 機能設計書 72-PHP

## 概要

本ドキュメントは、VS Codeの組み込み拡張機能「php-language-features」が提供するPHP言語機能の設計を記述する。

### 本機能の処理概要

PHPファイルの編集時に基本的な言語機能（コード補完、ホバー情報、シグネチャヘルプ、構文検証）を提供し、PHP開発の生産性を向上させる機能である。

**業務上の目的・背景**：PHPはWebアプリケーション開発で広く使用されるスクリプト言語である。開発者がPHPコードを効率的に記述できるよう、グローバル関数・変数の補完、関数シグネチャの表示、構文エラーの検出といった基本的な言語支援を提供する。より高度な機能は別途PHP Language Server拡張機能で提供される。

**機能の利用シーン**：
- PHPファイルを新規作成・編集する場面
- PHPの組み込み関数やグローバル変数を使用する場面
- 関数の引数を確認したい場面
- PHPコードの構文エラーを早期に検出したい場面

**主要な処理内容**：
1. PHPグローバル関数・変数・定数のコード補完
2. ドキュメント内で定義されたユーザー関数・変数の補完
3. 関数のホバー情報（説明、シグネチャ）表示
4. 関数呼び出し時のシグネチャヘルプ
5. PHP実行ファイルによる構文検証（php -l）

**関連システム・外部連携**：
- PHP実行ファイル（構文検証用、外部プロセス呼び出し）

**権限による制御**：特になし。すべてのユーザーが利用可能。ただし、構文検証にはPHPがシステムにインストールされている必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | テキストエディタ | 主画面 | PHPファイルの編集、補完、ホバー表示 |
| 30 | 問題ビュー | 結果表示画面 | 構文エラーの表示 |

## 機能種別

言語サービス / コード補完 / 診断

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | TextDocument | Yes | 編集中のPHPドキュメント | 言語ID = 'php' |
| position | Position | Yes | カーソル位置 | ドキュメント範囲内 |
| triggerCharacter | string | No | 補完トリガー文字 | '>'または'$' |

### 入力データソース

- エディタで開いているPHPファイル
- 組み込みPHPグローバル定義（phpGlobalFunctions.ts, phpGlobals.ts）
- PHP実行ファイル（構文検証時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CompletionItem[] | array | 補完候補リスト（関数、変数、定数、キーワード） |
| Hover | object | ホバー情報（説明、シグネチャ） |
| SignatureHelp | object | シグネチャヘルプ（パラメータ情報） |
| Diagnostic[] | array | 構文検証結果（エラー、警告） |

### 出力先

- エディタ（補完候補、ホバー情報、シグネチャヘルプ）
- 問題パネル（診断結果）

## 処理フロー

### 処理シーケンス

```
1. 拡張機能のアクティベーション
   └─ プロバイダーの登録（補完、ホバー、シグネチャヘルプ、検証）
2. コード補完要求（'>'または'$'入力時）
   └─ グローバル定義とドキュメント内定義から候補を収集
3. ホバー情報要求
   └─ カーソル位置のシンボルに対応する情報を返却
4. シグネチャヘルプ要求（'('または','入力時）
   └─ 関数のパラメータ情報を返却
5. ドキュメント保存時の構文検証
   └─ php -lコマンドを実行して結果を診断情報に変換
```

### フローチャート

```mermaid
flowchart TD
    A[PHPファイルを開く] --> B[プロバイダー登録済み]
    B --> C{ユーザー操作}
    C -->|'>'または'$'入力| D[補完候補提供]
    C -->|ホバー| E[ホバー情報提供]
    C -->|'('または','入力| F[シグネチャヘルプ提供]
    C -->|ファイル保存| G[構文検証実行]
    D --> H[候補リスト表示]
    E --> I[ツールチップ表示]
    F --> J[パラメータヒント表示]
    G --> K[診断情報更新]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-72-01 | アロー演算子補完 | '->'入力時のみ補完候補を提示 | triggerCharacter = '>' かつ直前が'->' |
| BR-72-02 | 変数補完 | '$'で始まる入力時にドキュメント内変数を補完 | prefix[0] = '$' |
| BR-72-03 | 構文検証設定 | php.validate.enableが有効な場合のみ検証実行 | 設定値 = true |
| BR-72-04 | 基本補完設定 | php.suggest.basicが有効な場合のみ補完提供 | 設定値 = true |

### 計算ロジック

- 変数抽出: 正規表現 `/\$([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)/g` でドキュメント内変数を検出
- 関数抽出: 正規表現 `/function\s+([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)\s*\(/g` でユーザー定義関数を検出

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | PHPNotFound | PHP実行ファイルが見つからない | 警告メッセージ表示、検証スキップ |
| - | ValidationTimeout | 検証タイムアウト | 検証スキップ |
| - | ParseError | PHP構文エラー | 診断情報として問題パネルに表示 |

### リトライ仕様

構文検証は各保存時に再実行される。タイムアウト時は次回保存時に再試行。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- 補完候補の応答は200ms以内を目標
- 構文検証は非同期実行でエディタをブロックしない

## セキュリティ考慮事項

- PHP実行ファイルパスはユーザー設定で指定
- 外部プロセス実行時はコマンドインジェクション対策が必要

## 備考

- 本拡張機能は基本的な言語機能のみを提供
- 高度な機能（定義へ移動、参照検索等）はPHP Intelephense等の拡張機能で提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

PHPの組み込み関数・変数・定数の定義データを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | phpGlobals.ts | `extensions/php-language-features/src/features/phpGlobals.ts` | グローバル変数、定数、キーワードの定義 |
| 1-2 | phpGlobalFunctions.ts | `extensions/php-language-features/src/features/phpGlobalFunctions.ts` | グローバル関数の定義（シグネチャ、説明） |

**読解のコツ**: IEntryインターフェースでdescriptionとsignatureが定義され、各グローバル要素に適用されている。

#### Step 2: エントリーポイントを理解する

拡張機能のアクティベーション処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | phpMain.ts | `extensions/php-language-features/src/phpMain.ts` | activate関数がエントリーポイント |

**主要処理フロー**:
1. **13-22行目**: activate関数で各プロバイダーを登録
2. **15-16行目**: PHPValidationProviderをアクティベート
3. **19行目**: CompletionItemProviderを登録（トリガー: '>', '$'）
4. **20行目**: HoverProviderを登録
5. **21行目**: SignatureHelpProviderを登録（トリガー: '(', ','）

#### Step 3: コード補完プロバイダーを理解する

補完候補の生成ロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | completionItemProvider.ts | `extensions/php-language-features/src/features/completionItemProvider.ts` | PHPCompletionItemProviderクラス |

**主要処理フロー**:
- **12-18行目**: provideCompletionItemsメソッドでphp.suggest.basic設定を確認
- **26-32行目**: '->'演算子の判定ロジック
- **35-47行目**: createNewProposal関数で補完アイテムを生成
- **66-89行目**: グローバル変数・関数・定数・キーワードの候補収集
- **91-111行目**: ドキュメント内の変数・関数を正規表現で抽出

#### Step 4: 構文検証プロバイダーを理解する

PHP実行ファイルを使用した構文検証処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | validationProvider.ts | `extensions/php-language-features/src/features/validationProvider.ts` | PHPValidationProviderクラス |

**主要処理フロー**:
- activateメソッドでドキュメント保存イベントをサブスクライブ
- php -lコマンドを実行して構文チェック
- 出力を解析してDiagnosticオブジェクトに変換

### プログラム呼び出し階層図

```
activate (phpMain.ts)
    │
    ├─ PHPValidationProvider (validationProvider.ts)
    │      └─ php -l コマンド実行 → 診断情報
    │
    ├─ PHPCompletionItemProvider (completionItemProvider.ts)
    │      ├─ phpGlobals → グローバル変数・定数・キーワード
    │      ├─ phpGlobalFunctions → グローバル関数
    │      └─ 正規表現抽出 → ユーザー定義変数・関数
    │
    ├─ PHPHoverProvider (hoverProvider.ts)
    │      └─ phpGlobals/phpGlobalFunctions → ホバー情報
    │
    └─ PHPSignatureHelpProvider (signatureHelpProvider.ts)
           └─ phpGlobalFunctions → シグネチャ情報
```

### データフロー図

```
[入力]                    [処理]                         [出力]

PHPソースコード ─────▶ CompletionItemProvider ────▶ 補完候補リスト
     │
     │                 ┌──────────────────────┐
     ├─────────────────▶ HoverProvider ────────▶ ホバー情報
     │                 └──────────────────────┘
     │
     │                 ┌──────────────────────┐
     ├─────────────────▶ SignatureHelpProvider ▶ シグネチャヘルプ
     │                 └──────────────────────┘
     │
     │                 ┌──────────────────────┐
     └─────────────────▶ ValidationProvider ───▶ 診断情報
                       │     │
                       │     └─▶ php -l（外部プロセス）
                       └──────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| phpMain.ts | `extensions/php-language-features/src/phpMain.ts` | ソース | 拡張機能エントリーポイント |
| completionItemProvider.ts | `extensions/php-language-features/src/features/completionItemProvider.ts` | ソース | コード補完プロバイダー |
| hoverProvider.ts | `extensions/php-language-features/src/features/hoverProvider.ts` | ソース | ホバー情報プロバイダー |
| signatureHelpProvider.ts | `extensions/php-language-features/src/features/signatureHelpProvider.ts` | ソース | シグネチャヘルププロバイダー |
| validationProvider.ts | `extensions/php-language-features/src/features/validationProvider.ts` | ソース | 構文検証プロバイダー |
| phpGlobals.ts | `extensions/php-language-features/src/features/phpGlobals.ts` | データ | PHPグローバル変数・定数・キーワード定義 |
| phpGlobalFunctions.ts | `extensions/php-language-features/src/features/phpGlobalFunctions.ts` | データ | PHPグローバル関数定義 |
| package.json | `extensions/php-language-features/package.json` | 設定 | 拡張機能マニフェスト |
