# 機能設計書 74-Git統合

## 概要

本ドキュメントは、VS Codeの組み込み拡張機能「git」が提供するGit統合機能の設計を記述する。

### 本機能の処理概要

Gitリポジトリの操作（コミット、プッシュ、プル、ブランチ管理等）をVS Code内で統合的に行える機能を提供し、バージョン管理の生産性を向上させる。

**業務上の目的・背景**：ソフトウェア開発においてバージョン管理は必須であり、Gitは最も広く使用されるツールである。コマンドラインを使用せずにGit操作をエディタ内で完結させることで、開発ワークフローの効率を大幅に向上させる。変更ファイルの可視化、差分確認、コミット履歴の参照など、日常的なGit操作をシームレスに行える環境を提供する。

**機能の利用シーン**：
- コード変更をステージング・コミットする場面
- リモートリポジトリとの同期（プッシュ/プル/フェッチ）を行う場面
- ブランチの作成・切り替え・マージを行う場面
- ファイルの変更履歴やdiffを確認する場面
- コンフリクトの解決を行う場面
- スタッシュの作成・適用を行う場面

**主要な処理内容**：
1. リポジトリの検出と初期化
2. ファイルの変更状態（ステータス）の監視と表示
3. ステージング/アンステージング操作
4. コミットの作成とメッセージ入力
5. リモートリポジトリとのプッシュ/プル/フェッチ
6. ブランチの作成・切り替え・削除・マージ
7. diff表示とインラインblame表示
8. タイムライン（履歴）表示
9. Gitファイルシステムプロバイダー（過去バージョンの参照）
10. 認証情報の管理（askpass）

**関連システム・外部連携**：
- Git実行ファイル（外部プロセス呼び出し）
- SSHキー/認証情報管理

**権限による制御**：ワークスペース信頼モードにより、信頼されていないフォルダではGit機能が制限される場合がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | ソース管理ビュー | 主画面 | 変更ファイル一覧、ステージング、コミット |
| 26 | タイムラインビュー | 参照画面 | ファイルのGit履歴表示 |
| 42 | SCM履歴ビュー | 参照画面 | コミットグラフ表示 |
| 12 | 差分エディタ | 参照画面 | ファイル差分の表示 |

## 機能種別

バージョン管理 / ファイル監視 / 外部プロセス連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| repositoryPath | string | Yes | リポジトリのルートパス | .gitディレクトリが存在 |
| commitMessage | string | No | コミットメッセージ | コミット時に必須 |
| branchName | string | No | ブランチ名 | ブランチ作成/切り替え時 |
| remoteName | string | No | リモート名 | プッシュ/プル時（デフォルト: origin） |

### 入力データソース

- ワークスペース内の.gitディレクトリ
- ユーザー入力（コミットメッセージ、ブランチ名等）
- Git設定ファイル（.gitconfig、.gitignore等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Repository | object | リポジトリ状態（HEAD、ブランチ、リモート等） |
| Resource[] | array | 変更ファイルリスト（ステータス別） |
| Commit[] | array | コミット履歴 |
| Branch[] | array | ブランチリスト |

### 出力先

- ソース管理ビュー（変更ファイル、ステージング状態）
- ステータスバー（ブランチ名、同期状態）
- タイムラインビュー（履歴）
- エディタデコレーション（blame情報）

## 処理フロー

### 処理シーケンス

```
1. 拡張機能のアクティベーション
   └─ Gitインストール確認、モデル初期化
2. リポジトリの検出
   └─ ワークスペースフォルダ内の.gitディレクトリを検索
3. リポジトリの監視開始
   └─ ファイルシステムウォッチャーによる変更監視
4. ステータス更新
   └─ git statusコマンドで変更ファイルを取得
5. ユーザー操作の実行
   └─ 各種Gitコマンドをバックグラウンドで実行
6. UIの更新
   └─ 操作結果をソース管理ビュー等に反映
```

### フローチャート

```mermaid
flowchart TD
    A[拡張機能アクティベート] --> B{Git検出}
    B -->|見つからない| C[警告表示]
    B -->|見つかった| D[モデル初期化]
    D --> E[リポジトリ検出]
    E --> F[ファイル監視開始]
    F --> G[ステータス取得]
    G --> H[UI更新]
    H --> I{ユーザー操作}
    I -->|ステージ| J[git add]
    I -->|コミット| K[git commit]
    I -->|プッシュ| L[git push]
    I -->|プル| M[git pull]
    J --> G
    K --> G
    L --> G
    M --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-74-01 | 自動リフレッシュ | ファイル変更時に自動でステータス更新 | git.autorefresh = true |
| BR-74-02 | 自動フェッチ | 定期的にリモートからフェッチ | git.autofetch = true |
| BR-74-03 | ブランチ保護 | 保護ブランチへの直接コミットを警告 | branchProtection設定 |
| BR-74-04 | コミットメッセージ検証 | 空メッセージや長すぎるメッセージを警告 | git.inputValidation設定 |

### 計算ロジック

- リポジトリ検出: scanDepthに基づいてワークスペースを再帰的に検索
- ステータス分類: git statusの出力をIndex（ステージ済み）、WorkingTree（未ステージ）、Merge（コンフリクト）に分類

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない（Gitの内部データストアを使用）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| GitNotFound | 初期化エラー | Gitがインストールされていない | ダウンロードリンク付き警告表示 |
| AuthenticationFailed | 認証エラー | リモートへの認証失敗 | 認証情報の再入力を促す |
| MergeConflict | コンフリクト | マージ/プル時のコンフリクト | コンフリクトマーカー表示、解決を促す |
| PushRejected | プッシュエラー | リモートが先に進んでいる | プル後の再プッシュを促す |

### リトライ仕様

- ネットワークエラー時は自動リトライなし（ユーザー再実行）
- 認証エラー時はaskpassダイアログを再表示

## トランザクション仕様

Gitの内部トランザクション管理に依存。コミット等のアトミック性はGitが保証。

## パフォーマンス要件

- ステータス更新はdebounce処理（既定5000ms）
- 大規模リポジトリでは部分的なステータス取得
- バックグラウンド操作でUIをブロックしない

## セキュリティ考慮事項

- askpassによる認証情報の安全な受け渡し
- 認証情報はメモリ内のみで保持
- SSH鍵のパスフレーズ入力対応

## 備考

- Git 2.0以上を推奨（一部機能は2.35以上が必要）
- サブモジュール、ワークツリーにも対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Gitリポジトリとリソースの内部表現を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | api/git.d.ts | `extensions/git/src/api/git.d.ts` | API型定義（Repository、Branch、Commit等） |
| 1-2 | repository.ts | `extensions/git/src/repository.ts` | Resourceクラス、RepositoryState |

**読解のコツ**: Status enumで変更状態（INDEX_MODIFIED、MODIFIED等）を把握し、ResourceGroupTypeでステージング分類を理解する。

#### Step 2: エントリーポイントを理解する

拡張機能のアクティベーションとモデル初期化を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.ts | `extensions/git/src/main.ts` | activate関数、createModel関数 |

**主要処理フロー**:
1. **40-140行目**: createModel関数でGit検出、モデル初期化
2. **52-64行目**: findGitでGit実行ファイルを検索
3. **86-92行目**: Gitインスタンス作成、Modelインスタンス作成
4. **113-122行目**: 各種プロバイダー（FileSystem、Decorations、Timeline等）の登録
5. **256-262行目**: activate関数でGitExtensionを返却

#### Step 3: Modelを理解する

リポジトリの検出と管理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | model.ts | `extensions/git/src/model.ts` | Modelクラス |

**主要処理フロー**:
- openRepositoryメソッドでリポジトリを開く
- scanSubfoldersメソッドでサブフォルダを検索
- リポジトリのライフサイクル管理（open/close）

#### Step 4: Repositoryを理解する

個別リポジトリの状態管理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | repository.ts | `extensions/git/src/repository.ts` | Repositoryクラス |

**主要処理フロー**:
- **40-50行目**: RepositoryState、ResourceGroupType定義
- **52-200行目**: Resourceクラス（変更ファイルの表現）
- statusメソッドでgit status実行
- commit、push、pull等の操作メソッド

#### Step 5: コマンドを理解する

ユーザー操作に対応するコマンド実装を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | commands.ts | `extensions/git/src/commands.ts` | CommandCenterクラス |

**主要処理フロー**:
- 各Git操作に対応するコマンドメソッド
- ユーザーインタラクション（Quick Pick等）の実装

### プログラム呼び出し階層図

```
activate (main.ts)
    │
    ├─ findGit → Git実行ファイル検索
    │
    ├─ createModel
    │      └─ Model (model.ts)
    │             ├─ openRepository
    │             │      └─ Repository (repository.ts)
    │             │             ├─ status → git status
    │             │             ├─ commit → git commit
    │             │             ├─ push → git push
    │             │             └─ ...
    │             └─ scanSubfolders
    │
    ├─ CommandCenter (commands.ts)
    │      └─ 各種Gitコマンド
    │
    ├─ GitFileSystemProvider (fileSystemProvider.ts)
    │      └─ 過去バージョンファイル参照
    │
    ├─ GitDecorations (decorationProvider.ts)
    │      └─ ファイルデコレーション
    │
    └─ GitTimelineProvider (timelineProvider.ts)
           └─ 履歴タイムライン
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ワークスペース ─────────▶ Model.openRepository ────────▶ Repository
     │                                                      │
     │                                                      ▼
ユーザー操作 ──────────▶ CommandCenter ────────────────▶ Git CLI
     │                       │                              │
     │                       ▼                              ▼
     │               Repository.status ◀──────────────── git status
     │                       │
     │                       ▼
     └─────────────▶ SourceControl ─────────────────▶ ソース管理ビュー
                            │
                            ▼
                     StatusBar ──────────────────────▶ ステータスバー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.ts | `extensions/git/src/main.ts` | ソース | 拡張機能エントリーポイント |
| model.ts | `extensions/git/src/model.ts` | ソース | リポジトリ管理モデル |
| repository.ts | `extensions/git/src/repository.ts` | ソース | 個別リポジトリ実装 |
| commands.ts | `extensions/git/src/commands.ts` | ソース | コマンド実装 |
| git.ts | `extensions/git/src/git.ts` | ソース | Git CLI ラッパー |
| fileSystemProvider.ts | `extensions/git/src/fileSystemProvider.ts` | ソース | Gitファイルシステム |
| decorationProvider.ts | `extensions/git/src/decorationProvider.ts` | ソース | ファイルデコレーション |
| timelineProvider.ts | `extensions/git/src/timelineProvider.ts` | ソース | タイムラインプロバイダー |
| historyProvider.ts | `extensions/git/src/historyProvider.ts` | ソース | 履歴プロバイダー |
| askpass.ts | `extensions/git/src/askpass.ts` | ソース | 認証情報管理 |
| statusbar.ts | `extensions/git/src/statusbar.ts` | ソース | ステータスバー表示 |
| blame.ts | `extensions/git/src/blame.ts` | ソース | Blame情報表示 |
| api/git.d.ts | `extensions/git/src/api/git.d.ts` | 型定義 | 公開API型定義 |
| package.json | `extensions/git/package.json` | 設定 | 拡張機能マニフェスト |
