# 機能設計書 75-GitHub統合

## 概要

本ドキュメントは、VS Codeの組み込み拡張機能「github」が提供するGitHub連携機能の設計を記述する。

### 本機能の処理概要

GitHubリポジトリとの連携機能を提供し、リポジトリの公開、認証情報管理、ブランチ保護、プッシュエラーハンドリング等を行う機能である。

**業務上の目的・背景**：GitHubは世界最大のコードホスティングプラットフォームであり、多くの開発プロジェクトで使用されている。VS CodeからGitHubへのシームレスな連携を提供することで、リポジトリの作成・公開、プルリクエストの作成、コード共有等の操作を効率化する。

**機能の利用シーン**：
- ローカルリポジトリをGitHubに公開する場面
- GitHubリポジトリをクローンする場面
- ブランチ保護ルールに基づく操作制限が必要な場面
- GitHub上のコードをvscode.devで開く場面
- コミット履歴の詳細をGitHubから取得する場面

**主要な処理内容**：
1. GitHubリモートソースプロバイダー（リポジトリ検索・クローン）
2. GitHubリモートソースパブリッシャー（リポジトリ公開）
3. GitHub認証情報プロバイダー
4. ブランチ保護プロバイダー
5. プッシュエラーハンドラー（フォーク提案等）
6. 履歴アイテム詳細プロバイダー（PR/コミット情報）
7. Canonical URIプロバイダー
8. vscode.dev共有プロバイダー

**関連システム・外部連携**：
- GitHub API（REST/GraphQL）
- GitHub認証（OAuth）
- vscode.git拡張機能

**権限による制御**：GitHub認証トークンのスコープに基づいて、利用可能な機能が制限される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | ソース管理ビュー | 主画面 | GitHubリポジトリ操作 |
| 42 | SCM履歴ビュー | 参照画面 | コミット履歴からGitHub PR情報表示 |
| 47 | コマンドパレット | 操作画面 | GitHubコマンドの実行 |

## 機能種別

外部サービス連携 / 認証管理 / リポジトリ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| repository | Repository | Yes | Git拡張機能のリポジトリオブジェクト | GitHubリモートが設定済み |
| accessToken | string | Yes | GitHub認証トークン | github-authentication経由で取得 |
| repoName | string | No | 公開時のリポジトリ名 | 有効なGitHubリポジトリ名 |
| isPrivate | boolean | No | プライベートリポジトリフラグ | 公開時に指定 |

### 入力データソース

- vscode.git拡張機能のAPI
- github-authentication拡張機能（認証トークン）
- GitHub API（リポジトリ情報、ブランチ保護ルール等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| RemoteSource | object | クローン可能なリポジトリ情報 |
| BranchProtection | object | ブランチ保護ルール |
| HistoryItemDetails | object | コミット/PR詳細情報 |

### 出力先

- ソース管理ビュー（リポジトリ状態）
- Quick Pick（リポジトリ選択）
- 通知（エラー、操作結果）

## 処理フロー

### 処理シーケンス

```
1. 拡張機能のアクティベーション
   └─ Git拡張機能APIの取得、プロバイダー登録
2. リポジトリのGitHubリモート検出
   └─ リモートURLからGitHubリポジトリを識別
3. 認証トークンの取得
   └─ github-authentication経由でOAuthトークン取得
4. GitHub APIとの連携
   └─ Octokit経由でAPI呼び出し
5. 各種操作の実行
   └─ 公開、クローン、ブランチ保護確認等
```

### フローチャート

```mermaid
flowchart TD
    A[拡張機能アクティベート] --> B{Git拡張機能有効?}
    B -->|No| C[無効化]
    B -->|Yes| D[プロバイダー登録]
    D --> E[GitHubリモート検出]
    E --> F{GitHubリポジトリ?}
    F -->|No| G[GitHub機能無効]
    F -->|Yes| H[認証トークン取得]
    H --> I[GitHub API連携]
    I --> J[ブランチ保護確認]
    I --> K[履歴詳細取得]
    I --> L[リポジトリ公開]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-75-01 | リモート検出 | github.comまたはghe.comのリモートを検出 | リモートURL解析時 |
| BR-75-02 | 認証スコープ | repo, user, workflowスコープを要求 | 公開/ブランチ保護時 |
| BR-75-03 | フォーク提案 | 書き込み権限がない場合にフォークを提案 | プッシュエラー時 |

### 計算ロジック

- GitHubリモート判定: URL内にgithub.comまたは設定されたGHEホストが含まれるか
- 認証トークン取得: VSCode認証APIを使用してOAuthフローを実行

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない（GitHub APIを使用）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | 認証エラー | トークン無効/期限切れ | 再認証を促す |
| 403 | 権限エラー | スコープ不足/アクセス禁止 | 必要な権限を説明 |
| 404 | NotFound | リポジトリが存在しない | エラーメッセージ表示 |
| 422 | Validation | リポジトリ名重複等 | 具体的なエラー内容を表示 |

### リトライ仕様

- APIレート制限時は待機後に自動リトライ
- 認証エラー時は再認証フロー開始

## トランザクション仕様

該当なし（GitHub APIの操作はアトミック）。

## パフォーマンス要件

- API呼び出しはキャッシュを活用
- ブランチ保護ルールはリポジトリ単位でキャッシュ

## セキュリティ考慮事項

- 認証トークンはVSCodeのシークレットストレージに保存
- トークンスコープは最小権限の原則に従う
- Enterprise Server設定は信頼されたURLのみ許可

## 備考

- GitHub Enterprise Serverにも対応
- vscode.dev共有機能でブラウザでのコード閲覧が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Git拡張機能との連携で使用する型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | typings/git.d.ts | `extensions/github/src/typings/git.d.ts` | Git API型定義 |
| 1-2 | typings/git-base.d.ts | `extensions/github/src/typings/git-base.d.ts` | Git Base API型定義 |

**読解のコツ**: RemoteSource、RemoteSourcePublisher等のインターフェースを把握する。

#### Step 2: エントリーポイントを理解する

拡張機能のアクティベーションと各プロバイダーの登録を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extension.ts | `extensions/github/src/extension.ts` | activate関数 |

**主要処理フロー**:
1. **22-44行目**: activate関数でロガー、テレメトリ、Octokitサービスを初期化
2. **42-43行目**: Git Base拡張機能とGit拡張機能の初期化を呼び出し
3. **46-74行目**: initializeGitBaseExtensionでリモートソースプロバイダー登録
4. **91-138行目**: initializeGitExtensionで各種プロバイダーを登録

#### Step 3: リモートソースプロバイダーを理解する

GitHubリポジトリの検索・クローン機能を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | remoteSourceProvider.ts | `extensions/github/src/remoteSourceProvider.ts` | GithubRemoteSourceProviderクラス |

**主要処理フロー**:
- getRemoteSourcesメソッドでGitHubリポジトリを検索
- GitHub APIを使用してユーザーのリポジトリ一覧を取得

#### Step 4: リモートソースパブリッシャーを理解する

ローカルリポジトリのGitHub公開機能を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | remoteSourcePublisher.ts | `extensions/github/src/remoteSourcePublisher.ts` | GithubRemoteSourcePublisherクラス |

**主要処理フロー**:
- publishRepositoryメソッドでリポジトリを作成・公開
- プライベート/パブリック選択、リポジトリ名入力

#### Step 5: プッシュエラーハンドラーを理解する

プッシュ失敗時のフォーク提案等を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | pushErrorHandler.ts | `extensions/github/src/pushErrorHandler.ts` | GithubPushErrorHandlerクラス |

**主要処理フロー**:
- handlePushErrorメソッドでエラー種別を判定
- 権限不足時にフォーク作成を提案

### プログラム呼び出し階層図

```
activate (extension.ts)
    │
    ├─ initializeGitBaseExtension
    │      └─ GithubRemoteSourceProvider (remoteSourceProvider.ts)
    │             └─ GitHub API → リポジトリ検索
    │
    └─ initializeGitExtension
           ├─ registerCommands (commands.ts)
           │
           ├─ GithubCredentialProviderManager (credentialProvider.ts)
           │      └─ 認証情報管理
           │
           ├─ GitHubBranchProtectionProviderManager (branchProtection.ts)
           │      └─ ブランチ保護ルール取得
           │
           ├─ GithubPushErrorHandler (pushErrorHandler.ts)
           │      └─ プッシュエラー処理
           │
           ├─ GithubRemoteSourcePublisher (remoteSourcePublisher.ts)
           │      └─ リポジトリ公開
           │
           └─ GitHubSourceControlHistoryItemDetailsProvider
                  └─ コミット/PR詳細取得
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Git Repository ─────────▶ GitHub Remote検出 ───────────▶ GitHub API
     │                                                      │
     │                                                      ▼
認証トークン ──────────▶ OctokitService ────────────────▶ API Response
     │                       │
     │                       ▼
     │               各種Provider ─────────────────────▶ UI更新
     │                       │
     │                       ├─▶ ブランチ保護情報
     │                       ├─▶ 履歴詳細情報
     │                       └─▶ リポジトリ操作結果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extension.ts | `extensions/github/src/extension.ts` | ソース | 拡張機能エントリーポイント |
| remoteSourceProvider.ts | `extensions/github/src/remoteSourceProvider.ts` | ソース | リポジトリ検索プロバイダー |
| remoteSourcePublisher.ts | `extensions/github/src/remoteSourcePublisher.ts` | ソース | リポジトリ公開プロバイダー |
| credentialProvider.ts | `extensions/github/src/credentialProvider.ts` | ソース | 認証情報プロバイダー |
| branchProtection.ts | `extensions/github/src/branchProtection.ts` | ソース | ブランチ保護プロバイダー |
| pushErrorHandler.ts | `extensions/github/src/pushErrorHandler.ts` | ソース | プッシュエラーハンドラー |
| historyItemDetailsProvider.ts | `extensions/github/src/historyItemDetailsProvider.ts` | ソース | 履歴詳細プロバイダー |
| canonicalUriProvider.ts | `extensions/github/src/canonicalUriProvider.ts` | ソース | Canonical URIプロバイダー |
| shareProviders.ts | `extensions/github/src/shareProviders.ts` | ソース | vscode.dev共有プロバイダー |
| auth.ts | `extensions/github/src/auth.ts` | ソース | Octokitサービス |
| commands.ts | `extensions/github/src/commands.ts` | ソース | コマンド登録 |
| util.ts | `extensions/github/src/util.ts` | ソース | ユーティリティ関数 |
| package.json | `extensions/github/package.json` | 設定 | 拡張機能マニフェスト |
