# 機能設計書 76-GitHub認証

## 概要

本ドキュメントは、VS Codeの組み込み拡張機能「github-authentication」が提供するGitHub認証機能の設計を記述する。

### 本機能の処理概要

GitHubおよびGitHub Enterprise Serverへの認証機能を提供し、OAuthフローを通じてアクセストークンを取得・管理する機能である。

**業務上の目的・背景**：VS Codeの各種GitHub連携機能（リポジトリ操作、GitHub Copilot、Pull Request拡張機能等）を利用するためには、GitHubへの認証が必要である。本拡張機能はVSCodeの認証プロバイダーAPIを通じて統一的な認証フローを提供し、複数の拡張機能から安全にGitHub APIにアクセスできるようにする。

**機能の利用シーン**：
- GitHub連携機能を初めて使用する際の認証フロー
- GitHub Copilotの認証
- Pull Request拡張機能の認証
- GitHub Enterprise Serverへの認証
- 複数のGitHubアカウントの管理

**主要な処理内容**：
1. GitHub OAuth認証フローの実行
2. アクセストークンの取得・保存
3. トークンのリフレッシュ
4. 認証セッションの管理（複数アカウント対応）
5. GitHub Enterprise Server認証のサポート
6. 認証状態の変更通知

**関連システム・外部連携**：
- GitHub OAuth API
- GitHub Enterprise Server OAuth API
- VS Code 認証プロバイダーAPI
- VS Code シークレットストレージ

**権限による制御**：要求されるスコープに基づいてアクセス権限が決定される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | コマンドパレット | 操作画面 | GitHub認証コマンドの実行 |
| 50 | アカウントメニュー | 参照画面 | 認証済みアカウントの表示・管理 |

## 機能種別

認証 / セキュリティ / アカウント管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| scopes | string[] | Yes | 要求するOAuthスコープ | 有効なGitHubスコープ |
| account | AuthenticationSessionAccountInformation | No | 特定アカウントの指定 | 既存セッションのアカウント |
| enterpriseUri | string | No | GitHub Enterprise ServerのURL | 有効なURI形式 |

### 入力データソース

- 拡張機能からの認証リクエスト
- ユーザー設定（github-enterprise.uri）
- OAuth コールバック（URIハンドラー経由）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AuthenticationSession | object | 認証セッション（アクセストークン、スコープ、アカウント情報） |
| sessionChangeEvent | event | セッション変更イベント |

### 出力先

- 認証プロバイダーAPI（VSCode内部）
- シークレットストレージ（トークン保存）
- 認証要求元の拡張機能

## 処理フロー

### 処理シーケンス

```
1. 拡張機能のアクティベーション
   └─ 認証プロバイダーの登録
2. 認証リクエスト受信
   └─ 要求スコープと既存セッションの照合
3. OAuth認証フロー
   └─ ブラウザでGitHub認証ページを開く
4. コールバック処理
   └─ URIハンドラーで認証コードを受信
5. トークン取得
   └─ 認証コードをアクセストークンに交換
6. セッション作成
   └─ トークンを保存し、セッションを返却
```

### フローチャート

```mermaid
flowchart TD
    A[認証リクエスト] --> B{既存セッションあり?}
    B -->|Yes| C{スコープ充足?}
    C -->|Yes| D[既存セッション返却]
    C -->|No| E[OAuth認証フロー開始]
    B -->|No| E
    E --> F[ブラウザで認証ページ表示]
    F --> G[ユーザー認証]
    G --> H[コールバックURL呼び出し]
    H --> I[URIハンドラーで受信]
    I --> J[トークン取得]
    J --> K[シークレットストレージに保存]
    K --> L[セッション作成・返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-76-01 | スコープ昇格 | 追加スコープが必要な場合は再認証 | 既存スコープ不足時 |
| BR-76-02 | 複数アカウント | 同一プロバイダーで複数アカウント許可 | supportsMultipleAccounts = true |
| BR-76-03 | Enterprise URI検証 | 設定されたURIを厳密に検証 | GHES使用時 |
| BR-76-04 | Fetch実装切替 | Electron/Node fetchの切り替え対応 | 設定変更時（要リロード） |

### 計算ロジック

- スコープ比較: 要求スコープが既存セッションスコープに包含されるかチェック
- トークン有効性: GitHub APIへのテストリクエストで検証

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない（VSCodeシークレットストレージを使用）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | URINotSet | GHES URI未設定 | NullAuthProvider登録 |
| - | URIInvalid | GHES URIが無効 | エラーメッセージ表示 |
| - | AuthFailed | OAuth認証失敗 | エラー通知、再試行を促す |
| - | TokenExpired | トークン期限切れ | 再認証フロー |

### リトライ仕様

- 認証失敗時はユーザーに再試行を促す
- トークン期限切れは自動検出して再認証

## トランザクション仕様

該当なし。

## パフォーマンス要件

- 認証フローは非同期で実行
- トークンキャッシュにより不要な認証を回避

## セキュリティ考慮事項

- トークンはVSCodeシークレットストレージに暗号化保存
- OAuthフローはPKCEを使用
- Enterprise Server URIは信頼されたもののみ許可

## 備考

- GitHub.com用（github）とEnterprise Server用（github-enterprise）の2つのプロバイダーを登録
- 設定変更（Fetch実装）は再起動が必要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

認証セッションの構造とイベント型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VSCode API | (組み込み) | AuthenticationSession、AuthenticationProvider型 |

**読解のコツ**: VSCodeの認証APIドキュメントで基本的な型を把握する。

#### Step 2: エントリーポイントを理解する

拡張機能のアクティベーションと認証プロバイダーの登録を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extension.ts | `extensions/github-authentication/src/extension.ts` | activate関数 |

**主要処理フロー**:
1. **63-68行目**: activate関数でURIハンドラーを登録
2. **68行目**: GitHubAuthenticationProvider（github.com用）を登録
3. **70-81行目**: GHES設定の監視と再初期化
4. **39-61行目**: initGHES関数でEnterprise Server認証プロバイダーを初期化

#### Step 3: GitHub認証プロバイダーを理解する

OAuthフローと認証セッション管理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | github.ts | `extensions/github-authentication/src/github.ts` | GitHubAuthenticationProviderクラス |

**主要処理フロー**:
- createSessionメソッドでOAuth認証フローを実行
- getSessionsメソッドで既存セッションを取得
- removeSessionメソッドでセッションを削除
- UriEventHandlerでコールバックを受信

#### Step 4: NullAuthProviderを理解する

GHES未設定時のフォールバックプロバイダーを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | extension.ts | `extensions/github-authentication/src/extension.ts` | NullAuthProviderクラス |

**主要処理フロー**:
- **12-37行目**: NullAuthProviderクラス定義
- GHES URI未設定/無効時にエラーメッセージを返す

### プログラム呼び出し階層図

```
activate (extension.ts)
    │
    ├─ UriEventHandler登録
    │      └─ OAuthコールバック受信
    │
    ├─ GitHubAuthenticationProvider (github.ts)
    │      ├─ createSession → OAuth認証
    │      ├─ getSessions → セッション取得
    │      └─ removeSession → セッション削除
    │
    └─ initGHES
           ├─ URI検証
           │      ├─ 未設定 → NullAuthProvider
           │      └─ 無効 → NullAuthProvider
           │
           └─ 有効 → GitHubAuthenticationProvider (GHES用)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

認証リクエスト ─────────▶ GitHubAuthenticationProvider ─▶ AuthenticationSession
     │                       │
     │                       ▼
     │               既存セッション確認
     │                       │
     │              ┌────────┴────────┐
     │              ▼                  ▼
     │        セッションあり      セッションなし
     │              │                  │
     │              ▼                  ▼
     │        スコープ確認        OAuthフロー
     │              │                  │
     │              ▼                  ▼
     └─────▶ セッション返却 ◀──── トークン取得
                                       │
                                       ▼
                              シークレットストレージ保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extension.ts | `extensions/github-authentication/src/extension.ts` | ソース | 拡張機能エントリーポイント |
| github.ts | `extensions/github-authentication/src/github.ts` | ソース | GitHub認証プロバイダー |
| githubServer.ts | `extensions/github-authentication/src/githubServer.ts` | ソース | OAuthサーバー連携（参照） |
| node/authServer.ts | `extensions/github-authentication/src/node/authServer.ts` | ソース | ローカル認証サーバー（参照） |
| common/keychain.ts | `extensions/github-authentication/src/common/keychain.ts` | ソース | トークン保存（参照） |
| package.json | `extensions/github-authentication/package.json` | 設定 | 拡張機能マニフェスト |
