# 機能設計書 77-Microsoft認証

## 概要

本ドキュメントは、VS Codeの組み込み拡張機能「microsoft-authentication」が提供するMicrosoft認証機能の設計を記述する。

### 本機能の処理概要

Microsoftアカウント（個人/組織）への認証機能を提供し、MSAL（Microsoft Authentication Library）を使用してAzure ADとの連携を行う機能である。

**業務上の目的・背景**：VS Codeの各種Microsoft/Azureサービス連携機能（Settings Sync、Azure拡張機能、Microsoft 365連携等）を利用するためには、Microsoftアカウントへの認証が必要である。本拡張機能はMSALライブラリを使用して、OAuth 2.0/OpenID Connect認証フローを実装し、セキュアなトークン管理を提供する。

**機能の利用シーン**：
- Settings Syncで設定を同期する際の認証
- Azure拡張機能でAzureリソースにアクセスする際の認証
- Microsoft Sovereign Cloud（政府機関向けクラウド）への認証
- 複数のMicrosoftアカウントの管理

**主要な処理内容**：
1. Microsoft OAuth認証フローの実行（MSAL使用）
2. アクセストークン/リフレッシュトークンの取得・管理
3. 認証ブローカー連携（Windows/macOS）
4. 認証セッションの管理（複数アカウント対応）
5. Microsoft Sovereign Cloud認証のサポート
6. 認証チャレンジへの対応

**関連システム・外部連携**：
- Azure AD / Microsoft Identity Platform
- MSAL（Microsoft Authentication Library）
- OS認証ブローカー（WAM/Keychain）
- VS Code 認証プロバイダーAPI

**権限による制御**：要求されるスコープに基づいてアクセス権限が決定される。組織ポリシーによる制限も適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | コマンドパレット | 操作画面 | Microsoft認証コマンドの実行 |
| 50 | アカウントメニュー | 参照画面 | 認証済みアカウントの表示・管理 |

## 機能種別

認証 / セキュリティ / アカウント管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| scopes | string[] | Yes | 要求するOAuthスコープ | 有効なMicrosoft Graphスコープ |
| account | AuthenticationSessionAccountInformation | No | 特定アカウントの指定 | 既存セッションのアカウント |
| authorizationServer | Uri | No | 認可サーバーURL | login.microsoftonline.comドメイン |

### 入力データソース

- 拡張機能からの認証リクエスト
- ユーザー設定（microsoft-sovereign-cloud設定）
- 認証ブローカー（OS統合）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AuthenticationSession | object | 認証セッション（アクセストークン、スコープ、アカウント情報） |
| sessionChangeEvent | event | セッション変更イベント |

### 出力先

- 認証プロバイダーAPI（VSCode内部）
- 認証ブローカー/シークレットストレージ（トークン保存）
- 認証要求元の拡張機能

## 処理フロー

### 処理シーケンス

```
1. 拡張機能のアクティベーション
   └─ MsalAuthProvider作成、認証プロバイダー登録
2. 認証リクエスト受信
   └─ 要求スコープと既存セッションの照合
3. MSAL認証フロー
   └─ 認証ブローカーまたはブラウザで認証
4. トークン取得
   └─ MSALからトークン取得、キャッシュ
5. セッション作成
   └─ トークンを保存し、セッションを返却
```

### フローチャート

```mermaid
flowchart TD
    A[認証リクエスト] --> B{既存セッションあり?}
    B -->|Yes| C{トークン有効?}
    C -->|Yes| D[既存セッション返却]
    C -->|No| E[トークンリフレッシュ]
    B -->|No| F{ブローカー使用?}
    F -->|Yes| G[認証ブローカー経由]
    F -->|No| H[ブラウザ認証]
    E --> I{リフレッシュ成功?}
    I -->|Yes| D
    I -->|No| F
    G --> J[トークン取得]
    H --> J
    J --> K[セッション作成・返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-77-01 | ブローカー優先 | 可能な場合は認証ブローカーを使用 | implementation = 'msal' |
| BR-77-02 | 複数アカウント | 同一プロバイダーで複数アカウント許可 | supportsMultipleAccounts = true |
| BR-77-03 | チャレンジ対応 | 条件付きアクセスに対応 | supportsChallenges = true |
| BR-77-04 | 実装切替 | msal/msal-no-brokerの切り替え | 設定変更時（要リロード） |

### 計算ロジック

- スコープ比較: 要求スコープが既存セッションスコープに包含されるかチェック
- テナント判定: 認可サーバーURLからテナントIDを抽出

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない（MSALキャッシュ/VSCodeストレージを使用）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | AuthFailed | 認証フロー失敗 | エラー通知、再試行を促す |
| - | ConsentRequired | 同意が必要 | 対話的認証フローを実行 |
| - | InteractionRequired | ユーザー操作が必要 | 対話的認証フローを実行 |
| - | ConfigError | Sovereign Cloud設定エラー | 設定画面を開く |

### リトライ仕様

- サイレント認証失敗時は対話的認証にフォールバック
- トークンリフレッシュ失敗時は再認証

## トランザクション仕様

該当なし。

## パフォーマンス要件

- トークンキャッシュにより不要な認証を回避
- サイレント認証を優先して使用

## セキュリティ考慮事項

- トークンはMSALキャッシュまたはVSCodeシークレットストレージに保存
- 認証ブローカー使用時はOSのセキュア領域を活用
- PKCEフローを使用

## 備考

- microsoft（個人/組織）とmicrosoft-sovereign-cloud（政府機関）の2つのプロバイダー
- 認証ブローカー無効化オプション（msal-no-broker）あり

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

認証セッションとMSAL関連の型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VSCode API | (組み込み) | AuthenticationSession、AuthenticationProvider型 |

**読解のコツ**: VSCodeの認証APIドキュメントとMSALのドキュメントを併せて参照する。

#### Step 2: エントリーポイントを理解する

拡張機能のアクティベーションと認証プロバイダーの登録を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extension.ts | `extensions/microsoft-authentication/src/extension.ts` | activate関数 |

**主要処理フロー**:
1. **72-74行目**: テレメトリレポーター、実装種別の取得
2. **75-99行目**: 実装切替時のリロード促進
3. **110-130行目**: MsalAuthProvider作成、認証プロバイダー登録
4. **16-70行目**: initMicrosoftSovereignCloudAuthProvider関数でSovereign Cloud認証を初期化

#### Step 3: Sovereign Cloud初期化を理解する

政府機関向けクラウド認証の設定を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extension.ts | `extensions/microsoft-authentication/src/extension.ts` | initMicrosoftSovereignCloudAuthProvider関数 |

**主要処理フロー**:
- **20-24行目**: 環境設定の取得（environment）
- **26-47行目**: カスタム環境の検証とEnvironment.add
- **49-51行目**: 環境の検証
- **55-69行目**: MsalAuthProvider作成と登録

#### Step 4: MSAL認証プロバイダーを理解する

MSALを使用した認証フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | node/authProvider.ts | `extensions/microsoft-authentication/src/node/authProvider.ts` | MsalAuthProviderクラス（参照） |

**主要処理フロー**:
- createメソッドでインスタンス作成
- createSessionメソッドでMSAL認証フローを実行
- getSessionsメソッドでキャッシュからセッションを取得

### プログラム呼び出し階層図

```
activate (extension.ts)
    │
    ├─ MicrosoftAuthenticationTelemetryReporter
    │
    ├─ MsalAuthProvider.create
    │      └─ MSAL PublicClientApplication
    │
    ├─ authentication.registerAuthenticationProvider
    │      └─ provider: 'microsoft'
    │
    └─ initMicrosoftSovereignCloudAuthProvider
           │
           ├─ Environment検証
           │      ├─ 'custom' → カスタム環境設定
           │      └─ 'AzureUSGovernment'等 → 既知環境
           │
           └─ MsalAuthProvider.create (Sovereign Cloud用)
                  └─ provider: 'microsoft-sovereign-cloud'
```

### データフロー図

```
[入力]                    [処理]                         [出力]

認証リクエスト ─────────▶ MsalAuthProvider ────────────▶ AuthenticationSession
     │                       │
     │                       ▼
     │               acquireTokenSilent（サイレント認証）
     │                       │
     │              ┌────────┴────────┐
     │              ▼                  ▼
     │        成功 → トークン    失敗
     │                                 │
     │                                 ▼
     │                    acquireTokenInteractive
     │                           │
     │                           ▼
     │                    認証ブローカー/ブラウザ
     │                           │
     │                           ▼
     └─────────────────▶ セッション返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extension.ts | `extensions/microsoft-authentication/src/extension.ts` | ソース | 拡張機能エントリーポイント |
| node/authProvider.ts | `extensions/microsoft-authentication/src/node/authProvider.ts` | ソース | MSAL認証プロバイダー（Node.js） |
| logger.ts | `extensions/microsoft-authentication/src/logger.ts` | ソース | ロガー |
| UriEventHandler.ts | `extensions/microsoft-authentication/src/UriEventHandler.ts` | ソース | URIイベントハンドラー |
| common/telemetryReporter.ts | `extensions/microsoft-authentication/src/common/telemetryReporter.ts` | ソース | テレメトリ |
| package.json | `extensions/microsoft-authentication/package.json` | 設定 | 拡張機能マニフェスト |
