# 機能設計書 78-タスク自動検出（npm）

## 概要

本ドキュメントは、VS Codeの組み込み拡張機能「npm」が提供するnpmタスク自動検出機能の設計を記述する。

### 本機能の処理概要

package.jsonファイルのscriptsセクションを解析し、VS Codeのタスクとして自動検出・実行可能にする機能である。

**業務上の目的・背景**：Node.js/JavaScriptプロジェクトでは、package.jsonのscriptsにビルド、テスト、開発サーバー起動などのコマンドを定義することが一般的である。これらのスクリプトをVS Codeのタスクシステムに統合することで、コマンドラインを使わずにスクリプトを実行でき、開発効率が向上する。

**機能の利用シーン**：
- npm run build、npm test等のスクリプトをタスクとして実行する場面
- NPMスクリプトエクスプローラーでスクリプト一覧を確認する場面
- package.jsonのscriptsセクションでホバー情報を確認する場面
- 複数パッケージ管理（npm/yarn/pnpm/bun）プロジェクトでの作業

**主要な処理内容**：
1. ワークスペース内のpackage.jsonファイル検出
2. scriptsセクションの解析とタスク生成
3. パッケージマネージャーの自動検出（npm/yarn/pnpm/bun）
4. スクリプトランナーの設定対応
5. NPMスクリプトエクスプローラービューの提供
6. package.jsonでのホバー情報表示
7. CodeLensによるスクリプト実行サポート
8. ターミナルQuick Fixの提供

**関連システム・外部連携**：
- npm/yarn/pnpm/bun CLI（スクリプト実行）
- npm registry（package.json補完時の情報取得）

**権限による制御**：ワークスペース信頼モードにより、信頼されていないフォルダではスクリプト実行が制限される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | NPMスクリプトビュー | 主画面 | スクリプト一覧、実行 |
| 11 | テキストエディタ | 参照画面 | package.jsonのホバー、CodeLens |
| 36 | ターミナル | 実行画面 | スクリプトの実行結果表示 |

## 機能種別

タスク自動検出 / タスク実行 / ツリービュー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| workspaceFolder | WorkspaceFolder | Yes | ワークスペースフォルダ | fileスキーム |
| packageJsonPath | Uri | Yes | package.jsonのパス | ファイルが存在 |
| scriptName | string | No | 実行するスクリプト名 | scriptsセクションに存在 |

### 入力データソース

- ワークスペース内のpackage.jsonファイル
- ユーザー設定（npm.packageManager、npm.scriptRunner等）
- ロックファイル（package-lock.json、yarn.lock、pnpm-lock.yaml、bun.lockb）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Task[] | array | 検出されたnpmスクリプトタスク |
| TreeItem[] | array | NPMスクリプトエクスプローラーのツリーアイテム |
| Hover | object | package.jsonでのスクリプトホバー情報 |
| CodeLens[] | array | スクリプト実行用CodeLens |

### 出力先

- タスクプロバイダー（VS Codeタスクシステム）
- NPMスクリプトエクスプローラービュー
- エディタ（ホバー、CodeLens）

## 処理フロー

### 処理シーケンス

```
1. 拡張機能のアクティベーション
   └─ タスクプロバイダー登録、ビュー登録
2. package.jsonの検出
   └─ ワークスペース内のpackage.jsonを検索
3. scriptsセクションの解析
   └─ 各スクリプトをTaskオブジェクトに変換
4. パッケージマネージャーの決定
   └─ ロックファイルまたは設定から判定
5. タスク提供
   └─ VS Codeタスクシステムに登録
```

### フローチャート

```mermaid
flowchart TD
    A[拡張機能アクティベート] --> B[タスクプロバイダー登録]
    B --> C[package.json検出]
    C --> D{package.jsonあり?}
    D -->|No| E[タスクなし]
    D -->|Yes| F[scriptsセクション解析]
    F --> G[パッケージマネージャー検出]
    G --> H[タスク生成]
    H --> I[ビルド/テストタスクグループ設定]
    I --> J[タスク返却]
    J --> K[エクスプローラービュー更新]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-78-01 | 自動検出設定 | npm.autoDetectがonの場合のみ自動検出 | 設定値 = 'on' |
| BR-78-02 | パッケージマネージャー自動判定 | ロックファイルから自動判定 | npm.packageManager = 'auto' |
| BR-78-03 | ビルドタスク識別 | 'build', 'compile', 'watch'を含む名前 | タスクグループ設定時 |
| BR-78-04 | テストタスク識別 | 'test'を含む名前 | タスクグループ設定時 |
| BR-78-05 | 除外設定 | npm.excludeパターンに一致するパスを除外 | パス検証時 |

### 計算ロジック

- パッケージマネージャー検出優先順位:
  1. bun.lockb → bun
  2. pnpm-lock.yaml → pnpm
  3. yarn.lock → yarn
  4. package-lock.json または デフォルト → npm

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ParseError | package.jsonパースエラー | エラーログ、スキップ |
| - | PackageManagerNotFound | パッケージマネージャー未検出 | npm をデフォルトとして使用 |
| - | ScriptExecutionError | スクリプト実行エラー | ターミナルにエラー表示 |

### リトライ仕様

package.jsonの変更監視により、ファイル変更時に自動再検出。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- タスクリストはキャッシュして再利用
- package.json変更時のみキャッシュ無効化
- 大規模ワークスペースでもnode_modulesを除外して高速検索

## セキュリティ考慮事項

- ワークスペース信頼モードでスクリプト実行を制御
- 任意コード実行のリスクがあるため、信頼されていないフォルダでは警告

## 備考

- npm installタスクも自動生成
- pre/postスクリプトの関係も認識

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

タスク定義とスクリプト情報の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tasks.ts | `extensions/npm/src/tasks.ts` | INpmTaskDefinition、ITaskWithLocation |

**読解のコツ**: TaskDefinitionインターフェースの拡張として、scriptとpathプロパティが追加されている点を把握する。

#### Step 2: エントリーポイントを理解する

拡張機能のアクティベーションと各種機能の登録を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | npmMain.ts | `extensions/npm/src/npmMain.ts` | activate関数 |

**主要処理フロー**:
1. **26-35行目**: HTTP設定、JSONプロバイダー登録、タスクプロバイダー登録
2. **38行目**: NPMスクリプトエクスプローラー登録
3. **40-52行目**: 設定変更時のキャッシュ無効化
4. **54行目**: ホバープロバイダー登録
5. **56-77行目**: 各種コマンド登録
6. **78行目**: CodeLensプロバイダー登録
7. **80-102行目**: ターミナルQuick Fixプロバイダー登録

#### Step 3: タスクプロバイダーを理解する

npmスクリプトからVS Codeタスクへの変換処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tasks.ts | `extensions/npm/src/tasks.ts` | NpmTaskProviderクラス |

**主要処理フロー**:
- **46-57行目**: NpmTaskProviderクラス、provideTasksメソッド
- **60-87行目**: resolveTaskメソッドでタスクを解決
- **89-91行目**: invalidateTasksCacheでキャッシュ無効化
- **93-101行目**: isBuildTask、isTestTask関数でタスクグループ判定
- **130-148行目**: getScriptRunner、getPackageManager関数

#### Step 4: パッケージマネージャー検出を理解する

ロックファイルからパッケージマネージャーを自動検出する処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | preferred-pm.ts | `extensions/npm/src/preferred-pm.ts` | findPreferredPM関数 |

**主要処理フロー**:
- ロックファイル（bun.lockb、pnpm-lock.yaml、yarn.lock、package-lock.json）を検索
- 見つかったファイルに基づいてパッケージマネージャーを決定

#### Step 5: スクリプトエクスプローラーを理解する

NPMスクリプトビューの実装を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | npmView.ts | `extensions/npm/src/npmView.ts` | NpmScriptsTreeDataProviderクラス |

**主要処理フロー**:
- TreeDataProviderを実装してスクリプト一覧を提供
- getChildrenメソッドでpackage.json別にスクリプトを取得

### プログラム呼び出し階層図

```
activate (npmMain.ts)
    │
    ├─ addJSONProviders (jsonContributions.ts)
    │      └─ package.json補完
    │
    ├─ registerTaskProvider
    │      └─ NpmTaskProvider (tasks.ts)
    │             ├─ provideTasks → provideNpmScripts
    │             │      └─ package.jsonからスクリプト抽出
    │             └─ resolveTask → タスク解決
    │
    ├─ registerExplorer
    │      └─ NpmScriptsTreeDataProvider (npmView.ts)
    │             └─ スクリプトツリー表示
    │
    ├─ registerHoverProvider
    │      └─ NpmScriptHoverProvider (scriptHover.ts)
    │             └─ scriptsセクションのホバー
    │
    └─ NpmScriptLensProvider (npmScriptLens.ts)
           └─ スクリプト実行CodeLens
```

### データフロー図

```
[入力]                    [処理]                         [出力]

package.json ───────────▶ readScripts ─────────────────▶ Script[]
     │                                                      │
     │                                                      ▼
ロックファイル ─────────▶ findPreferredPM ───────────────▶ パッケージマネージャー
     │                                                      │
     │                                                      ▼
     └─────────────────▶ createScriptRunnerTask ─────────▶ Task
                                                            │
                                                            ▼
                                                      タスクプロバイダー
                                                            │
                                                            ▼
                                                      エクスプローラー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| npmMain.ts | `extensions/npm/src/npmMain.ts` | ソース | 拡張機能エントリーポイント |
| tasks.ts | `extensions/npm/src/tasks.ts` | ソース | タスクプロバイダー |
| npmView.ts | `extensions/npm/src/npmView.ts` | ソース | スクリプトエクスプローラー |
| scriptHover.ts | `extensions/npm/src/scriptHover.ts` | ソース | ホバープロバイダー |
| npmScriptLens.ts | `extensions/npm/src/npmScriptLens.ts` | ソース | CodeLensプロバイダー |
| readScripts.ts | `extensions/npm/src/readScripts.ts` | ソース | スクリプト読み取り |
| preferred-pm.ts | `extensions/npm/src/preferred-pm.ts` | ソース | パッケージマネージャー検出 |
| commands.ts | `extensions/npm/src/commands.ts` | ソース | コマンド実装 |
| features/jsonContributions.ts | `extensions/npm/src/features/jsonContributions.ts` | ソース | JSON補完 |
| package.json | `extensions/npm/package.json` | 設定 | 拡張機能マニフェスト |
