# 機能設計書 79-タスク自動検出（Gulp）

## 概要

本ドキュメントは、VS Codeの組み込み拡張機能「gulp」が提供するGulpタスク自動検出機能の設計を記述する。

### 本機能の処理概要

gulpfile.js（または派生形式）を検出し、定義されているGulpタスクをVS Codeのタスクとして自動検出・実行可能にする機能である。

**業務上の目的・背景**：Gulpはストリームベースのビルドシステムであり、フロントエンド開発でのアセット処理（SASS/LESSコンパイル、画像最適化、JavaScript圧縮等）に広く使用されている。gulpfile.jsで定義されたタスクをVS Codeのタスクシステムに統合することで、コマンドラインを使わずにビルドタスクを実行でき、開発効率が向上する。

**機能の利用シーン**：
- gulp buildやgulp watchなどのタスクを実行する場面
- Gulpタスクをビルド/テストタスクとして設定する場面
- 複数のGulpタスクを順次実行する場面

**主要な処理内容**：
1. ワークスペース内のgulpfileファイル検出
2. `gulp --tasks-simple`コマンドでタスク一覧を取得
3. 各タスクをVS Codeタスクオブジェクトに変換
4. ビルド/テストタスクグループの自動設定
5. ファイル変更監視によるタスクキャッシュ更新

**関連システム・外部連携**：
- Gulp CLI（タスク実行、タスク一覧取得）
- Node.js（Gulp実行環境）

**権限による制御**：ワークスペース信頼モードにより、信頼されていないフォルダではタスク実行が制限される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | コマンドパレット | 操作画面 | タスク実行コマンド |
| 36 | ターミナル | 実行画面 | タスクの実行結果表示 |

## 機能種別

タスク自動検出 / タスク実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| workspaceFolder | WorkspaceFolder | Yes | ワークスペースフォルダ | fileスキーム |
| gulpfilePath | string | Yes | gulpfileのパス | ファイルが存在 |
| taskName | string | No | 実行するタスク名 | タスク一覧に存在 |

### 入力データソース

- ワークスペース内のgulpfile（.js/.mjs/.cjs/.ts、.babel.js、.esm.js対応）
- Gulp CLI出力（--tasks-simple）
- ユーザー設定（gulp.autoDetect）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Task[] | array | 検出されたGulpタスク |

### 出力先

- タスクプロバイダー（VS Codeタスクシステム）

## 処理フロー

### 処理シーケンス

```
1. 拡張機能のアクティベーション
   └─ TaskDetector作成、開始
2. ワークスペースフォルダの検出
   └─ 各フォルダにFolderDetector作成
3. gulpfileの検出
   └─ gulpfile.js等の存在確認
4. タスク一覧取得
   └─ gulp --tasks-simple --no-colorコマンド実行
5. タスク生成
   └─ 各行をTaskオブジェクトに変換
6. タスクグループ設定
   └─ ビルド/テストタスクを識別
```

### フローチャート

```mermaid
flowchart TD
    A[拡張機能アクティベート] --> B[TaskDetector作成]
    B --> C[ワークスペースフォルダ取得]
    C --> D[各フォルダにFolderDetector作成]
    D --> E{gulp.autoDetect = on?}
    E -->|No| F[タスクなし]
    E -->|Yes| G[gulpfile検出]
    G --> H{gulpfileあり?}
    H -->|No| F
    H -->|Yes| I[gulp --tasks-simple実行]
    I --> J[出力をパース]
    J --> K[Task配列生成]
    K --> L[ビルド/テストグループ設定]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-79-01 | 自動検出設定 | gulp.autoDetectがonの場合のみ自動検出 | 設定値 = 'on' |
| BR-79-02 | ビルドタスク識別 | 'build', 'compile', 'watch'を含む名前 | タスクグループ設定時 |
| BR-79-03 | テストタスク識別 | 'test'を含む名前 | タスクグループ設定時 |
| BR-79-04 | gulpfile形式 | .js/.mjs/.cjs/.ts、.babel.js、.esm.jsを認識 | ファイル検出時 |

### 計算ロジック

- Gulpコマンド検出優先順位:
  1. ローカル（node_modules/.bin/gulp[.cmd]）
  2. グローバル（PATH上のgulp）

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | GulpNotFound | Gulpがインストールされていない | 空のタスクリスト返却 |
| - | TaskListError | gulp --tasks-simple実行エラー | 出力チャンネルにエラー表示 |
| - | ParseError | 出力パースエラー | エラーログ、空リスト返却 |

### リトライ仕様

gulpfile/node_modules変更時にタスクキャッシュを無効化し、次回タスク要求時に再検出。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- タスクリストはキャッシュして再利用
- ファイル変更監視で必要時のみ再検出
- gulp --tasks-simple実行は非同期

## セキュリティ考慮事項

- ワークスペース信頼モードでタスク実行を制御
- 任意コード実行のリスクがあるため、信頼されていないフォルダでは警告

## 備考

- Gulp 4.x以降を推奨
- TypeScript gulpfile（gulpfile.ts）もサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

タスク定義の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.ts | `extensions/gulp/src/main.ts` | GulpTaskDefinitionインターフェース |

**読解のコツ**: TaskDefinitionを拡張してtaskとfileプロパティを追加している点を把握する。

#### Step 2: エントリーポイントを理解する

拡張機能のアクティベーションを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.ts | `extensions/gulp/src/main.ts` | activate関数 |

**主要処理フロー**:
1. **399-402行目**: activate関数でTaskDetectorを作成・開始

#### Step 3: TaskDetectorを理解する

タスクプロバイダーの管理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.ts | `extensions/gulp/src/main.ts` | TaskDetectorクラス |

**主要処理フロー**:
- **271-396行目**: TaskDetectorクラス
- **279-286行目**: startメソッドでワークスペースフォルダの監視開始
- **296-312行目**: updateWorkspaceFoldersメソッドでフォルダ追加/削除処理
- **334-350行目**: updateProviderメソッドでタスクプロバイダー登録

#### Step 4: FolderDetectorを理解する

個別フォルダでのGulpタスク検出を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | main.ts | `extensions/gulp/src/main.ts` | FolderDetectorクラス |

**主要処理フロー**:
- **114-269行目**: FolderDetectorクラス
- **128-129行目**: isEnabledメソッドで自動検出設定確認
- **132-138行目**: startメソッドでファイル監視開始
- **140-150行目**: getTasksメソッドでタスク取得
- **163-201行目**: hasGulpfileメソッドでgulpfile検出
- **203-261行目**: computeTasksメソッドでgulp --tasks-simple実行とタスク生成

#### Step 5: Gulpコマンド検出を理解する

ローカル/グローバルのGulpコマンド検出を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | main.ts | `extensions/gulp/src/main.ts` | findGulpCommand関数 |

**主要処理フロー**:
- **89-107行目**: findGulpCommand関数
- Windows/Linux/macOSでのローカルgulp検出
- ローカルにない場合はグローバルgulpを使用

### プログラム呼び出し階層図

```
activate (main.ts)
    │
    └─ TaskDetector
           ├─ start
           │      └─ updateWorkspaceFolders
           │             └─ FolderDetector（各フォルダ）
           │                    ├─ isEnabled → gulp.autoDetect確認
           │                    ├─ start → ファイル監視
           │                    └─ getTasks
           │                           ├─ hasGulpfile → gulpfile検出
           │                           └─ computeTasks
           │                                  ├─ findGulpCommand
           │                                  ├─ exec("gulp --tasks-simple")
           │                                  └─ タスク生成
           │
           └─ updateProvider
                  └─ tasks.registerTaskProvider('gulp', ...)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

gulpfile.js ────────────▶ hasGulpfile ──────────────────▶ boolean
     │
     │                    ┌───────────────────────────┐
     │                    │ gulp --tasks-simple       │
     └───────────────────▶│    --no-color             │───▶ stdout
                          └───────────────────────────┘
                                      │
                                      ▼
                              タスク名リスト
                                      │
                                      ▼
                              Task配列生成
                                      │
                                      ▼
                              タスクプロバイダー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.ts | `extensions/gulp/src/main.ts` | ソース | 拡張機能全体（エントリーポイント、検出ロジック） |
| package.json | `extensions/gulp/package.json` | 設定 | 拡張機能マニフェスト |
