# 機能設計書 8-コードスニペット

## 概要

本ドキュメントは、VS Codeエディタにおけるコードスニペット機能の設計仕様を記載する。定型コードの素早い挿入機能を実現する。

### 本機能の処理概要

コードスニペット機能は、頻繁に使用するコードパターンをテンプレートとして登録し、トリガー文字列やコマンドで素早く挿入する機能である。タブストップや変数置換により、動的なコード生成をサポートする。

**業務上の目的・背景**：ソフトウェア開発において、定型的なコードパターン（for文、if文、クラス定義など）を繰り返し記述する場面は多い。スニペット機能により、これらの定型コードを素早く正確に挿入でき、開発効率を大幅に向上させる。また、タブストップによりテンプレート内の編集箇所を順次移動でき、効率的なコード入力が可能になる。

**機能の利用シーン**：
- forループやif文などの制御構文の挿入
- クラスやメソッドのテンプレート挿入
- ライセンスヘッダーやコメントブロックの挿入
- 言語固有のボイラープレートコードの挿入

**主要な処理内容**：
1. スニペット解析 - スニペットテンプレートをパースしてAST構築
2. 変数解決 - $TM_FILENAME等の変数を実際の値に置換
3. タブストップ管理 - タブストップ位置を管理し、Tab/Shift+Tabでナビゲーション
4. テキスト挿入 - 解決済みテンプレートをエディタに挿入
5. ネストスニペット - スニペット内で別のスニペットを挿入可能

**関連システム・外部連携**：補完機能（IntelliSense）と連携してスニペット補完を提供。拡張機能からスニペットを登録可能。

**権限による制御**：読み取り専用モードでは挿入不可。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | テキストエディタ | 主画面 | 定型コードの素早い挿入 |

## 機能種別

入力支援 / テンプレート処理 / 挿入処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| template | string | Yes | スニペットテンプレート文字列 | スニペット構文準拠 |
| overwriteBefore | number | No | 挿入位置前の上書き文字数 | 0以上 |
| overwriteAfter | number | No | 挿入位置後の上書き文字数 | 0以上 |
| adjustWhitespace | boolean | No | インデント自動調整 | true/false |
| undoStopBefore | boolean | No | 挿入前にUndo境界作成 | true/false |
| undoStopAfter | boolean | No | 挿入後にUndo境界作成 | true/false |
| clipboardText | string | No | クリップボード内容（$CLIPBOARD変数用） | - |

### 入力データソース

- スニペット定義ファイル（.code-snippets）
- 拡張機能からの登録
- 補完候補（IntelliSense経由）
- コマンドパレット

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| insertedText | string | 挿入されたテキスト |
| tabstops | Position[] | タブストップ位置リスト |
| selections | Selection[] | タブストップ選択範囲 |

### 出力先

- エディタ画面（挿入テキスト）
- コンテキストキー（inSnippetMode、hasNextTabstop等）

## 処理フロー

### 処理シーケンス

```
1. スニペット挿入要求受付
   └─ テンプレート文字列と挿入オプションを受け取る
2. Undo境界作成
   └─ undoStopBeforeがtrueの場合、pushStackElement()
3. スニペットパース
   └─ SnippetParserでテンプレートをAST化
4. 変数解決
   └─ SnippetVariablesで変数を実際の値に置換
5. SnippetSession開始
   └─ 新しいセッションを作成または既存セッションを更新
6. テキスト挿入
   └─ モデルに編集操作を適用
7. タブストップ設定
   └─ 最初のタブストップ（$1または$0）を選択
8. コンテキストキー更新
   └─ inSnippetMode、hasNextTabstop等を設定
```

### フローチャート

```mermaid
flowchart TD
    A[スニペット挿入要求] --> B{モデルあり?}
    B -->|No| C[処理終了]
    B -->|Yes| D{undoStopBefore?}
    D -->|Yes| E[pushStackElement]
    D -->|No| F[スニペットパース]
    E --> F
    F --> G[変数解決]
    G --> H{既存セッション?}
    H -->|Yes| I[ネスト挿入]
    H -->|No| J[新規セッション作成]
    I --> K[テキスト挿入]
    J --> K
    K --> L[タブストップ設定]
    L --> M[コンテキストキー更新]
    M --> N{undoStopAfter?}
    N -->|Yes| O[pushStackElement]
    N -->|No| P[処理完了]
    O --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | インデント調整 | adjustWhitespaceでインデントを自動調整 | オプション有効時 |
| BR-002 | タブストップ順序 | $1, $2, ..., $0の順でナビゲーション | Tab押下時 |
| BR-003 | プレースホルダー | ${1:default}形式でデフォルト値設定可能 | スニペット定義時 |
| BR-004 | 変数 | $TM_FILENAME等の変数を自動解決 | スニペット挿入時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| PARSE_ERROR | エラー | スニペット構文エラー | エラーログ出力、セッションキャンセル |
| NO_MODEL | 情報 | エディタにモデルがない | 処理をスキップ |

### リトライ仕様

特になし

## トランザクション仕様

undoStopBefore/Afterでスニペット挿入全体をUndoスタックの単一操作として扱うことが可能。

## パフォーマンス要件

- スニペット挿入: 即座
- タブストップナビゲーション: 即座

## セキュリティ考慮事項

- シェルコマンド変数（$TM_SELECTED_TEXT等）のサニタイズ
- 悪意のあるスニペットによるコードインジェクション防止

## 備考

VS Codeのスニペット構文はTextMate互換であり、多くの既存スニペット定義を再利用可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、スニペットの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | snippetParser.ts | `src/vs/editor/contrib/snippet/browser/snippetParser.ts` | Snippet, Text, Placeholder, Variable等のAST |

#### Step 2: エントリーポイントを理解する

コントローラの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | snippetController2.ts | `src/vs/editor/contrib/snippet/browser/snippetController2.ts` | SnippetController2 |

**主要処理フロー**:
1. **51-57行目**: SnippetController2定義、ID登録
2. **59-61行目**: コンテキストキー定義（InSnippetMode等）
3. **109-126行目**: insert() - スニペット挿入エントリーポイント
4. **128-150行目**: _doInsert() - 挿入処理本体

#### Step 3: セッション管理を理解する

スニペットセッションの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | snippetSession.ts | `src/vs/editor/contrib/snippet/browser/snippetSession.ts` | SnippetSession |

#### Step 4: 変数解決を理解する

スニペット変数の解決を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | snippetVariables.ts | `src/vs/editor/contrib/snippet/browser/snippetVariables.ts` | 変数リゾルバー |

### プログラム呼び出し階層図

```
SnippetController2.insert()
    │
    ├─ _doInsert()
    │      ├─ pushStackElement() (undoStopBefore)
    │      │
    │      ├─ SnippetParser.parse()
    │      │      └─ スニペットAST構築
    │      │
    │      ├─ SnippetSession作成/更新
    │      │      ├─ 変数解決
    │      │      └─ テキスト挿入
    │      │
    │      └─ コンテキストキー更新
    │             ├─ inSnippetMode
    │             ├─ hasNextTabstop
    │             └─ hasPrevTabstop
    │
    ├─ next() - 次のタブストップへ
    │
    └─ prev() - 前のタブストップへ
```

### データフロー図

```
[入力]               [処理]                    [出力]

テンプレート ──▶ SnippetParser.parse() ──▶ スニペットAST
                        │
                        ▼
スニペットAST ──▶ VariableResolver ──▶ 解決済みテキスト
                        │
                        ▼
解決済みテキスト ──▶ SnippetSession ──▶ タブストップ位置
                        │
                        ▼
SnippetSession ──▶ editor.executeEdits() ──▶ テキスト挿入
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| snippetController2.ts | `src/vs/editor/contrib/snippet/browser/snippetController2.ts` | ソース | スニペットコントローラ |
| snippetParser.ts | `src/vs/editor/contrib/snippet/browser/snippetParser.ts` | ソース | スニペットパーサー |
| snippetSession.ts | `src/vs/editor/contrib/snippet/browser/snippetSession.ts` | ソース | スニペットセッション |
| snippetVariables.ts | `src/vs/editor/contrib/snippet/browser/snippetVariables.ts` | ソース | 変数リゾルバー |
