# 機能設計書 80-タスク自動検出（Grunt）

## 概要

本ドキュメントは、VS Codeの組み込み拡張機能「grunt」が提供するGruntタスク自動検出機能の設計を記述する。

### 本機能の処理概要

Gruntfile.js（または gruntfile.js）を検出し、定義されているGruntタスクをVS Codeのタスクとして自動検出・実行可能にする機能である。

**業務上の目的・背景**：Gruntはタスクランナーとして、JavaScript/フロントエンドプロジェクトでのビルド自動化に使用されている。Gruntfileで定義されたタスクをVS Codeのタスクシステムに統合することで、コマンドラインを使わずにビルドタスクを実行でき、開発効率が向上する。

**機能の利用シーン**：
- grunt buildやgrunt testなどのタスクを実行する場面
- Gruntタスクをビルド/テストタスクとして設定する場面
- 複数のGruntタスクを順次実行する場面

**主要な処理内容**：
1. ワークスペース内のGruntfile.js検出
2. `grunt --help`コマンドでタスク一覧を取得
3. 出力から「Available tasks」セクションを解析
4. 各タスクをVS Codeタスクオブジェクトに変換
5. ビルド/テストタスクグループの自動設定
6. ファイル変更監視によるタスクキャッシュ更新

**関連システム・外部連携**：
- Grunt CLI（タスク実行、タスク一覧取得）
- Node.js（Grunt実行環境）

**権限による制御**：ワークスペース信頼モードにより、信頼されていないフォルダではタスク実行が制限される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | コマンドパレット | 操作画面 | タスク実行コマンド |
| 36 | ターミナル | 実行画面 | タスクの実行結果表示 |

## 機能種別

タスク自動検出 / タスク実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| workspaceFolder | WorkspaceFolder | Yes | ワークスペースフォルダ | fileスキーム |
| gruntfilePath | string | Yes | Gruntfileのパス | ファイルが存在 |
| taskName | string | No | 実行するタスク名 | タスク一覧に存在 |

### 入力データソース

- ワークスペース内のGruntfile.js（大文字/小文字両方対応）
- Grunt CLI出力（--help）
- ユーザー設定（grunt.autoDetect）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Task[] | array | 検出されたGruntタスク |

### 出力先

- タスクプロバイダー（VS Codeタスクシステム）

## 処理フロー

### 処理シーケンス

```
1. 拡張機能のアクティベーション
   └─ TaskDetector作成、開始
2. ワークスペースフォルダの検出
   └─ 各フォルダにFolderDetector作成
3. Gruntfileの検出
   └─ Gruntfile.js/gruntfile.jsの存在確認
4. タスク一覧取得
   └─ grunt --help --no-colorコマンド実行
5. 出力解析
   └─ 「Available tasks」セクションを正規表現でパース
6. タスク生成
   └─ 各タスクをTaskオブジェクトに変換
7. タスクグループ設定
   └─ ビルド/テストタスクを識別
```

### フローチャート

```mermaid
flowchart TD
    A[拡張機能アクティベート] --> B[TaskDetector作成]
    B --> C[ワークスペースフォルダ取得]
    C --> D[各フォルダにFolderDetector作成]
    D --> E{grunt.autoDetect = on?}
    E -->|No| F[タスクなし]
    E -->|Yes| G[Gruntfile検出]
    G --> H{Gruntfileあり?}
    H -->|No| F
    H -->|Yes| I[grunt --help実行]
    I --> J[Available tasksセクション解析]
    J --> K[タスク名抽出]
    K --> L[Task配列生成]
    L --> M[ビルド/テストグループ設定]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-80-01 | 自動検出設定 | grunt.autoDetectがonの場合のみ自動検出 | 設定値 = 'on' |
| BR-80-02 | ビルドタスク識別 | 'build', 'compile', 'watch'を含む名前 | タスクグループ設定時 |
| BR-80-03 | テストタスク識別 | 'test'を含む名前 | タスクグループ設定時 |
| BR-80-04 | Gruntfile形式 | Gruntfile.jsまたはgruntfile.jsを認識 | ファイル検出時 |
| BR-80-05 | タスク名パース | 正規表現`/^\s*(\S.*\S)  \S/g`で抽出 | 出力解析時 |

### 計算ロジック

- Gruntコマンド検出優先順位:
  1. ローカル（node_modules/.bin/grunt[.cmd]）
  2. グローバル（PATH上のgrunt）

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | GruntNotFound | Gruntがインストールされていない | 空のタスクリスト返却 |
| - | TaskListError | grunt --help実行エラー | 出力チャンネルにエラー表示 |
| - | ParseError | 出力パースエラー | エラーログ、空リスト返却 |

### リトライ仕様

Gruntfile/node_modules変更時にタスクキャッシュを無効化し、次回タスク要求時に再検出。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- タスクリストはキャッシュして再利用
- ファイル変更監視で必要時のみ再検出
- grunt --help実行は非同期

## セキュリティ考慮事項

- ワークスペース信頼モードでタスク実行を制御
- 任意コード実行のリスクがあるため、信頼されていないフォルダでは警告

## 備考

- grunt --help出力形式に依存
- タスク名にスペースが含まれる場合はクォートで囲む

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

タスク定義の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.ts | `extensions/grunt/src/main.ts` | GruntTaskDefinitionインターフェース |

**読解のコツ**: TaskDefinitionを拡張してtask、args、fileプロパティを追加している点を把握する。

#### Step 2: エントリーポイントを理解する

拡張機能のアクティベーションを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.ts | `extensions/grunt/src/main.ts` | activate関数 |

**主要処理フロー**:
1. **357-360行目**: activate関数でTaskDetectorを作成・開始

#### Step 3: TaskDetectorを理解する

タスクプロバイダーの管理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.ts | `extensions/grunt/src/main.ts` | TaskDetectorクラス |

**主要処理フロー**:
- **230-354行目**: TaskDetectorクラス
- **238-245行目**: startメソッドでワークスペースフォルダの監視開始
- **255-271行目**: updateWorkspaceFoldersメソッドでフォルダ追加/削除処理
- **293-309行目**: updateProviderメソッドでタスクプロバイダー登録

#### Step 4: FolderDetectorを理解する

個別フォルダでのGruntタスク検出を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | main.ts | `extensions/grunt/src/main.ts` | FolderDetectorクラス |

**主要処理フロー**:
- **85-228行目**: FolderDetectorクラス
- **99-101行目**: isEnabledメソッドで自動検出設定確認
- **103-109行目**: startメソッドでファイル監視開始
- **111-120行目**: getTasksメソッドでタスク取得
- **136-220行目**: computeTasksメソッドでgrunt --help実行とタスク解析

**出力解析ロジック**:
- **154-178行目**: 「Available tasks」セクションを検出
- **182-183行目**: 正規表現 `/^\s*(\S.*\S)  \S/g` でタスク名を抽出
- **179行目**: 「Tasks run in the order specified」でセクション終了を検出

#### Step 5: Gruntコマンド検出を理解する

ローカル/グローバルのGruntコマンド検出を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | main.ts | `extensions/grunt/src/main.ts` | findGruntCommand関数 |

**主要処理フロー**:
- **72-83行目**: findGruntCommand関数
- Windows/Linux/macOSでのローカルgrunt検出
- ローカルにない場合はグローバルgruntを使用

### プログラム呼び出し階層図

```
activate (main.ts)
    │
    └─ TaskDetector
           ├─ start
           │      └─ updateWorkspaceFolders
           │             └─ FolderDetector（各フォルダ）
           │                    ├─ isEnabled → grunt.autoDetect確認
           │                    ├─ start → ファイル監視
           │                    └─ getTasks
           │                           └─ computeTasks
           │                                  ├─ Gruntfile存在確認
           │                                  ├─ findGruntCommand
           │                                  ├─ exec("grunt --help")
           │                                  ├─ "Available tasks"解析
           │                                  └─ タスク生成
           │
           └─ updateProvider
                  └─ tasks.registerTaskProvider('grunt', ...)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Gruntfile.js ───────────▶ exists確認 ──────────────────▶ boolean
     │
     │                    ┌───────────────────────────┐
     │                    │ grunt --help --no-color   │
     └───────────────────▶│                           │───▶ stdout
                          └───────────────────────────┘
                                      │
                                      ▼
                          "Available tasks"解析
                                      │
                                      ▼
                              正規表現でタスク名抽出
                                      │
                                      ▼
                              Task配列生成
                                      │
                                      ▼
                              タスクプロバイダー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.ts | `extensions/grunt/src/main.ts` | ソース | 拡張機能全体（エントリーポイント、検出ロジック） |
| package.json | `extensions/grunt/package.json` | 設定 | 拡張機能マニフェスト |
