# 機能設計書 82-デバッグ自動起動

## 概要

本ドキュメントは、VS Codeの「デバッグ自動起動（debug-server-ready）」機能の設計内容を記載する。サーバーアプリケーションのデバッグ時に、サーバー起動完了を検知して自動的にブラウザを開いたり追加のデバッグセッションを開始する機能を提供する。

### 本機能の処理概要

debug-server-ready拡張機能は、デバッグセッション中のコンソール出力やターミナル出力を監視し、サーバーが起動してリッスン状態になったことを検知すると、設定されたアクション（ブラウザを開く、追加のデバッグセッションを開始するなど）を自動実行する。

**業務上の目的・背景**：Web開発において、サーバーアプリケーションをデバッグする際に毎回手動でブラウザを開く手間を省く。特にNode.js/Express、ASP.NET Core、Python Flask等のサーバーサイド開発で、起動完了後に自動的にフロントエンドのデバッグも開始できるようにする。

**機能の利用シーン**：
- Node.jsサーバーをデバッグ起動し、ポートがリッスン状態になったらブラウザを自動で開く
- バックエンドとフロントエンドの統合デバッグで、サーバー起動後に自動的にChromeデバッガーをアタッチ
- カスタムパターンを設定して様々なサーバーフレームワークに対応

**主要な処理内容**：
1. デバッグセッション開始時にServerReadyDetectorを初期化
2. デバッグコンソール/ターミナル出力の監視
3. 正規表現パターンでサーバー起動メッセージを検出
4. 検出時に設定されたアクション（openExternally/debugWithChrome/debugWithEdge/startDebugging）を実行

**関連システム・外部連携**：VS Codeデバッグシステム、Chrome/Edgeデバッガー、統合ターミナル

**権限による制御**：信頼されていないワークスペースでもサポート

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | 実行とデバッグビュー | 主画面 | デバッグセッション管理、launch.json設定 |
| 5 | パネル | 補助機能 | デバッグコンソールでの出力監視 |
| 28 | ターミナルビュー | 補助機能 | ターミナル出力の監視 |

## 機能種別

イベント検知 / 自動アクション実行 / デバッグ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| serverReadyAction.pattern | string | No | サーバー起動を検知する正規表現 | デフォルト: "listening on.* (https?://\\S+\|[0-9]+)" |
| serverReadyAction.action | string | No | 実行するアクション | enum: openExternally, debugWithChrome, debugWithEdge, startDebugging |
| serverReadyAction.uriFormat | string | No | URI構築フォーマット | %s プレースホルダーは1つのみ |
| serverReadyAction.webRoot | string | No | ブラウザデバッグ用webRoot | デフォルト: ${workspaceFolder} |
| serverReadyAction.name | string | 条件付き | 開始するデバッグ設定名 | action=startDebuggingの場合必須 |
| serverReadyAction.config | object | 条件付き | インラインデバッグ設定 | action=startDebuggingの場合使用可能 |
| serverReadyAction.killOnServerStop | boolean | No | サーバー停止時に子セッション終了 | デフォルト: false |

### 入力データソース

- launch.json内のserverReadyAction設定
- デバッグコンソール出力（stdout/stderr/console）
- ターミナルデータ出力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| uri | string | 検出されたURIまたは構築されたURI |
| action | - | 外部ブラウザ起動/デバッグセッション開始 |

### 出力先

- 外部ブラウザ（openExternally）
- Chrome/Edgeデバッガーセッション（debugWithChrome/debugWithEdge）
- 追加のデバッグセッション（startDebugging）

## 処理フロー

### 処理シーケンス

```
1. デバッグセッション開始
   └─ onDidStartDebugSessionイベント発火

2. ServerReadyDetector初期化
   └─ serverReadyAction設定がある場合のみ

3. ターミナルデータリスナー登録
   └─ terminalDataWriteEventを監視

4. デバッグアダプタートラッカー登録
   └─ コンソール出力イベントを監視

5. パターンマッチング
   └─ 正規表現でサーバー起動メッセージを検出

6. URI抽出・構築
   └─ キャプチャグループからURI/ポート番号を取得

7. アクション実行
   └─ 設定されたアクションを実行

8. セッション終了時クリーンアップ
   └─ killOnServerStop=trueの場合、子セッションも終了
```

### フローチャート

```mermaid
flowchart TD
    A[デバッグ開始] --> B{serverReadyAction設定あり?}
    B -->|Yes| C[ServerReadyDetector作成]
    B -->|No| Z[通常デバッグ]
    C --> D[出力監視開始]
    D --> E{パターンマッチ?}
    E -->|No| D
    E -->|Yes| F[URI抽出]
    F --> G{action種別}
    G -->|openExternally| H[外部ブラウザ起動]
    G -->|debugWithChrome| I[Chromeデバッグ開始]
    G -->|debugWithEdge| J[Edgeデバッグ開始]
    G -->|startDebugging| K[追加デバッグセッション]
    H --> L{killOnServerStop?}
    I --> L
    J --> L
    K --> L
    L -->|Yes| M[セッション終了監視]
    L -->|No| Z
    M --> N[サーバー停止]
    N --> O[子セッション終了]
    O --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-82-1 | パターンデフォルト | "listening on"を含む出力でポート/URLを検出 | pattern未指定時 |
| BR-82-2 | URIフォーマット推定 | キャプチャが数字のみならhttp://localhost:%s | uriFormat未指定時 |
| BR-82-3 | 一度のみ発火 | パターンマッチは親セッションで一度のみ | 常時 |
| BR-82-4 | ANSI除去 | ターミナル出力からANSIエスケープコードを除去 | ターミナル監視時 |

### 計算ロジック

URIフォーマットの自動判定：
```typescript
// キャプチャが数字のみならポート番号として扱う
const format = args.uriFormat ||
  (/^[0-9]+$/.test(captureString) ? 'http://localhost:%s' : '%s');
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | エラーダイアログ | uriFormatに%sが複数または0個 | モーダルダイアログで通知 |
| - | エラーダイアログ | uriFormatに%sがあるがキャプチャなし | モーダルダイアログで通知 |

### リトライ仕様

リトライは行わない。一度パターンがマッチしたら以降は無視される。

## トランザクション仕様

該当なし

## パフォーマンス要件

- ターミナル/コンソール出力をリアルタイムで監視
- ANSIエスケープコード除去処理の効率化

## セキュリティ考慮事項

- 信頼されていないワークスペースでもサポート
- 仮想ワークスペースは非サポート
- terminalDataWriteEvent APIを使用（提案API）

## 備考

- Chrome/Edgeデバッグにはpwa-chrome/pwa-msedgeデバッガーを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.json | `extensions/debug-server-ready/package.json` | serverReadyActionスキーマ定義 |
| 1-2 | extension.ts | `extensions/debug-server-ready/src/extension.ts` | ServerReadyActionインターフェース（15-23行目） |

**読解のコツ**: package.jsonのcontributes.debuggers[*].configurationAttributesにserverReadyActionの詳細なスキーマが定義されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extension.ts | `extensions/debug-server-ready/src/extension.ts` | activate関数（323-351行目） |

**主要処理フロー**:
1. **325-332行目**: onDidStartDebugSessionでDetector開始
2. **334-336行目**: onDidTerminateDebugSessionでDetector停止
3. **340-350行目**: デバッグ設定解決時にトラッカー登録

#### Step 3: 検出ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extension.ts | `extensions/debug-server-ready/src/extension.ts` | ServerReadyDetectorクラス（59-321行目） |

**主要処理フロー**:
- **71-81行目**: start()でDetector作成
- **99-121行目**: startListeningTerminalData()でターミナル監視
- **145-155行目**: detectPattern()でパターンマッチング
- **187-216行目**: openExternalWithUri()でアクション実行

### プログラム呼び出し階層図

```
activate() [323行目]
    │
    ├─ onDidStartDebugSession [325行目]
    │      └─ ServerReadyDetector.start() [71-81行目]
    │             └─ new ServerReadyDetector() [123-134行目]
    │
    ├─ onDidTerminateDebugSession [334行目]
    │      └─ ServerReadyDetector.stop() [83-90行目]
    │
    └─ registerDebugConfigurationProvider [340行目]
           └─ startTrackerForType() [353-393行目]
                  │
                  └─ registerDebugAdapterTrackerFactory [356行目]
                         └─ onDidSendMessage [362-381行目]
                                └─ detectPattern() [145-155行目]
                                       │
                                       └─ openExternalWithString() [157-185行目]
                                              └─ openExternalWithUri() [187-216行目]
                                                     │
                                                     ├─ openExternally → vscode.env.openExternal
                                                     ├─ debugWithChrome → debugWithBrowser('pwa-chrome')
                                                     ├─ debugWithEdge → debugWithBrowser('pwa-msedge')
                                                     └─ startDebugging → startDebugSession()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

launch.json          ──▶ serverReadyAction解析
serverReadyAction           │
                            ▼
デバッグ出力         ──▶ detectPattern() [145行目]
(console/stderr/           │
stdout/terminal)           ▼
                      正規表現マッチング [147-148行目]
                            │
                            ▼
キャプチャ文字列     ──▶ openExternalWithString()   ──▶ URI構築
                            │
                            ▼
                      action判定 [190行目]
                            │
    ┌───────────────────────┼───────────────────────┐
    ▼                       ▼                       ▼
openExternally         debugWithBrowser      startDebugSession
    │                       │                       │
    ▼                       ▼                       ▼
外部ブラウザ起動      Chrome/Edgeデバッグ     追加デバッグセッション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extension.ts | `extensions/debug-server-ready/src/extension.ts` | ソース | メインロジック（検出、アクション実行） |
| package.json | `extensions/debug-server-ready/package.json` | 設定 | 拡張機能マニフェスト、スキーマ定義 |
| package.nls.json | `extensions/debug-server-ready/package.nls.json` | リソース | ローカライズ文字列 |
