# 機能設計書 83-デバッグ自動アタッチ

## 概要

本ドキュメントは、VS Codeの「デバッグ自動アタッチ（debug-auto-launch）」機能の設計内容を記載する。統合ターミナルで起動されたNode.jsプロセスに対して自動的にデバッガーをアタッチする機能を提供する。

### 本機能の処理概要

debug-auto-launch拡張機能は、VS Codeの統合ターミナルで実行されたNode.jsプロセスを検出し、設定に応じて自動的にデバッガーをアタッチする。これにより、`node --inspect`フラグを意識することなくデバッグを開始できる。

**業務上の目的・背景**：Node.js開発において、ターミナルからスクリプトを実行する際に毎回launch.jsonを設定したり、--inspectフラグを付けたりする手間を省く。開発者がより直感的にデバッグを開始できるようにする。

**機能の利用シーン**：
- ターミナルで`node app.js`を実行したとき、自動的にデバッガーがアタッチされる
- npm scriptsやyarnコマンド経由でNode.jsを実行した場合も検出される
- TypeScriptのts-nodeやnpxコマンドにも対応

**主要な処理内容**：
1. ステータスバーからの自動アタッチモード切り替え
2. ターミナル環境変数(NODE_OPTIONS)の設定
3. Node.jsプロセスの起動検出
4. デバッガーの自動アタッチ

**関連システム・外部連携**：VS Codeデバッグシステム、統合ターミナル、Node.jsランタイム

**権限による制御**：信頼されていないワークスペースでは無効化

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | ターミナルビュー | 主画面 | Node.jsプロセスの起動と検出 |
| 4 | ステータスバー | 主機能 | 自動アタッチモードの表示と切り替え |
| 23 | 実行とデバッグビュー | 連携画面 | アタッチされたデバッグセッションの表示 |

## 機能種別

プロセス監視 / 自動デバッグアタッチ / 環境変数制御

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| debug.javascript.autoAttachFilter | string | No | 自動アタッチのフィルタモード | enum: disabled, always, smart, onlyWithFlag |
| debug.javascript.autoAttachSmartPattern | string[] | No | smartモードでの除外パターン | glob patterns |

### 自動アタッチモード

| モード | 説明 |
|-------|------|
| disabled | 自動アタッチ無効 |
| always | すべてのNode.jsプロセスにアタッチ |
| smart | node_modules外のスクリプトにのみアタッチ |
| onlyWithFlag | --inspect/--inspect-brkフラグ付きのみ |

### 入力データソース

- ワークスペース設定
- ステータスバーのトグル操作
- ターミナルで実行されるコマンド

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| statusBarItem | StatusBarItem | 現在のモード表示 |
| debugSession | DebugSession | 自動アタッチされたセッション |

### 出力先

- ステータスバー（モード表示）
- デバッグビュー（デバッグセッション）
- ターミナル環境変数（NODE_OPTIONS）

## 処理フロー

### 処理シーケンス

```
1. 拡張機能のアクティベーション
   └─ onStartupFinishedイベントで起動

2. AutoAttachの初期化
   └─ ステータスバーアイテム作成

3. ターミナル環境変数の設定
   └─ NODE_OPTIONSに--inspectを追加（always/smartモード）

4. ターミナルでNode.js実行

5. Node.jsプロセスの検出
   └─ js-debug拡張機能によるプロセス検出

6. フィルタ条件の評価
   └─ smartモード: node_modules外かチェック
   └─ onlyWithFlag: --inspectフラグ有無チェック

7. デバッガーのアタッチ
   └─ vscode.debug.startDebugging

8. セッション終了時
   └─ プロセス終了に伴いセッション終了
```

### フローチャート

```mermaid
flowchart TD
    A[拡張機能起動] --> B[AutoAttach初期化]
    B --> C[ステータスバー作成]
    C --> D{現在のモード?}
    D -->|disabled| E[監視なし]
    D -->|always/smart/onlyWithFlag| F[ターミナル環境設定]
    F --> G[ターミナルでNode.js実行]
    G --> H{モード別判定}
    H -->|always| I[アタッチ]
    H -->|smart| J{node_modules外?}
    H -->|onlyWithFlag| K{--inspect付き?}
    J -->|Yes| I
    J -->|No| L[スキップ]
    K -->|Yes| I
    K -->|No| L
    I --> M[デバッグセッション開始]
    M --> N[プロセス終了監視]
    N --> O[セッション終了]
    L --> E
    E --> P[終了]
    O --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-83-1 | smartモード除外 | autoAttachSmartPatternにマッチするパスは除外 | smartモード時 |
| BR-83-2 | 信頼されていないワークスペース | 自動アタッチは無効化される | isTrusted=false時 |
| BR-83-3 | ワークスペース単位設定 | 各ワークスペースフォルダで個別に設定可能 | マルチルートワークスペース |

### デフォルトSmartパターン

```javascript
[
  '${workspaceFolder}/**',
  '!**/node_modules/**',
  '**/$KNOWN_TOOLS$/**'
]
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | 古いターミナルでNODE_OPTIONSが未設定 | ターミナル再起動を促す |
| - | 情報 | アタッチ対象なし | 静かにスキップ |

### リトライ仕様

リトライは行わない。ターミナル再起動で再設定される。

## トランザクション仕様

該当なし

## パフォーマンス要件

- ステータスバーの更新は即座に反映
- 環境変数の変更は次のターミナル起動から有効

## セキュリティ考慮事項

- 信頼されていないワークスペースでは自動的に無効化
- 仮想ワークスペースは非サポート

## 備考

- js-debug拡張機能と連携して動作
- Node.js以外のランタイム（Deno等）は対象外

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.json | `extensions/debug-auto-launch/package.json` | コマンド定義と設定項目 |
| 1-2 | extension.ts | `extensions/debug-auto-launch/src/extension.ts` | Stateインターフェース（17-21行目） |

**読解のコツ**: `contributes.commands`でモード切り替えコマンド、`configuration`で自動アタッチ設定を定義。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extension.ts | `extensions/debug-auto-launch/src/extension.ts` | activate関数（137-147行目） |

**主要処理フロー**:
1. **139行目**: isTrusted確認（信頼されていない場合は何もしない）
2. **143行目**: updateAutoAttach呼び出しで初期化
3. **145行目**: 設定変更時の再設定

#### Step 3: 自動アタッチロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extension.ts | `extensions/debug-auto-launch/src/extension.ts` | updateAutoAttach関数（83-134行目） |
| 3-2 | extension.ts | `extensions/debug-auto-launch/src/extension.ts` | createStatusBarItem（63-80行目） |

**主要処理フロー**:
- **86-89行目**: 現在の設定を取得
- **99-103行目**: js-debugのstartSelfHostコマンド呼び出し
- **105-121行目**: ステータスバーアイテムの更新
- **127行目**: ターミナル環境変数の更新

### プログラム呼び出し階層図

```
activate() [137行目]
    │
    ├─ workspace.isTrusted確認 [139行目]
    │
    ├─ updateAutoAttach() [143行目]
    │      │
    │      ├─ getConfig() [86行目]
    │      │
    │      ├─ commands.executeCommand [99-103行目]
    │      │    └─ 'extension.js-debug.startSelfHost'
    │      │
    │      ├─ createStatusBarItem() [105行目] or updateStatusBar() [109行目]
    │      │      │
    │      │      └─ StatusBarItem設定 [63-80行目]
    │      │
    │      └─ commands.executeCommand [127行目]
    │           └─ 'workbench.action.terminal.relaunch'
    │
    └─ onDidChangeConfiguration [145行目]
           └─ updateAutoAttach() [再呼び出し]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー設定変更     ──▶ onDidChangeConfiguration
または                      │
コマンド実行                ▼
                      updateAutoAttach() [83行目]
                            │
                            ├──▶ js-debug拡張機能呼び出し ──▶ NODE_OPTIONS設定
                            │
                            └──▶ createStatusBarItem()   ──▶ ステータスバー表示
                                       │
                                       ▼
ターミナル起動        ──▶ NODE_OPTIONS適用
                            │
                            ▼
Node.js実行          ──▶ --inspect有効
                            │
                            ▼
js-debug検出         ──▶ デバッグセッション開始    ──▶ デバッグビュー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extension.ts | `extensions/debug-auto-launch/src/extension.ts` | ソース | メインロジック（モード管理、ステータスバー） |
| package.json | `extensions/debug-auto-launch/package.json` | 設定 | 拡張機能マニフェスト、コマンド定義 |
| package.nls.json | `extensions/debug-auto-launch/package.nls.json` | リソース | ローカライズ文字列 |
