# 機能設計書 84-設定編集補完

## 概要

本ドキュメントは、VS Codeの「設定編集補完（configuration-editing）」機能の設計内容を記載する。settings.json、keybindings.json、tasks.jsonなどの設定ファイル編集時にインテリセンス補完とJSONスキーマ検証を提供する。

### 本機能の処理概要

configuration-editing拡張機能は、VS Codeの各種設定ファイルを編集する際に、プロパティ名の補完、値の候補表示、構文検証を提供する。JSONスキーマを活用してリアルタイムに入力補助を行う。

**業務上の目的・背景**：VS Codeの設定ファイルは複雑で多くのオプションが存在するため、手動で記述するのは困難。スキーマベースの補完と検証により、正確な設定記述をサポートし、設定ミスを防止する。

**機能の利用シーン**：
- settings.jsonを開いて新しい設定を追加する際に、プロパティ名の候補が表示される
- launch.jsonでデバッグ設定を編集する際に、有効な値の候補が表示される
- keybindings.jsonでキーバインドを設定する際に、コマンドIDの補完が利用できる

**主要な処理内容**：
1. JSONドキュメントの言語識別と適切なスキーマの関連付け
2. 補完候補の提供（CompletionItemProvider）
3. ドキュメント内の設定値に対するホバー情報の表示
4. GitHub Gist連携によるプロファイル共有

**関連システム・外部連携**：VS Code設定システム、JSONスキーマサービス、GitHub API

**権限による制御**：信頼されていないワークスペースでもサポート

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | エディタ領域 | 主画面 | settings.json等の編集と補完 |
| 21 | 設定ビュー | 参照元 | 設定GUIからJSONを開く操作 |

## 機能種別

インテリセンス補完 / JSONスキーマ検証 / ドキュメントヘルパー

## 入力仕様

### 入力パラメータ

対象ファイル種別と対応するスキーマ：

| ファイル | スキーマURL | 説明 |
|---------|------------|------|
| settings.json | vscode://schemas/settings/user | ユーザー設定 |
| keybindings.json | vscode://schemas/keybindings | キーバインド |
| launch.json | vscode://schemas/launch | デバッグ設定 |
| tasks.json | vscode://schemas/tasks | タスク設定 |
| *.code-workspace | vscode://schemas/workspaceConfig | ワークスペース設定 |
| extensions.json | vscode://schemas/extensions | 拡張機能推奨設定 |
| mcp.json | vscode://schemas/mcp | MCP設定 |

### 入力データソース

- 編集中のJSONドキュメント
- VS Code内蔵のJSONスキーマ
- カーソル位置情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| completionItems | CompletionItem[] | 補完候補の配列 |
| hoverInformation | Hover | ホバー時の説明情報 |
| diagnostics | Diagnostic[] | 検証エラー・警告 |

### 出力先

- エディタ内補完リスト
- ホバーポップアップ
- 問題パネル（診断情報）

## 処理フロー

### 処理シーケンス

```
1. 拡張機能のアクティベーション
   └─ onLanguage:json / onLanguage:jsoncで起動

2. ドキュメント判定
   └─ ファイルパスからスキーマを決定

3. 補完トリガー
   └─ ユーザーが入力または補完を要求

4. 補完候補の生成
   └─ SettingsDocumentHelperで候補を計算

5. 候補の表示
   └─ VS Codeの補完UIに表示

6. 選択と挿入
   └─ 選択された候補をドキュメントに挿入
```

### フローチャート

```mermaid
flowchart TD
    A[JSON/JSONCファイルを開く] --> B{設定ファイル?}
    B -->|Yes| C[スキーマ関連付け]
    B -->|No| D[標準JSON処理]
    C --> E[補完トリガー]
    E --> F[SettingsDocumentHelper]
    F --> G{カーソル位置}
    G -->|プロパティ名| H[設定キー候補]
    G -->|値| I[値候補/スニペット]
    G -->|キー位置 keybindings| J[コマンドID候補]
    H --> K[補完リスト表示]
    I --> K
    J --> K
    K --> L[ユーザー選択]
    L --> M[挿入処理]
    D --> N[終了]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-84-1 | スキーマ自動判定 | ファイルパスからスキーマを自動決定 | settings.json等 |
| BR-84-2 | デフォルト値表示 | 設定のデフォルト値を補完候補に表示 | 値の補完時 |
| BR-84-3 | 非推奨設定警告 | deprecatedな設定は警告表示 | 検証時 |
| BR-84-4 | プロファイルハンドラー | GitHubプロファイル連携を提供 | onProfileイベント |

### スキーママッピング

```json
{
  "settings.json": "vscode://schemas/settings/user",
  "launch.json": "vscode://schemas/launch",
  "tasks.json": "vscode://schemas/tasks",
  "keybindings.json": "vscode://schemas/keybindings",
  "*.code-workspace": "vscode://schemas/workspaceConfig"
}
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | 非推奨設定の使用 | Diagnosticで警告表示 |
| - | エラー | JSON構文エラー | 問題パネルに表示 |

### リトライ仕様

補完候補取得でのリトライは行わない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 補完候補は入力に応じてリアルタイムに計算
- 大規模なスキーマでもスムーズな補完を維持

## セキュリティ考慮事項

- 信頼されていないワークスペースでもサポート
- 仮想ワークスペースでもサポート
- GitHub Gist連携ではOAuthトークンを使用

## 備考

- jsonc-parserライブラリを使用してJSON解析
- JSONC（コメント付きJSON）をサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.json | `extensions/configuration-editing/package.json` | jsonValidationとlanguages定義（68-172行目） |

**読解のコツ**: `contributes.jsonValidation`でファイルパターンとスキーマURLのマッピングを定義。settings.json、launch.json等の設定ファイルがどのスキーマに関連付けられるかを確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | configurationEditingMain.ts | `extensions/configuration-editing/src/configurationEditingMain.ts` | activate関数とプロバイダー登録 |

**主要処理フロー**:
1. 言語機能プロバイダー（CompletionItemProvider、DocumentSymbolProvider）の登録
2. プロファイルハンドラーの登録

#### Step 3: 補完ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | settingsDocumentHelper.ts | `extensions/configuration-editing/src/settingsDocumentHelper.ts` | SettingsDocumentクラス |

**主要処理フロー**:
- provideCompletionItems: カーソル位置に応じた補完候補生成
- provideDocumentSymbols: ドキュメント内のシンボル一覧
- SmartSnippet: コンテキストに応じたスニペット生成

### プログラム呼び出し階層図

```
activate() [configurationEditingMain.ts]
    │
    ├─ registerDocumentSymbolProvider()
    │      └─ SettingsDocument.provideDocumentSymbols()
    │
    ├─ registerCompletionItemProvider()
    │      └─ SettingsDocument.provideCompletionItems()
    │             │
    │             ├─ jsonc-parser.parseTree()
    │             │
    │             ├─ findNodeAtLocation()
    │             │
    │             └─ createCompletionItem()
    │
    └─ registerDocumentRangeFormattingEditProvider()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

JSONドキュメント     ──▶ jsonc-parser.parseTree()
                            │
                            ▼
カーソル位置         ──▶ findNodeAtLocation()        ──▶ 現在のノード特定
                            │
                            ▼
スキーマ定義         ──▶ スキーマ参照               ──▶ プロパティ候補
                            │
                            ▼
                      createCompletionItem()        ──▶ CompletionItem[]
                            │
                            ▼
                      VS Code補完UI                 ──▶ ユーザーに表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| configurationEditingMain.ts | `extensions/configuration-editing/src/configurationEditingMain.ts` | ソース | エントリーポイント、プロバイダー登録 |
| settingsDocumentHelper.ts | `extensions/configuration-editing/src/settingsDocumentHelper.ts` | ソース | 補完ロジック、ドキュメントヘルパー |
| package.json | `extensions/configuration-editing/package.json` | 設定 | JSONValidation定義、スキーママッピング |
| schemas/ | `extensions/configuration-editing/schemas/` | リソース | 追加のJSONスキーマ定義 |
