# 機能設計書 88-シンプルブラウザ

## 概要

本ドキュメントは、VS Codeの「シンプルブラウザ（simple-browser）」機能の設計内容を記載する。エディタ内でWebページを表示するシンプルなブラウザ機能を提供する。

### 本機能の処理概要

simple-browser拡張機能は、VS Codeのエディタ領域内でWebページを表示するWebview ベースのブラウザを提供する。ローカルサーバーのプレビューや外部URL のクイック表示に使用される。

**業務上の目的・背景**：Web開発において、ローカルサーバーで動作するアプリケーションを確認するために外部ブラウザに切り替える手間を省く。開発環境内でのプレビュー確認を効率化する。

**機能の利用シーン**：
- ローカル開発サーバー（localhost:3000等）のプレビュー表示
- ポート転送されたリモートサーバーの表示
- 外部URLのクイック表示

**主要な処理内容**：
1. URLを指定してWebviewパネルを開く
2. HTTP/HTTPSプロトコルに対応
3. ローカルホスト（localhost、127.0.0.1等）の優先対応
4. 統合ブラウザへの切り替えオプション

**関連システム・外部連携**：VS Code Webview API、外部URIオープナーAPI

**権限による制御**：信頼されていないワークスペースでもサポート

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | エディタ領域 | 主画面 | Webページの表示 |
| 1 | コマンドパレット | 入力UI | URL入力・コマンド実行 |

## 機能種別

Webviewブラウザ / 外部URIオープナー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| url | string | Yes | 表示するURL | http/httpsプロトコル |

### コマンド

| コマンド名 | 説明 |
|-----------|------|
| simpleBrowser.show | URLを入力してブラウザを開く |
| simpleBrowser.api.open | API経由でブラウザを開く（拡張機能用） |

### 設定項目

| 設定名 | 型 | 説明 | デフォルト |
|-------|-----|------|----------|
| simpleBrowser.focusLockIndicator.enabled | boolean | フォーカスロックインジケーター表示 | true |
| simpleBrowser.useIntegratedBrowser | boolean | 統合ブラウザを使用（実験的） | false |

### 対応ホスト

```javascript
const enabledHosts = [
  'localhost',
  '127.0.0.1',          // localhost IPv4
  '[0:0:0:0:0:0:0:1]',  // localhost IPv6
  '[::1]',               // localhost IPv6短縮
  '0.0.0.0',             // all interfaces IPv4
  '[0:0:0:0:0:0:0:0]',  // all interfaces IPv6
  '[::]'                 // all interfaces IPv6短縮
];
```

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| webviewPanel | WebviewPanel | ブラウザパネル |

### 出力先

エディタ領域（Webviewパネル）

## 処理フロー

### 処理シーケンス

```
1. コマンド実行
   └─ simpleBrowser.showまたはAPI呼び出し

2. URL入力（showコマンドの場合）
   └─ InputBoxでURL入力

3. 統合ブラウザ確認
   └─ useIntegratedBrowser設定をチェック

4. SimpleBrowserManager.show呼び出し
   └─ 既存パネルがあれば再利用

5. Webviewパネル作成
   └─ SimpleBrowserViewを初期化

6. URLの表示
   └─ iframeでWebページを埋め込み

7. パネル状態の管理
   └─ シリアライズ/デシリアライズ対応
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド実行] --> B{コマンド種別}
    B -->|simpleBrowser.show| C[URL入力ダイアログ]
    B -->|simpleBrowser.api.open| D[URL直接指定]
    B -->|ExternalUriOpener| E[外部URLオープン要求]
    C --> F{URL入力あり?}
    F -->|Yes| G[URL取得]
    F -->|No| H[終了]
    D --> G
    E --> G
    G --> I{useIntegratedBrowser?}
    I -->|Yes| J[統合ブラウザで開く]
    I -->|No| K[SimpleBrowserManager.show]
    K --> L{既存パネルあり?}
    L -->|Yes| M[既存パネルにURL設定]
    L -->|No| N[新規パネル作成]
    M --> O[Webページ表示]
    N --> O
    J --> H
    O --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-88-1 | ローカルホスト優先 | enabledHostsはデフォルトまたはオプション優先度 | ExternalUriOpener |
| BR-88-2 | Web環境デフォルト | Webブラウザ環境ではデフォルト優先度 | isWeb()がtrue |
| BR-88-3 | パネル再利用 | 既存のSimpleBrowserパネルはURL更新で再利用 | 常時 |
| BR-88-4 | シリアライズ対応 | パネル状態をシリアライズして復元可能 | パネル再開時 |

### ExternalUriOpener優先度

```javascript
// ローカルホストの場合
return isWeb()
  ? ExternalUriOpenerPriority.Default
  : ExternalUriOpenerPriority.Option;

// その他の場合
return ExternalUriOpenerPriority.None;
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 情報 | URL入力なし | 何もせず終了 |
| - | 表示 | Webページ読み込みエラー | iframeのエラー表示 |

### リトライ仕様

リトライは行わない。ユーザーが再度URLを入力して開く。

## トランザクション仕様

該当なし

## パフォーマンス要件

- Webviewの初期化は即時
- iframeの読み込みはネットワーク依存

## セキュリティ考慮事項

- 信頼されていないワークスペースでもサポート
- 仮想ワークスペースでもサポート
- externalUriOpener APIを使用（提案API）

## 備考

- テレメトリ送信あり（@vscode/extension-telemetry）
- vscode-webview型定義を使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.json | `extensions/simple-browser/package.json` | コマンドと設定項目 |
| 1-2 | extension.ts | `extensions/simple-browser/src/extension.ts` | enabledHosts定義（20-32行目） |

**読解のコツ**: enabledHostsでローカルホストのバリエーション（IPv4、IPv6）を定義。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extension.ts | `extensions/simple-browser/src/extension.ts` | activate関数（57-121行目） |

**主要処理フロー**:
1. **59行目**: SimpleBrowserManager作成
2. **62-66行目**: WebviewPanelSerializer登録
3. **68-83行目**: showCommand登録
4. **85-94行目**: openApiCommand登録
5. **96-120行目**: ExternalUriOpener登録

#### Step 3: ブラウザ管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | simpleBrowserManager.ts | `extensions/simple-browser/src/simpleBrowserManager.ts` | SimpleBrowserManagerクラス |
| 3-2 | simpleBrowserView.ts | `extensions/simple-browser/src/simpleBrowserView.ts` | SimpleBrowserViewクラス |

**主要処理フロー**:
- **22-31行目**: show()でパネル表示/再利用
- **34-39行目**: restore()でパネル復元

### プログラム呼び出し階層図

```
activate() [57行目]
    │
    ├─ SimpleBrowserManager() [59行目]
    │
    ├─ registerWebviewPanelSerializer() [62行目]
    │      └─ manager.restore() [64行目]
    │
    ├─ registerCommand('simpleBrowser.show') [68行目]
    │      │
    │      ├─ shouldUseIntegratedBrowser() [69行目]
    │      │      └─ openInIntegratedBrowser() [70行目]
    │      │
    │      └─ showInputBox() [73-77行目]
    │             └─ manager.show() [81行目]
    │
    ├─ registerCommand('simpleBrowser.api.open') [85行目]
    │      └─ manager.show() [92行目]
    │
    └─ registerExternalUriOpener() [96行目]
           │
           ├─ canOpenExternalUri() [97-107行目]
           │
           └─ openExternalUri() [108-116行目]
                  └─ manager.show() [112-114行目]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンド実行         ──▶ showCommand / apiOpenCommand
または                      │
ExternalUriOpen            ▼
                      shouldUseIntegratedBrowser() [39行目]
                            │
                      ┌─────┴─────┐
                      ▼           ▼
             統合ブラウザ    SimpleBrowserManager.show()
                                  │
                                  ▼
                      SimpleBrowserView.create() [27行目]
                      または
                      view.show() [25行目] （既存パネル）
                                  │
                                  ▼
                      Webviewパネル表示         ──▶ エディタ領域
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extension.ts | `extensions/simple-browser/src/extension.ts` | ソース | エントリーポイント、コマンド登録 |
| simpleBrowserManager.ts | `extensions/simple-browser/src/simpleBrowserManager.ts` | ソース | パネル管理 |
| simpleBrowserView.ts | `extensions/simple-browser/src/simpleBrowserView.ts` | ソース | Webviewパネル実装 |
| package.json | `extensions/simple-browser/package.json` | 設定 | マニフェスト |
| media/ | `extensions/simple-browser/media/` | リソース | Webview内スクリプト・スタイル |
