# 機能設計書 89-マージコンフリクト

## 概要

本ドキュメントは、VS Codeの「マージコンフリクト（merge-conflict）」機能の設計内容を記載する。Gitマージコンフリクトの検出、視覚的なハイライト表示、および解決支援機能を提供する。

### 本機能の処理概要

merge-conflict拡張機能は、ファイル内のGitマージコンフリクトマーカー（<<<<<<<、=======、>>>>>>>）を検出し、視覚的にハイライト表示する。また、ワンクリックでコンフリクトを解決するCodeLensアクションを提供する。

**業務上の目的・背景**：Gitを使用した共同開発において、マージコンフリクトは頻繁に発生する。コンフリクト箇所を視覚的に識別し、迅速に解決できる支援機能により、開発者の生産性を向上させる。

**機能の利用シーン**：
- git mergeやgit rebase後のコンフリクト解決
- プルリクエストのマージ時のコンフリクト解決
- 複数のブランチを統合する際のコンフリクト管理

**主要な処理内容**：
1. ファイル内のコンフリクトマーカー検出
2. Current/Incomingセクションのハイライト表示
3. CodeLensによる解決アクション表示
4. ナビゲーションコマンド（次/前のコンフリクト）
5. 差分ビューでのコンフリクト比較

**関連システム・外部連携**：Gitソース管理、VS Code差分エディタ

**権限による制御**：信頼されていないワークスペースでもサポート

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | エディタ領域 | 主画面 | コンフリクトハイライト、CodeLens表示 |
| 24 | ソース管理ビュー | 連携画面 | コンフリクトファイル一覧 |
| 22 | エディタータイトルバー | 補助機能 | 前/次のコンフリクトボタン |

## 機能種別

コンフリクト検出 / 視覚化 / CodeLens / ナビゲーション

## 入力仕様

### 入力パラメータ

コンフリクトマーカー：

| マーカー | 説明 |
|---------|------|
| <<<<<<< | コンフリクト開始（Currentセクション開始） |
| \|\|\|\|\|\|\| | 共通祖先マーカー（オプション） |
| ======= | セクション区切り |
| >>>>>>> | コンフリクト終了（Incomingセクション終了） |

### 設定項目

| 設定名 | 型 | 説明 | デフォルト |
|-------|-----|------|----------|
| merge-conflict.codeLens.enabled | boolean | CodeLens表示 | true |
| merge-conflict.decorators.enabled | boolean | デコレーター表示 | true |
| merge-conflict.autoNavigateNextConflict.enabled | boolean | 解決後に自動で次へ移動 | false |
| merge-conflict.diffViewPosition | string | 差分ビュー位置 | "Current" |

### 入力データソース

- 編集中のテキストドキュメント
- ワークスペース設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| decorations | TextEditorDecorationType | ハイライト装飾 |
| codeLenses | CodeLens[] | 解決アクション |
| diagnostics | Diagnostic[] | コンフリクト情報 |

### 出力先

- エディタ内デコレーション
- CodeLens表示
- エディタータイトルバー（ナビゲーションボタン）

## 処理フロー

### 処理シーケンス

```
1. ドキュメントを開く/変更
   └─ DocumentTrackerがスキャン開始

2. コンフリクト検出
   └─ MergeConflictParserでマーカー解析

3. コンフリクト情報の構築
   └─ DocumentMergeConflict作成

4. 視覚化処理
   ├─ Decoratorがハイライト適用
   └─ CodeLensProviderがアクション表示

5. ユーザー操作
   ├─ Accept Current: Currentセクションを採用
   ├─ Accept Incoming: Incomingセクションを採用
   ├─ Accept Both: 両方を採用
   └─ Compare: 差分ビューで表示

6. 解決後処理
   └─ autoNavigateNextConflict設定に応じて次へ移動
```

### フローチャート

```mermaid
flowchart TD
    A[ドキュメントを開く] --> B{コンフリクトあり?}
    B -->|Yes| C[MergeConflictParser.scanDocument]
    B -->|No| D[終了]
    C --> E[コンフリクト情報構築]
    E --> F[Decorator適用]
    E --> G[CodeLens表示]
    F --> H[ユーザー操作待ち]
    G --> H
    H --> I{操作種別}
    I -->|Accept Current| J[Currentセクション適用]
    I -->|Accept Incoming| K[Incomingセクション適用]
    I -->|Accept Both| L[両方適用]
    I -->|Compare| M[差分ビュー表示]
    I -->|Next/Previous| N[コンフリクトナビゲーション]
    J --> O{autoNavigate?}
    K --> O
    L --> O
    O -->|Yes| P[次のコンフリクトへ]
    O -->|No| H
    N --> H
    M --> H
    P --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-89-1 | マーカー順序 | <<<<<<<、=======、>>>>>>>の順序で検出 | 常時 |
| BR-89-2 | 共通祖先 | \|\|\|\|\|\|\|マーカーはオプション | diff3スタイル |
| BR-89-3 | コンフリクトカウント | mergeConflictsCountコンテキストで個数管理 | 常時 |
| BR-89-4 | マージエディタ除外 | isMergeEditor時はコマンド無効 | 常時 |

### デコレーションカラー

```typescript
// Currentセクション: 緑系
// Incomingセクション: 青系
// スプリッター: グレー
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | 不完全なコンフリクトマーカー | パース中断、部分的に処理 |

### リトライ仕様

ドキュメント変更時に自動的に再スキャン。

## トランザクション仕様

該当なし

## パフォーマンス要件

- ドキュメント変更時のスキャンは即時実行
- 大きなファイルでも効率的なマーカー検索

## セキュリティ考慮事項

- 信頼されていないワークスペースでもサポート
- 仮想ワークスペースでもサポート

## 備考

- テレメトリ送信あり（@vscode/extension-telemetry）
- 3ウェイマージ（共通祖先付き）にも対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | interfaces.ts | `extensions/merge-conflict/src/interfaces.ts` | IDocumentMergeConflict、IDocumentMergeConflictDescriptor |
| 1-2 | mergeConflictParser.ts | `extensions/merge-conflict/src/mergeConflictParser.ts` | マーカー定義（10-13行目） |

**読解のコツ**: interfaces.tsでコンフリクト情報の構造を理解。current、incoming、splitter、commonAncestorsの関係を把握。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mergeConflictMain.ts | `extensions/merge-conflict/src/mergeConflictMain.ts` | activate関数 |
| 2-2 | services.ts | `extensions/merge-conflict/src/services.ts` | ServiceWrapperクラス |

**主要処理フロー**:
1. **9-13行目**: MergeConflictServicesを作成・開始
2. services.ts: **32-38行目**: 各サービス（DocumentTracker、CommandHandler、CodeLensProvider、Decorator）を初期化

#### Step 3: パーサーとデコレーターを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mergeConflictParser.ts | `extensions/merge-conflict/src/mergeConflictParser.ts` | MergeConflictParserクラス |
| 3-2 | mergeDecorator.ts | `extensions/merge-conflict/src/mergeDecorator.ts` | Decoratorクラス |

**主要処理フロー**:
- **24-86行目**: scanDocument()でコンフリクト検出
- **44-55行目**: 開始マーカー検出
- **62-79行目**: スプリッターと終了マーカー検出

### プログラム呼び出し階層図

```
activate() [mergeConflictMain.ts 9行目]
    │
    └─ MergeConflictServices() [services.ts 21行目]
           │
           └─ begin() [27行目]
                  │
                  ├─ DocumentTracker() [30行目]
                  │      │
                  │      └─ scanDocument() [呼び出し]
                  │             └─ MergeConflictParser.scanDocument() [24行目]
                  │
                  ├─ CommandHandler() [34行目]
                  │      │
                  │      ├─ accept.current
                  │      ├─ accept.incoming
                  │      ├─ accept.both
                  │      ├─ next
                  │      ├─ previous
                  │      └─ compare
                  │
                  ├─ CodeLensProvider() [35行目]
                  │      │
                  │      └─ provideCodeLenses()
                  │
                  ├─ ContentProvider() [36行目]
                  │
                  └─ Decorator() [37行目]
                         │
                         └─ デコレーション適用
```

### データフロー図

```
[入力]                    [処理]                         [出力]

テキストドキュメント ──▶ MergeConflictParser.scanDocument()
                            │
                            ▼
                      startHeaderMarker検出 [44行目]
                            │
                            ▼
                      commonAncestorsMarker検出 [58行目]
                            │
                            ▼
                      splitterMarker検出 [62行目]
                            │
                            ▼
                      endFooterMarker検出 [66行目]
                            │
                            ▼
                      DocumentMergeConflict[] [85行目]
                            │
        ┌───────────────────┼───────────────────┐
        ▼                   ▼                   ▼
Decorator              CodeLensProvider    CommandHandler
(ハイライト)           (アクション表示)    (コマンド実行)
        │                   │                   │
        ▼                   ▼                   ▼
エディタ装飾           CodeLens表示        テキスト編集
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mergeConflictMain.ts | `extensions/merge-conflict/src/mergeConflictMain.ts` | ソース | エントリーポイント |
| services.ts | `extensions/merge-conflict/src/services.ts` | ソース | サービス管理 |
| mergeConflictParser.ts | `extensions/merge-conflict/src/mergeConflictParser.ts` | ソース | コンフリクト解析 |
| documentMergeConflict.ts | `extensions/merge-conflict/src/documentMergeConflict.ts` | ソース | コンフリクトモデル |
| documentTracker.ts | `extensions/merge-conflict/src/documentTracker.ts` | ソース | ドキュメント監視 |
| commandHandler.ts | `extensions/merge-conflict/src/commandHandler.ts` | ソース | コマンド処理 |
| codelensProvider.ts | `extensions/merge-conflict/src/codelensProvider.ts` | ソース | CodeLens提供 |
| mergeDecorator.ts | `extensions/merge-conflict/src/mergeDecorator.ts` | ソース | デコレーション |
| contentProvider.ts | `extensions/merge-conflict/src/contentProvider.ts` | ソース | コンテンツ提供 |
| interfaces.ts | `extensions/merge-conflict/src/interfaces.ts` | ソース | 型定義 |
| package.json | `extensions/merge-conflict/package.json` | 設定 | マニフェスト |
