# 機能設計書 9-コードアクション

## 概要

本ドキュメントは、VS Codeエディタにおけるコードアクション機能の設計仕様を記載する。クイックフィックスとリファクタリング提案機能を実現する。

### 本機能の処理概要

コードアクション機能は、コードの問題点に対する修正提案（クイックフィックス）やリファクタリング操作を提供する機能である。電球アイコン（Light Bulb）で視覚的に提案の存在を示し、ユーザーの選択により自動的にコード修正を適用する。

**業務上の目的・背景**：ソフトウェア開発において、コードの品質向上とリファクタリングは継続的に行われる作業である。コードアクション機能により、エラーの自動修正、未使用インポートの削除、メソッドの抽出など、様々な改善操作をワンクリックで実行でき、開発者の負担を軽減しコード品質を向上させる。

**機能の利用シーン**：
- シンタックスエラーや型エラーの自動修正
- 未使用変数やインポートの削除
- メソッドやクラスの抽出リファクタリング
- インターフェース実装の自動生成
- 非推奨APIの更新提案

**主要な処理内容**：
1. コードアクショントリガー - カーソル位置変更、エラー発生、手動トリガーでアクション検索
2. プロバイダ問い合わせ - CodeActionProviderにコードアクションを要求
3. Light Bulb表示 - 利用可能なアクションがある場合、電球アイコンを表示
4. アクションリスト表示 - ユーザー操作でアクションリストをポップアップ表示
5. アクション適用 - 選択されたアクションを実行してコードを修正

**関連システム・外部連携**：Language Server Protocol経由で言語サーバーからコードアクションを取得。診断情報（Diagnostics）と連携してエラー修正を提案。

**権限による制御**：読み取り専用モードではコード変更を伴うアクションは無効。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | テキストエディタ | 主画面 | クイックフィックスとリファクタリング提案 |

## 機能種別

自動修正 / リファクタリング / ウィジェット表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| triggerType | CodeActionTriggerType | Yes | トリガー種別（Auto/Invoke） | 列挙値 |
| triggerAction | CodeActionTriggerSource | Yes | トリガーの発生源 | 列挙値 |
| filter | CodeActionFilter | No | アクション種別フィルター | - |
| autoApply | CodeActionAutoApply | No | 自動適用設定 | 列挙値 |
| includeDisabledActions | boolean | No | 無効アクションも表示 | true/false |

### 入力データソース

- カーソル位置変更イベント
- 診断情報（エラー、警告）
- 手動トリガー（Ctrl+.）
- Light Bulbクリック

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| codeActions | CodeActionItem[] | 利用可能なコードアクションリスト |
| edit | WorkspaceEdit | 適用する編集操作 |
| command | Command | 実行するコマンド |

### 出力先

- Light Bulbウィジェット（電球アイコン）
- コードアクションメニュー（ポップアップリスト）
- エディタ（コード修正適用）

## 処理フロー

### 処理シーケンス

```
1. トリガー検知
   └─ カーソル移動、エラー発生、手動トリガーを検知
2. CodeActionModel更新
   └─ 現在位置でのコードアクションを計算
3. プロバイダ問い合わせ
   └─ 登録済みCodeActionProviderにアクションを要求
4. Light Bulb表示判定
   └─ アクションがある場合、電球アイコンを表示
5. アクションリスト表示
   └─ ユーザー操作でアクションメニューを表示
6. アクション選択と適用
   └─ 選択されたアクションのeditまたはcommandを実行
```

### フローチャート

```mermaid
flowchart TD
    A[トリガー検知] --> B{トリガー種別}
    B -->|Auto| C[自動計算]
    B -->|Invoke| D[手動計算]
    C --> E[CodeActionModel.trigger]
    D --> E
    E --> F[CodeActionProvider問い合わせ]
    F --> G{アクションあり?}
    G -->|Yes| H[Light Bulb表示]
    G -->|No| I[Light Bulb非表示]
    H --> J{ユーザー操作}
    J -->|クリック| K[アクションリスト表示]
    J -->|Ctrl+.| K
    K --> L[アクション選択]
    L --> M[applyCodeAction]
    M --> N[WorkspaceEdit適用]
    M --> O[Command実行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 自動トリガー | カーソル移動やテキスト変更で自動的にアクション検索 | Auto設定時 |
| BR-002 | AIフィックス優先 | AIによる修正提案がある場合、自動適用オプション | 単一AIアクション時 |
| BR-003 | キーバインド解決 | アクションに対応するキーバインドを表示 | アクションリスト表示時 |
| BR-004 | プログレス表示 | 適用処理中はプログレスインジケーター表示 | 処理時間が500ms超過時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NO_ACTIONS | 情報 | 利用可能なアクションがない | メッセージ表示 |
| APPLY_ERROR | エラー | アクション適用失敗 | エラーログ出力 |

### リトライ仕様

特になし

## トランザクション仕様

コードアクションの適用はUndoスタックに積まれ、取り消し可能。

## パフォーマンス要件

- アクション検索: バックグラウンドで非同期実行
- プログレス表示: 500ms超過時に表示

## セキュリティ考慮事項

- 拡張機能からのコードアクションはサンドボックス内で実行

## 備考

コードアクションはLSP標準機能であり、多くの言語サーバーがサポート。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コードアクションの型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.ts | `src/vs/editor/contrib/codeAction/common/types.ts` | CodeActionItem, CodeActionSet, CodeActionTrigger |

#### Step 2: エントリーポイントを理解する

コントローラの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | codeActionController.ts | `src/vs/editor/contrib/codeAction/browser/codeActionController.ts` | CodeActionController |

**主要処理フロー**:
1. **51-57行目**: CodeActionController定義、ID登録
2. **86-87行目**: CodeActionModel作成、状態変更監視
3. **89-95行目**: LightBulbWidget初期化
4. **122-124行目**: showCodeActions() - アクションリスト表示
5. **130-143行目**: manualTriggerAtCurrentPosition() - 手動トリガー
6. **149行目以降**: applyCodeAction() - アクション適用

#### Step 3: モデル層を理解する

コードアクションモデルの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | codeActionModel.ts | `src/vs/editor/contrib/codeAction/browser/codeActionModel.ts` | CodeActionModel |

#### Step 4: ウィジェット層を理解する

Light BulbとメニューのUIを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lightBulbWidget.ts | `src/vs/editor/contrib/codeAction/browser/lightBulbWidget.ts` | LightBulbWidget |
| 4-2 | codeActionMenu.ts | `src/vs/editor/contrib/codeAction/browser/codeActionMenu.ts` | コードアクションメニュー |

### プログラム呼び出し階層図

```
CodeActionController
    │
    ├─ CodeActionModel
    │      ├─ trigger() - アクション計算トリガー
    │      └─ onDidChangeState - 状態変更イベント
    │
    ├─ CodeActionProvider.provideCodeActions()
    │      └─ 言語サーバー/拡張機能からアクション取得
    │
    ├─ LightBulbWidget
    │      ├─ show() - 電球表示
    │      └─ onClick - クリックイベント
    │
    ├─ showCodeActionList()
    │      └─ ActionWidgetService.show() - メニュー表示
    │
    └─ applyCodeAction()
           ├─ WorkspaceEdit適用
           └─ Command実行
```

### データフロー図

```
[入力]               [処理]                    [出力]

カーソル位置 ──▶ CodeActionModel.trigger() ──▶ トリガーイベント
                        │
                        ▼
診断情報 ──▶ CodeActionProvider ──▶ CodeActionItem[]
                        │
                        ▼
CodeActionItem[] ──▶ LightBulbWidget ──▶ 電球表示
                        │
                        ▼
ユーザー選択 ──▶ applyCodeAction() ──▶ コード修正
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| codeActionController.ts | `src/vs/editor/contrib/codeAction/browser/codeActionController.ts` | ソース | コードアクションコントローラ |
| codeActionModel.ts | `src/vs/editor/contrib/codeAction/browser/codeActionModel.ts` | ソース | コードアクションモデル |
| codeAction.ts | `src/vs/editor/contrib/codeAction/browser/codeAction.ts` | ソース | アクション適用処理 |
| lightBulbWidget.ts | `src/vs/editor/contrib/codeAction/browser/lightBulbWidget.ts` | ソース | 電球ウィジェット |
| codeActionMenu.ts | `src/vs/editor/contrib/codeAction/browser/codeActionMenu.ts` | ソース | アクションメニュー |
| types.ts | `src/vs/editor/contrib/codeAction/common/types.ts` | ソース | 型定義 |
