# 機能設計書 90-参照ビュー

## 概要

本ドキュメントは、VS Codeの「参照ビュー（references-view）」機能の設計内容を記載する。シンボルの参照、実装、呼び出し階層、型階層をツリー形式で表示・ナビゲートする機能を提供する。

### 本機能の処理概要

references-view拡張機能は、コードシンボルに対する参照、実装、呼び出し階層（Call Hierarchy）、型階層（Type Hierarchy）を専用のビューで表示する。ピークビュー（インライン表示）とは別に、サイドバーでの常駐表示と履歴管理を提供する。

**業務上の目的・背景**：大規模なコードベースにおいて、シンボルの使用箇所や呼び出し関係を把握することは重要。ピークビューは一時的な確認に適しているが、参照ビューは継続的なナビゲーションと履歴管理に適している。

**機能の利用シーン**：
- 関数がどこから呼び出されているかを調査
- インターフェースの実装箇所を一覧表示
- クラスの継承関係（スーパータイプ/サブタイプ）を確認
- 過去の参照検索履歴から再検索

**主要な処理内容**：
1. 参照検索とツリー表示（Find All References）
2. 実装検索（Go to Implementations）
3. 呼び出し階層表示（Call Hierarchy）
4. 型階層表示（Type Hierarchy）
5. 検索履歴の管理と再実行

**関連システム・外部連携**：VS Code言語サーバー（LSP）、各種言語プロバイダー

**権限による制御**：信頼されていないワークスペースでもサポート

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | サイドバー | 主画面 | 参照ビューパネル表示 |
| 2 | エディタ領域 | 連携画面 | 参照元へのナビゲーション |

## 機能種別

参照検索 / ツリー表示 / 階層表示 / ナビゲーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| uri | Uri | Yes | 対象ファイル | 有効なファイルパス |
| position | Position | Yes | カーソル位置 | ファイル内の有効な位置 |

### コマンド

| コマンド名 | 説明 | キーバインド |
|-----------|------|-------------|
| references-view.findReferences | 参照を検索 | Shift+Alt+F12 |
| references-view.findImplementations | 実装を検索 | - |
| references-view.showCallHierarchy | 呼び出し階層を表示 | Shift+Alt+H |
| references-view.showTypeHierarchy | 型階層を表示 | - |

### 設定項目

| 設定名 | 型 | 説明 | デフォルト |
|-------|-----|------|----------|
| references.preferredLocation | string | 優先表示場所（peek/view） | "peek" |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| treeView | TreeView | 参照ツリービュー |
| treeItems | TreeItem[] | ツリーアイテム一覧 |

### 出力先

サイドバーの「参照」ビューコンテナ

## 処理フロー

### 処理シーケンス

```
1. コマンド実行
   └─ 参照検索/実装検索/階層表示

2. LSPリクエスト
   └─ 言語サーバーにクエリ

3. 結果の取得
   └─ Location[]または階層情報

4. ツリーモデル構築
   └─ SymbolTreeInputを作成

5. ビュー表示
   └─ TreeViewにデータをセット

6. 履歴追加
   └─ TreeInputHistoryに追加

7. ナビゲーション
   └─ アイテムクリックでエディタにジャンプ
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド実行] --> B{コマンド種別}
    B -->|findReferences| C[vscode.executeReferenceProvider]
    B -->|findImplementations| D[vscode.executeImplementationProvider]
    B -->|showCallHierarchy| E[vscode.prepareCallHierarchy]
    B -->|showTypeHierarchy| F[vscode.prepareTypeHierarchy]
    C --> G[Location[]取得]
    D --> G
    E --> H[CallHierarchyItem取得]
    F --> I[TypeHierarchyItem取得]
    G --> J[ReferencesTreeInput作成]
    H --> K[CallHierarchyInput作成]
    I --> L[TypeHierarchyInput作成]
    J --> M[SymbolsTree.setInput]
    K --> M
    L --> M
    M --> N[TreeView更新]
    N --> O[履歴追加]
    O --> P[ユーザー操作待ち]
    P --> Q{操作種別}
    Q -->|アイテムクリック| R[エディタにジャンプ]
    Q -->|階層展開| S[子要素を取得]
    Q -->|履歴選択| T[再検索]
    R --> P
    S --> P
    T --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-90-1 | 優先表示場所 | references.preferredLocationでpeek/viewを切替 | 参照検索時 |
| BR-90-2 | 階層方向切替 | 呼び出し階層は受信/発信を切替可能 | Call Hierarchy |
| BR-90-3 | 型階層方向 | 型階層はスーパータイプ/サブタイプを切替可能 | Type Hierarchy |
| BR-90-4 | 履歴管理 | 過去の検索をFILO順で管理 | 常時 |
| BR-90-5 | ドラッグ&ドロップ | ツリーアイテムをエディタにドロップ可能 | 常時 |

### ツリーアイテムコンテキスト

```typescript
// contextValue
'file-item'       // ファイルノード
'reference-item'  // 参照ノード
'call-item'       // 呼び出しノード
'type-item'       // 型ノード
'history-item'    // 履歴ノード
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | メッセージ | 参照なし | "No results."メッセージ表示 |
| - | メッセージ | プロバイダーなし | 操作不可（コマンド無効化） |

### リトライ仕様

リトライは行わない。再検索はrefreshコマンドで実行。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 大量の参照結果でもスムーズなツリー表示
- 遅延読み込みで階層データを効率的に取得

## セキュリティ考慮事項

- 信頼されていないワークスペースでもサポート
- 仮想ワークスペースでもサポート

## 備考

- WordAnchorクラスで位置のトラッキングを実現
- EditorHighlightsクラスでエディタ内ハイライトを表示

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | references-view.d.ts | `extensions/references-view/src/references-view.d.ts` | SymbolTreeInput、SymbolItemNavigation等の型定義 |
| 1-2 | package.json | `extensions/references-view/package.json` | viewsContainers、views、commands定義 |

**読解のコツ**: SymbolTreeInputが入力の基本インターフェース。resolve()でモデルを解決し、TreeDataProviderを返す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extension.ts | `extensions/references-view/src/extension.ts` | activate関数 |

**主要処理フロー**:
1. **15行目**: SymbolsTree作成
2. **17行目**: references.register呼び出し
3. **18行目**: calls.register呼び出し
4. **19行目**: types.register呼び出し
5. **21-28行目**: setInput/getInput関数を返却

#### Step 3: ツリー管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tree.ts | `extensions/references-view/src/tree.ts` | SymbolsTreeクラス |
| 3-2 | tree.ts | `extensions/references-view/src/tree.ts` | TreeInputHistoryクラス |

**主要処理フロー**:
- **30-37行目**: TreeView作成
- **49-117行目**: setInput()でモデルをセット
- **119-129行目**: clearInput()で結果クリア
- **240-352行目**: TreeInputHistoryで履歴管理

### プログラム呼び出し階層図

```
activate() [extension.ts 13行目]
    │
    ├─ new SymbolsTree() [15行目]
    │      │
    │      └─ createTreeView() [31行目]
    │
    ├─ references.register() [17行目]
    │      │
    │      └─ registerCommand('findReferences')
    │             └─ tree.setInput(ReferencesTreeInput)
    │
    ├─ calls.register() [18行目]
    │      │
    │      └─ registerCommand('showCallHierarchy')
    │             └─ tree.setInput(CallHierarchyInput)
    │
    └─ types.register() [19行目]
           │
           └─ registerCommand('showTypeHierarchy')
                  └─ tree.setInput(TypeHierarchyInput)

SymbolsTree.setInput() [tree.ts 49行目]
    │
    ├─ input.resolve() [68行目]
    │      └─ モデル解決
    │
    ├─ _provider.update() [71行目]
    │
    ├─ _history.add() [84行目]
    │
    ├─ _navigation.update() [88行目]
    │
    └─ _tree.reveal() [93行目]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

エディタ位置         ──▶ コマンド実行
(uri, position)           │
                          ▼
                    vscode.executeXxxProvider
                          │
                          ▼
Location[]          ──▶ ReferencesTreeInput作成
または                    │
HierarchyItem             ▼
                    SymbolsTree.setInput() [49行目]
                          │
                          ├──▶ input.resolve()
                          │         │
                          │         ▼
                          │    TreeDataProvider
                          │
                          ├──▶ _provider.update() [71行目]
                          │
                          └──▶ TreeView更新           ──▶ サイドバー表示
                                    │
ユーザー操作         ──▶ _tree.reveal() / navigate    ──▶ エディタジャンプ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extension.ts | `extensions/references-view/src/extension.ts` | ソース | エントリーポイント |
| tree.ts | `extensions/references-view/src/tree.ts` | ソース | SymbolsTree、TreeInputHistory |
| references.ts | `extensions/references-view/src/references.ts` | ソース | 参照検索ロジック |
| calls.ts | `extensions/references-view/src/calls.ts` | ソース | 呼び出し階層ロジック |
| types.ts | `extensions/references-view/src/types.ts` | ソース | 型階層ロジック |
| navigation.ts | `extensions/references-view/src/navigation.ts` | ソース | ナビゲーション |
| highlights.ts | `extensions/references-view/src/highlights.ts` | ソース | エディタハイライト |
| utils.ts | `extensions/references-view/src/utils.ts` | ソース | ユーティリティ（WordAnchor等） |
| references-view.d.ts | `extensions/references-view/src/references-view.d.ts` | ソース | 型定義 |
| package.json | `extensions/references-view/package.json` | 設定 | マニフェスト |
