# 機能設計書 91-IPYNBサポート

## 概要

本ドキュメントは、VS Code拡張機能「ipynb」のJupyter Notebook（.ipynb）ファイルサポート機能に関する設計仕様を記載する。

### 本機能の処理概要

Jupyter Notebookファイル（.ipynb形式）をVS Code上で開き、編集、保存するための機能を提供する。IPYNBファイルは対話型のデータサイエンス・機械学習ワークフローで広く利用されており、コードセル・マークダウンセル・出力結果を含む複合的なドキュメント形式である。

**業務上の目的・背景**：データサイエンティスト、機械学習エンジニア、研究者がVS Code上でJupyter Notebookを直接編集できるようにすることで、外部のJupyter Lab/Notebookサーバーを起動せずに、統一されたIDE環境でノートブックを操作できるようにする。これにより、コード補完、デバッグ、バージョン管理などのVS Codeの豊富な機能をノートブック編集にも活用可能となる。

**機能の利用シーン**：
- .ipynbファイルを開いて対話的にPythonコードを実行する場合
- 既存のノートブックのセル内容を編集・追加・削除する場合
- ノートブックをJSON形式で保存し、他のJupyterクライアントとの互換性を維持する場合
- セルの実行結果（テキスト、画像、HTML等）を確認する場合

**主要な処理内容**：
1. IPYNBファイルの読み込み（JSON解析）とVS Code NotebookDocument形式への変換
2. セルメタデータ、ノートブックメタデータの管理
3. セル追加・削除・編集時のメタデータ同期
4. ノートブック保存時のJSON形式へのシリアライズ
5. nbformat 4.5以降で必要なセルIDの自動生成・管理

**関連システム・外部連携**：Jupyter Kernel（Python, R等の実行カーネル）との連携は別の拡張機能（Jupyter拡張）が担当。本機能はファイル形式のサポートに特化している。

**権限による制御**：特別な権限制御はなく、ファイルシステムへのアクセス権限に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | Notebookエディタ | 主画面 | セルの表示・編集・実行結果の表示 |
| - | エクスプローラー | 参照画面 | .ipynbファイルの選択・開く |

## 機能種別

データ変換処理 / ファイルシリアライズ・デシリアライズ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| content | Uint8Array | Yes | IPYNBファイルのバイナリ内容 | UTF-8デコード可能であること |
| token | CancellationToken | No | キャンセルトークン | - |

### 入力データソース

ファイルシステムから読み込まれる.ipynbファイル（JSON形式）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cells | NotebookCellData[] | セル配列（コードセル・マークダウンセル） |
| metadata | object | ノートブックメタデータ（カーネル情報、言語情報等） |

### 出力先

VS Code NotebookDocument内部表現

## 処理フロー

### 処理シーケンス

```
1. ファイル読み込み
   └─ Uint8ArrayをUTF-8文字列にデコード
2. JSON解析
   └─ 文字列をIPYNBオブジェクトにパース
3. セル変換
   └─ 各セルをNotebookCellData形式に変換
4. メタデータ抽出
   └─ ノートブックメタデータを抽出
5. NotebookData生成
   └─ 変換結果をNotebookDataとして返却
```

### フローチャート

```mermaid
flowchart TD
    A[ファイル読み込み] --> B[UTF-8デコード]
    B --> C[JSON解析]
    C --> D{解析成功?}
    D -->|Yes| E[セル変換]
    D -->|No| F[エラー返却]
    E --> G[メタデータ抽出]
    G --> H[NotebookData生成]
    H --> I[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-91-1 | セルID自動生成 | nbformat 4.5以上ではセルIDが必須 | 新規セル追加時 |
| BR-91-2 | 言語ID同期 | セル言語がノートブック既定言語と異なる場合、メタデータに記録 | セル言語変更時 |
| BR-91-3 | 実行カウント同期 | セル実行後、execution_countをメタデータに反映 | セル実行完了時 |

### 計算ロジック

- セルID生成: UUID生成後、ハイフンを除去し先頭8文字を使用
- セルIDの重複チェック: ノートブック内の全セルIDと照合

## データベース操作仕様

本機能はデータベースを使用しない（ファイルベース）。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | JSON解析エラー | 不正なJSON形式 | ユーザーに通知、空のNotebookを返却 |
| - | UTF-8デコードエラー | 不正なエンコーディング | ユーザーに通知 |

### リトライ仕様

リトライは不要（ファイル読み込み失敗はユーザー操作で再試行）

## トランザクション仕様

該当なし（ファイルシステム操作）

## パフォーマンス要件

大規模なノートブック（数百セル、大量の出力）でも2秒以内に読み込み完了すること。

## セキュリティ考慮事項

- ノートブック内の出力にHTMLが含まれる可能性があるため、レンダリング時にサニタイズが必要
- ファイルパスの検証は上位レイヤーで実施

## 備考

本拡張機能はJupyter NotebookのJSON形式（nbformat）に準拠。バージョン4.0以上をサポート。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

IPYNB形式とVS Code内部表現の対応関係を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | common.ts | `extensions/ipynb/src/common.ts` | CellMetadata型定義、セルの種類（code/markdown） |
| 1-2 | @jupyterlab/nbformat | 外部パッケージ | nbformat仕様の型定義 |

**読解のコツ**: `CellMetadata`はIPYNB JSONのセルメタデータに対応。`vscode`プロパティはVS Code固有の拡張メタデータ。

#### Step 2: エントリーポイントを理解する

拡張機能の起動ポイントと主要コンポーネントの登録。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ipynbMain.ts | `extensions/ipynb/src/ipynbMain.ts` | activate関数で各機能を初期化 |

**主要処理フロー**:
1. **9-15行目**: NotebookSerializerの登録（deserialize/serialize処理）
2. **16-20行目**: モデル同期機能の有効化

#### Step 3: デシリアライズ処理を理解する

IPYNBファイルからNotebookDocumentへの変換処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notebookSerializer.ts | `extensions/ipynb/src/notebookSerializer.ts` | deserializeNotebook関数 |
| 3-2 | deserializers.ts | `extensions/ipynb/src/deserializers.ts` | セル変換ロジック |

**主要処理フロー**:
- **deserializeNotebook**: JSONパース → セル配列変換 → NotebookData生成

#### Step 4: シリアライズ処理を理解する

NotebookDocumentからIPYNBファイルへの変換処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | serializers.ts | `extensions/ipynb/src/serializers.ts` | serializeNotebook関数 |

**主要処理フロー**:
- **serializeNotebook**: NotebookDocument → JSON変換 → UTF-8エンコード

#### Step 5: モデル同期処理を理解する

編集時のメタデータ同期処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | notebookModelStoreSync.ts | `extensions/ipynb/src/notebookModelStoreSync.ts` | onDidChangeNotebookCells関数 |

**主要処理フロー**:
- **26-29行目**: イベントリスナー登録
- **127-225行目**: セル変更時のメタデータ更新処理
- **241-261行目**: セルID生成ロジック

### プログラム呼び出し階層図

```
ipynbMain.ts (activate)
    │
    ├─ notebookSerializer.ts
    │      ├─ deserializeNotebook
    │      │      └─ deserializers.ts (セル変換)
    │      └─ serializeNotebook
    │             └─ serializers.ts (JSON生成)
    │
    └─ notebookModelStoreSync.ts
           ├─ onDidChangeNotebookCells (編集検知)
           └─ trackAndUpdateCellMetadata (メタデータ更新)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

.ipynbファイル ───▶ deserializeNotebook ───▶ NotebookDocument
(JSON)                    │
                          ├─ JSONパース
                          ├─ セル変換
                          └─ メタデータ抽出

NotebookDocument ───▶ serializeNotebook ───▶ .ipynbファイル
                          │                    (JSON)
                          ├─ セル変換
                          ├─ メタデータ構築
                          └─ JSON文字列化
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ipynbMain.ts | `extensions/ipynb/src/ipynbMain.ts` | ソース | 拡張機能エントリーポイント |
| notebookSerializer.ts | `extensions/ipynb/src/notebookSerializer.ts` | ソース | シリアライザ実装 |
| deserializers.ts | `extensions/ipynb/src/deserializers.ts` | ソース | デシリアライズロジック |
| serializers.ts | `extensions/ipynb/src/serializers.ts` | ソース | シリアライズロジック |
| notebookModelStoreSync.ts | `extensions/ipynb/src/notebookModelStoreSync.ts` | ソース | モデル同期 |
| common.ts | `extensions/ipynb/src/common.ts` | ソース | 共通型定義 |
| helper.ts | `extensions/ipynb/src/helper.ts` | ソース | ユーティリティ関数 |
| package.json | `extensions/ipynb/package.json` | 設定 | 拡張機能マニフェスト |
