# 機能設計書 92-ターミナル補完

## 概要

本ドキュメントは、VS Code拡張機能「terminal-suggest」の統合ターミナルにおけるコマンド補完機能に関する設計仕様を記載する。

### 本機能の処理概要

VS Codeの統合ターミナルにおいて、コマンド、サブコマンド、オプション、引数の入力補完を提供する機能。シェル固有のビルトインコマンドやPATH上の実行可能ファイル、git・npm・yarn等の主要CLIツールのサブコマンド補完をサポートする。

**業務上の目的・背景**：開発者がターミナル操作を行う際、コマンドやオプションの入力を効率化し、タイプミスを減少させる。特にgit、npm、yarn等の複雑なサブコマンド体系を持つCLIツールでは、補完なしでは生産性が低下する。IDEネイティブの補完機能を提供することで、外部ツールへの依存を減らし、一貫したユーザー体験を実現する。

**機能の利用シーン**：
- ターミナルでgitコマンドのサブコマンドやオプションを入力する場合
- npmやyarnのスクリプト名を補完する場合
- cdコマンドでディレクトリパスを補完する場合
- シェルビルトインコマンドを入力する場合

**主要な処理内容**：
1. ターミナル入力コンテキストの解析（コマンド・引数・オプションの識別）
2. シェル種別の判定（bash, zsh, fish, PowerShell等）
3. PATH環境変数からの実行可能ファイル一覧取得
4. シェル固有ビルトインコマンドの取得
5. Fig仕様に基づくコマンド補完スペックの評価
6. ファイル・ディレクトリパスの補完

**関連システム・外部連携**：Fig補完スペック形式との互換性を持ち、外部の補完定義を利用可能。

**権限による制御**：特別な権限制御はなく、ターミナルで実行可能なコマンドを補完対象とする。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 統合ターミナル | 主画面 | コマンド入力時の補完表示 |
| - | 補完ドロップダウン | 結果表示画面 | 補完候補の選択 |

## 機能種別

入力補完 / テキスト処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| terminal | vscode.Terminal | Yes | 対象ターミナルインスタンス | - |
| terminalContext | vscode.TerminalCompletionContext | Yes | 入力コンテキスト | commandLine, cursorIndexを含む |
| token | CancellationToken | No | キャンセルトークン | - |

### 入力データソース

- ターミナルの入力行（commandLine）とカーソル位置（cursorIndex）
- シェル統合から取得した環境変数（PATH等）
- シェル統合から取得した現在の作業ディレクトリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| items | TerminalCompletionItem[] | 補完候補アイテムの配列 |
| showFiles | boolean | ファイル補完を表示するか |
| showDirectories | boolean | ディレクトリ補完を表示するか |
| cwd | Uri | 補完用の現在ディレクトリ |

### 出力先

ターミナル補完UIへの補完候補リスト

## 処理フロー

### 処理シーケンス

```
1. シェル種別判定
   └─ terminal.state.shellからシェルタイプを取得
2. コマンドコンテキスト解析
   └─ commandLineからカーソル位置までの文字列を解析
3. PATH実行可能ファイル取得
   └─ 環境変数PATHのディレクトリから実行可能ファイルを列挙
4. シェルグローバル取得
   └─ シェル固有ビルトインコマンドを取得（キャッシュ付き）
5. Fig仕様スペック評価
   └─ コマンドに対応するスペックからサブコマンド・オプションを取得
6. 結果マージ・フィルタリング
   └─ 入力文字列でフィルタリングしてソート
7. 補完リスト返却
   └─ TerminalCompletionItem[]またはTerminalCompletionListを返却
```

### フローチャート

```mermaid
flowchart TD
    A[補完リクエスト受信] --> B[シェル種別判定]
    B --> C{サポート対象?}
    C -->|No| D[終了]
    C -->|Yes| E[コマンドコンテキスト解析]
    E --> F[PATH実行可能ファイル取得]
    F --> G[シェルグローバル取得]
    G --> H[Figスペック評価]
    H --> I{タイムアウト?}
    I -->|Yes| J[タイムアウト応答]
    I -->|No| K[結果マージ]
    K --> L[補完リスト返却]
    J --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-92-1 | シェルグローバルキャッシュ | ビルトインコマンドは7日間キャッシュ | 全てのシェル |
| BR-92-2 | タイムアウト | 補完取得は5秒でタイムアウト | 常時 |
| BR-92-3 | PATH監視 | PATHディレクトリの変更を監視しキャッシュ更新 | 常時 |
| BR-92-4 | シェル固有リセット文字 | シェルごとにコマンド区切り文字が異なる | コマンド解析時 |

### 計算ロジック

- キャッシュキー生成: `${machineId}:${remoteAuthority}:${shellType}`
- キャッシュ有効期限: 7日間（CACHE_MAX_AGE_MS = 1000 * 60 * 60 * 24 * 7）

## データベース操作仕様

本機能はデータベースを使用しない。キャッシュはファイルベースで管理。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | タイムアウト | 補完取得が5秒超過 | 空の補完リストを返却 |
| - | シェル未サポート | 未対応シェルタイプ | 補完なしで終了 |
| - | ビルトイン取得エラー | シェルコマンド実行失敗 | エラーログ出力、空配列返却 |

### リトライ仕様

リトライは不要（ユーザーの再入力で再トリガー）

## トランザクション仕様

該当なし

## パフォーマンス要件

- 補完応答は200ms以内を目標
- 最大タイムアウト5秒
- キャッシュによる2回目以降の高速化

## セキュリティ考慮事項

- 環境変数のサニタイズ（ELECTRON_*, VSCODE_*等を除外）
- ファイルシステムアクセスはシェル統合で取得したCWDに限定

## 備考

Fig仕様（https://fig.io/）と互換性のある補完スペック形式を採用。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

補完リソースとトークン種別の型定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.ts | `extensions/terminal-suggest/src/types.ts` | ICompletionResource型の定義 |
| 1-2 | tokens.ts | `extensions/terminal-suggest/src/tokens.ts` | TokenType（Command, Option, Argument等）の定義 |

**読解のコツ**: `ICompletionResource`は補完候補の基本単位。`TokenType`はカーソル位置のコンテキスト種別。

#### Step 2: エントリーポイントを理解する

拡張機能の起動と補完プロバイダの登録処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | terminalSuggestMain.ts | `extensions/terminal-suggest/src/terminalSuggestMain.ts` | activate関数、provideTerminalCompletions |

**主要処理フロー**:
1. **251-257行目**: activate関数でキャッシュ初期化
2. **263-329行目**: registerTerminalCompletionProviderで補完プロバイダ登録
3. **265-276行目**: シェル種別判定とサポートチェック
4. **278-286行目**: コマンド一覧の取得
5. **290-303行目**: スペック評価とタイムアウト処理

#### Step 3: シェルグローバル取得を理解する

シェル固有ビルトインコマンドの取得とキャッシュ処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | terminalSuggestMain.ts | `extensions/terminal-suggest/src/terminalSuggestMain.ts` | getShellGlobals関数（95-135行目） |
| 3-2 | bash.ts | `extensions/terminal-suggest/src/shell/bash.ts` | Bashビルトイン取得 |
| 3-3 | zsh.ts | `extensions/terminal-suggest/src/shell/zsh.ts` | Zshビルトイン取得 |
| 3-4 | pwsh.ts | `extensions/terminal-suggest/src/shell/pwsh.ts` | PowerShellビルトイン取得 |

**主要処理フロー**:
- **95-135行目**: キャッシュチェックと取得処理
- **137-194行目**: fetchAndCacheShellGlobals - 実際のシェルコマンド実行

#### Step 4: Figスペック評価を理解する

コマンド固有の補完定義の評価処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | figInterface.ts | `extensions/terminal-suggest/src/fig/figInterface.ts` | getFigSuggestions関数 |
| 4-2 | git.ts | `extensions/terminal-suggest/src/completions/git.ts` | gitコマンドのスペック定義（例） |

**主要処理フロー**:
- Figスペックからサブコマンド、オプション、引数の補完候補を生成
- ジェネレータによる動的補完候補の生成

#### Step 5: PATH実行可能ファイル取得を理解する

環境変数PATHからの実行可能ファイル列挙処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | pathExecutableCache.ts | `extensions/terminal-suggest/src/env/pathExecutableCache.ts` | getExecutablesInPath関数 |

**主要処理フロー**:
- PATHディレクトリの列挙
- 実行可能ファイルのフィルタリング
- ファイルシステム監視による動的更新

### プログラム呼び出し階層図

```
terminalSuggestMain.ts (activate)
    │
    ├─ registerTerminalCompletionProvider
    │      │
    │      ├─ getTerminalShellType (シェル種別判定)
    │      │
    │      ├─ pathExecutableCache.getExecutablesInPath
    │      │      └─ PATH実行可能ファイル列挙
    │      │
    │      ├─ getShellGlobals
    │      │      └─ shell/bash.ts, zsh.ts, pwsh.ts (ビルトイン取得)
    │      │
    │      ├─ getCompletionItemsFromSpecs
    │      │      └─ getFigSuggestions (Figスペック評価)
    │      │             └─ completions/*.ts (各コマンドスペック)
    │      │
    │      └─ resolveCwdFromCurrentCommandString
    │
    └─ watchPathDirectories (PATH監視)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ターミナル入力 ───▶ provideTerminalCompletions ───▶ TerminalCompletionItem[]
(commandLine)            │
                         ├─ シェル種別判定
                         ├─ PATH実行可能ファイル取得
                         ├─ シェルグローバル取得
                         ├─ Figスペック評価
                         └─ 結果マージ

キャッシュ
    ├─ cachedGlobals (メモリ)
    └─ terminalSuggestGlobalsCacheV2.json (ファイル)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| terminalSuggestMain.ts | `extensions/terminal-suggest/src/terminalSuggestMain.ts` | ソース | メインエントリーポイント |
| tokens.ts | `extensions/terminal-suggest/src/tokens.ts` | ソース | トークン種別定義 |
| types.ts | `extensions/terminal-suggest/src/types.ts` | ソース | 型定義 |
| pathExecutableCache.ts | `extensions/terminal-suggest/src/env/pathExecutableCache.ts` | ソース | PATH実行可能ファイルキャッシュ |
| figInterface.ts | `extensions/terminal-suggest/src/fig/figInterface.ts` | ソース | Figスペック評価 |
| bash.ts | `extensions/terminal-suggest/src/shell/bash.ts` | ソース | Bashビルトイン |
| zsh.ts | `extensions/terminal-suggest/src/shell/zsh.ts` | ソース | Zshビルトイン |
| pwsh.ts | `extensions/terminal-suggest/src/shell/pwsh.ts` | ソース | PowerShellビルトイン |
| fish.ts | `extensions/terminal-suggest/src/shell/fish.ts` | ソース | Fishビルトイン |
| git.ts | `extensions/terminal-suggest/src/completions/git.ts` | ソース | gitコマンドスペック |
| npm.ts | `extensions/terminal-suggest/src/completions/npm.ts` | ソース | npmコマンドスペック |
| yarn.ts | `extensions/terminal-suggest/src/completions/yarn.ts` | ソース | yarnコマンドスペック |
| package.json | `extensions/terminal-suggest/package.json` | 設定 | 拡張機能マニフェスト |
