# 機能設計書 93-Markdown数式

## 概要

本ドキュメントは、VS Code拡張機能「markdown-math」のMarkdownドキュメント内での数式レンダリング機能に関する設計仕様を記載する。

### 本機能の処理概要

Markdownドキュメント内のLaTeX形式の数式を、KaTeXライブラリを使用してレンダリングする機能。インライン数式（$...$）とブロック数式（$$...$$）、およびフェンスドコードブロック（```math```）をサポートし、Markdownプレビュー画面で美しい数式表現を実現する。

**業務上の目的・背景**：技術ドキュメント、研究論文、教育資料などでは数式の表現が必須となる。Markdown形式で文書を作成しながら、LaTeX形式の数式を直接記述・プレビューできることで、科学技術分野の開発者・研究者の生産性を向上させる。VS Code内で完結した数式編集環境を提供する。

**機能の利用シーン**：
- 技術ドキュメントに数式を含めてMarkdownで記述する場合
- README.mdに数学的な説明を追加する場合
- Jupyter Notebook風のドキュメントを作成する場合
- 学術論文の下書きをMarkdownで作成する場合

**主要な処理内容**：
1. markdown-itプラグインとしてKaTeXを統合
2. インライン数式（$...$）のパースとレンダリング
3. ブロック数式（$$...$$）のパースとレンダリング
4. フェンスドコードブロック数式（```math）のサポート
5. カスタムマクロの設定と適用
6. Markdownプレビュー用スタイルシートの提供

**関連システム・外部連携**：markdown-itレンダラー、KaTeXライブラリ、Notebookレンダラーとの連携。

**権限による制御**：特別な権限制御はなく、設定によりの有効/無効切り替えが可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | Markdownプレビュー | 主画面 | 数式のレンダリング表示 |
| - | Markdownエディタ | 参照画面 | 数式の記述・編集 |
| - | Notebookエディタ | 参照画面 | セル内数式のレンダリング |

## 機能種別

レンダリング処理 / プラグイン統合

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| markdown.math.enabled | boolean | No | 数式機能の有効/無効（デフォルト: true） | - |
| markdown.math.macros | object | No | カスタムマクロ定義 | キー:マクロ名、値:展開式 |

### 入力データソース

- Markdownドキュメントのテキスト内容
- VS Code設定（markdown.math.*）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| renderedHtml | string | KaTeXでレンダリングされた数式HTML |
| styles | CSS | 数式表示用スタイルシート |

### 出力先

Markdownプレビューパネル、Notebookセル出力

## 処理フロー

### 処理シーケンス

```
1. 拡張機能アクティベーション
   └─ activate関数の実行
2. markdown-it拡張
   └─ extendMarkdownItでKaTeXプラグインを登録
3. 設定読み込み
   └─ markdown.math.enabled/macrosの取得
4. 数式パース
   └─ markdown-itがテキストをパース
5. KaTeXレンダリング
   └─ 数式トークンをHTMLに変換
6. スタイル適用
   └─ CSSでフォーマット
```

### フローチャート

```mermaid
flowchart TD
    A[Markdownテキスト] --> B{数式機能有効?}
    B -->|No| C[通常レンダリング]
    B -->|Yes| D[KaTeXプラグイン適用]
    D --> E[インライン数式検出]
    D --> F[ブロック数式検出]
    D --> G[フェンスドブロック検出]
    E --> H[KaTeXレンダリング]
    F --> H
    G --> H
    H --> I[HTML出力]
    C --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-93-1 | デフォルト有効 | 数式機能はデフォルトで有効 | インストール直後 |
| BR-93-2 | 設定変更時リロード | 設定変更時にMarkdownプラグインをリロード | 設定変更検知時 |
| BR-93-3 | マクロリセット | 各ドキュメントレンダリング前にマクロをリセット | レンダリング開始時 |
| BR-93-4 | グローバルグループ | globalGroup有効でドキュメント全体でマクロ共有 | 常時 |

### 計算ロジック

- 数式構文: インライン `$...$`、ブロック `$$...$$`、フェンスドブロック ` ```math `
- マクロ展開: KaTeX標準のマクロ展開ロジック

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 数式構文エラー | 不正なLaTeX構文 | KaTeXエラーメッセージを表示 |
| - | マクロエラー | 不正なマクロ定義 | エラー表示、該当マクロをスキップ |

### リトライ仕様

リトライは不要（ユーザーが構文を修正して再プレビュー）

## トランザクション仕様

該当なし

## パフォーマンス要件

- 数式レンダリングは100ms以内を目標
- 大量の数式（100以上）でも2秒以内にプレビュー更新

## セキュリティ考慮事項

- KaTeXはXSS攻撃に対して安全（任意HTMLの実行を防止）
- untrustedWorkspacesでもサポート可能

## 備考

KaTeXはMathJaxより高速だが、一部のLaTeXコマンドは未サポート。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 設定構造を理解する

拡張機能の設定項目を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.json | `extensions/markdown-math/package.json` | configuration（86-106行目）の設定項目 |

**読解のコツ**: `markdown.math.enabled`と`markdown.math.macros`の2つの設定が主要。

#### Step 2: エントリーポイントを理解する

拡張機能の起動と設定監視。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extension.ts | `extensions/markdown-math/src/extension.ts` | activate関数の全体構造 |

**主要処理フロー**:
1. **11-15行目**: activate関数とisEnabled判定
2. **17-20行目**: getMacros関数でマクロ設定取得
3. **22-26行目**: 設定変更時のリロード処理
4. **28-45行目**: extendMarkdownIt関数によるプラグイン登録

#### Step 3: markdown-it統合を理解する

KaTeXプラグインの適用処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extension.ts | `extensions/markdown-math/src/extension.ts` | extendMarkdownIt関数（29-44行目） |

**主要処理フロー**:
- **30行目**: isEnabled()で有効性チェック
- **31行目**: @vscode/markdown-it-katexのrequire
- **33-37行目**: KaTeXオプション設定（enableFencedBlocks, globalGroup, macros）
- **38-40行目**: マクロリセットルールの登録
- **41行目**: md.use(katex, options)でプラグイン適用

#### Step 4: 構文ハイライト定義を理解する

TextMate文法による数式構文のハイライト。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | md-math-block.tmLanguage.json | `extensions/markdown-math/syntaxes/md-math-block.tmLanguage.json` | ブロック数式の構文定義 |
| 4-2 | md-math-inline.tmLanguage.json | `extensions/markdown-math/syntaxes/md-math-inline.tmLanguage.json` | インライン数式の構文定義 |
| 4-3 | md-math-fence.tmLanguage.json | `extensions/markdown-math/syntaxes/md-math-fence.tmLanguage.json` | フェンスドブロックの構文定義 |

**主要処理フロー**:
- 各ファイルはTextMate文法でMarkdown内の数式部分を検出
- `embeddedLanguages`で`latex`言語として認識

### プログラム呼び出し階層図

```
extension.ts (activate)
    │
    ├─ isEnabled() - 有効性チェック
    │
    ├─ getMacros() - マクロ設定取得
    │
    ├─ onDidChangeConfiguration - 設定変更監視
    │      └─ markdown.api.reloadPlugins - プラグインリロード
    │
    └─ extendMarkdownIt(md)
           │
           ├─ require('@vscode/markdown-it-katex')
           │
           ├─ md.core.ruler.push('reset-katex-macros')
           │
           └─ md.use(katex, options)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Markdownテキスト ───▶ markdown-it ───▶ HTMLプレビュー
    │                      │
    │                      ├─ extendMarkdownIt
    │                      │      └─ KaTeX変換
    │                      │
    └─ 設定              └─ スタイルシート適用
       (macros)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extension.ts | `extensions/markdown-math/src/extension.ts` | ソース | 拡張機能エントリーポイント |
| package.json | `extensions/markdown-math/package.json` | 設定 | 拡張機能マニフェスト |
| md-math.tmLanguage.json | `extensions/markdown-math/syntaxes/md-math.tmLanguage.json` | 構文定義 | 数式言語定義 |
| md-math-block.tmLanguage.json | `extensions/markdown-math/syntaxes/md-math-block.tmLanguage.json` | 構文定義 | ブロック数式構文 |
| md-math-inline.tmLanguage.json | `extensions/markdown-math/syntaxes/md-math-inline.tmLanguage.json` | 構文定義 | インライン数式構文 |
| md-math-fence.tmLanguage.json | `extensions/markdown-math/syntaxes/md-math-fence.tmLanguage.json` | 構文定義 | フェンスドブロック構文 |
| katex.min.css | `extensions/markdown-math/notebook-out/katex.min.css` | スタイル | KaTeX用CSS |
| index.css | `extensions/markdown-math/preview-styles/index.css` | スタイル | プレビュー用CSS |
| katex.js | `extensions/markdown-math/notebook-out/katex.js` | スクリプト | Notebookレンダラー |
