# 機能設計書 94-トンネル転送

## 概要

本ドキュメントは、VS Code拡張機能「tunnel-forwarding」のポートフォワーディング機能に関する設計仕様を記載する。

### 本機能の処理概要

VS Codeのローカル環境で実行中のサービス（Webサーバー等）を、インターネット経由で外部からアクセス可能にするトンネリング機能。code-tunnel CLIを使用してGitHub認証を行い、パブリックまたはプライベートなポート転送を実現する。

**業務上の目的・背景**：開発中のWebアプリケーションを、外部のデバイス（モバイル端末等）や他の開発者と共有する際、ローカルサーバーを一時的にインターネット公開する必要がある。ngrokなどの外部ツールに依存せず、VS Code内蔵の機能として安全なポート転送を提供する。これにより、デモ、テスト、ペアプログラミングなどのワークフローが効率化される。

**機能の利用シーン**：
- ローカルのWebサーバーをモバイルデバイスでテストする場合
- 開発中のAPIを外部サービスのWebhookテストに使用する場合
- チームメンバーに開発中の機能をデモする場合
- リモートペアプログラミングでローカル環境を共有する場合

**主要な処理内容**：
1. GitHub認証によるユーザー認証
2. code-tunnel CLIプロセスの起動と管理
3. ポート転送リクエストの処理
4. パブリック/プライベートアクセス制御
5. HTTP/HTTPSプロトコルサポート
6. アクティブポートの動的管理

**関連システム・外部連携**：GitHub認証API、code-tunnel CLI、VS Codeトンネルプロバイダー API。

**権限による制御**：GitHub認証が必須。パブリック転送には追加の同意確認が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ポートパネル | 主画面 | ポート転送の設定・管理 |
| - | 通知 | 結果表示画面 | 転送開始・エラーの通知 |
| - | 出力チャンネル | 参照画面 | ログの表示 |

## 機能種別

ネットワーク処理 / プロセス管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| remoteAddress.port | number | Yes | 転送するローカルポート番号 | 有効なポート番号 |
| remoteAddress.host | string | Yes | ホスト名（通常localhost） | - |
| privacy | TunnelPrivacyId | No | public/private（デフォルト: private） | - |
| protocol | string | No | http/https（デフォルト: http） | - |

### 入力データソース

- VS Codeポート検出機能からの転送リクエスト
- ユーザーによる手動ポート追加

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| localAddress | string | 外部アクセス用URL |
| remoteAddress | object | ローカルポート情報 |
| privacy | TunnelPrivacyId | プライバシー設定 |

### 出力先

VS Codeトンネルプロバイダー経由でポートパネルに表示

## 処理フロー

### 処理シーケンス

```
1. トンネルリクエスト受信
   └─ provideTunnel呼び出し
2. パブリック転送の場合、同意確認
   └─ consentPublicPort
3. CLIプロセス状態チェック
   └─ State判定（Inactive/Starting/Active/Error）
4. 必要に応じてCLI起動
   └─ setupPortForwardingProcess
5. GitHub認証
   └─ getSession('github', ['user:email', 'read:org'])
6. アクティブポート更新
   └─ updateActivePortsIfRunning
7. ポートフォーマット設定
   └─ setPortFormat
```

### フローチャート

```mermaid
flowchart TD
    A[ポート転送リクエスト] --> B{パブリック?}
    B -->|Yes| C[同意確認]
    B -->|No| D[Tunnel作成]
    C -->|同意| D
    C -->|拒否| E[終了]
    D --> F{CLI状態?}
    F -->|Inactive/Error| G[CLI起動]
    F -->|Starting| H[起動待機]
    F -->|Active| I[ポート追加]
    G --> J[GitHub認証]
    J --> H
    H --> K[Active状態へ]
    K --> I
    I --> L[URL返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-94-1 | パブリック警告 | パブリック転送時に警告表示 | privacy=public |
| BR-94-2 | クリーンアップタイムアウト | 最後のポート終了後10秒でCLI停止 | 全ポート終了時 |
| BR-94-3 | ローカル専用 | リモート環境では無効 | remoteAuthority存在時 |
| BR-94-4 | デフォルトプライベート | 明示指定なしはprivate | privacy未指定時 |

### 計算ロジック

- URLフォーマット: `{portFormat}`.replace('{port}', portNumber)
- クリーンアップタイムアウト: 10,000ms（CLEANUP_TIMEOUT）

## データベース操作仕様

本機能はデータベースを使用しない。状態はメモリ内で管理。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CLI起動エラー | code-tunnelが見つからない | エラーログ出力、State.Error設定 |
| - | 認証エラー | GitHub認証失敗 | 認証フロー再試行 |
| - | プロセス終了 | 予期しないCLI終了 | State.Error設定、エラーメッセージ表示 |

### リトライ仕様

restart()コマンドで手動リトライ可能

## トランザクション仕様

該当なし

## パフォーマンス要件

- CLI起動は5秒以内
- ポート追加はActive状態で即座に反映

## セキュリティ考慮事項

- GitHub認証による本人確認
- パブリック転送時の警告表示
- アクセストークンは環境変数経由でCLIに渡す
- 警告表示の「今後表示しない」設定はglobalStateに保存

## 備考

code-tunnelはVS Code CLIの一部として配布される。開発環境ではデバッグビルドを使用可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

状態管理とTunnelオブジェクトの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | extension.ts | `extensions/tunnel-forwarding/src/extension.ts` | TunnelPrivacyId（12-15行目）、State（64-69行目）、StateT（71-75行目） |

**読解のコツ**: 状態マシン（State.Inactive → Starting → Active → Error）の遷移を把握する。

#### Step 2: エントリーポイントを理解する

拡張機能の起動とプロバイダー登録。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extension.ts | `extensions/tunnel-forwarding/src/extension.ts` | activate関数（77-107行目） |

**主要処理フロー**:
1. **78-80行目**: リモート環境チェック（ローカル専用）
2. **82-83行目**: Logger、TunnelProviderの初期化
3. **86-87行目**: コマンド登録（showLog, restart）
4. **93-105行目**: registerTunnelProviderでプロバイダー登録

#### Step 3: Tunnel提供ロジックを理解する

ポート転送リクエストの処理フロー。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extension.ts | `extensions/tunnel-forwarding/src/extension.ts` | provideTunnel（158-201行目） |

**主要処理フロー**:
- **159-163行目**: パブリック転送時の同意確認
- **165-175行目**: Tunnelオブジェクト作成
- **177-200行目**: 状態に応じた処理分岐

#### Step 4: CLIプロセス管理を理解する

code-tunnel CLIの起動と通信。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | extension.ts | `extensions/tunnel-forwarding/src/extension.ts` | setupPortForwardingProcess（266-342行目） |

**主要処理フロー**:
- **267-269行目**: GitHub認証セッション取得
- **271-277行目**: CLI引数構築
- **280行目**: spawn()でCLI起動
- **314-336行目**: stdout/stderrのパースとイベント処理

#### Step 5: アクティブポート管理を理解する

ポートの追加・削除とCLI通信。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | extension.ts | `extensions/tunnel-forwarding/src/extension.ts` | updateActivePortsIfRunning（250-264行目） |

**主要処理フロー**:
- **255-256行目**: JSON形式でstdinに書き込み
- **258-263行目**: クリーンアップタイムアウトの管理

### プログラム呼び出し階層図

```
extension.ts (activate)
    │
    ├─ registerTunnelProvider
    │      │
    │      └─ TunnelProvider
    │             │
    │             ├─ provideTunnel
    │             │      ├─ consentPublicPort (パブリック同意)
    │             │      ├─ setupPortForwardingProcess (CLI起動)
    │             │      │      └─ authentication.getSession (GitHub認証)
    │             │      └─ updateActivePortsIfRunning
    │             │
    │             ├─ restart
    │             │      └─ killRunningProcess
    │             │
    │             └─ killRunningProcess
    │
    └─ Logger
           └─ createOutputChannel (ログ出力)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ポート転送リクエスト ───▶ TunnelProvider ───▶ Tunnel URL
(port, privacy)               │
                              ├─ GitHub認証
                              │
                              ├─ code-tunnel CLI
                              │      │
                              │      └─ stdin: ポート情報JSON
                              │          stderr: portFormat JSON
                              │
                              └─ 状態管理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extension.ts | `extensions/tunnel-forwarding/src/extension.ts` | ソース | 拡張機能メインロジック |
| deferredPromise.ts | `extensions/tunnel-forwarding/src/deferredPromise.ts` | ソース | Promise遅延解決ユーティリティ |
| split.ts | `extensions/tunnel-forwarding/src/split.ts` | ソース | 改行分割ストリーム |
| package.json | `extensions/tunnel-forwarding/package.json` | 設定 | 拡張機能マニフェスト |
